/*
* @category    Formulario Plantilla Resultado por Profesional
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winPlantillaResultadoxProcedUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Asociar Plantilla Resultados por Procedimiento ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winPlantillaResultadoxProced',
    initComponent: function() {
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmPlantillaResProcedxProfe',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intIdPlantillaProcedxProfe'
                            },
                            {
                                xtype: 'hidden',
                                id: 'intUsuarioPlantillaProced',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIdProfesionalPlantillaProced',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIdProcedimiento',
                                value: 0
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                fieldLabel: 'Concepto',
                                items: [
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Concepto',
                                        id: 'btnSearchConcepto_conceptos',
                                        handler:function(){
                                            buscarconceptoBasico('Search');
                                        }
                                    },
                                    {
                                        xtype: 'textfield',
                                        readOnly: true,
                                        width: 96,
                                        allowBlank: false,
                                        style: 'color: #0000cc; font-weight: bold;',
                                        id: 'sysCodConcepto'
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 435,
                                        height: 50,
                                        fieldLabel: 'Descripción',
                                        style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                        id: 'sysDesConcepto'
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Plantilla',
                                allowBlank: false,
                                id: 'strnomPlantilla'
                            },
                            {
                                xtype: 'htmleditor',
                                name: 'Formato',
                                fieldLabel: 'Formato',
                                anchor: '100%',
                                height: 420,
                                grow: true,
                                allowBlank: false,
                                enableColors: false,
                                enableAlignments: false,
                                enableFont: false,
                                enableFontSize: false,
                                enableFormat: false,
                                enableLinks: false,
                                enableLists: false,
                                enableSourceEdit: true,
                                //value: '<font size="3"><span style="font-weight: bold;">ECOGRAFIA DUPLEX A COLOR CAROTIDAS</span></font><br><br>La&nbsp; porción extracraneana de ambas carótidas (común, interna y externa) y vertebrales fueron claramente visualizadas con un transductor de 7.5 Mhz y su flujo se evalúo con imagen a color y con doppler pulsado.<br><br><span style="font-weight: bold;">ARTERIAS CAROTIDAS:</span> No se evidenciaron alteraciones ateroescleróticas ni hemodinámicas en todo el trayecto extracraneano. Las velocidades sistólicas máximas obtenidas fueron:&nbsp; <br><br>ARTERIA CAROTIDA COMUN DERECHA&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; CMS /SEG<br>ARTERIA CAROTIDA COMUN IZQUIERDA&nbsp;&nbsp;&nbsp; CMS/SEG<br>ARTERIA CAROTIDA INTERNA DERECHA&nbsp;&nbsp;&nbsp; CMS/SEG<br>ARTERIA CAROTIDA INTERNA IZQUIERDA&nbsp; CMS /SEG<br>INDICE ARTERIAL DERECHO&nbsp; <br>INDICE ARTERIAL IZQUIERDO <br><br><span style="font-weight: bold;">ARTERIAS VERTEBRALES:</span> Se detecto un flujo cefálico y de características hemodinámicas normales en ambas arterias en donde no se observan signos de estenosis&nbsp; en sus segmentos más proximal.<br><br><span style="font-weight: bold;">CONCLUSION:</span><br>NO HAY EVIDENCIA DE LESIONES ESTENOSANTES EN TODO EL TRAYECTO EXTRACRANEANO DEL SISTEMA CAROTIDEO Y VERTEBRAL BILATERALMENTE.',
                                id: 'memHTMLformatoPlantilla'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Plantilla',
                            iconCls: 'btnGuardar',
                            id: 'btn_AsociarPlantillaProced'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Plantilla',
                            iconCls: 'btnGuardar',
                            id: 'btn_EditPlantillaProced'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirPlantillaProced'
                        }
                    ]
                }
            }
        ];
        winPlantillaResultadoxProcedUi.superclass.initComponent.call(this);
    }
});
