/*
* @category    Formulario Filtro Busqueda Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFilterProfesionalesUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: BUSCAR PROFESIONALES ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winFilterProfesionales',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmFilterProfesionales',
                padding: 10,
                items: [
                    {
                        html:'<img src="../../../resources/varios/search.png" align="left" alt=""/>',border: false
                    },
                    {
                        html:'</br>',border: false
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Nro Documento ID',
                                allowBlank: true,
                                emptyText: 'Digite el Nro de Documento',
                                id: 'strqryDocumentoProfe'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Nombre',
                                allowBlank: true,
                                emptyText: 'Digite el Nombre',
                                id: 'strqryNombreProfe'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Especialidad',
                                anchor: '100%',
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                emptyText: 'Seleccionar...!',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                store: 'StoreEspecialidadxProfesional',
                                forceSelection: false,
                                allowBlank: true,
                                id: 'strqryEspecialidadProfe'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Tipo',
                                anchor: '100%',
                                triggerAction: 'all',
                                mode: 'local',
                                typeAhead: true,
                                emptyText: 'Seleccionar...!',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                store: 'StoreTipoProfesional',
                                forceSelection: false,
                                allowBlank: true,
                                id: 'strqryTipoProfe'
                            },
                        ]
                    },
                    {
                        html:'</br>',border: false
                    },
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Aplicar Búsqueda',
                            iconCls: 'btnFiltro',
                            id: 'btn_FiltroProfe'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Cancelar',
                            iconCls: 'btnCancelar',
                            id: 'btn_CancelFiltroProfe'
                        }
                    ]
                }
            }
        ];
        winFilterProfesionalesUi.superclass.initComponent.call(this);
    }
});
