/*
* @category    Formulario Excluir Horario por Agenda
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winExcluirHorarioxAgendaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Excluir Horario a Agenda ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winExcluirHorarioxAgendaUi',
    initComponent: function() {
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmExcluirHorarioxAgenda',
                padding: 10,
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intDetAgendaExcidRegistro'
                    },
                    {
                        xtype: 'hidden',
                        id: 'intDetAgendaExcidUsuario'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Horario',
                        allowBlank: true,
                        readOnly: true,
                        id: 'sysDetAgendaExcHorario'
                    },                    
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Observaciones',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        id: 'memDetAgendaExcObservaciones'
                    },
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Motivo',
                        anchor: '100%',
                        allowBlank: false,
                        emptyText: 'Motivo por el cual desea excluir el horario',
                        id: 'memDetAgendaExcMotivo'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Excluir',
                            iconCls: 'btnDelHour',
                            id: 'btnDetAgendaExcGuardar'
                        }
                    ]
                }
            }
        ];
        winExcluirHorarioxAgendaUi.superclass.initComponent.call(this);
    }
});
