/*
* @category    Formulario Editar Agenda
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winEditarAgendaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Editar Agenda ::.',
    width: 970,
    height: 570,
    border: false,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winEditarAgendaUi',
    initComponent: function() {
        
        function renderEstado(value, p, record){
            switch (value){
                case "s":
                    return String.format(
                        'Sin Asignar',
                        value);
                    break;
                case "b":
                    return String.format(
                        'Bloqueado',
                        value);
                    break;
                case "a":
                    return String.format(
                        'Cita Asignada',
                        value);
                    break;
                default:
                    return String.format(
                        '{0}',
                        value);
                    break;
            }
        }
        
        function renderSiNo(value, p, record){
            if (value == 0)
                return String.format(
                        'NO',
                        value);
            else
                return String.format(
                        'SI',
                        value);
        }
        
        function renderNota (value, p, record){
            if (value == 'a')
                return String.format(
                        'Adicional',
                        value);
            else
                return String.format(
                        '',
                        value);
        }
        var stGridDetalleAgenda = new StoreGridDetalleAgenda();
        this.bbar = [
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'button',
                text: 'Salir',
                iconCls: 'btnSalir',
                ref: '../detAgendaSalir',
                id: 'detAgendaSalir',
                listeners: {
                    click : function() {
                        Ext.Msg.show({
                            title: 'eOfiClinic',
                            msg: 'Esta seguro que desea cerrar la ventana?',
                            buttons: Ext.Msg.YESNO,
                            icon: Ext.Msg.QUESTION,
                            fn: function(btn)
                            {
                                if(btn=="yes")
                                {
                                    Ext.getCmp('winEditarAgendaUi').close();
                                }
                            }
                        });
                    }
                }
            }
        ];
        
        this.items = [
            {
                xtype: 'hidden',
                id: 'detAgendaidAgenda'
            },
            {
                xtype: 'hidden',
                id: 'detAgendaEstado'
            },
            {
                xtype: 'hidden',
                id: 'detAgendaFecAgenda'
            },
            {
                xtype: 'panel',
                layout: 'form',
                border: false,
                frame: true,
                labelWidth: 150,
                style: 'background:transparent;',
                items: [
                    {
                        html: '<img src="../../../resources/varios/calendar.png" align="left" alt=""/>',
                        border: false
                    },
                    {
                        xtype: 'compositefield',
                        frame: true,
                        fieldLabel: 'ID Profesional',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'numberfield',
                                allowNegative: false,
                                allowDecimals: false,
                                width: 200,
                                fieldLabel: 'Documento ID',
                                allowBlank: true,
                                readOnly: true,
                                id: 'detAgendaDocProfesional'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Nro. Registro o Tarjeta Profesional',
                                maxLength: 20,
                                emptyText: 'Nro Registro / Tarjeta',
                                allowBlank: true,
                                readOnly: true,
                                id: 'detAgendaRegistroProfesional'
                            },
                            {
                                html:'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;',
                                border: false
                            },
                            {
                                xtype: 'displayfield',
                                id: 'detAgendaCERRADA',
                                style: 'color: #006666; font-size: large; font-weight: bold;'
                            },
                            {
                                xtype: 'displayfield',
                                id: 'detAgendaCANCELADA',
                                style: 'color: red; font-size: large; font-weight: bold;'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Descripción / Nombre',
                        allowBlank: true,
                        readOnly: true,
                        id: 'detAgendaDescripcion'
                    },
                    {
                        xtype: 'compositefield',
                        frame: true,
                        fieldLabel: 'Tipo / Especialidad',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'detAgendaTipoProfesional'
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                width: 635,
                                fieldLabel: 'Especialidad',
                                id: 'detAgendaIdEspecialidad'
                            }
                        ]
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Consultorio / Unidad',
                        allowBlank: true,
                        readOnly: true,
                        id: 'detAgendaConsultorio'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Plantilla',
                        allowBlank: true,
                        readOnly: true,
                        id: 'detAgendaPlantilla'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Fecha Agenda',
                        allowBlank: true,
                        readOnly: true,
                        id: 'detAgendaFecha'
                    },
                    {
                        xtype: 'grid',
                        id: 'detAgendagrid',
                        store: stGridDetalleAgenda,
                        anchor: "100%",
                        height: 300,
                        border: false,
                        frame: true,
                        loadMask: true,
                        columns: [
                            {
                                header: 'detalleagendaID',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'detalleagendaID',
                                width: 1,
                                hidden: true,
                                hideable: false
                            },
                            {
                                header: 'Descripción de la Cita',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'detalleagendaDesCita',
                                width: 250,
                                hideable: false
                            },
                            {
                                header: 'Grupo Prioritario',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'GrupoPrioritario',
                                hideable: false,
                                renderer: renderSiNo
                            },
                            {
                                header: 'Asignar WEB',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'AsignarWeb',
                                hideable: false,
                                renderer: renderSiNo
                            },
                            {
                                header: 'Estado',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'Estado',
                                hideable: false,
                                renderer: renderEstado
                            },
                            {
                                header: 'Observaciones',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'Observaciones',
                                hideable: false,
                                width: 250
                            },
                            {
                                header: 'Nota',
                                readOnly: true,
                                sortable: false,
                                dataIndex: 'TipoRegistro',
                                hideable: false,
                                renderer: renderNota
                            }
                        ],
                        tbar:
                            {
                                xtype: 'toolbar',
                                items: [
                                    {
                                        xtype: 'button',
                                        text: 'Incluir Horario',
                                        iconCls: 'btnAddHour',
                                        id: 'btnAdddetAgenda'
                                    },
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    {
                                        xtype: 'button',
                                        text: 'Excluir Horario',
                                        iconCls: 'btnDelHour',
                                        id: 'btnDeldetAgenda'
                                    },
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    {
                                        xtype: 'button',
                                        text: 'Desbloquear Horario',
                                        iconCls: 'btnEditRow',
                                        id: 'btnDesbldetAgenda'
                                    },
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    {
                                        xtype: 'button',
                                        text: 'Imprimir Agenda',
                                        iconCls: 'btnImprimir',
                                        id: 'btnPrintdetAgenda'
                                    }
                                ]
                            },
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                        iconCls:'icon-grid',
                        viewConfig: {
                            forceFit:true
                        },
                        columnLines: true,
                        view: new Ext.grid.GridView({ 
                            getRowClass : function (row, index) { 
                                var estado = row.data.Estado;
                                switch (estado)
                                {
                                    case "a":
                                        return 'Amarillo';
                                        break;
                                    case "b":
                                        return 'Rojo';
                                        break;
                                    default:
                                        break;
                                }
                            }
                        })
                    }
                ]
                
            }
        ];
        winEditarAgendaUi.superclass.initComponent.call(this);
    }
});
