/*
* @category    Formulario Adicionar Plantilla Citas
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAdicionarPlantillaCitasProfeUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar Plantilla de Citas ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAdicionarPlantillaCitasProfeUi',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAdicionarPlantillaCitasProfe',
                padding: 10,
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intidPrestadorGridPlantilla'
                    },
                    {
                        xtype: 'hidden',
                        id: 'intidProfesionalGridPlantilla'
                    },
                    {
                        xtype: 'hidden',
                        id: 'intidUsuarioGridPlantilla'
                    },
                    {
                        xtype: 'textfield',
                        anchor: '100%',
                        fieldLabel: 'Descripción / Nombre',
                        allowBlank: false,
                        emptyText: 'Digite la Descripción o Nombre',
                        id: 'strDescripcionGridPlantilla'
                    },
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            ref: '../btnGuardarPlantilla',
                            id: 'btnGuardarPlantilla'
                        }
                    ]
                }
            }
        ];
        winAdicionarPlantillaCitasProfeUi.superclass.initComponent.call(this);
    }
});
