/*
* @category    Modelo Maestro Examenes Previos
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var DGDataStore;
var DGColumnModel;
var DGListingEditorGrid;
var DGListingWindow;
var DGListingSelectedRow;
var DGListingContextMenu;
var anchoPantalla;
var MargenIzquierdo;

Ext.onReady(function(){
    Ext.QuickTips.init();

    setTimeout(function(){
        Ext.get('loading').remove();
        Ext.get('loading-mask').fadeOut({remove:true});
    }, 150);

    var el = Ext.get('idusuario');
    var ID_USUARIO = el.getValue();
    el = Ext.get('nomusuario');
    var NOM_USUARIO = el.getValue();
    el = Ext.get('codusuario');
    var COD_USUARIO = el.getValue();
    el = Ext.get('idempresa');
    var ID_EMPRESA = el.getValue();
    el = Ext.get('nomempresa');
    var NOM_EMPRESA = el.getValue();
    el = Ext.get('idcliente');
    var ID_CLIENTE = el.getValue();
    el = Ext.get('nomcliente');
    var NOM_CLIENTE = el.getValue();
    el = Ext.get('idsede');
    var ID_SEDE = el.getValue();
    el = Ext.get('nomsede');
    var NOM_SEDE = el.getValue();
    el = Ext.get('idperfil');
    var ID_PERFIL = el.getValue();
    anchoPantalla = screen.width;
    switch(anchoPantalla)
    {
        case 1024:
            MargenIzquierdo = 15;
            break;
        case 1280:
            MargenIzquierdo = 150;
            break;
    }

    Ext.util.Format.Currency = function(v)
    {
        return FormatoMoneda(v);
    };

    var dsGenero = new Ext.data.JsonStore({
        proxy: new Ext.data.HttpProxy ({
            url: '../../controlador/cbGenero.php',
            method: 'POST'
        }),
        id: 'dsGenero',
        idProperty: 'Codigo',
        root: 'rows',
        fields:[
           {name: 'Codigo'},
           {name: 'Descripcion'}
        ]
    });
    dsGenero.load();

    Ext.apply(Ext.form.VTypes,{
        exclusionNotZero: function(val, field){
            try{
                if (val < 1){
                    return false;
                } else {
                    field.clearInvalid();
                    return true;
                }
            }catch(e){
                return false;
            }
        },
        exclusionNotZeroText: 'No puede tener valor cero!'
    });

    

    var btnSalir = new Ext.Button({
        id: 'btnSalir',
        text: 'Salir',
        icon: '../../../resources/botones/salir.png',
        iconCls: 'x-btn-text-icon',
        minWidth: 80,
        handler:function(){
            window.close();
        }
    });

    var btnLimpiarFiltro = new Ext.Button({
        id: 'btnLimpiar',
        text: 'Quitar Busqueda',
        icon: '../../../resources/botones/salir.png',
        iconCls: 'x-btn-text-icon',
        minWidth: 80,
        handler:function(){
            resetSearch();
        }
    });

    function startAdvancedSearch(){
        var SearchForm;
        var SearchWindow;
        var SearchDes;
        var SearchEsp;
        var SearchTipo;

        function listSearch(){
         // render according to a SQL date format.
         /*var startDate = "";
         var endDate = "";
         if(SearchEnteringItem.getValue() !== "") {
            startDate = SearchEnteringItem.getValue().format('Y-m-d');
         }
         if(SearchLeavingItem.getValue() !== "") {
            endDate = SearchLeavingItem.getValue().format('Y-m-d');
         }*/

            DGDataStore.baseParams = {
                task: 'SEARCH',
                Doc: SearchDoc.getValue(),
                Ape1: SearchApe1.getValue(),
                Ape2: SearchApe2.getValue(),
                Nom1: SearchNom1.getValue(),
                Nom2: SearchNom2.getValue(),
                Genero: SearchGenero.getValue(),
                CAS: SearchCAS.getValue(),
                Exa: SearchExamen.getValue(),
                Consec: SearchConsec.getValue()
            };
            SearchWindow.close();
            DGDataStore.reload({params: {start: 0, limit: 15}});
        }

        function resetSearch(){
            DGDataStore.baseParams = {
                task: 'LISTING',
                Doc: null,
                Ape1: null,
                Ape2: null,
                Nom1: null,
                Nom2: null,
                Genero: null,
                CAS: null,
                Exa: null,
                Consec: null
            };
            DGDataStore.reload({params: {start: 0, limit: 15}});
            SearchWindow.close();
        }

        SearchDoc = new Ext.form.TextField({
            fieldLabel: 'Documento ID',
            emptyText: 'Todos',
            maxLength: 200,
            anchor : '95%',
            maskRe: /([a-zA-Z0-9\s]+)$/
        });
        SearchApe1 = new Ext.form.TextField({
            fieldLabel: '1er Apellido',
            emptyText: 'Todos',
            maxLength: 200,
            anchor : '95%',
            maskRe: /([a-zA-Z0-9\s]+)$/
        });
        SearchApe2 = new Ext.form.TextField({
            fieldLabel: '2do Apellido',
            emptyText: 'Todos',
            maxLength: 200,
            anchor : '95%',
            maskRe: /([a-zA-Z0-9\s]+)$/
        });
        SearchNom1 = new Ext.form.TextField({
            fieldLabel: '1er Nombre',
            emptyText: 'Todos',
            maxLength: 200,
            anchor : '95%',
            maskRe: /([a-zA-Z0-9\s]+)$/
        });
        SearchNom2 = new Ext.form.TextField({
            fieldLabel: '2do Nombre',
            emptyText: 'Todos',
            maxLength: 200,
            anchor : '95%',
            maskRe: /([a-zA-Z0-9\s]+)$/
        });
        SearchGenero = new Ext.form.ComboBox({
            fieldLabel: 'Genero',
            store: dsGenero,
            mode: 'local',
            loadingText: 'Cargando Generos...!',
            valueField: 'Codigo',
            displayField: 'Descripcion',
            emptyText: 'Todos',
            anchor:'95%',
            triggerAction: 'all'
        });
        SearchCAS = new Ext.form.TextField({
            fieldLabel: 'CAS',
            emptyText: 'Todos',
            maxLength: 200,
            anchor : '95%',
            maskRe: /([0-9\s]+)$/
        });
        SearchExamen = new Ext.form.TextField({
            fieldLabel: 'Examen',
            emptyText: 'Todos',
            maxLength: 200,
            width: '50'
        });
        SearchConsec = new Ext.form.TextField({
            fieldLabel: 'Consecutivo',
            emptyText: 'Todos',
            maxLength: 200,
            anchor : '95%'
        });
        SearchCompositeExamen =  new Ext.form.CompositeField({
            fieldLabel: 'Prefijo - Numero',
            anchor: '100%',
            id: 'compoSearchExamen',
            items: [SearchExamen,SearchConsec]
        });
        
        SearchForm = new Ext.FormPanel({
            bodyStyle: 'padding: 15px',
            width: 700,
            items: [{
                layout: 'form',
                border: false,
                items: [SearchDoc,SearchApe1,SearchApe2,SearchNom1,SearchNom2,SearchGenero,SearchCAS,SearchCompositeExamen],
                buttons: [{
                    text: 'Buscar',
                    handler: listSearch
                },{
                    text: 'Cerrar y Limpair Busqueda',
                    handler: resetSearch
                }]
            }]
        });

        SearchWindow = new Ext.Window({
            title: 'Busqueda',
            closable:true,
            width: 750,
            height: 300,
            plain:true,
            modal:true,
            layout: 'fit',
            items: SearchForm
        });

        SearchWindow.show();
    }

    DGDataStore = new Ext.data.GroupingStore({
        id: 'DGDataStore',
        proxy: new Ext.data.HttpProxy({
            url: '../../controlador/examenespreviosicp.php',
            method: 'POST'
        }),
        baseParams:{task: "LISTING"},
        groupField: 'Examen',
        loadMask: {msg:"Cargando Registros, por favor espere..."},
        autoload: false,
        reader: new Ext.data.JsonReader({
            root: 'results',
            totalProperty: 'total',
            id: 'id'
          },[
            {name: 'IDRecord', type: 'int', mapping: 'idrecord'},
            {name: 'Paciente', type: 'string', mapping: 'paciente'},
            {name: 'CAS', type: 'int', mapping: 'CAS'},
            {name: 'Examen', type: 'string', mapping: 'texamen'},
            {name: 'NroExamen', type: 'string', mapping: 'examen'},
            {name: 'FechaIngreso', type: 'string', mapping: 'fechaingreso'},
            {name: 'FechaCierre', type: 'string', mapping: 'fechacierre'},
            {name: 'Cliente', type: 'string', mapping: 'cliente'},
            {name: 'Plan', type: 'string', mapping: 'plan'},
            {name: 'SubPlan', type: 'string', mapping: 'subplan'}
         ]),
      sortInfo:{field: 'IDRecord', field: 'Examen', direction: "ASC"}
    });
    
    DGColumnModel = new Ext.grid.ColumnModel(
        [{
            header: 'ID Paciente',
            readOnly: true,
            sortable: true,
            dataIndex: 'IDRecord',
            width: 50,
            hidden: true
        },{
            header: 'Paciente',
            readOnly: true,
            sortable: true,
            dataIndex: 'Paciente',
            width: 250,
            hidden: false
        },{
            header: 'Tipo Examen',
            dataIndex: 'Examen',
            sortable: true,
            width: 20,
            hidden: true
        },{
            header: 'Nro Examen',
            dataIndex: 'NroExamen',
            sortable: true,
            width: 120
        },{
            header: 'CAS',
            dataIndex: 'CAS',
            sortable: true,
            width: 120
        },{
            header: 'Cliente',
            dataIndex: 'Cliente',
            sortable: true,
            width: 120
        },{
            header: 'Plan',
            dataIndex: 'Plan',
            sortable: true,
            width: 120
        },{
            header: 'SubPlan',
            dataIndex: 'SubPlan',
            sortable: true,
            width: 120
        },{
            header: 'Fecha Ingreso',
            dataIndex: 'FechaIngreso',
            width: 100
        },{
            header: 'Fecha Cierre',
            dataIndex: 'FechaCierre',
            width: 100
        }]
    );
    DGColumnModel.defaultSortable= true;

    DGListingEditorGrid =  new Ext.grid.GridPanel({
        id: 'DGListingEditorGrid',
        store: DGDataStore,
        cm: DGColumnModel,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
        iconCls:'icon-grid',
        loadMask:{msg:"Cargando Registros, por favor espere..."},
        view: new Ext.grid.GroupingView({
            groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
            getRowClass: function(record, index, rowParams, store){
                var estado = record.data.FechaCierre;
                switch (estado)
                {
                    case "":
                        return 'NoActivo';
                        break;
                    default:
                        break;
                }
            }
        }),
        bbar: new Ext.PagingToolbar({
            pageSize: 15,
            store: DGDataStore,
            displayInfo: true
        }),
        tbar: [{
            text: 'Buscar',
            tooltip: 'Buscar Registros...',
            handler: startAdvancedSearch,
            iconCls:'search'
        }, '-', new Ext.app.SearchField({
                store: DGDataStore,
                params: {start: 0, limit: 15},
                width: 120
        })]
    });

   DGListingWindow = new Ext.Window({
        id: 'DGListingWindow',
        title: ' ',
        closable:false,
        width:980,
        height:480,
        plain:true,
        resizable : false,
        x: MargenIzquierdo,
        y:120,
        layout: 'fit',
        loadMask: true,
        items: DGListingEditorGrid,
        tbar:['->',btnSalir],
        bbar:[{
            text  : 'Empresa: ' + NOM_EMPRESA,
            xtype : 'tbtext'
        },'->',{
            text  : 'Sistemas Ofisalud - desarrollo@ofisalud.com - Tel: 3016398114',
            xtype : 'tbtext'
        }]
    });
    DGListingWindow.show();
    //DGDataStore.load({params: {start: 0, limit: 15}});
 
  
});

