/*
* @category    Programacion Eventos Formulario POS(Punto de Venta Optica)
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
var CodFrm = "BS00001";
var ID_EMPRESA;
var ID_SEDE;
var ID_IPS;
var ID_USUARIO;
var gCAS;
var paso1 = false;
var paso2 = false;
var paso3 = false;
var paso4 = false;
var paso5 = false;
MaximizarVentana();
winPOSOptica = Ext.extend(winPOSOpticaUi, {
    initComponent: function() {
        
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        ID_CONSULTORIO = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        el = Ext.get('IdMunicipio');
        ID_MUNICIPIO = el.getValue();
        
        this.title = NOM_APLICACION + " ©  .:: POS - Optica ::.";
        
        stCliente = new StoreCliente();
        stCliente.load({params:{pSede:ID_IPS,pEmpresa:ID_EMPRESA}});
        winPOSOptica.superclass.initComponent.call(this);
        Ext.getCmp('fClienteLA').setValue(0);
        Ext.getCmp('fPlanLA').setValue(0);
        Ext.getCmp('fSubPlanLA').setValue(0);
        Ext.getCmp('fPacienteValido').setValue(0);
        Ext.getCmp('fIdEmpresa').setValue(ID_EMPRESA);
        Ext.getCmp('fIdSede').setValue(ID_SEDE);
        Ext.getCmp('fIdIPS').setValue(ID_IPS);
        //Ext.getCmp('bolCrearCASxServicio').setValue(true);
        //Ext.getCmp('fsRIPSAC').setVisible(false);
        //Ext.getCmp('fsRIPSAP').setVisible(false);
                
        this.setPagePosition((screen.width - 1004)/2, 5);
        this.fNomEmpresa.setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        this.fNomSede.setValue("SEDE: " + Ext.get('nomsede').getValue());
        this.fNomIPS.setValue("IPS: " + Ext.get('nomips').getValue());
        this.fNomUSR.setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        el = Ext.get('FecSistema');
        //this.fFecNac.setMaxValue(el.getValue());
        //this.fFecSol.setMaxValue(el.getValue());
        el = Ext.get('FecControl');
        //this.fFecSol.setMinValue(el.getValue());
        var fCliente = this.fCliente.on("select",this.CargaCbPlan,this);
        var fCliente1 = this.fCliente.on("change",this.ChangeCargaCbPlan,this);
        var fPlan = this.fPlan.on("select",this.CargaCbSubPlan,this);
        var fPlan1 = this.fPlan.on("change",this.ChangeCargaCbSubPlan,this);
        var fRegimen = this.fRegimen.on("select",this.ValidarRegimen,this);
        var fTafiliado = this.fTafiliado.on("select",this.ValidarParentesco,this);
        var fFecNac = this.fFecNac.on("Blur",this.MostrarEdad,this);
        var fPrograma = this.fPrograma.on("select",this.ValidarPrograma,this);
        var btnAddProfeSol = Ext.getCmp('btnAddProfeSol').on("click",this.CrearProfesionalSolicitante,this);
        var btnActualizaPac  = Ext.getCmp('btnActualizaPac').on("click",this.ActualizaInfoPaciente,this);
        var btnAyuda = this.btnAyuda.on("click",this.LlamarAyuda,this);
        var btnNuevo = this.btnNuevo.on("click",this.NuevoServicio, this);
        var btnSalir = this.btnSalir.on("click",this.Salir, this);
        //var btnVerificaPacienteListado = Ext.getCmp('btnVerificaPacienteListado').on("click",this.VerificaListado,this);
        var btnRadicar = this.btnRadicar.on("click",this.GuardarDatosBasicos, this);
        var strdocpac_citas_special = Ext.getCmp('fDocID').on("specialkey",this.ValidarNumeroDocumentoPacSK,this);
        var fRango =  Ext.getCmp('fRango').on("select",this.SelectRangoSalarial,this);
        var btnBuscarPacienteRadica = Ext.getCmp('btnBuscarPacienteRadica').on("click",this.BuscarPaciente,this);
        var btnAddRegistroConcepto  = Ext.getCmp('btnAddRegistroConcepto').on("click",this.AdicionarRegistroConcepto,this);
        var btnDelRegistroConcepto  = Ext.getCmp('btnDelRegistroConcepto').on("click",this.EliminarRegistroConcepto,this);
        var btnBuscarRadica = Ext.getCmp('btnBuscarRadica').on("click",this.BuscarRadicacionEstudios,this);
        /*var sysDiagPpalHC = Ext.getCmp('sysDiagPpalHC').on("specialkey",this.searchDiagPpalHC,this);
        var sysDiagRel1HC = Ext.getCmp('sysDiagRel1HC').on("specialkey",this.searchDiagRel1HC,this);
        var sysDiagRel2HC = Ext.getCmp('sysDiagRel2HC').on("specialkey",this.searchDiagRel2HC,this);
        var sysDiagRel3HC = Ext.getCmp('sysDiagRel3HC').on("specialkey",this.searchDiagRel3HC,this);
        
        var sysDiagPpalProc = Ext.getCmp('sysDiagPpalProc').on("specialkey",this.searchDiagPpalProc,this);
        var sysDiagRel1Proc = Ext.getCmp('sysDiagRel1Proc').on("specialkey",this.searchDiagRel1Proc,this);
        var sysDiagRel2Proc = Ext.getCmp('sysDiagRel2Proc').on("specialkey",this.searchDiagRel2Proc,this);
        */
       var btnPagoDocumentoFac = Ext.getCmp('btnPagoDocumentoFac').on("click",this.GenerarPagoFacturaParticular,this);
       var btnImprimirDocumentoFac = Ext.getCmp('btnImprimirDocumentoFac').on("click",this.ImprimirDocumentoFac,this);
        var strTipoVentaPOS = Ext.getCmp('strTipoVentaPOS').on("change",this.CargaTipoVentaPOS,this);
        
        //stCIE10 = new StoreCIE10();
        
        var sm_gridservicios = Ext.getCmp('gridConceptosRegistroVenta').getSelectionModel();
        sm_gridservicios.on("rowselect",this.UpdateDetalleSolServicio,this);
        
        el = Ext.get('Legalizar');
        gCAS = el.getValue();
        
        EstblecerCamposEnabled();
        Ext.getCmp('sysTextoEliminado').setValue("");
        Ext.getCmp('btnReactivarCAS').setVisible(false);
        Ext.getCmp('fDeptoMuni').setValue(ID_MUNICIPIO);
        Ext.getCmp('fYaGuardo').setValue(0);
        
    },
    ImprimirDocumentoFac: function(){ 
        if(Ext.getCmp('gridFacturacionOrden').selModel.getCount() === 1)
        {
            var selections = Ext.getCmp('gridFacturacionOrden').selModel.getSelections();
            switch (selections[0].json.TipoDocumento){
                case "FV":
                    window.open('../../../app/controlador/legalizaciones/print_fv_pos_particular.php?pCAS='+selections[0].json.CAS+'&pPaciente='+selections[0].json.Paciente+'&pIdReg='+selections[0].json.idLegalizacion+'&pTipoLegalizacion='+selections[0].json.TipoLegalizacion+'&pPrefijo='+selections[0].json.Prefijo+'&pNroDocumento='+selections[0].json.NroDocumento+'&pFechaDocumento='+selections[0].json.FechaDocumento+'&pNroResolucion='+selections[0].json.NroResolucion+'&pFechaVencimiento='+selections[0].json.FechaVencimiento+'&pConcepto='+selections[0].json.Concepto+'&pVlrTotal='+selections[0].json.VlrTotal+'&pVlrIVA='+selections[0].json.VlrIVA+'&pVlrCuotaModeradora='+selections[0].json.VlrCuotaModeradora+'&pVlrCopagos='+selections[0].json.VlrCopagos+'&pVlrDescuentos='+selections[0].json.VlrDescuentos+'&pVlrNeto='+selections[0].json.VlrNeto+'&pAnulada='+selections[0].json.Anulada+'&pUsuarioAnula='+selections[0].json.UsuarioAnula+'&pMotivoAnula='+selections[0].json.MotivoAnula+'&pFechaAnula='+selections[0].json.FechaAnula+'&pUsuarioFactura='+selections[0].json.UsuarioFactura,"FACTURA DE VENTA");
                    break;
                case "RCPART":
                    window.open('../../../app/controlador/legalizaciones/print_rc_pos_particular.php?pCAS='+selections[0].json.CAS+'&pPaciente='+selections[0].json.Paciente+'&pIdReg='+selections[0].json.idLegalizacion+'&pCliente='+selections[0].json.Cliente+'&pPlan='+selections[0].json.Plan+'&pSubPlan='+selections[0].json.SubPlan+'&pTipoLegalizacion='+selections[0].json.TipoLegalizacion+'&pPrefijo='+selections[0].json.Prefijo+'&pNroDocumento='+selections[0].json.NroDocumento+'&pFechaDocumento='+selections[0].json.FechaDocumento+'&pNroResolucion='+selections[0].json.NroResolucion+'&pFechaVencimiento='+selections[0].json.FechaVencimiento+'&pConcepto='+selections[0].json.Concepto+'&pVlrTotal='+selections[0].json.VlrTotal+'&pVlrIVA='+selections[0].json.VlrIVA+'&pVlrCuotaModeradora='+selections[0].json.VlrCuotaModeradora+'&pVlrCopagos='+selections[0].json.VlrCopagos+'&pVlrDescuentos='+selections[0].json.VlrDescuentos+'&pVlrNeto='+selections[0].json.VlrNeto+'&pAnulada='+selections[0].json.Anulada+'&pUsuarioAnula='+selections[0].json.UsuarioAnula+'&pMotivoAnula='+selections[0].json.MotivoAnula+'&pFechaAnula='+selections[0].json.FechaAnula+'&pUsuarioFactura='+selections[0].json.UsuarioFactura,"RECIBO DE CAJA");
                    break;
                default:
                    break;
            }
        }else{
            Ext.MessageBox.show({
                title: 'eOfiClinic',
                msg: 'Debe seleccionar solo un documento.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    GenerarPagoFacturaParticular: function(){
        if(parseInt(Ext.getCmp('fYaGuardo').getValue()) !== 0){
            Ext.Ajax.request({
                url: '../../controlador/posoptica/legalizacionpos.php',
                params:{
                    PROCESO: 'SALDO_CARTERA_PART',
                    pCAS: Ext.getCmp('fCas').getValue()
                },
                success: function(response,options)
                {
                    var Respuesta = response.responseText;
                    var Contenido = Respuesta.split('^');
                    if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Ocurrio un error al validar el saldo de cartera.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    } else {
                        var AbonosCartera = parseFloat(Contenido[0], 10).toFixed(2);
                        var MaxPago = Ext.getCmp('sysSaldoVenta').getValue() - AbonosCartera;
                        if(AbonosCartera < Ext.getCmp('sysSaldoVenta').getValue()){
                            var winAplicaAbono = new winAplicarAbonoParticularesUi();
                            Ext.getCmp('sysEmpresaLegalizacion').setValue(ID_EMPRESA);
                            Ext.getCmp('sysIPSLegalizacion').setValue(ID_IPS);
                            Ext.getCmp('sysBodegaAbono').setValue(Ext.getCmp('strBodegaVentaPOS').getValue());
                            Ext.getCmp('sysLegalizacion').setValue(Ext.getCmp('fCas').getValue());
                            Ext.getCmp('sysLegalizacionUsuario').setValue(ID_USUARIO);
                            Ext.getCmp('sysSaldoPendiente').setValue(MaxPago);
                            Ext.getCmp('sysPagoCartera').setMaxValue(MaxPago);
                            Ext.getCmp('sysSaldoPendiente').setMaxValue(MaxPago);
                            Ext.getCmp('sysIVAVentaAbono').setValue(Ext.getCmp('sysIVAVenta').getValue());
                            Ext.getCmp('sysSubTotVentaAbono').setValue(Ext.getCmp('sysSubTotVenta').getValue());
                            Ext.getCmp('sysCMVentaAbono').setValue(Ext.getCmp('sysCMVenta').getValue());
                            Ext.getCmp('sysCOPVentaAbono').setValue(Ext.getCmp('sysCOPVenta').getValue());
                            Ext.getCmp('sysDescuentoVentaAbono').setValue(Ext.getCmp('sysDescuentoVenta').getValue());
                            Ext.getCmp('sysEmpresaVentaAbono').setValue(Ext.getCmp('sysEmpresaVenta').getValue());
                            Ext.getCmp('sysSaldoVentaAbono').setValue(Ext.getCmp('sysSaldoVenta').getValue());
                            winAplicaAbono.show();
                        }else{
                            Ext.MessageBox.show({
                                title: 'Error',
                                msg: 'El Registro de Venta Nro: ' + Ext.getCmp('fCas').getValue() + ', No tiene saldo de cartera pendiente.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                },
                failure: function(response,options){
                    Ext.MessageBox.show({
                        title: 'Error Conexión',
                        msg: 'No podemos realizar la validacion del saldo de cartera y/o No se pudo establecer conexión con el servidor',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                },
                scope:this 
            });
        }else{
            Ext.MessageBox.show({
                title: 'Error Conexión',
                msg: 'Primero debe guardar el registro de venta',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    CargaTipoVentaPOS:function(f,newValue,oldValue){
        if(newValue == null || newValue == ""){
            Ext.getCmp('fPlan').store.removeAll(true);
            Ext.getCmp('fSubPlan').store.removeAll(true);
            Ext.getCmp('fContrato').store.removeAll(true);
            Ext.getCmp('fCliente').setValue(null);
            Ext.getCmp('fPlan').setValue(null);
            Ext.getCmp('fPlan').allowBlank = true;
            Ext.getCmp('fPlan').clearInvalid();
            Ext.getCmp('fPlan').disable();
            Ext.getCmp('fSubPlan').setValue(null);
            Ext.getCmp('fSubPlan').allowBlank = true;
            Ext.getCmp('fSubPlan').clearInvalid();
            Ext.getCmp('fSubPlan').disable();
            Ext.getCmp('fContrato').setValue(null);
            Ext.getCmp('fContrato').allowBlank = true;
            Ext.getCmp('fContrato').clearInvalid();
            Ext.getCmp('fContrato').disable();
            
        }else{
            if(newValue !== oldValue){
                Ext.getCmp('fPlan').store.removeAll(true);
                Ext.getCmp('fSubPlan').store.removeAll(true);
                Ext.getCmp('fContrato').store.removeAll(true);
                Ext.getCmp('fPlan').setValue(null);
                Ext.getCmp('fPlan').allowBlank = true;
                Ext.getCmp('fPlan').clearInvalid();
                Ext.getCmp('fPlan').disable();
                Ext.getCmp('fSubPlan').setValue(null);
                Ext.getCmp('fSubPlan').allowBlank = true;
                Ext.getCmp('fSubPlan').clearInvalid();
                Ext.getCmp('fSubPlan').disable();
                Ext.getCmp('fContrato').setValue(null);
                Ext.getCmp('fContrato').allowBlank = true;
                Ext.getCmp('fContrato').clearInvalid();
                Ext.getCmp('fContrato').disable();
            }
        }
    },
    ChangeCargaCbPlan:function(f,newValue,oldValue){
        if(newValue == null || newValue == ""){
            Ext.getCmp('fPlan').store.removeAll(true);
            Ext.getCmp('fSubPlan').store.removeAll(true);
            Ext.getCmp('fContrato').store.removeAll(true);
            Ext.getCmp('fPlan').setValue(null);
            Ext.getCmp('fSubPlan').setValue(null);
            Ext.getCmp('fContrato').setValue(null);
            Ext.getCmp('fContrato').disable();
        }
    },
    ChangeCargaCbSubPlan:function(f,newValue,oldValue){
        if(newValue == null || newValue == ""){
            Ext.getCmp('fSubPlan').store.removeAll(true);
            Ext.getCmp('fSubPlan').setValue(null);
            Ext.getCmp('fSubPlan').disable();
        }
    },
    searchDiagRel2Proc: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            var seguirdx = false;
            var txt = Ext.getCmp('sysDiagRel2Proc').getValue().toUpperCase();
            Ext.getCmp('sysDiagRel2Proc').setValue(txt);
            stCIE10.filterBy(function(record,id){
                return record.get('Codigo') ==  Ext.getCmp('sysDiagRel2Proc').getValue(); 
            });
            stCIE10.each(function(record){
                Ext.getCmp('sysDiagRel2ProcNom').setValue(record.get('Descripcion'));
                seguirdx = true;
            });
            if(!seguirdx){
                Ext.getCmp('sysDiagRel2Proc').setValue('');
                Ext.getCmp('sysDiagRel2ProcNom').setValue('');
            }
        }
    },
    searchDiagRel1Proc: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            
            var seguirdx = false;
            var txt = Ext.getCmp('sysDiagRel1Proc').getValue().toUpperCase();
            Ext.getCmp('sysDiagRel1Proc').setValue(txt);
            stCIE10.filterBy(function(record,id){
                return record.get('Codigo') ==  Ext.getCmp('sysDiagRel1Proc').getValue(); 
            });
            stCIE10.each(function(record){
                Ext.getCmp('sysDiagRel1ProcNom').setValue(record.get('Descripcion'));
                seguirdx = true;
            });
            if(!seguirdx){
                Ext.getCmp('sysDiagRel1Proc').setValue('');
                Ext.getCmp('sysDiagRel1ProcNom').setValue('');
            }
        }
    },
    searchDiagPpalProc: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            var seguirdx = false;
            var txt = Ext.getCmp('sysDiagPpalProc').getValue().toUpperCase();
            Ext.getCmp('sysDiagPpalProc').setValue(txt);
            stCIE10.filterBy(function(record,id){
                return record.get('Codigo') ==  Ext.getCmp('sysDiagPpalProc').getValue(); 
            });
            stCIE10.each(function(record){
                Ext.getCmp('sysDiagPpalProcNom').setValue(record.get('Descripcion'));
                seguirdx = true;
            });
            if(!seguirdx){
                Ext.getCmp('sysDiagPpalProc').setValue('');
                Ext.getCmp('sysDiagPpalProcNom').setValue('');
            }  
        }
    },
    searchDiagRel3HC: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            var seguirdx = false;
            var txt = Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase();
            Ext.getCmp('sysDiagRel3HC').setValue(txt);
            stCIE10.filterBy(function(record,id){
                return record.get('Codigo') ==  Ext.getCmp('sysDiagRel3HC').getValue(); 
            });
            stCIE10.each(function(record){
                Ext.getCmp('sysDiagRel3HCNom').setValue(record.get('Descripcion'));
                seguirdx = true;
            });
            if(!seguirdx){
                Ext.getCmp('sysDiagRel3HC').setValue('');
                Ext.getCmp('sysDiagRel3HCNom').setValue('');
            }  
        }
    },
    searchDiagRel2HC: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            var seguirdx = false;
            var txt = Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase();
            Ext.getCmp('sysDiagRel2HC').setValue(txt);
            stCIE10.filterBy(function(record,id){
                return record.get('Codigo') ==  Ext.getCmp('sysDiagRel2HC').getValue(); 
            });
            stCIE10.each(function(record){
                Ext.getCmp('sysDiagRel2HCNom').setValue(record.get('Descripcion'));
                seguirdx = true;
            });
            if(!seguirdx){
                Ext.getCmp('sysDiagRel2HC').setValue('');
                Ext.getCmp('sysDiagRel2HCNom').setValue('');
            }  
        }
    },
    searchDiagRel1HC: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            var seguirdx = false;
            var txt = Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase();
            Ext.getCmp('sysDiagRel1HC').setValue(txt);
            stCIE10.filterBy(function(record,id){
                return record.get('Codigo') ==  Ext.getCmp('sysDiagRel1HC').getValue(); 
            });
            stCIE10.each(function(record){
                Ext.getCmp('sysDiagRel1HCNom').setValue(record.get('Descripcion'));
                seguirdx = true;
            });
            if(!seguirdx){
                Ext.getCmp('sysDiagRel1HC').setValue('');
                Ext.getCmp('sysDiagRel1HCNom').setValue('');
            }  
        }
    },
    searchDiagPpalHC: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            var seguirdx = false;
            var txt = Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase();
            Ext.getCmp('sysDiagPpalHC').setValue(txt);
            stCIE10.filterBy(function(record,id){
                return record.get('Codigo') ==  Ext.getCmp('sysDiagPpalHC').getValue(); 
            });
            stCIE10.each(function(record){
                Ext.getCmp('sysDiagPpalHCNom').setValue(record.get('Descripcion'));
                seguirdx = true;
            });
            if(!seguirdx){
                Ext.getCmp('sysDiagPpalHC').setValue('');
                Ext.getCmp('sysDiagPpalHCNom').setValue('');
            }
        }
    },
    EliminarRegistroConcepto: function(){
        if(parseInt(Ext.getCmp('fYaGuardo').getValue()) === 0){
            if(Ext.getCmp('gridConceptosRegistroVenta').selModel.getCount() == 1){
                var idrec = Ext.getCmp('gridConceptosRegistroVenta').selModel.getSelected();
                Ext.Msg.show({
                    title: 'Conceptos',
                    msg: 'Esta seguro que desea eliminar el concepto ' + idrec.data.DesConceptoItem,
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn){
                        if(btn=="yes"){
                            Ext.getCmp('gridConceptosRegistroVenta').store.remove( idrec );
                            this.LiquidarValoresVenta();
                         }
                    }
                });
            }
        }else{
            Ext.Msg.show({
                title: 'POS - [Datos Básicos]',
                msg: 'La venta ya se guardo y no se puede modificar..!',
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    BuscarRadicacionEstudios: function(){
        buscarventas("POS OPTICA");
    },
    AdicionarRegistroConcepto: function(){
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        if(parseInt(Ext.getCmp('fYaGuardo').getValue()) === 0){
            var winAddRegistroPOS = new winAddRegistroConceptoItemUi();
            winAddRegistroPOS.title = NOM_APLICACION + ' .::Adicionar Concepto::.';
            var btn_AddConceptoItem = Ext.getCmp('btn_AddConceptoItem').on("click",this.GuardarConceptoItem,this);
            var btn_SalirConceptoItem = Ext.getCmp('btn_SalirConceptoItem').on("click",this.CerrarVentanaConceptoItem,this);
            winAddRegistroPOS.show();
        }else{
            Ext.Msg.show({
                title: 'POS - [Datos Básicos]',
                msg: 'La venta ya se guardo y no se puede modificar..!',
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    GuardarConceptoItem: function(){
        var frm = Ext.getCmp('frmAddConceptoItem').getForm();
        if ( frm.isValid() ){
            Ext.Msg.show({
                title: 'Conceptos',
                msg: 'Esta seguro que desea adicionar el concepto',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn){
                    if(btn=="yes")
                    {
                        var wTituloItem = "";
                        var wEntregado = " - [ITEM SIN ENTREGAR]";
                        if(Ext.getCmp('strEntregadoItem').getValue() === true){
                            wEntregado = " - [ITEM ENTREGADO]";
                        }
                        var recId = Ext.getCmp('gridConceptosRegistroVenta').store.getCount() + 1;
                        var st = new DTSConceptosRegistroVenta();
                        if(Ext.getCmp('intLoteConceptoItem').getRawValue() === "" || Ext.getCmp('intLoteConceptoItem').getRawValue() === null){
                            wTituloItem = Ext.getCmp('strCodConceptoItem').getValue() + " - " + Ext.getCmp('strDesConceptoItem').getValue() + wEntregado;
                        }else{
                            wTituloItem = Ext.getCmp('strCodConceptoItem').getValue() + " - " + Ext.getCmp('strDesConceptoItem').getValue() + "  - Lote: " + Ext.getCmp('intLoteConceptoItem').getRawValue() + wEntregado;
                        }
                        Ext.getCmp('gridConceptosRegistroVenta').store.add(new st.recordType({
                                IDReg: recId,
                                idConceptoItem: Ext.getCmp('intidConceptoItem').getValue(),
                                UsaLoteItem: Ext.getCmp('intUsaLoteItem').getValue(),
                                KardexItem: Ext.getCmp('intKardexItem').getValue(),
                                TituloItem: wTituloItem,
                                CodConceptoItem: Ext.getCmp('strCodConceptoItem').getValue(),
                                DesConceptoItem: Ext.getCmp('strDesConceptoItem').getValue(),
                                LoteConceptoItem: Ext.getCmp('intLoteConceptoItem').getValue(),
                                DesLoteConceptoItem: Ext.getCmp('intLoteConceptoItem').getRawValue(),
                                VlrTarifaItem: Ext.getCmp('intVlrTarifaItem').getValue(),
                                PorIVAItem: Ext.getCmp('intPorIVAItem').getValue(),
                                VlrIVAItem: Ext.getCmp('intVlrIVAItem').getValue(),
                                CantidadItem: Ext.getCmp('intCantidadItem').getValue(),
                                VlrTotalItem: Ext.getCmp('intVlrTotalItem').getValue(),
                                VlrCuotaModeradoraItem: Ext.getCmp('intVlrCuotaModeradoraItem').getValue(),
                                VlrCopagoItem: Ext.getCmp('intVlrCopagoItem').getValue(),
                                VlrDescuentosItem: Ext.getCmp('intVlrDescuentosItem').getValue(),
                                VlrEmpresaItem: Ext.getCmp('intVlrEmpresaItem').getValue(),
                                VlrNetoItem: Ext.getCmp('intVlrNetoItem').getValue(),
                                EntregadoItem: Ext.getCmp('strEntregadoItem').getValue(),
                                REFRACTIVO_RxOD_Esf: Ext.getCmp('strREFRACTIVO_RxOD_Esf').getValue(),
                                REFRACTIVO_RxOD_Cil: Ext.getCmp('strREFRACTIVO_RxOD_Cil').getValue(),
                                REFRACTIVO_RxOD_Eje: Ext.getCmp('strREFRACTIVO_RxOD_Eje').getValue(),
                                REFRACTIVO_RxOD_Add: Ext.getCmp('strREFRACTIVO_RxOD_Add').getValue(),
                                REFRACTIVO_RxOD_AVFL: Ext.getCmp('strREFRACTIVO_RxOD_AVFL').getValue(),
                                REFRACTIVO_RxOD_AVFP: Ext.getCmp('strREFRACTIVO_RxOD_AVFP').getValue(),
                                REFRACTIVO_RxOI_Esf: Ext.getCmp('strREFRACTIVO_RxOI_Esf').getValue(),
                                REFRACTIVO_RxOI_Cil: Ext.getCmp('strREFRACTIVO_RxOI_Cil').getValue(),
                                REFRACTIVO_RxOI_Eje: Ext.getCmp('strREFRACTIVO_RxOI_Eje').getValue(),
                                REFRACTIVO_RxOI_Add: Ext.getCmp('strREFRACTIVO_RxOI_Add').getValue(),
                                REFRACTIVO_RxOI_AVFL: Ext.getCmp('strREFRACTIVO_RxOI_AVFL').getValue(),
                                REFRACTIVO_RxOI_AVFP: Ext.getCmp('strREFRACTIVO_RxOI_AVFP').getValue(),
                                COLOR_TTO: Ext.getCmp('strCOLOR_TTO').getValue(),
                                COLOR_TTO_DESCRIPCION: Ext.getCmp('strCOLOR_TTO_DESCRIPCION').getValue(),
                                MONTURA: Ext.getCmp('strMONTURA').getValue(),
                                MONTURA_H: Ext.getCmp('strMONTURA_H').getValue(),
                                MONTURA_V: Ext.getCmp('strMONTURA_V').getValue(),
                                MONTURA_D: Ext.getCmp('strMONTURA_D').getValue(),
                                MONTURA_P: Ext.getCmp('strMONTURA_P').getValue(),
                                MONTURA_NP_OD: Ext.getCmp('strMONTURA_NP_OD').getValue(),
                                MONTURA_NP_OI: Ext.getCmp('strMONTURA_NP_OI').getValue(),
                                LABORATORIO_OBS: Ext.getCmp('strLABORATORIO_OBS').getValue()
                            })
                        );
                        Ext.getCmp('winAddRegistroConceptoItemUi').close();
                        this.LiquidarValoresVenta();
                    }
                }
            });
        }else{
            Ext.Msg.show({
                title: 'Conceptos',
                msg: 'Existen campos obligatorios que están vacios..!',
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    CerrarVentanaConceptoItem: function(){
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        Ext.Msg.show({
            title: NOM_APLICACION,
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winAddRegistroConceptoItemUi').close();
                }
            }
        });
    },
    BuscarRadicacionEstudios: function(){
       buscarventas("POS OPTICA");
    },
    BuscarPaciente: function(){
        buscarpaciente("POS");
    },
    SelectRangoSalarial: function(cmb, rec, idx) {
        Ext.getCmp('fPorCopagos').setValue(rec.data.Porcentaje);
        Ext.getCmp('fMaxCopago').setValue(rec.data.TopeEvento);
        Ext.getCmp('fvlrCuotaModeradoraIndicada').setValue(rec.data.VlrCuotaModeradora);
    },
    ValidarNumeroDocumentoPacSK: function(f,e){
        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
        {
            Ext.getCmp('fPacienteValido').setValue(0);
            Ext.getCmp('fGenero').setValue("");
            Ext.getCmp('fApe1').setValue("");
            Ext.getCmp('fApe2').setValue("");
            Ext.getCmp('fNom1').setValue("");
            Ext.getCmp('fNom2').setValue("");
            Ext.getCmp('fEdad').setValue("");
            Ext.getCmp('fDeptoMuni').setValue("");
            Ext.getCmp('fDireccion').setValue("");
            Ext.getCmp('fZona').setValue("");
            Ext.getCmp('fTel1').setValue("");
            Ext.getCmp('fTel2').setValue("");
            Ext.getCmp('fEmail').setValue("");
            Ext.getCmp('fFecNac').setValue("");
            Ext.getCmp('fEdad').setValue("");
            Ext.getCmp('fRegimen').setValue(1);
            Ext.getCmp('fTafiliado').setValue("");
            Ext.getCmp('fParentesco').setValue("");
            Ext.getCmp('fRango').setValue("");
            Ext.getCmp('fEstado').setValue("");
            Ext.getCmp('fPacienteValido').setValue(0);
            Ext.Msg.wait('Cargando Información del Paciente... por favor espere!');
            Ext.Ajax.request(
            {
                url: '../../controlador/pacientes/pacientes_cargardatos.php',
                params:{
                    pTdoc: Ext.getCmp('fTdoc').getValue(),
                    pDocumento: Ext.getCmp('fDocID').getValue()
                },
                success: function(response,options)
                {
                    var el = Ext.get('response'); 
                    var Respuesta = response.responseText;
                    var Contenido = Respuesta.split('^');
                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                        Ext.Msg.hide();
                        Ext.getCmp('fIdPaciente').setValue(0);
                        verListadoAtencion(Ext.getCmp('fIdEmpresa').getValue(),Ext.getCmp('fIdSede').getValue(),Ext.getCmp('fIdIPS').getValue(), Ext.getCmp('fTdoc').getValue(),Ext.getCmp('fDocID').getValue(),true,Ext.getCmp('fIdPaciente').getValue(),"Radicacion");
                        if (Ext.getCmp('fAtenderFueraListado').getValue() == 1)
                            Ext.getCmp('fPacienteValido').setValue(1);
                    } else {
                        Ext.getCmp('fIdPaciente').setValue(Contenido[0]);
                        Ext.getCmp('fTdoc').setValue(Contenido[1]);
                        Ext.getCmp('fGenero').setValue(Contenido[9]);
                        Ext.getCmp('fApe1').setValue(Contenido[3]);
                        Ext.getCmp('fApe2').setValue(Contenido[4]);
                        Ext.getCmp('fNom1').setValue(Contenido[5]);
                        Ext.getCmp('fNom2').setValue(Contenido[6]);
                        Ext.getCmp('fEdad').setValue(Contenido[8]);
                        Ext.getCmp('fDeptoMuni').setValue(Contenido[15]);
                        Ext.getCmp('fDireccion').setValue(Contenido[10]);
                        Ext.getCmp('fZona').setValue(Contenido[11]);
                        Ext.getCmp('fTel1').setValue(Contenido[12]);
                        Ext.getCmp('fTel2').setValue(Contenido[13]);
                        Ext.getCmp('fEmail').setValue(Contenido[14]);
                        if(Contenido[7] != null && Contenido[7] != ""){
                            var xfecnac = Contenido[7].split('-');
                            var dianac = xfecnac[0];
                            var mesnac = (xfecnac[1].length < 2)?'0':'';
                            mesnac += xfecnac[1];
                            var anonac = xfecnac[2];
                            Ext.getCmp('fFecNac').setValue(dianac + "-" + mesnac + "-" + anonac);
                            //Ext.getCmp('fEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fFecNac').getValue().format('Y/m/d')));
                            Ext.getCmp('fEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),Ext.getCmp('fFecNac').getValue()));
                        }
                        Ext.Ajax.request(
                        {
                            url: '../../controlador/pacientes/pacientes_sedeips.php',
                            params:{
                                pPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                pIPS: Ext.getCmp('fIdIPS').getValue()
                            },
                            success: function(response,options)
                            {
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null)
                                    if (Ext.getCmp('fAtenderFueraListado').getValue() == 1)
                                        Ext.getCmp('fPacienteValido').setValue(1);
                                else
                                    Ext.getCmp('fPacienteValido').setValue(1);
                            },
                            failure: function(response,options){
                                if (Ext.getCmp('fAtenderFueraListado').getValue() == 1)
                                    Ext.getCmp('fPacienteValido').setValue(1);
                            },
                            scope:this 
                        });
                        Ext.Msg.hide();
                        verListadoAtencion(Ext.getCmp('fIdEmpresa').getValue(),Ext.getCmp('fIdSede').getValue(),Ext.getCmp('fIdIPS').getValue(), Ext.getCmp('fTdoc').getValue(),Ext.getCmp('fDocID').getValue(),true,Ext.getCmp('fIdPaciente').getValue(),"Radicacion");
                    }
                },
                failure: function(response,options){
                    var el = Ext.get('response');
                    alert("error al comunicarse con el servidor.");
                },
                scope:this 
            });       
        }
    },
    ActualizaInfoPaciente: function(){
        if (Ext.getCmp('fIdPaciente').getValue() != 0 && Ext.getCmp('fApe1').isValid() && Ext.getCmp('fNom1').isValid() && Ext.getCmp('fRegimen').isValid() && Ext.getCmp('fGenero').isValid() && Ext.getCmp('fFecNac').isValid() && Ext.getCmp('fDeptoMuni').isValid() && Ext.getCmp('fDireccion').isValid() && Ext.getCmp('fTel1').isValid() && Ext.getCmp('fZona').isValid() && Ext.getCmp('fTafiliado').isValid() && Ext.getCmp('fRango').isValid())
        {
            Ext.Msg.show({
                title: 'Actualizar Paciente',
                msg: 'Esta seguro que desea actualizar la información del paciente',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        Ext.Ajax.request(
                        {
                            url: '../../controlador/pacientes/controlador_pacientes.php',
                            params:{
                                task: 'ACTUALIZAR',
                                pIdPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                pTDoc: Ext.getCmp('fTdoc').getValue(),
                                pDocID: Ext.getCmp('fDocID').getValue(),
                                pRegimen: Ext.getCmp('fRegimen').getValue(),
                                pGenero: Ext.getCmp('fGenero').getValue(),
                                pApe1: QuitarAcentosTxt(Ext.getCmp('fApe1').getValue().toUpperCase()),
                                pApe2: QuitarAcentosTxt(Ext.getCmp('fApe2').getValue().toUpperCase()),
                                pNom1: QuitarAcentosTxt(Ext.getCmp('fNom1').getValue().toUpperCase()),
                                pNom2: QuitarAcentosTxt(Ext.getCmp('fNom2').getValue().toUpperCase()),
                                pFecNac: Ext.getCmp('fFecNac').getValue().format("Y-m-d"),
                                pDeptoMuni: Ext.getCmp('fDeptoMuni').getValue(),
                                pDireccion: QuitarAcentosTxt(Ext.getCmp('fDireccion').getValue().toUpperCase()),
                                pTel1: QuitarAcentosTxt(Ext.getCmp('fTel1').getValue().toUpperCase()),
                                pTel2: QuitarAcentosTxt(Ext.getCmp('fTel2').getValue().toUpperCase()),
                                pZona: Ext.getCmp('fZona').getValue(),
                                pEmail: QuitarAcentosTxt(Ext.getCmp('fEmail').getValue()),
                                pTafiliado: Ext.getCmp('fTafiliado').getValue(),
                                pParentesco: Ext.getCmp('fParentesco').getValue(),
                                pRango: Ext.getCmp('fRango').getValue(),
                                pEstado: Ext.getCmp('fEstado').getValue(),
                                pIdEmpresa: Ext.getCmp('fIdEmpresa').getValue(),
                                pIdSede: Ext.getCmp('fIdSede').getValue(),
                                pIdIPS: Ext.getCmp('fIdIPS').getValue(),
                                pUsuario: Ext.get('idusuario').getValue()
                            },
                            success: function(response,options)
                            {
                                var Respuesta = response.responseText;
                                var Contenido = Respuesta.split('^');
                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                    Ext.MessageBox.show({
                                        title: 'Actualizando Paciente',
                                        msg: 'Ocurrio un error al actualizar la información del paciente o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                } else {
                                    Ext.MessageBox.show({
                                        title: 'Actualizando Paciente',
                                        msg: 'Se actualizo la información del paciente con exito...!',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                }
                            },
                            failure: function(response,options){
                                Ext.MessageBox.show({
                                    title: 'Actualizando Paciente',
                                    msg: 'Ocurrio un error al actualizar la información del paciente o no se pudo establecer conexión con el servidor.',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            },
                            scope:this
                        });
                    }
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Actualizando Paciente',
                msg: 'El Paciente no ha sido creado o por favor verifique los datos que son requeridos para actualizar el paciente.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    GuardarDatosBasicos: function(){
        Ext.getCmp('fPacienteValido').setValue(1);
        if(parseInt(Ext.getCmp('fYaGuardo').getValue()) === 0 && Ext.getCmp('strBodegaVentaPOS').getValue() !== "" && Ext.getCmp('strBodegaVentaPOS').getValue() !== null){
            var frm = Ext.getCmp('frmRadica').getForm();
            if ( frm.isValid() ){
                if (Ext.getCmp('fPacienteValido').getValue() == 1){
                    Ext.Msg.show({
                        title: 'Radicar Servicios',
                        msg: 'Esta seguro que desea Guardar la información  con los conceptos registrados',
                        buttons: Ext.Msg.YESNO,
                        icon: Ext.Msg.QUESTION,
                        fn: function(btn){
                            if(btn=="yes"){
                                var recId = Ext.getCmp('gridConceptosRegistroVenta').store.getCount();
                                if(recId < 1){
                                    Ext.MessageBox.show({
                                        title: 'Registro de Venta',
                                        msg: 'Debe registar al menos un concepto.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }else{
                                    Ext.Msg.wait('Guardando Venta... por favor espere!');
                                    var parametrosConceptos = "";
                                    Ext.getCmp('gridConceptosRegistroVenta').store.each(function(record){
                                        parametrosConceptos = parametrosConceptos + record.get('idConceptoItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('UsaLoteItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('KardexItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('CodConceptoItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('DesConceptoItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('LoteConceptoItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('VlrTarifaItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('PorIVAItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('VlrIVAItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('CantidadItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('VlrTotalItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('VlrCuotaModeradoraItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('VlrCopagoItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('VlrDescuentosItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('VlrEmpresaItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('VlrNetoItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('EntregadoItem') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('REFRACTIVO_RxOD_Esf') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('REFRACTIVO_RxOD_Cil') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('REFRACTIVO_RxOD_Eje') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('REFRACTIVO_RxOD_Add') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('REFRACTIVO_RxOD_AVFL') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('REFRACTIVO_RxOD_AVFP') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('REFRACTIVO_RxOI_Esf') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('REFRACTIVO_RxOI_Cil') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('REFRACTIVO_RxOI_Eje') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('REFRACTIVO_RxOI_Add') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('REFRACTIVO_RxOI_AVFL') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('REFRACTIVO_RxOI_AVFP') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('COLOR_TTO') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('COLOR_TTO_DESCRIPCION') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('MONTURA') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('MONTURA_H') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('MONTURA_V') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('MONTURA_D') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('MONTURA_P') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('MONTURA_NP_OD') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('MONTURA_NP_OI') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('LABORATORIO_OBS') +  "|^|";
                                        parametrosConceptos = parametrosConceptos + record.get('IDReg');
                                        parametrosConceptos = parametrosConceptos + "|¬|";
                                    });
                                    if (Ext.getCmp('fCas').getValue() == 0){
                                        Ext.Ajax.request({
                                            url: '../../controlador/posoptica/guardar_venta.php',
                                            params:{
                                                pIdPaciente: Ext.getCmp('fIdPaciente').getValue(),
                                                pTDoc: Ext.getCmp('fTdoc').getValue(),
                                                pDocID: Ext.getCmp('fDocID').getValue(),
                                                pRegimen: Ext.getCmp('fRegimen').getValue(),
                                                pGenero: Ext.getCmp('fGenero').getValue(),
                                                pApe1: QuitarAcentosTxt(Ext.getCmp('fApe1').getValue().toUpperCase()),
                                                pApe2: QuitarAcentosTxt(Ext.getCmp('fApe2').getValue().toUpperCase()),
                                                pNom1: QuitarAcentosTxt(Ext.getCmp('fNom1').getValue().toUpperCase()),
                                                pNom2: QuitarAcentosTxt(Ext.getCmp('fNom2').getValue().toUpperCase()),
                                                //pFecNac: Ext.getCmp('fFecNac').getValue().format("Y-m-d"),
                                                pFecNac: Ext.getCmp('fFecNac').getValue(),
                                                pDeptoMuni: Ext.getCmp('fDeptoMuni').getValue(),
                                                pDireccion: QuitarAcentosTxt(Ext.getCmp('fDireccion').getValue().toUpperCase()),
                                                pTel1: QuitarAcentosTxt(Ext.getCmp('fTel1').getValue().toUpperCase()),
                                                pTel2: QuitarAcentosTxt(Ext.getCmp('fTel2').getValue().toUpperCase()),
                                                pZona: Ext.getCmp('fZona').getValue(),
                                                pEmail: QuitarAcentosTxt(Ext.getCmp('fEmail').getValue()),
                                                pTafiliado: Ext.getCmp('fTafiliado').getValue(),
                                                pParentesco: Ext.getCmp('fParentesco').getValue(),
                                                pRango: Ext.getCmp('fRango').getValue(),
                                                pEstado: Ext.getCmp('fEstado').getValue(),
                                                pIdEmpresa: Ext.getCmp('fIdEmpresa').getValue(),
                                                pIdSede: Ext.getCmp('fIdSede').getValue(),
                                                pIdIPS: Ext.getCmp('fIdIPS').getValue(),
                                                pBodega: Ext.getCmp('strBodegaVentaPOS').getValue(),
                                                pUsuario: Ext.get('idusuario').getValue(),
                                                pEdad: Ext.getCmp('fEdad').getValue(),
                                                pExento: Ext.getCmp('fExento').getValue(),
                                                pTutela: Ext.getCmp('fTutela').getValue(),
                                                pCliente: Ext.getCmp('fCliente').getValue(),
                                                pPlan: Ext.getCmp('fPlan').getValue(),
                                                pSubPlan: Ext.getCmp('fSubPlan').getValue(),
                                                pContrato: Ext.getCmp('fContrato').getValue(),
                                                pUsaListado: Ext.getCmp('fUsaListado').getValue(),
                                                pAtenderFueraListado: Ext.getCmp('fAtenderFueraListado').getValue(),
                                                pRequiereAutorizacion: Ext.getCmp('fRequiereAutorizacion').getValue(),
                                                pFacturarParticular: Ext.getCmp('fFacturarParticular').getValue(),
                                                pFacturarCopagos: Ext.getCmp('fFacturarCopagos').getValue(),
                                                pCopagoDigitado: Ext.getCmp('fCopagoDigitado').getValue(),
                                                pPorCopagos: Ext.getCmp('fPorCopagos').getValue(),
                                                pMaxCopago: Ext.getCmp('fMaxCopago').getValue(),
                                                pvlrCuotaModeradoraIndicada: Ext.getCmp('fvlrCuotaModeradoraIndicada').getValue(),
                                                pFecSol: Ext.getCmp('fFecSol').getValue().format("Y-m-d"),
                                                pPrograma: Ext.getCmp('fPrograma').getValue(),
                                                pAutorizacion: Ext.getCmp('fAutorizacion').getValue().toUpperCase(),
                                                pProfeSol: Ext.getCmp('fProfeSol').getValue(),
                                                pFinalidad: Ext.getCmp('fFinalidad').getValue(),
                                                pExentoPrograma: Ext.getCmp('fExentoPrograma').getValue(),
                                                //pCrearCASxServicio: Ext.getCmp('bolCrearCASxServicio').getValue(),
                                                pConceptos: parametrosConceptos,
                                                pVlrEstudiosCAS: Ext.getCmp('sysSubTotVenta').getValue(),
                                                pVlrIVACAS: Ext.getCmp('sysIVAVenta').getValue(),
                                                pVlrCMCAS: Ext.getCmp('sysCMVenta').getValue(),
                                                pVlrCOPCAS: Ext.getCmp('sysCOPVenta').getValue(),
                                                pVlrDescuentoCAS: Ext.getCmp('sysDescuentoVenta').getValue(),
                                                pVlrEmpresaCAS: Ext.getCmp('sysEmpresaVenta').getValue(),
                                                pVlrNetoCAS: Ext.getCmp('sysSaldoVenta').getValue(),
                                                pTipoRegistro: Ext.getCmp('strTipoVentaPOS').getValue()
                                            },
                                            success: function(response,options)
                                            {
                                                var Respuesta = response.responseText;
                                                var Contenido = Respuesta.split('^');
                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                    Ext.getCmp('fIdPaciente').setValue(0);
                                                    Ext.Msg.hide();
                                                    Ext.MessageBox.show({
                                                        title: 'POS',
                                                        msg: 'Ocurrio un error al guardar la información del paciente o no se pudo establecer conexión con el servidor.',
                                                        buttons: Ext.MessageBox.OK,
                                                        icon: Ext.MessageBox.ERROR
                                                    });
                                                } else {
                                                    Ext.Msg.hide();
                                                    Ext.Msg.show({
                                                        title: 'POS',
                                                        msg: 'Se Guardo el Registro de Ventas',
                                                        buttons: Ext.Msg.OK,
                                                        icon: Ext.MessageBox.INFO
                                                    });
                                                    Ext.getCmp('fCas').setValue(Contenido[0]);
                                                    Ext.getCmp('fNroCAS').setValue("Reg: " + Contenido[0]);
                                                    Ext.getCmp('fYaGuardo').setValue(1);
                                                    //this.NuevoServicio;
                                                }
                                            },
                                            failure: function(response,options){
                                                Ext.Msg.hide();
                                                Ext.MessageBox.show({
                                                    title: 'POS',
                                                    msg: 'Ocurrio un error al generar el registro de ventas o no se pudo establecer conexión con el servidor.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            },
                                            scope:this
                                        });
                                    }
                                }
                            }
                        }
                    });
                }else{
                    Ext.Msg.show({
                        title: 'POS - [Datos Básicos]',
                        msg: 'Paciente o Tercero no valido!',
                        buttons: Ext.Msg.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }else{
                Ext.Msg.show({
                    title: 'POS - [Datos Básicos]',
                    msg: 'Existen campos obligatorios que están vacios..!',
                    buttons: Ext.Msg.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        }else{
            Ext.Msg.show({
                title: 'POS - [Datos Básicos]',
                msg: 'La venta ya se guardo y no se puede modificar..!',
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    VerificaListado: function(){
        if (Ext.getCmp('fTdoc').getValue() == "" || Ext.getCmp('fTdoc').getValue() == null || Ext.getCmp('fDocID').getValue() == "" || Ext.getCmp('fDocID').getValue() == null)
        {
            Ext.Msg.show({
                title: 'Verificación del Listado de Atención',
                msg: 'Debe ingresar los datos de tipo de documento y numero de documento del paciente.',
                buttons: Ext.Msg.OK,
                icon: Ext.MessageBox.ERROR
            });
        } else {
            verListadoAtencion(Ext.getCmp('fIdEmpresa').getValue(),Ext.getCmp('fIdSede').getValue(),Ext.getCmp('fIdIPS').getValue(), Ext.getCmp('fTdoc').getValue(), Ext.getCmp('fDocID').getValue(),false,Ext.getCmp('fIdPaciente').getValue(),"Radicacion");
        }
    },
    Salir: function(){
        Ext.Msg.show({
            title: 'Salir',
            msg: 'Esta seguro que desea salir del sistema de radicación de servicios',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    NuevoServicio: function(){
        EsValido = false;
        Ext.Msg.show({
            title: 'Nuevo Registro',
            msg: 'Esta seguro que desea hacer un nuevo registro, si hace este se perdera la información ingresada hasta ahora',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    var frm = Ext.getCmp('frmRadica').getForm();
                    frm.reset();
                    frm.clearInvalid();
                    
                    Ext.getCmp('fIdPaciente').setValue(0);
                    Ext.getCmp('fCliente').clearValue();
                    Ext.getCmp('fPlan').clearValue();
                    Ext.getCmp('fSubPlan').clearValue();
                    Ext.getCmp('fContrato').clearValue();
                    Ext.getCmp('fCliente').setValue(null);
                    Ext.getCmp('fPlan').setValue(null);
                    Ext.getCmp('fSubPlan').setValue(null);
                    Ext.getCmp('fContrato').setValue(null);
                    Ext.getCmp('fPlan').store.removeAll(true);
                    Ext.getCmp('fSubPlan').store.removeAll(true);
                    Ext.getCmp('fContrato').store.removeAll(true);
                    Ext.getCmp('fClienteLA').setValue(0);
                    Ext.getCmp('fPlanLA').setValue(0);
                    Ext.getCmp('fSubPlanLA').setValue(0);
                    Ext.getCmp('fCliente').store.load({
                        params:{pSede:ID_IPS,pEmpresa:ID_EMPRESA}
                    });
                    Ext.getCmp('fPlan').disable();
                    Ext.getCmp('fSubPlan').disable();
                    Ext.getCmp('fNroCAS').setValue("Sin Registrar");
                    Ext.getCmp('fEstadoCAS').setValue("");
                    Ext.getCmp('fFecRadicado').setValue("");
                    Ext.getCmp('fPacienteValido').setValue(0);
                    paso1 = false;
                    paso2 = false;
                    paso3 = false;
                    paso4 = false;
                    paso5 = false;
                    Ext.getCmp('fYaLegalizado').setValue(0);
                    Ext.getCmp('fYaLiquidado').setValue(0);
                    Ext.getCmp('fCas').setValue(0);
                    Ext.getCmp('fNroCAS').setValue("Sin Registrar");
                    Ext.getCmp('fModificaCAS').setValue(1);
                    Ext.getCmp('gridConceptosRegistroVenta').store.removeAll();
                    EstblecerCamposEnabled();
                    Ext.getCmp('fDeptoMuni').setValue(ID_MUNICIPIO);
                    Ext.getCmp('strTipoVentaPOS').setReadOnly(false);
                    Ext.getCmp('pnDetalleServicio').update();
                    Ext.getCmp('gridFacturacionOrden').store.removeAll();
                }
            }
        });
    },
    LlamarAyuda : function(){
        MostrarAyuda(CodFrm);
    },
    UpdateDetalleSolMx: function(sm, rowIdx, r) {
        this.pnDetalleMx.update(r.data);
    },
    UpdateDetalleSolServicio: function(sm, rowIdx, r) {
        Ext.getCmp('pnDetalleServicio').update(r.data);
    },
    CrearProfesionalSolicitante: function() {
        var winProfeSol = new winProfeSolUi();
        winProfeSol.title = 'eOfiClinic .::Adicionar Profesional Solicitante::.';
        Ext.getCmp('btn_AdicionarProfeSol').setVisible(true);
        Ext.getCmp('btn_ModificarProfeSol').setVisible(false);
        Ext.getCmp('sysUsuario').setVisible(false);
        Ext.getCmp('sysFechaAct').setVisible(false);
        Ext.getCmp('intUsuario').setValue(ID_USUARIO);
        winProfeSol.show();
    },
    ValidarPrograma: function(cmb, rec, idx) {
        this.fFinalidad.setValue(rec.data.Finalidad);
        this.fExentoPrograma.setValue(rec.data.Exento);
    },
    MostrarEdad: function(f) {
        Ext.getCmp('fEdad').setValue(MostrarEdadCompleta(new Date().format('Y/m/d'),f.getValue().format('Y/m/d')));
    },
    ValidarParentesco: function(cmb, rec, idx) {
        if (cmb.getValue() != "C" && cmb.getValue() != "N"){
            this.fParentesco.enable();
            this.fParentesco.allowBlank = false;
        }else{
            this.fParentesco.clearValue();
            this.fParentesco.allowBlank = true;
            this.fParentesco.disable();
        }
    },
    ValidarRegimen: function(cmb, rec, idx) {
        this.fTafiliado.clearValue();
        this.fTafiliado.store.load({
            params: { 'pRegimen': cmb.getValue() }
        });
        this.fRango.clearValue();
        this.fRango.store.load({
            params: { 'pRegimen': cmb.getValue() }
        });
    },
    CargaCbPlan: function(cmb, rec, idx) {
        this.fUsaListado.setValue(rec.data.UsaListadoAtencion);
        this.fAtenderFueraListado.setValue(rec.data.AtenderFueraListado);
        this.fRequiereAutorizacion.setValue(rec.data.RequiereAutorizacion);
        if (Ext.getCmp('fAtenderFueraListado').getValue() == 1 && Ext.getCmp('fPacienteValido').getValue() == 0)
            Ext.getCmp('fPacienteValido').setValue(1);
        if (rec.data.RequiereAutorizacion == "1"){
            this.fAutorizacion.enable();
            this.fAutorizacion.allowBlank = false;
        }else{
            this.fAutorizacion.allowBlank = true;
            this.fAutorizacion.setValue(null);
            this.fAutorizacion.clearInvalid();
            this.fAutorizacion.disable();
        }
        this.fFacturarParticular.setValue(rec.data.FacturarParticular);
        Ext.getCmp('fFacturarCopagos').setValue(rec.data.FacturarCopagos);
        Ext.getCmp('fCopagoDigitado').setValue(rec.data.CopagoDigitado);
        //jorge
        this.fPlan.clearValue();
        this.fSubPlan.clearValue();
        this.fContrato.clearValue();
        Ext.getCmp('fPlan').store.removeAll(true);
        Ext.getCmp('fSubPlan').store.removeAll(true);
        Ext.getCmp('fContrato').store.removeAll(true);
        if(Ext.getCmp('strTipoVentaPOS').getValue() === "I"){
            this.fPlan.store.load({
                params: { 'pCliente': cmb.getValue() }
            });
            this.fPlan.enable();
            this.fContrato.store.load({
                params: { 'pCliente': cmb.getValue() }
            });
            this.fContrato.enable();
            if (Ext.getCmp('fClienteLA').getValue() == 0)
                this.fEstado.clearValue();
            if (this.fUsaListado.getValue() == "1"){
                this.fEstado.enable();
                this.fEstado.allowBlank = false;
            } else {
                this.fEstado.disable();
                this.fEstado.allowBlank = true;
            }
        }
        
    },
    CargaCbSubPlan: function(cmb, rec, idx) {
        this.fSubPlan.clearValue();
        Ext.getCmp('fSubPlan').store.removeAll(true);
        //alert(Ext.getCmp('fSubPlanLA').getValue());
        //if (Ext.getCmp('fSubPlanLA').getValue() == 0)
        //{
            this.fSubPlan.store.load({
                params: { 'pPlan': cmb.getValue() }
            });
        //}
        this.fSubPlan.enable();
    }
});

function LiquidarValoresVenta(){
    var SUBTOT = 0;
    var CM = 0;
    var COP = 0;
    var IVA = 0;
    var DES = 0;
    var VLREMPRESA = 0;
    var NET = 0;
    Ext.getCmp('gridConceptosRegistroVenta').store.each(function(record){
        IVA = IVA + (record.get('VlrIVAItem') * record.get('CantidadItem'));
        SUBTOT = SUBTOT + record.get('VlrTotalItem');
        CM = CM + record.get('VlrCuotaModeradoraItem');
        COP = COP + record.get('VlrCopagoItem');
        DES = DES + record.get('VlrDescuentosItem');
        VLREMPRESA = VLREMPRESA + record.get('VlrEmpresaItem');
        NET = NET + record.get('VlrNetoItem');
    });
    Ext.getCmp('sysSubTotVenta').setValue(0);
    Ext.getCmp('sysCMVenta').setValue(0);
    Ext.getCmp('sysCOPVenta').setValue(0);
    Ext.getCmp('sysDescuentoVenta').setValue(0);
    Ext.getCmp('sysEmpresaVenta').setValue(0);
    Ext.getCmp('sysSaldoVenta').setValue(0);
    Ext.getCmp('sysIVAVenta').setValue(0);

    Ext.getCmp('sysIVAVenta').setValue(IVA);
    Ext.getCmp('sysSubTotVenta').setValue(SUBTOT);
    Ext.getCmp('sysCMVenta').setValue(CM);
    Ext.getCmp('sysCOPVenta').setValue(COP);
    Ext.getCmp('sysDescuentoVenta').setValue(DES);
    Ext.getCmp('sysEmpresaVenta').setValue(VLREMPRESA);
    Ext.getCmp('sysSaldoVenta').setValue(NET);
}

function EstblecerCamposEnabled(){
    Ext.getCmp('fTdoc').enable();
    Ext.getCmp('fDocID').enable();
    Ext.getCmp('fRegimen').enable();
    Ext.getCmp('fGenero').enable();
    Ext.getCmp('fApe1').enable();
    Ext.getCmp('fApe2').enable();
    Ext.getCmp('fNom1').enable();
    Ext.getCmp('fNom2').enable();
    Ext.getCmp('fFecNac').enable();
    Ext.getCmp('fDeptoMuni').enable();
    Ext.getCmp('fDireccion').enable();
    Ext.getCmp('fTel1').enable();
    Ext.getCmp('fTel2').enable();
    Ext.getCmp('fZona').enable();
    Ext.getCmp('fEmail').enable();
    Ext.getCmp('fTafiliado').enable();
    Ext.getCmp('fRango').enable();
    Ext.getCmp('fCliente').enable();
    Ext.getCmp('fFecSol').enable();
    Ext.getCmp('fPrograma').enable();
    Ext.getCmp('fProfeSol').enable();
}

function EstblecerCamposDisabled(){
    Ext.getCmp('fTdoc').disable();
    Ext.getCmp('fDocID').disable();
    Ext.getCmp('fRegimen').disable();
    Ext.getCmp('fGenero').disable();
    Ext.getCmp('fApe1').disable();
    Ext.getCmp('fApe2').disable();
    Ext.getCmp('fNom1').disable();
    Ext.getCmp('fNom2').disable();
    Ext.getCmp('fFecNac').disable();
    Ext.getCmp('fDeptoMuni').disable();
    Ext.getCmp('fDireccion').disable();
    Ext.getCmp('fTel1').disable();
    Ext.getCmp('fTel2').disable();
    Ext.getCmp('fZona').disable();
    Ext.getCmp('fEmail').disable();
    Ext.getCmp('fTafiliado').disable();
    Ext.getCmp('fRango').disable();
    Ext.getCmp('fCliente').disable();
    Ext.getCmp('fFecSol').disable();
    Ext.getCmp('fPrograma').disable();
    Ext.getCmp('fProfeSol').disable();
}

function fnBorrarConcepto(wConsecutivoDetale)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: '../../controlador/radicacionservicios/guardar_datosbasicos.php',
        params:{
            PROCESO: 'EliminarConcepto',
            pConsecutivoDetalle: wConsecutivoDetale
        },
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    Ext.getCmp('gridServicios').store.reload();
                    Ext.MessageBox.show({
                        title: 'eOfiClinic',
                        msg: 'Se elimino con exito el concepto seleccionado',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    });
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar los registros en estos momentos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}