/*
* @category    Formulario Registro de Concepto a Radicar
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddRegistroConceptoItemUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Adicionar Conceptos ::.',
    width: 980,
    autoHeight: true,
    autoScroll: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winAddRegistroConceptoItemUi',
    initComponent: function() {
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        
        var stLotesxConceptoInv = new StoreLotesxConcepto();
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAddConceptoItem',
                padding: 10,
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Concepto',
                            iconCls: 'btnGuardar',
                            id: 'btn_AddConceptoItem'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirConceptoItem'
                        }
                    ]
                },
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'hidden',
                                flex: 1,
                                readOnly: true,
                                width: 96,
                                id: 'intidConceptoItem'
                            },
                            {
                                xtype: 'hidden',
                                flex: 1,
                                readOnly: true,
                                width: 96,
                                id: 'intUsaLoteItem'
                            },
                            {
                                xtype: 'hidden',
                                flex: 1,
                                readOnly: true,
                                width: 96,
                                id: 'intKardexItem'
                            },
                            {
                                xtype: 'compositefield',
                                frame: true,
                                fieldLabel: 'Codigo Barras',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 130,
                                        allowBlank: true,
                                        id: 'sysFilterCodBarrasItem',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB && Ext.getCmp('sysFilterCodBarrasItem').getValue() !== "" && Ext.getCmp('sysFilterCodBarrasItem').getValue() !== null){
                                                    Ext.Ajax.request({
                                                        url: '../../controlador/conceptos/controlador_conceptos.php',
                                                        params:{
                                                            task: 'SEARCH_CONCEPTO_BARRAS',
                                                            pBarras: Ext.getCmp('sysFilterCodBarrasItem').getValue()
                                                        },
                                                        success: function(response,options)
                                                        {
                                                            var Respuesta = response.responseText;
                                                            var Contenido = Respuesta.split('^');
                                                            if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                Ext.MessageBox.show({
                                                                    title: 'eOfiClinic',
                                                                    msg: 'El Codigo de Barras no esta asociado a ningun concepto.',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            } else {
                                                                Ext.getCmp('intLoteConceptoItem').store.removeAll();
                                                                Ext.getCmp('intUsaLoteItem').setValue(Contenido[3]);
                                                                Ext.getCmp('intidConceptoItem').setValue(Contenido[0]);
                                                                Ext.getCmp('strCodConceptoItem').setValue(Contenido[1]);
                                                                Ext.getCmp('strDesConceptoItem').setValue(Contenido[2]);
                                                                if(parseInt(Ext.getCmp('intUsaLoteItem').getValue()) === 1){
                                                                    Ext.getCmp('intLoteConceptoItem').store.load({
                                                                        params:{
                                                                            pConcepto: Ext.getCmp('intidConceptoItem').getValue()
                                                                        }
                                                                    });
                                                                    Ext.getCmp('intLoteConceptoItem').allowBlank = false;
                                                                    Ext.getCmp('intLoteConceptoItem').setVisible(true);
                                                                }else{
                                                                    Ext.getCmp('intLoteConceptoItem').setValue(null);
                                                                    Ext.getCmp('intLoteConceptoItem').clearInvalid();
                                                                    Ext.getCmp('intLoteConceptoItem').allowBlank = true;
                                                                    Ext.getCmp('intLoteConceptoItem').setVisible(false);
                                                                }
                                                                var wVlarIVA = 0;
                                                                if(Contenido[5] !== "" && Contenido[5] !== null){
                                                                    wVlarIVA = Contenido[5];
                                                                }
                                                                Ext.getCmp('intPorIVAItem').setValue(wVlarIVA);
                                                                Ext.getCmp('intKardexItem').setValue(Contenido[5]);
                                                            }
                                                        },
                                                        failure: function(response,options){
                                                            Ext.MessageBox.show({
                                                                title: 'Error Conexión',
                                                                msg: 'El Codigo de Barras no esta asociado a ningun concepto.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        },
                                                        scope:this 
                                                    });
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Concepto',
                                        id: 'btnSearchConceptoItem',
                                        handler:function(){
                                            buscarconceptoBasico('POS OPTICA');
                                        }
                                    },
                                    {
                                        xtype: 'textfield',
                                        readOnly: true,
                                        width: 96,
                                        allowBlank: false,
                                        style: 'color: #0000cc; font-weight: bold;',
                                        id: 'strCodConceptoItem'
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 475,
                                        style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                        id: 'strDesConceptoItem'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Lote',
                                anchor: '100%',
                                allowBlank: false,
                                store: stLotesxConceptoInv,
                                valueField: 'IdLoteVencimiento',
                                displayField: 'NroLote',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                itemSelector: 'div.cbLote',
                                tpl: '<tpl for="."><div class="cbLote"><h3>{NroLote}</h3>Vencimiento: {FecVencimiento}<hr /></div></tpl>',
                                id: 'intLoteConceptoItem'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                anchor: '100%',
                                fieldLabel: 'Vlr Tarifa',
                                items: [
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        width: 150,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'intVlrTarifaItem',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    var TARIFA = parseFloat(Ext.getCmp('intVlrTarifaItem').getValue());
                                                    if(Ext.getCmp('intVlrTarifaItem').getValue()==null || Ext.getCmp('intVlrTarifaItem').getValue()==""){
                                                        TARIFA = 0;  
                                                        Ext.getCmp('intVlrTarifaItem').setValue(0);
                                                    }
                                                    var PORIVA = parseFloat(Ext.getCmp('intPorIVAItem').getValue()/100);
                                                    var IVA = TARIFA * PORIVA;
                                                    Ext.getCmp('intVlrIVAItem').setValue(IVA);
                                                    var CANT = parseInt(Ext.getCmp('intCantidadItem').getValue());
                                                    var SUBTOT = TARIFA * CANT;
                                                    var CM = parseFloat(Ext.getCmp('intVlrCuotaModeradoraItem').getValue());
                                                    var COP = parseFloat(Ext.getCmp('intVlrCopagoItem').getValue());
                                                    var IVA = parseFloat(Ext.getCmp('intPorIVAItem').getValue()/100);
                                                    var DES = parseFloat(Ext.getCmp('intVlrDescuentosItem').getValue());
                                                    var VLREMPRESA = parseFloat(Ext.getCmp('intVlrEmpresaItem').getValue());
                                                    var NET = SUBTOT + CM + COP - DES - VLREMPRESA;
                                                    Ext.getCmp('intVlrTotalItem').setValue(SUBTOT);
                                                    Ext.getCmp('intVlrNetoItem').setValue(NET);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'IVA:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "%",
                                        width: 60,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'intPorIVAItem',
                                        readOnly: true
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        width: 150,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'intVlrIVAItem',
                                        readOnly: true
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Cantidad:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        minValue: 1,
                                        width: 50,
                                        value: 1,
                                        decimalPrecision: 0,
                                        allowBlank: false,
                                        id: 'intCantidadItem',
                                        listeners:
                                        {
                                            scope: this,
                                            specialkey: function(f,e)
                                            {
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                {
                                                    if(Ext.getCmp('intCantidadItem').getValue()==null || Ext.getCmp('intCantidadItem').getValue()==""){
                                                        CM = 0;  
                                                        Ext.getCmp('intCantidadItem').setValue(1);
                                                    }
                                                    var TARIFA = parseFloat(Ext.getCmp('intVlrTarifaItem').getValue());
                                                    var PORIVA = parseFloat(Ext.getCmp('intPorIVAItem').getValue()/100);
                                                    var IVA = TARIFA * PORIVA;
                                                    Ext.getCmp('intVlrIVAItem').setValue(IVA);
                                                    var CANT = parseInt(Ext.getCmp('intCantidadItem').getValue());
                                                    var SUBTOT = TARIFA * CANT;
                                                    var CM = parseFloat(Ext.getCmp('intVlrCuotaModeradoraItem').getValue());
                                                    var COP = parseFloat(Ext.getCmp('intVlrCopagoItem').getValue());
                                                    var IVA = parseFloat(Ext.getCmp('intPorIVAItem').getValue()/100);
                                                    var DES = parseFloat(Ext.getCmp('intVlrDescuentosItem').getValue());
                                                    var VLREMPRESA = parseFloat(Ext.getCmp('intVlrEmpresaItem').getValue());
                                                    var NET = SUBTOT + CM + COP - DES - VLREMPRESA;
                                                    Ext.getCmp('intVlrTotalItem').setValue(SUBTOT);
                                                    Ext.getCmp('intVlrNetoItem').setValue(NET);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'displayfield',
                                        value: 'Subtotal:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        width: 150,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'intVlrTotalItem',
                                        readOnly: true
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numericfield',
                                        fieldLabel: 'Vlr Cuota Moderadora',
                                        currencySymbol: "$",
                                        width: 150,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'intVlrCuotaModeradoraItem',
                                        listeners:{
                                            scope: this,
                                            specialkey: function(f,e){
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                    if(Ext.getCmp('intVlrCuotaModeradoraItem').getValue()==null || Ext.getCmp('intVlrCuotaModeradoraItem').getValue()==""){
                                                        CM = 0;  
                                                        Ext.getCmp('intVlrCuotaModeradoraItem').setValue(0);
                                                    }
                                                    var TARIFA = parseFloat(Ext.getCmp('intVlrTarifaItem').getValue());
                                                    var PORIVA = parseFloat(Ext.getCmp('intPorIVAItem').getValue()/100);
                                                    var IVA = TARIFA * PORIVA;
                                                    Ext.getCmp('intVlrIVAItem').setValue(IVA);
                                                    var CANT = parseInt(Ext.getCmp('intCantidadItem').getValue());
                                                    var SUBTOT = TARIFA * CANT;
                                                    var CM = parseFloat(Ext.getCmp('intVlrCuotaModeradoraItem').getValue());
                                                    var COP = parseFloat(Ext.getCmp('intVlrCopagoItem').getValue());
                                                    var IVA = parseFloat(Ext.getCmp('intPorIVAItem').getValue()/100);
                                                    var DES = parseFloat(Ext.getCmp('intVlrDescuentosItem').getValue());
                                                    var VLREMPRESA = parseFloat(Ext.getCmp('intVlrEmpresaItem').getValue());
                                                    var NET = SUBTOT + CM + COP - DES - VLREMPRESA;
                                                    Ext.getCmp('intVlrTotalItem').setValue(SUBTOT);
                                                    Ext.getCmp('intVlrNetoItem').setValue(NET);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Vlr Copago:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        width: 150,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'intVlrCopagoItem',
                                        listeners:{
                                            scope: this,
                                            specialkey: function(f,e){
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                    if(Ext.getCmp('intVlrCopagoItem').getValue()==null || Ext.getCmp('intVlrCopagoItem').getValue()==""){
                                                        COP = 0;  
                                                        Ext.getCmp('intVlrCopagoItem').setValue(0);
                                                    }
                                                    var TARIFA = parseFloat(Ext.getCmp('intVlrTarifaItem').getValue());
                                                    var PORIVA = parseFloat(Ext.getCmp('intPorIVAItem').getValue()/100);
                                                    var IVA = TARIFA * PORIVA;
                                                    Ext.getCmp('intVlrIVAItem').setValue(IVA);
                                                    var CANT = parseInt(Ext.getCmp('intCantidadItem').getValue());
                                                    var SUBTOT = TARIFA * CANT;
                                                    var CM = parseFloat(Ext.getCmp('intVlrCuotaModeradoraItem').getValue());
                                                    var COP = parseFloat(Ext.getCmp('intVlrCopagoItem').getValue());
                                                    var IVA = parseFloat(Ext.getCmp('intPorIVAItem').getValue()/100);
                                                    var DES = parseFloat(Ext.getCmp('intVlrDescuentosItem').getValue());
                                                    var VLREMPRESA = parseFloat(Ext.getCmp('intVlrEmpresaItem').getValue());
                                                    var NET = SUBTOT + CM + COP - DES - VLREMPRESA;
                                                    Ext.getCmp('intVlrTotalItem').setValue(SUBTOT);
                                                    Ext.getCmp('intVlrNetoItem').setValue(NET);
                                                }
                                            }
                                        }
                                    },
                                    {
                                        html: 'Vlr Descuentos:'
                                    },
                                    {
                                        xtype: 'numericfield',
                                        currencySymbol: "$",
                                        width: 150,
                                        value: 0,
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        id: 'intVlrDescuentosItem',
                                        listeners:{
                                            scope: this,
                                            specialkey: function(f,e){
                                                if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                                    if(Ext.getCmp('intVlrDescuentosItem').getValue()==null || Ext.getCmp('intVlrDescuentosItem').getValue()==""){
                                                        DES = 0;  
                                                        Ext.getCmp('intVlrDescuentosItem').setValue(0);
                                                    }
                                                    var TARIFA = parseFloat(Ext.getCmp('intVlrTarifaItem').getValue());
                                                    var PORIVA = parseFloat(Ext.getCmp('intPorIVAItem').getValue()/100);
                                                    var IVA = TARIFA * PORIVA;
                                                    Ext.getCmp('intVlrIVAItem').setValue(IVA);
                                                    var CANT = parseInt(Ext.getCmp('intCantidadItem').getValue());
                                                    var SUBTOT = TARIFA * CANT;
                                                    var CM = parseFloat(Ext.getCmp('intVlrCuotaModeradoraItem').getValue());
                                                    var COP = parseFloat(Ext.getCmp('intVlrCopagoItem').getValue());
                                                    var IVA = parseFloat(Ext.getCmp('intPorIVAItem').getValue()/100);
                                                    var DES = parseFloat(Ext.getCmp('intVlrDescuentosItem').getValue());
                                                    var VLREMPRESA = parseFloat(Ext.getCmp('intVlrEmpresaItem').getValue());
                                                    var NET = SUBTOT + CM + COP - DES - VLREMPRESA;
                                                    Ext.getCmp('intVlrTotalItem').setValue(SUBTOT);
                                                    Ext.getCmp('intVlrNetoItem').setValue(NET);
                                                }
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'numericfield',
                                fieldLabel: 'Vlr Empresa',
                                width: 150,
                                value: 0,
                                currencySymbol: "$",
                                useThousandSeparator: true,
                                alwaysDisplayDecimals: true,
                                thousandSeparator: ',',
                                minValue: 0,
                                decimalPrecision: 2,
                                allowBlank: false,
                                id: 'intVlrEmpresaItem',
                                listeners:{
                                    scope: this,
                                    specialkey: function(f,e){
                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB){
                                            if(Ext.getCmp('intVlrEmpresaItem').getValue()==null || Ext.getCmp('intVlrEmpresaItem').getValue()==""){
                                                DES = 0;  
                                                Ext.getCmp('intVlrEmpresaItem').setValue(0);
                                            }
                                            var TARIFA = parseFloat(Ext.getCmp('intVlrTarifaItem').getValue());
                                            var PORIVA = parseFloat(Ext.getCmp('intPorIVAItem').getValue()/100);
                                            var IVA = TARIFA * PORIVA;
                                            Ext.getCmp('intVlrIVAItem').setValue(IVA);
                                            var CANT = parseInt(Ext.getCmp('intCantidadItem').getValue());
                                            var SUBTOT = TARIFA * CANT;
                                            var CM = parseFloat(Ext.getCmp('intVlrCuotaModeradoraItem').getValue());
                                            var COP = parseFloat(Ext.getCmp('intVlrCopagoItem').getValue());
                                            var IVA = parseFloat(Ext.getCmp('intPorIVAItem').getValue()/100);
                                            var DES = parseFloat(Ext.getCmp('intVlrDescuentosItem').getValue());
                                            var VLREMPRESA = parseFloat(Ext.getCmp('intVlrEmpresaItem').getValue());
                                            var NET = SUBTOT + CM + COP - DES - VLREMPRESA;
                                            Ext.getCmp('intVlrTotalItem').setValue(SUBTOT);
                                            Ext.getCmp('intVlrNetoItem').setValue(NET);
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'numericfield',
                                        fieldLabel: 'Vlr Neto',
                                        width: 150,
                                        value: 0,
                                        currencySymbol: "$",
                                        useThousandSeparator: true,
                                        alwaysDisplayDecimals: true,
                                        thousandSeparator: ',',
                                        minValue: 0,
                                        decimalPrecision: 2,
                                        allowBlank: false,
                                        readOnly: true,
                                        id: 'intVlrNetoItem'
                                    },
                                    {
                                        html: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="font-size:14px; color:#00C;">Entregado:</span>'
                                    },
                                    {
                                        xtype: 'checkbox',
                                        name: 'Entregado',
                                        anchor: '100%',
                                        value: 'false',
                                        id: 'strEntregadoItem'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'fieldset',
                        title: 'LENTES',
                        anchor: '100%',
                        layout: 'form',
                        collapsible: true,
                        titleCollapse: true,
                        autoHeight: true,
                        items: [
                            {
                                xtype: 'panel',
                                autoHeight: true,
                                width: 885,
                                layout: {
                                    columns: 2,
                                    type: 'table'
                                },
                                items: [
                                    {           
                                        xtype: 'panel',
                                        layout: 'table',
                                        layoutConfig: {
                                            columns: 6
                                        },
                                        height: 85,
                                        width: 450,
                                        padding: 5,
                                        title: '<center>Rx OD</center>',
                                        items:[
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                width: 75,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 70,
                                                        fieldLabel: 'Esf',
                                                        name: 'Esf',
                                                        allowBlank: true,
                                                        id: 'strREFRACTIVO_RxOD_Esf'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                width: 75,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 70,
                                                        fieldLabel: 'Cil',
                                                        name: 'Cil',
                                                        allowBlank: true,
                                                        id: 'strREFRACTIVO_RxOD_Cil'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                width: 75,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 70,
                                                        fieldLabel: 'Eje',
                                                        name: 'Eje',
                                                        allowBlank: true,
                                                        id: 'strREFRACTIVO_RxOD_Eje'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                width: 75,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 70,
                                                        fieldLabel: 'Add',
                                                        name: 'Add',
                                                        allowBlank: true,
                                                        id: 'strREFRACTIVO_RxOD_Add'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                width: 75,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 70,
                                                        fieldLabel: 'AVFL',
                                                        name: 'AVFL',
                                                        allowBlank: true,
                                                        id: 'strREFRACTIVO_RxOD_AVFL'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                width: 75,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 70,
                                                        fieldLabel: 'AVFP',
                                                        name: 'AVFP',
                                                        allowBlank: true,
                                                        id: 'strREFRACTIVO_RxOD_AVFP'
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'table',
                                        layoutConfig: {
                                            columns: 6
                                        },
                                        height: 85,
                                        width: 450,
                                        padding: 5,
                                        title: '<center>Rx OI</center>',
                                        items:[
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                width: 75,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 65,
                                                        fieldLabel: 'Esf',
                                                        name: 'Esf',
                                                        allowBlank: true,
                                                        id: 'strREFRACTIVO_RxOI_Esf'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                width: 75,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 70,
                                                        fieldLabel: 'Cil',
                                                        name: 'Cil',
                                                        allowBlank: true,
                                                        id: 'strREFRACTIVO_RxOI_Cil'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                width: 75,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 70,
                                                        fieldLabel: 'Eje',
                                                        name: 'Eje',
                                                        allowBlank: true,
                                                        id: 'strREFRACTIVO_RxOI_Eje'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                width: 75,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 70,
                                                        fieldLabel: 'Add',
                                                        name: 'Add',
                                                        allowBlank: true,
                                                        id: 'strREFRACTIVO_RxOI_Add'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                width: 65,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 60,
                                                        fieldLabel: 'AVFL',
                                                        name: 'AVFL',
                                                        allowBlank: true,
                                                        id: 'strREFRACTIVO_RxOI_AVFL'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                width: 65,
                                                border: false,
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        width: 60,
                                                        fieldLabel: 'AVFP',
                                                        name: 'AVFP',
                                                        allowBlank: true,
                                                        id: 'strREFRACTIVO_RxOI_AVFP'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 350,
                                        fieldLabel: 'Color y Tratamientos',
                                        name: 'Color y Tratamientos',
                                        allowBlank: true,
                                        id: 'strCOLOR_TTO'
                                    },
                                    {
                                        html: 'Descripcion: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 350,
                                        name: 'Descripcion',
                                        allowBlank: true,
                                        id: 'strCOLOR_TTO_DESCRIPCION'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 250,
                                        fieldLabel: 'Montura',
                                        name: 'Montura',
                                        allowBlank: true,
                                        id: 'strMONTURA'
                                    },
                                    {
                                        html: 'H: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 50,
                                        name: 'H',
                                        allowBlank: true,
                                        id: 'strMONTURA_H'
                                    },
                                    {
                                        html: 'V: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 50,
                                        name: 'V',
                                        allowBlank: true,
                                        id: 'strMONTURA_V'
                                    },
                                    {
                                        html: 'D: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 50,
                                        name: 'D',
                                        allowBlank: true,
                                        id: 'strMONTURA_D'
                                    },
                                    {
                                        html: 'P: '
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 50,
                                        name: 'P',
                                        allowBlank: true,
                                        id: 'strMONTURA_P'
                                    },
                                    {
                                        html: '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;- NP: O.D.'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 50,
                                        name: 'NP: OD',
                                        allowBlank: true,
                                        id: 'strMONTURA_NP_OD'
                                    },
                                    {
                                        html: 'O.I.'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 50,
                                        name: 'NP: OI',
                                        allowBlank: true,
                                        id: 'strMONTURA_NP_OI'
                                    }
                                ]
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Laboratorio',
                                name: 'Laboratorio',
                                allowBlank: true,
                                id: 'strLABORATORIO_OBS'
                            }
                        ]
                    }
                ]
            }
        ];
        winAddRegistroConceptoItemUi.superclass.initComponent.call(this);
    }
});
