/*
* @category    Cargar Cargar Imagenes por Paciente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

CargarImagenesxPacienteUi = Ext.extend(Ext.Window, {
    layout: 'fit',
    id: 'CargarImagenesxPacienteUi',
    width: 560,
    autoHeight: true,
    closeAction: 'hide',
    plain: true,
    modal: true,
    frame: true,
    border: false,
    closable: false,
    draggable: false,
    resizable: false,
    title: 'Adjuntar Imagenes por Paciente',

    initComponent: function() {
        el = Ext.get('idxac');
        var xID_CONSULTORIO = el.getValue();
        el = Ext.get('idaplicacion');
        NOM_APLICACION = el.getValue();
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();

        var frmCargarArchivo = new Ext.FormPanel({
            closeAction: 'hide',
            fileUpload: true,
            labelWidth: 80,
            frame: true,
            autoHeight: true,
            //height: 49,
            url: '../../controlador/pacientes/controlador_filesasoc.php',
            bodyStyle: 'padding:0px 0px 30px',
            defaults: {
                allowBlank: false
            },
            items: [
                {
                    xtype: 'hidden',
                    anchor: '100%',
                    allowBlank: true,
                    name: 'sysPacienteImg',
                    id: 'sysPacienteImg'
                },
                {
                    xtype: 'textfield',
                    fieldLabel: 'Nombre',
                    anchor: '100%',
                    name: 'txtNombreImgPac',
                    allowBlank: false,
                    id: 'txtNombreImgPac'
                },
                {
                    xtype: 'datefield',
                    fieldLabel: 'Fecha',
                    //anchor: '100%',
                    width: 120,
                    name: 'fecImgPac',
                    allowBlank: false,
                    disabledDates: '',
                    emptyText: '(dia/mes/año) ',
                    style: 'text-align:center;',
                    id: 'fecImgPac'
                },
                {
                    xtype: 'fileuploadfield',
                    anchor: '99%',
                    id: 'archivoImgxPac',
                    fieldLabel: 'Archivo',
                    name: 'firma-path',
                    buttonText: '...',
                    buttonCfg: {}
                },
                {
                    xtype: 'textarea',
                    fieldLabel: 'Notas',
                    anchor: '100%',
                    name: 'memNotasImgPac',
                    allowBlank: false,
                    id: 'memNotasImgPac'
                }
            ]
        });
    
        this.items = [
            frmCargarArchivo
        ];
        this.buttons = [
            {
                text: 'Adjuntar Imagen',
                iconCls: 'btnCargarFoto',
                handler: function(){
                    nomTarea = "GRABAR_OFIMEDICAL";
                    if(NOM_APLICACION == "OfiMedical"){
                        nomTarea = "GRABAR_OFIMEDICAL";
                    }else{
                        nomTarea = "GRABAR_OFICLINIC";
                    }
                    if (frmCargarArchivo.getForm().isValid()) {					
                        frmCargarArchivo.getForm().submit({
                            waitTitle: 'Estado',
                            waitMsg: 'Cargando Archivo ...',
                            params: {
                                task: nomTarea,
                                pPaciente: Ext.getCmp('sysPacienteImg').getValue()
                            },
                            success: function(form, action){
                                var data = Ext.util.JSON.decode(action.response.responseText);
                                Ext.Msg.show({
                                    title: NOM_APLICACION,
                                    msg: data.message.reason,
                                    buttons: Ext.Msg.OK,
                                    icon: Ext.Msg.INFO
                                });
                                winImgxPac.reloadStore();
                                Ext.getCmp('CargarImagenesxPacienteUi').close();
                            },
                            failure: function(form, action){
                                if (action.failureType == 'server') {
                                    var data = Ext.util.JSON.decode(action.response.responseText);
                                    Ext.Msg.show({
                                        title: NOM_APLICACION,
                                        msg: data.errors.reason,
                                        buttons: Ext.Msg.OK,
                                        icon: Ext.Msg.ERROR
                                    });
                                }
                            }
                        });
                    }
                }
            },
            {
                text: 'Salir',
                iconCls: 'btnSalir',
                handler: function(){
                    Ext.getCmp('CargarImagenesxPacienteUi').close();
                }
            }
        ];
        CargarImagenesxPacienteUi.superclass.initComponent.call(this);
    }
});
