var wIdPaciente = 0;

try {
    var campo = Ext.getCmp('intIdPaciente');
    if ( campo != null ) {
        wIdPaciente = Ext.getCmp('intIdPaciente').getValue();
    }
}catch(ex) {
}

if(wIdPaciente == 0){
    try {
        var campo1 = Ext.getCmp('sysIdPacienteHC');
        if ( campo1 != null ) {
            wIdPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
        }
    }catch(ex) {
    }
}

var winDocumentoAsocxPac = function(config){
    this.config = config;
};

winDocumentoAsocxPac.prototype = {
    lookup : {},
    show : function(el, callback){
        if(!this.win){
            this.initTemplates();
            var stImagenxPac = new Ext.data.JsonStore({
                id: 'stDocxPac',
                url: this.config.url,
		root: 'imagenes',
                baseParams: {
                    task: 'LISTAR_IMAGENES'
                },
		fields: [
                    {name:'IdRegistroImagen'},
                    {name:'Paciente'},
                    {name:'FechaRegistro'},
                    {name:'GrupoImagen'},
                    {name:'RutaImagen'},
                    {name:'NotasImagen'},
                    {name:'Usuario'}
                ],
		listeners: {
                    'load': {fn:function(){ this.view.select(0); }, scope:this, single:true}
                }
            });
            this.store = stImagenxPac;
            stImagenxPac.load({
                params:{
                    task: 'LISTAR_IMAGENES',
                    pPaciente: fnIdentificarPacDoc(), //Ext.getCmp('intIdPaciente').getValue(),
                    pNom: null,
                    pNota: null,
                    pOrden: 'Nombre'
                }
            });
            
            var formatData = function(data){
                data.shortName = data.GrupoImagen;
                data.dateString = data.FechaRegistro;
		this.lookup[data.IdRegistroImagen] = data;
                return data;
            };

            this.view = new Ext.DataView({
                id: 'viewDocxPac',
                tpl: this.thumbTemplate,
		singleSelect: true,
		overClass:'x-view-over',
		itemSelector: 'div.thumb-wrap',
		emptyText : '<div style="padding:10px;">No existen imagenes que coincidan con el filtro</div>',
		store: this.store,
		listeners: {
                    'selectionchange': {fn:this.showDetails, scope:this, buffer:100},
                    'dblclick'       : {fn:this.doCallback, scope:this},
                    'loadexception'  : {fn:this.onLoadException, scope:this},
                    'beforeselect'   : {fn:function(view){
                        return view.store.getRange().length > 0;
                    }}
                },
		prepareData: formatData.createDelegate(this)
            });

            var cfg = {
                title: 'Documentos Asociados al Paciente',
                id: 'doc-chooser-dlg',
                layout: 'border',
                maximized : true,
                minWidth: 500,
                minHeight: 300,
		modal: true,
		closeAction: 'hide',
		border: false,
		items:[
                    {
                        id: 'doc-chooser-view',
                        region: 'center',
                        autoScroll: true,
                        items: this.view,
                        tbar:[
                            {
                                xtype: 'button',
                                text: 'Adicionar',
                                iconCls: 'btnAddRow',
                                //id: 'btnAddDocxPac',
                                listeners:{
                                    click : function(){
                                        if (fnIdentificarPacDoc() != 0){
                                            var fileAdjuntarDoc;
                                            fileAdjuntarDoc = new CargarDocumentosxPacienteUi();
                                            Ext.getCmp('sysPacienteDoc').setValue(fnIdentificarPacDoc());
                                            fileAdjuntarDoc.show();
                                        }else{
                                            Ext.MessageBox.show({
                                                title: 'Error',
                                                msg: 'El Paciente no es valido o no ha sido creado',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar',
                                iconCls: 'btnDelRow',
                                id: 'btnDelDocxPac',
                                listeners:{
                                    click: function(){
                                        var selNode = Ext.getCmp('viewDocxPac').getSelectedNodes();
                                        if(selNode && selNode.length > 0){
                                            selNode = selNode[0];
                                            var data = this.lookup[selNode.id];
                                            if(data.Usuario == ID_USUARIO){
                                                var stView = this.store;
                                                Ext.Msg.show({
                                                    title: 'Eliminar Archivo....!',
                                                    msg: 'Esta seguro que desea eliminar el archivo seleccionado ' + data.GrupoImagen + '?',
                                                    buttons: Ext.Msg.YESNO,
                                                    icon: Ext.Msg.QUESTION,
                                                    fn: function(btn){
                                                        if(btn=="yes"){
                                                            fnEliminarArchivosxPac('../../controlador/pacientes/controlador_docsasoc.php',{task: "ELIMINAR_ARCHIVO", pRutaArchivo: data.RutaImagen.toLowerCase(), pidRegistro: data.IdRegistroImagen},stView);
                                                        }
                                                    }
                                                });
                                            }else{
                                                Ext.MessageBox.show({
                                                    title: 'Error',
                                                    msg: 'No se puede eliminar el archivo porque usted no fue el usuario que asocio este archivo al paciente',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        }
                                    }, scope:this
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'tbfill'
                            },
                            {
                                xtype: 'textfield',
                                emptyText: 'Nombre...!',
                                id: 'searchDocxPacNom',
                                width: 110
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'textfield',
                                emptyText: 'Notas...!',
                                id: 'searchDocxPacNota',
                                width: 110
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                text: 'Ordenar Por:'
                            },
                            {
                                id: 'searchDocxPacSort',
                                xtype: 'combo',
                                typeAhead: true,
                                triggerAction: 'all',
                                width: 100,
                                editable: false,
                                mode: 'local',
                                displayField: 'desc',
                                valueField: 'name',
                                lazyInit: false,
                                value: 'Nombre',
                                store: new Ext.data.ArrayStore({
                                    fields: ['name', 'desc'],
                                    data : [['Nombre', 'Nombre'],['FechaRegistro', 'Fecha']]
                                })
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                tooltip: 'Buscar Documento',
                                iconCls: 'btnBuscar',
                                id: 'btnEjecutarSearchDocxPac',
                                listeners:{
                                    click: function(){
                                        var detailEl = Ext.getCmp('doc-detail-panel').body;
                                        detailEl.update('');
                                        stImagenxPac.removeAll(true);
                                        stImagenxPac.load();
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                tooltip: 'Limpiar Datos del Filtro',
                                iconCls: 'btnLimpiar',
                                id: 'btnCleanSearchDocxPac',
                                listeners:{
                                    click: function(){
                                        var detailEl = Ext.getCmp('doc-detail-panel').body;
                                        detailEl.update('');
                                        Ext.getCmp('searchDocxPacNom').setValue(null);
                                        Ext.getCmp('searchDocxPacNota').setValue(null);
                                        Ext.getCmp('searchDocxPacSort').setValue("Nombre");
                                        stDocumentoxPac.removeAll(true);
                                        stDocumentoxPac.load();
                                    }
                                }
                            }
                            
                        ]
                    },
                    {
                        id: 'doc-detail-panel',
                        region: 'east',
                        split: true,
                        width: 250,
                        minWidth: 250,
                        maxWidth: 250
                    }
                ],
		keys: {
                    key: 27, // Esc key
                    handler: function(){ this.win.hide(); },
                        scope: this
                }
            };
            Ext.apply(cfg, this.config);
            stImagenxPac.on('beforeload', function(store){
                store.baseParams = {
                    task: 'LISTAR_IMAGENES',
                    pPaciente: fnIdentificarPacDoc(), //Ext.getCmp('intIdPaciente').getValue(),
                    pNom: QuitarAcentosTxtMayusculas(Ext.getCmp('searchDocxPacNom').getValue().toUpperCase()),
                    pNota: QuitarAcentosTxtMayusculas(Ext.getCmp('searchDocxPacNota').getValue().toUpperCase()),
                    pOrden: QuitarAcentosTxtMayusculas(Ext.getCmp('searchDocxPacSort').getValue())
                };
            });
            this.win = new Ext.Window(cfg);
	}

	this.reset();
	this.win.show(el);
	this.callback = callback;
	this.animateTarget = el;
    },
    initTemplates : function(){
        this.thumbTemplate = new Ext.XTemplate(
            '<tpl for=".">',
            '<div class="thumb-wrap" id="{IdRegistroImagen}">',
            '<div class="thumb"><img src="../../../resources/varios/icon.png" title="{GrupoImagen}"></div>',
            '<span>{GrupoImagen}</span>',
            '<span>{FechaRegistro}</span></div>',
            '</tpl>'
        );
	this.thumbTemplate.compile();
        this.detailsTemplate = new Ext.XTemplate(
            '<div class="details">',
                '<tpl for=".">',
                    '<img src="../../../resources/varios/icon.png" width="220" height="200"><div class="details-info">',
                    '<b>Descripción:</b>',
                    '<span style="color:#00C; text-align:justify">{GrupoImagen}</span>',
                    '<b>Fecha:</b>',
                    '<span>{FechaRegistro}</span>',
                    '<b>Notas:</b>',
                    '<span style="text-align:justify">{NotasImagen}</span></div>',
                '</tpl>',
            '</div>'
        );
	this.detailsTemplate.compile();
    },
    showDetails : function(){
        var selNode = this.view.getSelectedNodes();
	var detailEl = Ext.getCmp('doc-detail-panel').body;
	if(selNode && selNode.length > 0){
            selNode = selNode[0];
            var data = this.lookup[selNode.id];
            detailEl.hide();
            this.detailsTemplate.overwrite(detailEl, data);
            detailEl.slideIn('l', {stopFx:true,duration:.2});
        }else{
            detailEl.update('');
        }
    },
    reloadStore: function(){
        this.store.reload();
    },
    filter : function(){
        var filter = Ext.getCmp('filter');
	this.view.store.filter('GrupoImagen', filter.getValue());
	this.view.select(0);
    },
    sortImages : function(){
        var v = Ext.getCmp('sortSelect').getValue();
    	this.view.store.sort(v, v == 'name' ? 'asc' : 'desc');
    	this.view.select(0);
    },
    reset : function(){
        if(this.win.rendered){
            //Ext.getCmp('filter').reset();
            this.view.getEl().dom.scrollTop = 0;
        }
	this.view.store.clearFilter();
	this.view.select(0);
    },
    doCallback : function(){
        var selNode = this.view.getSelectedNodes()[0];
	//var callback = this.callback;
	//var lookup = this.lookup;
        var data = this.lookup[selNode.id];
        wURL = data.RutaImagen.toLowerCase();
        //myURL = wURL.replace("../../../","http://www.e-oficlinic.com/oficlinic/");
        myURL = wURL.replace("../../../","");
        wNomImagen = data.GrupoImagen;
        window.open("../../controlador/pacientes/download.php?idFile="+myURL+"&nomFile="+wNomImagen,"Descargas");
        //window.open("../../controlador/pacientes/download.php?idFile="+"http://oficlinic.com/oficlinic/"+wURL.substr(9)+"&nomFile="+wNomImagen,"Descargas");
        
    },
    onLoadException : function(v,o){
        this.view.getEl().update('<div style="padding:10px;">Error cargar documentos.</div>');
    }
};

String.prototype.ellipse = function(maxLength){
    if(this.length > maxLength){
        return this.substr(0, maxLength-3) + '...';
    }
    return this;
};

function fnEliminarArchivosxPac(URL,arrParam, storeView){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 0:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el archivo en estos momentos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
                case 1:
                    Ext.MessageBox.show({
                        title: 'Documentos Asociadas al Paciente',
                        msg: 'se elimino el archivo con exito',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.INFO
                    });
                    storeView.removeAll(true);
                    storeView.load();
                    break;
                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el archivo en estos momentos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar el archivo en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnIdentificarPacDoc(){
    var wIdPaciente = 0;
    try {
        var campo = Ext.getCmp('intIdPaciente');
        if ( campo != null ) {
            wIdPaciente = Ext.getCmp('intIdPaciente').getValue();
        }
    }catch(ex) {
    }

    if(wIdPaciente == 0){
        try {
            var campo1 = Ext.getCmp('sysIdPacienteHC');
            if ( campo1 != null ) {
                wIdPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
            }
        }catch(ex) {
        }
    }
    
    return wIdPaciente;
}