/*
* @category    Programacion Eventos Formulario Cargar Base Datos Pacientes Salud P&P
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmCargarBDSPyP = Ext.extend(winFrmCargarBDSPyPUi, {
    initComponent: function() {
        winFrmCargarBDSPyP.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnLoadBD = Ext.getCmp('btnLoadBD').on("click",this.CargarBaseDatos,this);
        
    },
    CargarBaseDatos: function(){
        Ext.Msg.show({
            title: 'eOficlinic: Cargue Base Datos',
            msg: 'Esta seguro que desea cargar la base de datos seleccionada, si hace esto sera bajo su responsabilidad y NO se podra deshacer el proceso?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn){
                if(btn === "yes"){
                    var frm = Ext.getCmp('frmCargarBDSPyP').getForm();
                    if (frm.isValid()) {					
                        Ext.getCmp('frmCargarBDSPyP').getForm().submit({
                            waitTitle: 'Estado',
                            waitMsg: 'Cargando Archivo ...',
                            params: {
                                task: "CARGAR_SALUDPYP",
                                pUsuario: ID_USUARIO
                            },
                            success: function(form, action){
                                var data = Ext.util.JSON.decode(action.response.responseText);
                                Ext.Msg.show({
                                    title: "eOfiClinic",
                                    msg: data.message.reason,
                                    buttons: Ext.Msg.OK,
                                    icon: Ext.Msg.INFO
                                });
                                //Ext.getCmp('CargarImagenesxPacienteUi').close();
                            },
                            failure: function(form, action){
                                if (action.failureType == 'server') {
                                    var data = Ext.util.JSON.decode(action.response.responseText);
                                    Ext.Msg.show({
                                        title: "eOfiClinic",
                                        msg: data.errors.reason,
                                        buttons: Ext.Msg.OK,
                                        icon: Ext.Msg.ERROR
                                    });
                                }
                            }
                        });
                    }
                }
            }
        });
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn){
                if(btn === "yes"){
                    window.close();
                }
            }
        });
    }
    
});

