/*
* @category    Formulario Grid Notificación Reparación
* @package     OfiClinic Web
* @author      Héctor Iván Ramírez Cardona<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmKardexPacienteUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: KARDEX DE PACIENTES Y DEMANDA INDUCIDA  ::.',
    id: 'winFrmKardexPaciente',
    closable: false,
    width:980,
    height:600,
    plain:true,
    maximized:true,
    resizable : false,
    y:120,
    layout: 'fit',
    initComponent: function() {
        var stGrid = new StoreGridKardexPaciente();
        this.items= [
            {  
                xtype: 'panel',
                width: screen.width,
                height: 550,
                items:[
                    {
                        xtype:'fieldset',
                        collapsible: true,
                        anchor:'100%',
                        autoHeight:true,
                        items:[
                            {
                                xtype: 'button',
                                text: 'Programar Demanda',
                                iconCls: 'btnEditRow',
                                id: 'btnProDemanda'
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        layout: 'table',
                        anchor:'100%',
                        labelWidth:100,
                        title: '<center>FILTROS</center>',
                        border:false,
                        colspan:2,
                        height: 220,
                        padding: 5,
                        items: [
                            {
                                xtype: 'panel',
                                height:200,
                                width:700,
                                labelWidth:70,
                                border:false,
                                layout:'form',
                                padding:5,
                                id:'FiltroKardexPaciente',
                                items:[
                                    {
                                        xtype: 'combo',
                                        anchor: '100%',
                                        store: 'StorePrograma',
                                        forceSelection: true,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        fieldLabel: 'Programa',
                                        name: 'Programa',
                                        emptyText: 'Seleccione...!',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        triggerAction: 'all',
                                        mode: 'local',
                                        id: 'intPrograma'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 100,
                                                store:'StoreTipoDocumento',
                                                forceSelection: true,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                fieldLabel: 'Tipo de ID',
                                                name: 'Tipo de ID',
                                                emptyText: 'Seleccione...!',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                mode: 'local',
                                                id: 'strTipoDocumento'
                                            },
                                            {
                                                html:'ID'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width:90,
                                                name: 'ID',
                                                id: 'intNIdentificacion'
                                            },
                                            {
                                                html:'Paciente'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width:260,
                                                name: 'Paciente',
                                                id: 'strPaciente'
                                            },
                                            {
                                                xtype: 'button',
                                                tooltip:'Buscar Paciente',
                                                iconCls: 'btnBuscar',
                                                id: 'btnBusPaciente'
                                            }
                                        ]
                                    },
                                    {
                                        xtype:'fieldset',
                                        id:'fsFecha',
                                        title: 'FECHAS',
                                        labelWidth:70,
                                        collapsible: true,
                                        items:[
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        width: 100,
                                                        emptyText: 'Desde...',
                                                        fieldLabel: 'Inscripcion ',
                                                        name:"Inscripcion",
                                                        id: 'fecDesInscripcion'
                                                    },
                                                    {
                                                        html:'Hasta'
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 100,
                                                        emptyText: 'Hasta...',
                                                        name:"Hasta Inscripcion",
                                                        id: 'fecHasInscripcion'
                                                    },
                                                    {
                                                        html:'</br>',
                                                        height: 23
                                                    },
                                                    {
                                                        html:'Proxima Cita'
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 100,
                                                        emptyText: 'Desde...',
                                                        name:"Proxima Cita",
                                                        id: 'fecProCita'
                                                    },
                                                    {
                                                        html:'Hasta'
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 100,
                                                        emptyText: 'Hasta...',
                                                        name:"Hasta Proxima Cita ",
                                                        id: 'fecHasProCita'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]                                        
                            },
                            {
                                xtype: 'panel',
                                height:200,
                                width:500,
                                labelWidth:70,
                                border:false,
                                layout:'form',
                                padding:5,
                                id:'FiltroKardexPaciente1',
                                items:[
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                width: 150,
                                                store:'StoreEstado',
                                                forceSelection: true,
                                                valueField: 'Descripcion',
                                                displayField: 'Descripcion',
                                                fieldLabel: 'Estado',
                                                name: 'Estado',
                                                emptyText: 'Seleccione...!',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                mode: 'local',
                                                id: 'strEstado'
                                            },
                                            {
                                                html:'Prioridad'
                                            },
                                            {   
                                                xtype: 'combo',
                                                store:'StorePrioridad',
                                                valueField:'Descripcion',
                                                displayField:'Descripcion',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                width:150,
                                                name: 'Prioridad',
                                                mode: 'local',
                                                id: 'strPrioridad'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'numberfield',
                                                fieldLabel:'Edad Desde',
                                                name: 'Edad Desde',
                                                width: 100,
                                                emptyText: 'Desde...',
                                                allowNegative: false,
                                                id: 'intEdadDesde'
                                            },
                                            {
                                                html:'Hasta'
                                            },
                                            {
                                                xtype: 'numberfield',
                                                name: 'Edad Hasta',
                                                emptyText: 'Hasta..',
                                                width: 100,
                                                allowNegative: false,
                                                id: 'intEdadHasta'
                                            },
                                            {
                                                html:'Sexo'
                                            },
                                            {   
                                                xtype: 'combo',
                                                store:'StoreSexo',
                                                valueField:'Descripcion',
                                                displayField:'Descripcion',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                listEmptyText: '',
                                                triggerAction: 'all',
                                                anchor: '100%',
                                                name: 'Sexo',
                                                width:120,
                                                mode: 'local',
                                                id: 'strSexo'
                                            }
                                        ]
                                    }
                                ]
                            }
                        ],
                        tbar:
                        {
                            items:[
                                {
                                    xtype: 'tbfill'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Aplicar Filtro',
                                    iconCls: 'btnAplicarFiltro',
                                    id: 'btn_AplicarFiltro'
                                }
                            ]
                        }
                    },
                    {
                        xtype: 'grid',
                        id: 'gridKardexPaciente',
                        store: stGrid,
                        anchor: "100%",
                        height: 360,
                        border: false,
                        frame: true,
                        columns: [
                            {    
                                xtype: 'gridcolumn',
                                sortable: false,
                                hidden: true,
                                hideable: false,
                                dataIndex: 'Prioridad'
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'Id Kardex',
                                sortable: false,
                                width: 1,
                                hidden: true,
                                hideable: false,
                                dataIndex: 'IdKardex'
                            },
                            {    
                                xtype: 'gridcolumn',
                                header: 'Paciente',
                                sortable: false,
                                width: 200,
                                hidden: false,
                                hideable: false,
                                dataIndex: 'NomPaciente'
                            },
                            {    
                                xtype: 'gridcolumn',
                                header: 'Programa',
                                sortable: false,
                                width: 200,
                                hidden: false,
                                hideable: false,
                                dataIndex: 'NomPrograma'
                            },
                            {    
                                xtype: 'gridcolumn',
                                header: 'Sede',
                                sortable: false,
                                width: 130,
                                hidden: false,
                                hideable: false,
                                dataIndex: 'Sede'
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'Prestador',
                                sortable: true,
                                width: 70,
                                hidden: false,
                                hideable: false,
                                dataIndex: 'Prestador'
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'Cliente',
                                sortable: false,
                                width: 100,
                                hidden: false,
                                hideable: false,
                                dataIndex: 'Cliente'
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'Fecha Preinscripcion',
                                sortable: true,
                                width: 100,
                                hidden: false,
                                hideable: false,
                                dataIndex: 'Fecha_Preinscripcion'
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'Proxima Cita',
                                sortable: true,
                                width: 100,
                                hidden: false,
                                hideable: false,
                                dataIndex: 'Fecha_Probable'
                            },
                            {    
                                xtype: 'gridcolumn',
                                header: 'Tipo Demanda',
                                sortable: false,
                                width: 90,
                                hidden: false,
                                hideable: false,
                                dataIndex: 'Tipo_Demanda'
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'Fecha Cierre',
                                sortable: true,
                                width: 90,
                                hidden: false,
                                hideable: false,
                                dataIndex: 'Fecha_Cierre'
                            },

                            {    
                                xtype: 'gridcolumn',
                                header: 'Causa Cierre',
                                sortable: false,
                                width: 330,
                                hidden: false,
                                hideable: false,
                                dataIndex: 'Causa_Cierre'
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'Observaciones',
                                sortable: true,
                                width: 330,
                                hidden: false,
                                hideable: false,
                                dataIndex: 'Observaciones_Kardex'
                            },
                            {    
                                xtype: 'gridcolumn',
                                header: 'Usuario Inscribio',
                                sortable: false,
                                width: 100,
                                hidden: false,
                                hideable: false,
                                dataIndex: 'Usuario_Inscribio'
                            },
                            {
                                xtype: 'gridcolumn',
                                header: 'Estado',
                                sortable: false,
                                width: 330,
                                hidden: true,
                                hideable: false,
                                dataIndex: 'Estado'
                            }
                        ],
                        stripeRows:true,

                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                        bbar: new Ext.PagingToolbar({
                            pageSize: 15,
                            anchor:'100%',
                            store: stGrid,                
                            displayInfo: true
                        }),
                        view: new Ext.grid.GroupingView({ 
                        groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
                        getRowClass: function (record, rowIndex, rowParams, store) {
                                var estado = record.data.Prioridad;
                                switch (estado)
                                {
                                    case "ALTA":
                                        return 'Rojo table';
                                        break;
                                    case "BAJA":
                                        return 'Verde table';
                                        break;
                                    case "MEDIA":
                                        return 'Amarillo table';
                                        break;
                                    default:
                                        break;
                                }
                            }
                        }),
                        tbar:
                        {
                            xtype: 'toolbar',
                            anchor:'100%',
                            items:[
                                {
                                    xtype: 'button',
                                    text: 'Agregar Paciente Programa',
                                    iconCls: 'btnAddPacPrograma',
                                    id: 'btnCreaPaciente'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Cerrar Programa',
                                    iconCls: 'btnCerrPrograma',
                                    id: 'btnCerrarPrograma'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Seguimiento Programa',
                                    iconCls: 'btnAddSeguimiento',
                                    id: 'btnAgrBitacora'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Consultar Historial Seguimiento',
                                    iconCls: 'btnSegHistorial',
                                    id: 'btnConHisSeguimiento'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Programar Proximas Fechas',
                                    iconCls: 'btnProgramarFechas',
                                    id: 'btnProgramarFechas'
                                }
                            ]
                        }
                    }
                ]
            }
        ];
        winFrmKardexPacienteUi.superclass.initComponent.call(this);
    }   
});