/*
* @category    Formulario Tipo Componente
* @package     OfiClinic Web
* @author      Héctor Iván Ramírez Cardona<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

/**
*  Pre: ---
*  Post: ---
*  Return: winTipoEquipoUi Object
*  Resumen: Crea el formulario para registrar un tipo de Componente y modificarla
**/

winCerProgrmaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Cerrar Programa ::.',
    width: 700,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winCerrProgramaUi',
    
    /**
    *  Pre:---
    *  Post: ---
    *  Return: --- 
    *  Resumen: Inicializa el componente del formulario tipo componente
    **/
   
    initComponent: function() 
    {
        this.items = [
                {
                    xtype: 'form',
                    frame: true,
                    anchor: '100%',
                    id: 'frmCerrPrograma',
                    padding: 10,
                    items: [
                        {
                            xtype: 'panel',
                            layout: 'form',
                            border: false,
                            labelWidth: 100,
                            items:[
                                {
                                    xtype:'hidden',
                                    id:'intCerPrograma'
                                },
                                {
                                    xtype:'hidden',
                                    id:'sysfecCierre'
                                },
                                {
                                    xtype: 'textfield',
                                    anchor: '100%',
                                    fieldLabel: 'Paciente',
                                    readOnly:true,
                                    name: 'Paciente',
                                    allowBlank: false,
                                    id: 'sysCerPaciente'
                                },
                                {
                                    xtype: 'textfield',
                                    anchor: '100%',
                                    readOnly:true,
                                    fieldLabel:'Programa',
                                    name: 'Programa',
                                    allowBlank: false,
                                    id: 'sysCerPrograma'
                                },
                                {
                                    xtype: 'textarea',
                                    anchor: '100%',
                                    fieldLabel: 'Causa del Cierre',
                                    name: 'Causa del Cierre',
                                    allowBlank: true,
                                    emptyText: '',
                                    maxLength: 250,
                                    maxLengthText: 'maximo 250 caracteres ',
                                    id: 'memCauCierre'
                                },
                                {
                                    xtype:'hidden',
                                    id:'intUsuCierre'
                                }
                            ]
                        }
                    ],
                    tbar:
                    {
                        items: [
                            {
                                xtype: 'tbfill'
                            },
                            {
                                xtype: 'button',
                                text: 'Cerrar Programa',
                                iconCls: 'btnGuardar',
                                id: 'btn_CerrarPrograma'
                            }
                        ]
                    },
                    bbar:
                    {
                        items: [
                            {
                                xtype: 'tbfill'
                            },
                            {
                                xtype: 'button',
                                text: 'Salir',
                                iconCls: 'btnSalir',
                                id: 'btn_SalirCerrPrograma'
                            }
                        ]
                    }
                }
            ];
        winCerProgrmaUi.superclass.initComponent.call(this);    
    }
});
