/*
* @category    Formulario Tipo Componente
* @package     OfiClinic Web
* @author      Héctor Iván Ramírez Cardona<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

/**
*  Pre: ---
*  Post: ---
*  Return: winTipoEquipoUi Object
*  Resumen: Crea el formulario para registrar un tipo de Componente y modificarla
**/

winKarBitacoraUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Kardex Bitacora ::.',
    width: 700,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winKarBitacoraUi',
    
    /**
    *  Pre:---
    *  Post: ---
    *  Return: --- 
    *  Resumen: Inicializa el componente del formulario tipo componente
    **/
   
    initComponent: function() 
    {
        this.items = [
                {
                    xtype:'tabpanel',
                    activeTab:0,
                    anchor:'99%',
                    heigth:615,
                    items:[
                        {
                            xtype: 'panel',
                            iconCls:'btnEvolucionar',
                            title: 'Seguimiento Programa',
                            anchor: '100%',
                            heigth:605,
                            id:'pnseguimiento',
                            items: [
                                {
                                    xtype: 'form',
                                    frame: true,
                                    anchor: '100%',
                                    id: 'frmKarBitacora',
                                    padding: 10,
                                    items: [
                                        {
                                            xtype: 'panel',
                                            layout: 'form',
                                            border: false,
                                            labelWidth: 100,
                                            items:[
                                                {
                                                    xtype:'hidden',
                                                    id:'intKarBitacora'
                                                },
                                                {
                                                    xtype:'hidden',
                                                    id:'intKarPaciente'
                                                },
                                                {
                                                    xtype: 'textfield',
                                                    anchor: '100%',
                                                    fieldLabel: 'Paciente',
                                                    readOnly:true,
                                                    name: 'Paciente',
                                                    allowBlank: false,
                                                    id: 'sysBitPaciente'
                                                },
                                                {
                                                    xtype: 'textfield',
                                                    anchor: '100%',
                                                    readOnly:true,
                                                    fieldLabel:'Programa',
                                                    name: 'Programa',
                                                    allowBlank: false,
                                                    id: 'sysBitPrograma'
                                                },
                                                {
                                                    xtype: 'compositefield',
                                                    style: 'background:transparent;',
                                                    items: [
                                                        {   
                                                            xtype: 'combo',
                                                            store:'StoreTipoContacto',
                                                            valueField:'Descripcion',
                                                            displayField:'Descripcion',
                                                            typeAhead: true,
                                                            typeAheadDelay: 50,
                                                            listEmptyText: '',
                                                            triggerAction: 'all',
                                                            anchor: '100%',
                                                            fieldLabel: 'Tipo Contacto',
                                                            name: 'Tipo Contacto',
                                                            allowBlank:true,
                                                            width:120,
                                                            mode: 'local',
                                                            id: 'strBitTipContacto'
                                                        },
                                                        {
                                                            html:'Parentesco'
                                                        },
                                                        {
                                                            xtype: 'textfield',
                                                            width:90,
                                                            name: 'Parentesco',
                                                            allowBlank: false,
                                                            id: 'strBitParentesco'
                                                        },
                                                        {
                                                            html:'Fecha Contacto'
                                                        },
                                                        {
                                                            xtype: 'datefield',
                                                            width:90,
                                                            name: 'Fecha Contacto',
                                                            allowBlank: false,
                                                            id: 'fecBitFecContacto'
                                                        }
                                                    ]
                                                },
                                                {
                                                    xtype: 'combo',
                                                    store:'StoreSiNo',
                                                    width:100,
                                                    valueField: 'Descripcion',
                                                    displayField: 'Descripcion',
                                                    fieldLabel: 'Contacto Efectivo',
                                                    name: 'Contacto Efectivo',
                                                    forceSelection: true,
                                                    emptyText: 'Seleccione...!',
                                                    mode: 'local',
                                                    typeAhead: true,
                                                    allowBlank: true,
                                                    typeAheadDelay: 50,
                                                    listEmptyText: '',
                                                    triggerAction: 'all',
                                                    id: 'strBitConEfectivo'
                                                },
                                                {
                                                    xtype: 'textarea',
                                                    anchor: '100%',
                                                    fieldLabel: 'Observacion',
                                                    name: 'Observacion',
                                                    allowBlank: true,
                                                    emptyText: '',
                                                    maxLength: 250,
                                                    maxLengthText: 'maximo 250 caracteres ',
                                                    id: 'memBitObservacion'
                                                },
                                                {
                                                    xtype:'hidden',
                                                    id:'intUsuSeguimiento'
                                                }
                                            ]
                                        }
                                    ],
                                    tbar:
                                    {
                                        items: [
                                            {
                                                xtype: 'tbfill'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Guardar',
                                                iconCls: 'btnGuardar',
                                                id: 'btn_AdicionarKarBitagora'
                                            }
                                        ]
                                    }
                                }
                            ]
                        },
                        {
                            xtype: 'panel',
                            iconCls:'btnDetalleseguimiento',
                            title: 'Detalle Seguimiento',
                            anchor: '100%',
                            heigth:605,
                            items: [
                                new winFrmDetalleSeguimiento()
                            ]
                        },
                        {
                            xtype: 'panel',
                            iconCls:'btnProgramarFechas',
                            title: 'Programacion Proximas Fechas',
                            anchor: '100%',
                            heigth:605,
                            items: [
                                new winFrmKarProgramacion()
                            ]
                        }
                    ]
                },
                {
                    bbar:[
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'displayfield',
                            text: 'Programa',
                            style: 'color:darkblue',
                            iconCls: '',
                            id: 'btnPrograma'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'displayfield',
                            text: 'Usuario',
                            style: 'color:darkblue',
                            iconCls: '',
                            id: 'btnUsuario'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {   
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirKarBitagora'
                        }
                    ] 
                }
            ];
        winKarBitacoraUi.superclass.initComponent.call(this);    
    }
});
