/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmKardexPacientes = Ext.extend(winFrmKardexPacientesUi, {
    initComponent: function() {
        winFrmKardexPacientes.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";

        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        
        Ext.getCmp('sysIdEmpresa').setValue(ID_EMPRESA);
        Ext.getCmp('sysIPS').setValue(ID_IPS);
        
        var btnBuscarPacienteLegalizacion = Ext.getCmp('btnBuscarPacienteLegalizacion').on("click",this.BuscarPacienteLegaliza,this);
        var btnLimpiarPacienteLegalizacion = Ext.getCmp('btnLimpiarPacienteLegalizacion').on("click",this.LimpiarDatosPaciente,this);
        var btnCrearRegistro = Ext.getCmp('btnCrearRegistro').on("click",this.NuevoIngresoPaciente,this);
        var btnRetiroPrograma = Ext.getCmp('btnRetiroPrograma').on("click",this.RetiroPrograma,this);
        var btnCrearRegistroAlerta = Ext.getCmp('btnCrearRegistroAlerta').on("click",this.NuevaAlerta,this);
        var btnEliminarAlerta = Ext.getCmp('btnEliminarAlerta').on("click",this.EliminarAlerta,this);
        var btnDemandaInducida = Ext.getCmp('btnDemandaInducida').on("click",this.Bitacora,this);
        var btnPacientes = Ext.getCmp('btnPacientes').on("click",this.ListarPacientes,this);
        var btnAlertas = Ext.getCmp('btnAlertas').on("click",this.ListarPacientesAlertas,this);
        var btnSalir = Ext.getCmp('btnSalir').on("click",this.SalirOpcion,this);
    },
    
    Bitacora: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea Realizar un Registro de Demanda Inducida?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes"){
                    if(Ext.getCmp('intPacienteLegalizacion').getValue() == 0 || Ext.getCmp('intPacienteLegalizacion').getValue() == null || Ext.getCmp('intPacienteLegalizacion').getValue() == ""){
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Seleccione un Paciente',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }else{
                        if(Ext.getCmp('gridKardexPacientes').selModel.getCount() == 1){
                            var selections = Ext.getCmp('gridKardexPacientes').selModel.getSelections();
                            var winFrmBitacora = new winFrmBitacoraUi();
                            Ext.getCmp('sysTipoDoc').setValue(Ext.getCmp('sysTipDoc').getValue());
                            Ext.getCmp('sysDocumento').setValue(Ext.getCmp('sysDoc').getValue());
                            Ext.getCmp('sysPrimerNombre').setValue(Ext.getCmp('sysPrimer_Nombre').getValue());
                            Ext.getCmp('sysSegundoNombre').setValue(Ext.getCmp('sysSegundo_Nombre').getValue());
                            Ext.getCmp('sysPrimerApellido').setValue(Ext.getCmp('sysPrimer_Apellido').getValue());
                            Ext.getCmp('sysSegundoApellido').setValue(Ext.getCmp('sysSegundo_Apellido').getValue());
                            Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('sysFecNac').getValue());
                            Ext.getCmp('sysGenero').setValue(Ext.getCmp('sysSexo').getValue());
                            Ext.getCmp('sysIdPaciente').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
                            Ext.getCmp('sysPrograma').setValue(selections[0].json.IdPrograma);
                            winFrmBitacora.show();
                        }else{
                            Ext.MessageBox.show({
                                title: 'Error',
                                msg: 'Seleccione un Programa',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            }
        });
    },
    
    
    
    NuevoIngresoPaciente: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea Realizar una Pre-Inscripcion?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    if(Ext.getCmp('intPacienteLegalizacion').getValue() == 0 || Ext.getCmp('intPacienteLegalizacion').getValue() == null || Ext.getCmp('intPacienteLegalizacion').getValue() == ""){
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Seleccione un Paciente',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }else{
                        var winPreInscripcionPacientes = new winPreInscripcionPacientesUi();
                        Ext.getCmp('sysTipoDoc').setValue(Ext.getCmp('sysTipDoc').getValue());
                        Ext.getCmp('sysDocumento').setValue(Ext.getCmp('sysDoc').getValue());
                        Ext.getCmp('sysPrimerNombre').setValue(Ext.getCmp('sysPrimer_Nombre').getValue());
                        Ext.getCmp('sysSegundoNombre').setValue(Ext.getCmp('sysSegundo_Nombre').getValue());
                        Ext.getCmp('sysPrimerApellido').setValue(Ext.getCmp('sysPrimer_Apellido').getValue());
                        Ext.getCmp('sysSegundoApellido').setValue(Ext.getCmp('sysSegundo_Apellido').getValue());
                        Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('sysFecNac').getValue());
                        Ext.getCmp('sysGenero').setValue(Ext.getCmp('sysSexo').getValue());
                        Ext.getCmp('sysIdPaciente').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
                        Ext.getCmp('sysUsuario').setValue(ID_USUARIO);
                        Ext.getCmp('sysIPS').setValue(ID_IPS);
                        winPreInscripcionPacientes.show();
                    }
                }
            }
        });
    },
    
    RetiroPrograma: function(){
        if(Ext.getCmp('gridKardexPacientes').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridKardexPacientes').selModel.getSelections();
            if(selections[0].json.Estado == "R"){
                
                Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Usuario que ya esta Retirado del Programa Seleccionado',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
            }else{
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'Esta seguro que desea Retirar al Paciente del Programa Seleccionado?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes"){
                            var winRetiroPrograma = new winRetiroProgramaUi();
                            Ext.getCmp('sysTipoDoc').setValue(Ext.getCmp('sysTipDoc').getValue());
                            Ext.getCmp('sysDocumento').setValue(Ext.getCmp('sysDoc').getValue());
                            Ext.getCmp('sysPrimerNombre').setValue(Ext.getCmp('sysPrimer_Nombre').getValue());
                            Ext.getCmp('sysSegundoNombre').setValue(Ext.getCmp('sysSegundo_Nombre').getValue());
                            Ext.getCmp('sysPrimerApellido').setValue(Ext.getCmp('sysPrimer_Apellido').getValue());
                            Ext.getCmp('sysSegundoApellido').setValue(Ext.getCmp('sysSegundo_Apellido').getValue());
                            Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('sysFecNac').getValue());
                            Ext.getCmp('sysGenero').setValue(Ext.getCmp('sysSexo').getValue());
                            Ext.getCmp('sysIdPaciente').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
                            Ext.getCmp('sysIdKardex').setValue(selections[0].json.IdKardex);
                            Ext.getCmp('sysPrograma').setValue(selections[0].json.ProgramaNom);
                            winRetiroPrograma.show();
                        }
                    }
                })
            }
        }
    },
    
    NuevaAlerta: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea Crear una Alerta?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    if(Ext.getCmp('intPacienteLegalizacion').getValue() == 0 || Ext.getCmp('intPacienteLegalizacion').getValue() == null || Ext.getCmp('intPacienteLegalizacion').getValue() == ""){
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Seleccione un Paciente',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }else{
                        var winAddAlerta = new winAddAlertaUi();
                        Ext.getCmp('sysTipoDoc').setValue(Ext.getCmp('sysTipDoc').getValue());
                        Ext.getCmp('sysDocumento').setValue(Ext.getCmp('sysDoc').getValue());
                        Ext.getCmp('sysPrimerNombre').setValue(Ext.getCmp('sysPrimer_Nombre').getValue());
                        Ext.getCmp('sysSegundoNombre').setValue(Ext.getCmp('sysSegundo_Nombre').getValue());
                        Ext.getCmp('sysPrimerApellido').setValue(Ext.getCmp('sysPrimer_Apellido').getValue());
                        Ext.getCmp('sysSegundoApellido').setValue(Ext.getCmp('sysSegundo_Apellido').getValue());
                        Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('sysFecNac').getValue());
                        Ext.getCmp('sysGenero').setValue(Ext.getCmp('sysSexo').getValue());
                        Ext.getCmp('sysIdPaciente').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
                        winAddAlerta.show();
                    }
                }
            }
        });
    },
    
    EliminarAlerta: function(){
        if(Ext.getCmp('gridAlertasPacientes').selModel.getCount() == 1){
            fnEliminarAlerta();
        }
    },
    
    LimpiarDatosPaciente: function(){
        Ext.getCmp('intPacienteLegalizacion').setValue(0);
        Ext.getCmp('sysPacienteLegalizacion').setValue(null);
        Ext.getCmp('gridKardexPacientes').store.baseParams = {
            task: 'LISTAR',
            pPaciente: 0,
            pIPS: ID_IPS
        };
        Ext.getCmp('gridKardexPacientes').store.load();
    },
    
    ListarPacientes: function(){
        if(Ext.getCmp('intPacienteLegalizacion').getValue() == null || Ext.getCmp('intPacienteLegalizacion').getValue() == "" || Ext.getCmp('intPacienteLegalizacion').getValue() == 0){
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Seleccione un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }else{
            Ext.getCmp('gridKardexPacientes').store.baseParams = {
                task: 'LISTAR',
                pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                pIPS: ID_IPS
            };
            Ext.getCmp('gridKardexPacientes').store.load();
        }
    },
    
    ListarPacientesAlertas: function(){
        if(Ext.getCmp('intPacienteLegalizacion').getValue() == null || Ext.getCmp('intPacienteLegalizacion').getValue() == "" || Ext.getCmp('intPacienteLegalizacion').getValue() == 0){
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Seleccione un Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }else{
            Ext.getCmp('gridAlertasPacientes').store.baseParams = {
                task: 'LISTAR_ALERTAS',
                pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                pIPS: ID_IPS
            };
            Ext.getCmp('gridAlertasPacientes').store.load();
        }
    },
    
    BuscarPacienteLegaliza: function(){
        buscarpaciente("Resolucion4505");
    },
    BuscarPacienteAgendaManual: function(){
        buscarpacienteagendamanual();
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
});
function fnEliminarAlerta(){
        Ext.Msg.show({
        title: 'Eliminar Alerta....!',
        msg: 'Esta seguro que desea Eliminar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn=="yes")
            {
                var selections = Ext.getCmp('gridAlertasPacientes').selModel.getSelections();
                var frm = Ext.getCmp('frmKardexPacientes').getForm();
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/pacientes/controlador_pacientes_kardex.php',
                        params: {
                            task: 'ELIMINAR_ALERTA',
                            pIdAlerta: selections[0].json.IdAlerta
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Eliminar Alerta',
                                        msg: 'Se Elimino la Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('gridAlertasPacientes').store.load();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Eliminar Alerta',
                                        msg: 'Ocurrio un error al Eliminar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Eliminar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}
