/*
* @category    Formulario Demanda Inducida
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmDemandaInducidaUi = Ext.extend(Ext.Window, {
    layout: 'fit',
    title: '.:: Demanda Inducida ::.',
    width: 1000,
    autoHeight: true,
    closeAction: 'hide',
    plain: true,
    modal: true,
    frame: true,
    border: false,
    closable: false,
    draggable: false,
    resizable: false,
    id: 'winFrmDemandaInducida',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        wPaciente = 0;
        wCAS = 0;
        
        var stGrid = new StoreGridDemandaInducida();
        //var st = new StoreGridDemandaInducida();
        //st.load();
        
        function VerInfoDemanda(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<table border="0"><tr><td>' + value + '<br>Hora: ' + record.get('HoraContacto') + '</td></tr><tr><td><span style="color:blue">' + record.get('TipoRegistro') + '<br>' + record.get('Programa') + '</span></br></td></tr><tr><td><span style="color:red">Usuario: ' + record.get('NomUsuario') + '</span></br></td></tr></table>';
        }
        
        var DetalleResumenDemanda = new Ext.Panel({
            id:'DetalleResumenDemanda',
            width: 635,
            height: 341,
            autoScroll:true,
            closable:false
        });
        
        //Store Local
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                autoHeight: true,
                anchor: '100%',
                autoScroll: true,
                id: 'frmDemandaInducida',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intPacienteLegalizacion',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIdEmpresa',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIPS',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysTipDoc',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysDoc',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPrimer_Nombre',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSegundo_Nombre',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPrimer_Apellido',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSegundo_Apellido',
                        value: 0
                    },
                    {
                        xtype: 'datefield',
                        hidden: true,
                        id: 'sysFecNac',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSexo',
                        value: 0
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 815,
                                fieldLabel: 'Paciente',
                                readOnly: true,
                                allowBlank: true,
                                emptyText: 'Debe Buscar Paciente....',
                                id: 'sysPacienteLegalizacion'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Paciente',
                                id: 'btnBuscarPacienteLegalizacion'
                            },
                            {
                                xtype: 'button',
                                tooltip: 'Limpiar Datos del Paciente',
                                iconCls: 'btnLimpiar',
                                id: 'btnLimpiarPacienteLegalizacion'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'tabpanel',
                anchor: '99%',
                autoHeight: true,
                border: false,
                enableTabScroll: true,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Demanda Inducida',
                        autoHeight: true,
                        autoScroll: true,
                        anchor: '98%',
                        frame: true,
                        border: false,
                        id: 'fichaDemanda',
                        layout: 'form',
                        items: [
                            {
                                xtype: 'panel',
                                layout: 'hbox',
                                anchor: '100%',
                                height: 341,
                                items: [
                                    {
                                        xtype: 'grid',
                                        store: stGrid,
                                        //title: 'Seguimiento',
                                        width: 290,
                                        height: 345,
                                        flex: 1,
                                        id: 'gridDemandaInducida',
                                        columns: [
                                            {
                                                xtype: 'gridcolumn',
                                                header: 'Fecha',
                                                sortable: true,
                                                anchor: '100%',
                                                dataIndex: 'FechaContacto',
                                                renderer: VerInfoDemanda,
                                                hideable: false
                                            }
                                        ],
                                        tbar: [
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Listar',
                                                iconCls: 'btnActualizarGrid',
                                                id: 'btnListarD'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'tbfill'
                                            },
                                            new Ext.app.SearchField({
                                                id: 'qryProgramaD',
                                                store: stGrid,
                                                params: {start: 0, limit: 15},
                                                ValparamP1: 1,
                                                emptyText: 'Escriba el Programa a Buscar',
                                                width: 150,
                                                pLoadGrid: false,
                                                pGrid: 'gridDemandaInducida',
                                                parrParam: {params:{pManual:0}}
                                            })
                                        ],
                                        bbar: [
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Nuevo',
                                                iconCls: 'btnAddRow',
                                                id: 'btnNuevoRegistroD'
                                            },
                                            {
                                                xtype: 'tbseparator'
                                            },
                                            {
                                                xtype: 'button',
                                                text: 'Eliminar',
                                                iconCls: 'btnDelRow',
                                                id: 'btnDelRegistroD'
                                            }
                                        ],
                                        viewConfig: {
                                            forceFit:true
                                        }
                                    },
                                    DetalleResumenDemanda
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    id: 'btnSalirD'
                }
            ]
        };
        winFrmDemandaInducidaUi.superclass.initComponent.call(this);
    }
});
