/*
* @category    Formulario Add Demanda Inducida
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmAddDemandaInducidaUi = Ext.extend(Ext.Window, {
    layout: 'form',
    title: '.:: Demanda Inducida ::.',
    width: 1000,
    height: 570,
    autoScroll: true,
    closeAction: 'hide',
    plain: true,
    modal: true,
    frame: true,
    border: false,
    closable: false,
    draggable: false,
    resizable: false,
    id: 'winFrmAddDemandaInducida',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        wPaciente = 0;
        
     
        //Store Local
        
        var dataTipoContacto = [
            ['Telefonico'],
            ['Presencial'],
            ['Otro']
        ];
        var stTipoContacto = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoContacto.loadData(dataTipoContacto);
        
        var dataParentesco = [
            ['CONYUGUE O COMPANERO PERMANENTE'],
            ['HIJO - HIJA'],
            ['PADRE - MADRE'],
            ['OTRO MIEMBRO DE LA FAMILIA'],
            ['OTRO NO PERTENECIENTE A LA FAMILIA']
        ];
        var stParentesco = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stParentesco.loadData(dataParentesco);
        
        var dataTipoRegistro = [
            ['DEMANDA INDUCIDA'],
            ['CITACION A TALLERES'],
            ['CONFIRMACION DE CITA'],
            ['SEGUIMIENTO INASISTENIA DE CONSULTA'],
            ['SEGUIMIENTO ACCIONES INSEGURAS'],
            ['SEGUIMIENTO FACTORES DE RIESGO']
        ];
        var stTipoRegistro = new Ext.data.ArrayStore({
            fields: [
                {name: 'Descripcion'}
            ]
        });
        stTipoRegistro.loadData(dataTipoRegistro);
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                autoHeight: true,
                anchor: '100%',
                autoScroll: true,
                id: 'frmAddDemandaInducida',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'sysIdPaciente',
                        value: 0
                    },
                    {
                        xtype: 'panel',
                        title: '<center>DATOS BASICOS</center>',
                        layout: 'form',
                        anchor: '100%',
                        labelSeparator: '',
                        autoHeight: true,
                        id: 'pnDatosBasicos',
                        items: [
                            {
                                html: '<br>'
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '100%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Tipo Doc ID',
                                        anchor: '100%',
                                        name: 'cbTdoc',
                                        allowBlank: false,
                                        store: 'StoreTdocPac',
                                        readOnly: true,
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Tipo Documento....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'sysTipoDoc'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 150,
                                        allowBlank: false,
                                        readOnly: true,
                                        emptyText: 'Documento',
                                        id: 'sysDocumento'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                anchor: '100%',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 150,
                                        allowBlank: false,
                                        readOnly: true,
                                        fieldLabel: 'Paciente',
                                        emptyText: 'Primer Apellido',
                                        id: 'sysPrimerApellido'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 150,
                                        allowBlank: true,
                                        readOnly: true,
                                        emptyText: 'Segundo Apellido',
                                        id: 'sysSegundoApellido'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 150,
                                        allowBlank: false,
                                        readOnly: true,
                                        emptyText: 'Primer Nombre',
                                        id: 'sysPrimerNombre'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 150,
                                        allowBlank: true,
                                        readOnly: true,
                                        emptyText: 'Segundo Nombre',
                                        id: 'sysSegundoNombre'
                                    },
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 150,
                                        name: 'Fecha Nac',
                                        fieldLabel: 'Fecha Nac',
                                        allowBlank: false,
                                        readOnly: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'sysFechaNac'
                                    },
                                    {
                                        html: 'Genero'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 200,
                                        name: 'Genero',
                                        allowBlank: false,
                                        readOnly: true,
                                        store: 'StoreGenero',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        emptyText: 'Seleccione Genero....',
                                        forceSelection: true,
                                        id: 'sysGenero'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: '<center>DEMANDA INDUCIDA</center>',
                        layout: 'form',
                        anchor: '100%',
                        labelWidth: 120,
                        labelSeparator: '',
                        autoHeight: true,
                        id: 'pnBitacoraAddDemandaInducida',
                        items: [
                            {
                                html: '<br>'
                            },
                            {
                                xtype: 'combo',
                                name: 'Tipo Registro',
                                fieldLabel: 'Tipo Registro',
                                anchor: '100%',
                                allowBlank: false,
                                store: stTipoRegistro,
                                valueField: 'Descripcion',
                                displayField: 'Descripcion',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                id: 'strTipoRegistro'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Fecha del Contacto<br>&nbsp;',
                                        width: 140,
                                        name: 'Fecha Contacto',
                                        allowBlank: false,
                                        emptyText: '(dia/mes/año) ',
                                        value: new Date(). format('d/m/Y'),
                                        style: 'text-align:center;',
                                        id: 'fecContacto'
                                    },
                                    {
                                        html: 'Tipo Contacto'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Tipo Contacto',
                                        width: 140,
                                        allowBlank: false,
                                        store: stTipoContacto,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: 'Telefonico',
                                        id: 'strTipoContacto'
                                    },
                                    {
                                        html: 'El Contacto Efectivo?'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Contacto Efectivo?',
                                        width: 140,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        //value: "SI",
                                        id: 'strContactoEfectivo'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: 'Persona que contesto al Contacto',
                                        name: 'Persona Contacto',
                                        width: 380,
                                        allowBlank: true,
                                        id: 'strPersonaContactoDem'
                                    },
                                    {
                                        html: 'Parentezco'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Parentezco',
                                        width: 350,
                                        allowBlank: true,
                                        store: stParentesco,
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strParentesco'
                                    }
                                ]
                            },
                            {
                                xtype: 'textarea',
                                anchor: '95%',
                                fieldLabel: 'Observacion',
                                name: 'Observacion',
                                height: 50,
                                allowBlank: true,
                                id: 'memObservacion'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Programa',
                                anchor: '95%',
                                name: 'cbProgramaDemanda4505',
                                allowBlank: false,
                                store: 'StoreProgramasGeneral',
                                forceSelection: true,
                                triggerAction: 'all',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                mode: 'local',
                                valueField: 'IdPrograma',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Programa....',
                                submitValue: true,
                                id: 'sysPrograma'
                            },
                            {
                                xtype: 'numberfield',
                                name: 'CAS',
                                fieldLabel: 'CAS Cita',
                                width: 68,
                                minValue: 0,
                                decimalPrecision: 0,
                                allowBlank: true,
                                id: 'intCASCita'
                            },
                            {
                                html: '<hr><br>'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Realizar un Proximo Contacto',
                                        name: 'Realizar un Proximo Contacto',
                                        width: 90,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        value: 'NO',
                                        id: 'strProximoContacto',
                                        listeners:{
                                            change : function( t, newValue, oldValue){
                                                if(newValue === "NO"){
                                                    Ext.getCmp('fecProximoContacto').disable();
                                                    Ext.getCmp('strMotivoProximoContacto').disable();
                                                    Ext.getCmp('fecProximoContacto').clearInvalid();
                                                    Ext.getCmp('strMotivoProximoContacto').clearInvalid();
                                                    Ext.getCmp('fecProximoContacto').setValue(null);
                                                    Ext.getCmp('strMotivoProximoContacto').setValue(null);
                                                }else{
                                                    Ext.getCmp('fecProximoContacto').enable();
                                                    Ext.getCmp('strMotivoProximoContacto').enable();
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'datefield',
                                        fieldLabel: 'Fecha Proximo Contacto',
                                        width: 200,
                                        name: 'Fecha Proximo Contacto',
                                        allowBlank: true,
                                        disabled: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecProximoContacto'
                                    },
                                    {
                                        html: 'Motivo Proximo Contacto'
                                    },
                                    {
                                        xtype: 'textfield',
                                        name: 'Motivo Proximo Contacto',
                                        width: 350,
                                        disabled: true,
                                        allowBlank: true,
                                        id: 'strMotivoProximoContacto'
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        this.tbar = {
            xtype: 'toolbar',
            items: [
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'button',
                    text: 'Guardar Bitacora',
                    iconCls: 'btnGuardar',
                    id: 'btnGuardarBitacora',
                        listeners:{
                            click : function(){
                            guardarDatosRegistroDemanda();
                        }
                    }
                }
            ]
        };
        this.bbar = {
            xtype: 'toolbar',
            items: [
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    id: 'btnSalirBitacora',
                    listeners:{
                        click : function(){
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'Esta seguro que desea cerrar la ventana?',
                                buttons: Ext.Msg.YESNO,
                                icon: Ext.Msg.QUESTION,
                                fn: function(btn)
                                {
                                    if(btn=="yes")
                                    {
                                        Ext.getCmp('winFrmAddDemandaInducida').close();
                                    }
                                }
                            });
                        }
                    }
                }
            ]
        };
        winFrmAddDemandaInducidaUi.superclass.initComponent.call(this);
    }
});


function guardarDatosRegistroDemanda(){
        Ext.Msg.show({
        title: 'Guardar Demanda Inducida....!',
        msg: 'Esta seguro que desea Guardar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn=="yes")
            {
              var frm = Ext.getCmp('frmAddDemandaInducida').getForm();
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/pacientes/controlador_demanda_inducida.php',
                        params: {
                            task: 'GUARDAR_DEMANDA',
                            pIPS: ID_IPS,
                            pUsuario: ID_USUARIO,
                            pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                            pTipoRegistro: Ext.getCmp('strTipoRegistro').getValue(),
                            pFechaContacto: Ext.getCmp('fecContacto').getValue(),
                            pTipoContacto: Ext.getCmp('strTipoContacto').getValue(),
                            pContactoEfectivo: Ext.getCmp('strContactoEfectivo').getValue(),
                            pPersonaContacto: QuitarAcentosTxt(Ext.getCmp('strPersonaContactoDem').getValue()),
                            pParentesco: QuitarAcentosTxt(Ext.getCmp('strParentesco').getValue()),
                            pObservacion: QuitarAcentosTxt(Ext.getCmp('memObservacion').getValue()),
                            pProximoContacto: Ext.getCmp('fecProximoContacto').getValue(),
                            pPrograma: Ext.getCmp('sysPrograma').getValue(),
                            pProximoContactoSINO: Ext.getCmp('strProximoContacto').getValue(),
                            pCASCita: Ext.getCmp('intCASCita').getValue(),
                            pMotivoProximoContacto: QuitarAcentosTxt(Ext.getCmp('strMotivoProximoContacto').getValue())
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar Demanda Inducida',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('gridDemandaInducida').store.baseParams = {
                                        task: 'LISTAR',
                                        pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                                        pIPS: ID_IPS
                                    };
                                    Ext.getCmp('gridDemandaInducida').store.load();
                                    Ext.getCmp('winFrmAddDemandaInducida').close();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar Demanda Inducida',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}
