/*
* @category    Formulario Demanda Inducida
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmDemandaInducidaUi = Ext.extend(Ext.Window, {
    layout: 'fit',
    title: '.:: Demanda Inducida ::.',
    width: 1000,
    autoHeight: true,
    closeAction: 'hide',
    plain: true,
    modal: true,
    frame: true,
    border: false,
    closable: false,
    draggable: false,
    resizable: false,
    id: 'winFrmDemandaInducida',
    initComponent: function() {
        Ext.BLANK_IMAGE_URL = '../../../lib/extjs/resources/images/default/s.gif';
        wPaciente = 0;
        wCAS = 0;
        
        var stGrid = new StoreGridDemandaInducida();
        
        
        //Store Local
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                autoHeight: true,
                anchor: '100%',
                autoScroll: true,
                id: 'frmDemandaInducida',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'intPacienteLegalizacion',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIdEmpresa',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysIPS',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysTipDoc',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysDoc',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPrimer_Nombre',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSegundo_Nombre',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPrimer_Apellido',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSegundo_Apellido',
                        value: 0
                    },
                    {
                        xtype: 'datefield',
                        hidden: true,
                        id: 'sysFecNac',
                        value: 0
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysSexo',
                        value: 0
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                width: 815,
                                fieldLabel: 'Paciente',
                                readOnly: true,
                                allowBlank: true,
                                emptyText: 'Debe Buscar Paciente....',
                                id: 'sysPacienteLegalizacion'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Paciente',
                                id: 'btnBuscarPacienteLegalizacion'
                            },
                            {
                                xtype: 'button',
                                tooltip: 'Limpiar Datos del Paciente',
                                iconCls: 'btnLimpiar',
                                id: 'btnLimpiarPacienteLegalizacion'
                            }
                        ]
                    }
                ]
            },
            {
                xtype: 'tabpanel',
                anchor: '99%',
                autoHeight: true,
                border: false,
                enableTabScroll: true,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                activeTab: 0,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Demanda Inducida',
                        autoHeight: true,
                        autoScroll: true,
                        anchor: '98%',
                        frame: true,
                        border: false,
                        id: 'fichaKardex',
                        layout: 'form',
                        items: [
                            {
                                xtype: 'grid',
                                id: 'gridDemandaInducida',
                                store: stGrid,
                                autoWidth: true,
                                height: 350,
                                border: false,
                                frame: true,
                                loadMask: true,
                                stripeRows: true,
                                colModel: new Ext.ux.grid.LockingColumnModel([
                                    {
                                        header: 'Programa',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Programa',
                                        align: 'center',
                                        width: 150,
                                        hideable: false
                                    },
                                    {
                                        header: 'FechaContacto',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'FechaContacto',
                                        align: 'center',
                                        width: 100,
                                        hideable: false
                                    },
                                    {
                                        header: 'TipoContacto',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'TipoContacto',
                                        align: 'center',
                                        width: 150,
                                        hideable: false
                                    },
                                    {
                                        header: 'ContactoEfectivo',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'ContactoEfectivo',
                                        align: 'center',
                                        width: 100,
                                        hideable: false
                                    },
                                    {
                                        header: 'PersonaContacto',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'PersonaContacto',
                                        align: 'center',
                                        width: 104,
                                        hideable: false
                                    },
                                    {
                                        header: 'FechaCita',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'FechaEstudio',
                                        align: 'center',
                                        width: 100,
                                        hideable: false
                                    },
                                    {
                                        header: 'Profesional',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'Profesional',
                                        align: 'center',
                                        width: 250,
                                        hideable: false
                                    },
                                    {
                                        header: 'FechaAtencion',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'FechaAtencion',
                                        align: 'center',
                                        width: 100,
                                        hideable: false
                                    },
                                    {
                                        header: 'FechaContacto',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'ProximoContacto',
                                        align: 'center',
                                        width: 100,
                                        hideable: false
                                    },
                                    {
                                        header: 'MotivoProximoContacto',
                                        readOnly: true,
                                        sortable: false,
                                        dataIndex: 'MotivoProximoContacto',
                                        align: 'left',
                                        width: 200,
                                        hideable: false
                                    }
                                ]),
                                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                                view: new Ext.grid.GroupingView({
                                //view: new Ext.ux.grid.LockingGridView({
                                    groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
                                    getRowClass: function(record, index, rowParams, store){
                                        var estado = record.data.RealizaProximoContrato;
                                        switch (estado){
                                            case "SI":
                                                return 'NoApto';
                                                break;
                                            default:
                                                return; 
                                                break;
                                        }
                                    }
                                }),
                                columnLines: true,
                                tbar: {
                                    xtype: 'toolbar',
                                    anchor:'100%',
                                    items:[
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Listar',
                                            iconCls: 'btnActualizarGrid',
                                            id: 'btnListar'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Nuevo Registro',
                                            iconCls: 'btnAddRow',
                                            id: 'btnNuevoRegistro'
                                        }
                                    ]
                                }
                            }
                        ]
                    }
                ]
            }
        ];
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winFrmDemandaInducidaUi.superclass.initComponent.call(this);
    }
});
