/*
* @category    Programacion Eventos Formulario Demanda Inducida
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmDemandaInducida = Ext.extend(winFrmDemandaInducidaUi, {
    initComponent: function() {
        winFrmDemandaInducida.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";

        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        
        Ext.getCmp('sysIdEmpresa').setValue(ID_EMPRESA);
        Ext.getCmp('sysIPS').setValue(ID_IPS);
        
        var btnBuscarPacienteLegalizacion = Ext.getCmp('btnBuscarPacienteLegalizacion').on("click",this.BuscarPacienteLegaliza,this);
        var btnLimpiarPacienteLegalizacion = Ext.getCmp('btnLimpiarPacienteLegalizacion').on("click",this.LimpiarDatosPaciente,this);
        var btnListar = Ext.getCmp('btnListar').on("click",this.ListarPaciente,this);
        var btnNuevoRegistro = Ext.getCmp('btnNuevoRegistro').on("click",this.NuevoRegistro,this);
        var btnSalir = Ext.getCmp('btnSalir').on("click",this.SalirOpcion,this);
    },

    NuevoRegistro: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea Crear un Nuevo Registro?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    if(Ext.getCmp('intPacienteLegalizacion').getValue() == 0 || Ext.getCmp('intPacienteLegalizacion').getValue() == null || Ext.getCmp('intPacienteLegalizacion').getValue() == ""){
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Seleccione un Paciente',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }else{
                        var winFrmAddDemandaInducida = new winFrmAddDemandaInducidaUi();
                        Ext.getCmp('sysTipoDoc').setValue(Ext.getCmp('sysTipDoc').getValue());
                        Ext.getCmp('sysDocumento').setValue(Ext.getCmp('sysDoc').getValue());
                        Ext.getCmp('sysPrimerNombre').setValue(Ext.getCmp('sysPrimer_Nombre').getValue());
                        Ext.getCmp('sysSegundoNombre').setValue(Ext.getCmp('sysSegundo_Nombre').getValue());
                        Ext.getCmp('sysPrimerApellido').setValue(Ext.getCmp('sysPrimer_Apellido').getValue());
                        Ext.getCmp('sysSegundoApellido').setValue(Ext.getCmp('sysSegundo_Apellido').getValue());
                        Ext.getCmp('sysFechaNac').setValue(Ext.getCmp('sysFecNac').getValue());
                        Ext.getCmp('sysGenero').setValue(Ext.getCmp('sysSexo').getValue());
                        Ext.getCmp('sysIdPaciente').setValue(Ext.getCmp('intPacienteLegalizacion').getValue());
                        winFrmAddDemandaInducida.show();
                    }
                }
            }
        });
    },
    
    ListarPaciente: function(){
        if(Ext.getCmp('intPacienteLegalizacion').getValue() == null || Ext.getCmp('intPacienteLegalizacion').getValue() == "" || Ext.getCmp('intPacienteLegalizacion').getValue() == 0){
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Seleccione el Paciente',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }else{
            Ext.getCmp('gridDemandaInducida').store.baseParams = {
                task: 'LISTAR',
                pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                pIPS: ID_IPS
            };
            Ext.getCmp('gridDemandaInducida').store.load();
        }
    },
    LimpiarDatosPaciente: function(){
        Ext.getCmp('intPacienteLegalizacion').setValue(0);
        Ext.getCmp('sysPacienteLegalizacion').setValue(null);
        Ext.getCmp('gridDemandaInducida').store.baseParams = {
            task: 'LISTAR',
            pPaciente: 0,
            pIPS: ID_IPS
        };
        Ext.getCmp('gridDemandaInducida').store.load();
    },
    
    BuscarPacienteLegaliza: function(){
        buscarpaciente("Resolucion4505");
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
});