/*
* @category    Formulario Unificar Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmCambiarRangoSalarialUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Cambiar Rango Salarial ::.',
    id: 'winFrmCambiarRangoSalarial',
    closable:false,
    width:980,
    //height:280,
    autoHeight: true,
    resizable : false,
    border: false,
    frame: true,
    y:120,
    initComponent: function() {
        var mybbar = new utilBbarUi();
                
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmUnificarPaciente',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        html: '<img src="../../../resources/varios/money.png" align="left" alt=""/>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        html:'&nbsp;&nbsp;&nbsp;',
                        border: false
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysPacienteMalo'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysTDocCambioRango'
                    },
                    {
                        xtype: 'hidden',
                        id: 'sysDocumentoCambioRango'
                    },
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Paciente',
                                width: 790,
                                readOnly: true,
                                allowBlank: false,
                                emptyText: 'Seleccione Paciente....',
                                id: 'fPacienteMalo'
                            },
                            {
                                xtype: 'button',
                                iconCls: 'btnBuscar',
                                tooltip: 'Buscar Paciente',
                                id: 'btnBuscarPacienteUnificaMalo'
                            }
                        ]
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Rango Salarial',
                        width: 200,
                        name: 'cbRango',
                        allowBlank: false,
                        listEmptyText: 'Seleccione',
                        store: 'StoreRangoSal',
                        forceSelection: true,
                        triggerAction: 'all',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        mode: 'local',
                        emptyText: 'Seleccione Rango Salarial....',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        tpl: '<tpl for="."><div class="cbRango"><h3>{Descripcion}</h3><p style="font-size: 12; color: #AA0033">Valor: $ {VlrCuotaModeradora}</p><p style="font-size: 11; color: #0000EE ">Porcentaje: {txtPorcentaje} %</p><p style="font-size: 10; color: #33373d">{Observaciones}</p><hr /></div></tpl>',
                        itemSelector: 'div.cbRango',
                        autoHeight: true,
                        id: 'strRangoSalarial'
                    }
                ],
                tbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnAceptar',
                            text: 'Cambiar Rango',
                            id: 'btnUnificarRango'
                        }
                    ]
                }
            }
        ];
        winFrmCambiarRangoSalarialUi.superclass.initComponent.call(this);
    }
});
