/*
* @category    Alertas por Paciente
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

AlertasxPaciente001Ui = Ext.extend(Ext.Panel, {
    anchor: '100%',
    autoHeight: true,
    initComponent: function() {
        var stGridAlerta = new StoreGridAlertasPacientes();
        
        function DescripcionAlerta(val, x, store){
            mostrarHC = '<table><tr><td style="padding: 1px;">';
            mostrarHC += val;
            mostrarHC += '</td></tr></table>';
            return mostrarHC;
        }
        
        this.items = [
            {
                xtype: 'grid',
                id: 'gridAlertasPacientes',
                store: stGridAlerta,
                autoWidth: true,
                height: 350,
                border: false,
                frame: true,
                loadMask: true,
                stripeRows: true,
                colModel: new Ext.ux.grid.LockingColumnModel([
                    {
                        header: 'Fecha',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Fecha',
                        align: 'center',
                        width: 100,
                        hideable: false
                    },
                    {
                        header: 'Tipo Alerta',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'TipoAlerta',
                        align: 'center',
                        width: 230,
                        hideable: false
                    },
                    {
                        header: 'Alerta',
                        readOnly: true,
                        sortable: false,
                        dataIndex: 'Alerta',
                        align: 'left',
                        width: 570,
                        renderer: DescripcionAlerta,
                        hideable: false
                    }
                ]),
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                view: new Ext.grid.GroupingView({
                //view: new Ext.ux.grid.LockingGridView({
                    groupTextTpl: '{text} ({[values.rs.length]} {[values.rs.length > 1 ? "Items" : "Item"]})',
                    getRowClass: function(record, index, rowParams, store){
                        var estado = record.data.TipoAlerta;
                        switch (estado){
                            case "CONDICION DE SALUD":
                                return 'NoApto';
                                break;
                            default:
                                return; 
                                break;
                        }
                    }
                }),
                //view: new Ext.ux.grid.LockingGridView(),
                columnLines: true,
                bbar: {
                    xtype: 'toolbar',
                    anchor:'100%',
                    items:[
                        {
                            xtype: 'button',
                            text: 'Actualizar',
                            iconCls: 'btnActualizarGrid',
                            id: 'btnAlertas',
                            listeners: {
                                click: function(){
                                    try {
                                        var campoIdPaciente = Ext.getCmp('intIdPaciente');
                                        if ( campoIdPaciente !== null ) {
                                            Ext.getCmp('gridAlertasPacientes').store.load({
                                                params: {
                                                    pPaciente: Ext.getCmp('intIdPaciente').getValue()
                                                }
                                            });
                                        }
                                    }catch(ex) {
                                        Ext.getCmp('gridAlertasPacientes').store.reload();
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        }
                    ]
                },
                tbar: {
                    xtype: 'toolbar',
                    anchor:'100%',
                    items:[
                        {
                            xtype: 'button',
                            text: 'Crear Alerta',
                            iconCls: 'btnAddRow',
                            id: 'btnCrearRegistroAlerta',
                            listeners:{
                                click: function(){
                                    try {
                                        var campoIdPaciente = Ext.getCmp('intIdPaciente');
                                        if ( campoIdPaciente !== null ) {
                                            wPaciente = Ext.getCmp('intIdPaciente').getValue();
                                        }
                                    }catch(ex) {
                                        try {
                                            var campoIdPaciente = Ext.getCmp('sysIdPacienteHC');
                                            if ( campoIdPaciente !== null ) {
                                                wPaciente = Ext.getCmp('sysIdPacienteHC').getValue();
                                            }
                                        }catch(ex) {
                                            //
                                        }
                                    }    
                                    if(parseInt(wPaciente) !== 0){
                                        var winAddAlerta = new winAddAlertaUi();
                                        Ext.getCmp('sysIdPacienteAlerta').setValue(wPaciente);
                                        winAddAlerta.show();
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Eliminar Alerta',
                            iconCls: 'btnDelRow',
                            id: 'btnEliminarAlerta',
                            listeners: {
                                click : function() {
                                    if(parseInt(Ext.getCmp('gridAlertasPacientes').selModel.getCount()) === 1){
                                        var selections = Ext.getCmp('gridAlertasPacientes').selModel.getSelections();
                                        //if(parseInt(selections[0].json.Usuario) === parseInt(ID_USUARIO)){
                                            Ext.Msg.show({
                                                title: 'Alertas',
                                                msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.TipoAlerta + ': ' + selections[0].json.Alerta + '?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn === "yes"){
                                                        fnEliminarAlerta("../../controlador/pacientes/controlador_pacientes_kardex.php",{task: "ELIMINAR_ALERTA", pIdAlerta: selections[0].json.IdAlerta}, 'gridAlertasPacientes');
                                                    }
                                                }
                                            });
                                        //}else{
                                        //    Ext.MessageBox.show({
                                        //        title: 'Error',
                                        //        msg: 'Usted no fue el usuario que creo la alerta, por tal motivo no la puede eliminar',
                                        //        buttons: Ext.MessageBox.OK,
                                        //        icon: Ext.MessageBox.ERROR
                                        //    });
                                        //}
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        AlertasxPaciente001Ui.superclass.initComponent.call(this);
    }
});

function fnEliminarAlerta(URL,arrParam, pGrid, arrParamStore){
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                    }
                    break;

                case 3:
                    if (typeof pGrid !== 'undefined'){
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                        ID_PLANTILLA_CITAS = 0;
                        Ext.MessageBox.show({
                            title: 'eOfiClinic',
                            msg: 'Alguno de los registros no se pudieron eliminar',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.WARNING
                        });
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar el registro en estos momentos o existen datos relacionados en otras tablas',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}