/*
* @category    Administracion 4505
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmAdministracion4505 = Ext.extend(winFrmAdministracion4505Ui, {
    initComponent: function() {
        winFrmAdministracion4505.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";

        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        
        Ext.getCmp('sysIdEmpresa').setValue(ID_EMPRESA);
        Ext.getCmp('sysIPS').setValue(ID_IPS);
        
        var btnCrearPeriodo = Ext.getCmp('btnCrearPeriodo').on("click",this.NuevoPeriodo4505,this);
        var btnCerrarPeriodo = Ext.getCmp('btnCerrarPeriodo').on("click",this.CerrarPeriodo4505,this);
        var btnGenerar4505 = Ext.getCmp('btnGenerar4505').on("click",this.GenerarPeriodo4505,this);
        var btnDescargar4505 = Ext.getCmp('btnDescargar4505').on("click",this.Descargar4505,this);
        //var btnAsociarPaciente = Ext.getCmp('btnAsociarPaciente').on("click",this.AsociarPaciente4505,this);
        var btnSalir = Ext.getCmp('btnSalir').on("click",this.SalirOpcion,this);
        var btnBuscarPacienteLegalizacion = Ext.getCmp('btnBuscarPacienteLegalizacion').on("click",this.BuscarPacienteLegaliza,this);
        var btnLimpiarPacienteLegalizacion = Ext.getCmp('btnLimpiarPacienteLegalizacion').on("click",this.LimpiarDatosPaciente,this);
    },
    Descargar4505: function(){
        location.href = "../../controlador/pacientes/descargar4505.php";
    },
    AsociarPaciente4505: function(){
        if(Ext.getCmp('sysId_4505').getValue() != "" && Ext.getCmp('sysId_4505').getValue() != null && parseInt(Ext.getCmp('sysId_4505').getValue()) != 0 && parseInt(Ext.getCmp('intPacienteLegalizacion').getValue()) != 0 && Ext.getCmp('sysFecNac').getValue() != null && Ext.getCmp('sysFecNac').getValue() != ""){
            Ext.Msg.show({
                title: 'Crear Registro Paciente 4505....!',
                msg: 'Esta seguro que desea asociar el paciente para el periodo seleccionado?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn){
                    if(btn == "yes"){
                        var frm = Ext.getCmp('frmAdministracion4505').getForm();
                        if (frm.isValid()){
                            frm.submit({
                                url: '../../controlador/pacientes/controlador_pacientes_4505.php',
                                params: {
                                    task: 'GUARDAR_SEGUIMIENTO_002',
                                    pIPS: ID_IPS,
                                    pId4505: Ext.getCmp('sysId_4505').getValue(),
                                    pUsuario: ID_USUARIO,
                                    pPaciente: Ext.getCmp('intPacienteLegalizacion').getValue(),
                                    pCliente: Ext.getCmp('sysCliente').getValue(),
                                    pTipoDoc: Ext.getCmp('sysTipDoc').getValue(),
                                    pDocumento: Ext.getCmp('sysDoc').getValue(),
                                    pPrimerApellido: Ext.getCmp('sysPrimer_Apellido').getValue(),
                                    pSegundoApellido: Ext.getCmp('sysSegundo_Apellido').getValue(),
                                    pPrimerNombre: Ext.getCmp('sysPrimer_Nombre').getValue(),
                                    pSegundoNombre: Ext.getCmp('sysSegundo_Nombre').getValue(),
                                    pFechaNac: Ext.getCmp('sysFecNac').getValue().format('Y-m-d'),
                                    pHasta: Ext.getCmp('sysAno01').getValue() + "-" + Ext.getCmp('sysMes01').getValue() + "-" + Ext.getCmp('sysDiaHasta01').getValue(),
                                    pGenero: Ext.getCmp('sysSexo').getValue()
                                },
                                success: function(res,req){
                                    switch(req.result.requestedId){
                                        case "1":
                                            Ext.MessageBox.show({
                                                title: 'Crear Registro Paciente 4505....!',
                                                msg: 'Se Creo el Paciente en la Resolucion 4505 con Exito.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.INFO
                                            });
                                            break;

                                        default:
                                            Ext.MessageBox.show({
                                                title: 'Crear Registro Paciente 4505....!',
                                                msg: 'Ocurrio un error al Crear Paciente o no se pudo establecer conexión con el servidor.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                            break;
                                    }
                                },
                                failure: function(response,options){
                                    Ext.MessageBox.show({
                                        title: 'Error Base Datos',
                                        msg: 'No podemos Crear Paciente en estos momentos',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }
                            });
                        }else{
                            Ext.MessageBox.show({
                                title: 'Error',
                                msg: 'El Usuario es Requerido',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Debe seleccionar el periodo y el paciente, y/o la fecha de naciemiento no es correcta',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    GenerarPeriodo4505: function(){
        if(Ext.getCmp('sysId_4505').getValue() == 0){
            Ext.Msg.show({
                title: 'Cerrar Periodo....!',
                msg: 'Esta seguro que desea Generar Planos del Periodo Seleccionado?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn){
                    if(btn=="yes"){
                        Ext.Ajax.request({
                            url: '../../controlador/pacientes/controlador_pacientes_4505.php',
                                params: {
                                    task: 'GENERAR_FILES_REGUNICO',
                                    pEmpresa: ID_EMPRESA,
                                    pIPS: ID_IPS,
                                    pCliente: Ext.getCmp('sysCliente').getValue()
                                },
                            success: function(response){
                                var result = response.responseText;
                                if (result > 0){
                                    Ext.Msg.hide();
                                    Ext.MessageBox.show({
                                        title: 'OfiClinic',
                                        msg: 'Se genero el archivo satisfactoriamente, por favor descarguelo',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                }
                            },
                            failure: function(response){
                                var result = response.responseText;
                                Ext.MessageBox.show({
                                    title: 'Error Base Datos',
                                    msg: 'No podemos generar los archivos de 4505 en estos momentos',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }
                        });
                    }
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Seleccione el Periodo a Cerrar',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    CerrarPeriodo4505: function(){
        if(Ext.getCmp('sysId_4505').getValue() != 0){
            Ext.Msg.show({
                title: 'Cerrar Periodo....!',
                msg: 'Esta seguro que desea Cerrar el Periodo Seleccionado?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn){
                    if(btn=="yes"){
                        var frm = Ext.getCmp('frmAdministracion4505').getForm();
                        if (frm.isValid()){
                            frm.submit({
                                url: '../../controlador/pacientes/controlador_pacientes_4505.php',
                                params: {
                                    task: 'CERRAR_PERIODO',
                                    pEmpresa: ID_EMPRESA,
                                    pIPS: ID_IPS,
                                    pCliente: Ext.getCmp('sysCliente').getValue(),
                                    pId4505: Ext.getCmp('sysId_4505').getValue()
                                },
                                success: function(res,req)
                                {
                                    switch(req.result.requestedId){
                                        case "1":
                                            Ext.MessageBox.show({
                                                title: 'Cerrar Periodo',
                                                msg: 'Se Cerro el Periodo con Exito.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.INFO
                                            });
                                            break;

                                        default:
                                            Ext.MessageBox.show({
                                                title: 'Cerrar Periodo',
                                                msg: 'Ocurrio un error al Cerrar el Periodo o no se pudo establecer conexión con el servidor.',
                                                buttons: Ext.MessageBox.OK,
                                                icon: Ext.MessageBox.ERROR
                                            });
                                            break;
                                    }
                                },
                                failure: function(response,options)
                                {
                                    Ext.MessageBox.show({
                                        title: 'Error Base Datos',
                                        msg: 'No podemos Cerrar el Periodo en estos momentos',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }
                            });
                        }else{
                            Ext.MessageBox.show({
                                title: 'Error',
                                msg: 'El Usuario es Requerido',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Seleccione el Periodo a Cerrar',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    NuevoPeriodo4505: function(){
        if(Ext.getCmp('sysCliente').getValue() == 0 || Ext.getCmp('sysCliente').getValue() == null || Ext.getCmp('sysCliente').getValue() == "" || Ext.getCmp('sysAnio_4505').getValue() == 0 || Ext.getCmp('sysAnio_4505').getValue() == null || Ext.getCmp('sysAnio_4505').getValue() == "" || Ext.getCmp('sysMes_4505').getValue() == null || Ext.getCmp('sysMes_4505').getValue() == ""){
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Debe Seleccionar un Cliente, Periodo y Mes',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }else{
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea Crear Nuevo Periodo?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn){
                    if(btn == "yes"){
                        if(Ext.getCmp('sysAnio_4505').getValue() == 0 || Ext.getCmp('sysAnio_4505').getValue() == null || Ext.getCmp('sysAnio_4505').getValue() == ""){
                            Ext.getCmp('sysAnio_4505').setValue(new Date().getFullYear());
                        }
                        bisiesto = (Ext.getCmp('sysAnio_4505').getValue()%4==0) && ((Ext.getCmp('sysAnio_4505').getValue()%100!= 0) || (Ext.getCmp('sysAnio_4505').getValue()%400==0));
                        if(Ext.getCmp('sysMes00').getValue() == 2 && bisiesto){
                            Ext.getCmp('sysDiaHasta').setValue(29);
                        }
                        var frm = Ext.getCmp('frmAdministracion4505').getForm();
                        frm.submit({
                            waitMsg: 'Creando Periodo. Por favor Espere...',
                            url: '../../controlador/pacientes/controlador_pacientes_4505.php',
                            params: {
                                task: 'GUARDAR_PERIODO',
                                pEmpresa: ID_EMPRESA,
                                pIPS: ID_IPS,
                                pCliente: Ext.getCmp('sysCliente').getValue(),
                                pPeriodoAnio: Ext.getCmp('sysAnio_4505').getValue(),
                                pPeriodoMes: Ext.getCmp('sysMes00').getValue(),
                                pPeriodoDesde: "01",
                                pPeriodoHasta: Ext.getCmp('sysDiaHasta').getValue()
                            },
                            success: function(res,req)
                            {
                                switch(req.result.requestedId){
                                    case "1":
                                        Ext.MessageBox.show({
                                            title: 'Nuevo Periodo Resolucion 4505',
                                            msg: 'Se Creo el Nuevo Periodo para la Resolucion 4505 con Exito.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.INFO
                                        });
                                        break;

                                    default:
                                        Ext.MessageBox.show({
                                            title: 'Nuevo Periodo Resolucion 4505',
                                            msg: 'Ocurrio un error al Crear un Nuevo Periodo para la Resolucion 4505 o no se pudo establecer conexión con el servidor.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                        break;
                                }
                            },
                            failure: function(response,options)
                            {
                                Ext.MessageBox.show({
                                    title: 'Error Base Datos',
                                    msg: 'No podemos Crear un Nuevo Periodo para la Resolucion 4505 en estos momentos',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }
                        });
                    }
                }
            });
        }
    },
    LimpiarDatosPaciente: function(){
        Ext.getCmp('intPacienteLegalizacion').setValue(0);
        Ext.getCmp('sysPacienteLegalizacion').setValue(null);
    },
    BuscarPacienteLegaliza: function(){
        buscarpaciente("Resolucion4505");
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
});
