/*
* @category    Formulario Seguimiento Pacientes Resolucion 4505
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winSeguimientoPacientes4505Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Seguimiento Pacientes Resolucion 4505 ::.',
    width: 1000,
    height: 636,
    closable: true,
    resizable: false,
    draggable: false,
    modal: true,
    autoScroll: true,
    padding: 10,
    id: 'winSeguimeitnoPaciente4505',
    initComponent: function() {
        
       
        var searchStoreREPSS = new Ext.data.Store({
            proxy: new Ext.data.ScriptTagProxy({
                url: '../../controlador/asistencial/controlador_oficlinic_repss.php'
            }),
            reader: new Ext.data.JsonReader({
                root: 'data',
                totalProperty: 'totalCount',
                id: 'id'
            }, [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ])
        });
        
        
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '100%',
                id: 'panelHC',
                border: false,
                height: 570,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'form',
                        frame: true,
                        anchor: '100%',
                        id: 'frmSeguimeitnoPaciente4505',
                        padding: 10,
                        border: false,
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                value: 'NA',
                                fieldLabel: 'Pantalla',
                                id: 'sysPantalla'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                value: 'NA',
                                fieldLabel: 'Pantalla',
                                id: 'sysIdAgendaManual'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'Usuario',
                                id: 'sysUsuario'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'ConsecutivoRegistro',
                                id: 'sysConsecutivoRegistro'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'Id4505',
                                id: 'sysId4505'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'IdPaciente',
                                id: 'sysIdPaciente'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'FechaRegistro',
                                value: new Date().format('Y-m-d'),
                                id: 'sysFechaRegistro'
                            },
                            {
                                xtype: 'panel',
                                title: '<center>DATOS BASICOS</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                autoHeight: true,
                                id: 'pnDatosBasicos',
                                items: [
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Tipo Doc ID',
                                                anchor: '100%',
                                                name: 'cbTdoc',
                                                allowBlank: false,
                                                store: 'StoreTdocPac',
                                                readOnly: true,
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Tipo Documento....',
                                                mode: 'local',
                                                triggerAction: 'all',
                                                forceSelection: true,
                                                id: 'sysTipoDoc'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: 'Documento',
                                                id: 'sysDocumento'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        anchor: '100%',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                fieldLabel: 'Paciente',
                                                emptyText: 'Primer Apellido',
                                                id: 'sysPrimerApellido'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: true,
                                                readOnly: true,
                                                emptyText: 'Segundo Apellido',
                                                id: 'sysSegundoApellido'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: 'Primer Nombre',
                                                id: 'sysPrimerNombre'
                                            },
                                            {
                                                xtype: 'textfield',
                                                width: 150,
                                                allowBlank: true,
                                                readOnly: true,
                                                emptyText: 'Segundo Nombre',
                                                id: 'sysSegundoNombre'
                                            },
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'datefield',
                                                width: 150,
                                                name: 'Fecha Nac',
                                                fieldLabel: 'Fecha Nac',
                                                allowBlank: false,
                                                readOnly: true,
                                                emptyText: '(dia/mes/año) ',
                                                style: 'text-align:center;',
                                                id: 'sysFechaNac',
                                                listeners:{
                                                    change : function( t, newValue, oldValue){
                                                        calculoEdadPacienteMeses();
                                                        if(MesesCumplidos >= 120 && MesesCumplidos <= 349){
                                                            Ext.getCmp('sysRegistroConsultaJoven1erVez').setValue("SIN DATO");
                                                            Ext.getCmp('sysRegistroConsultaJoven1erVez').enable();
                                                            Ext.getCmp('fecConsultaJovenPrimeraVez').setValue("1800-01-01");
                                                            Ext.getCmp('fecConsultaJovenPrimeraVez').enable();
                                                        }else{
                                                            Ext.getCmp('sysRegistroConsultaJoven1erVez').setValue("NO APLICA");
                                                            Ext.getCmp('sysRegistroConsultaJoven1erVez').disable();
                                                            Ext.getCmp('fecConsultaJovenPrimeraVez').setValue("1845-01-01");
                                                            Ext.getCmp('fecConsultaJovenPrimeraVez').disable();
                                                        }
                                                        if(MesesCumplidos <= 120){
                                                            Ext.getCmp('sysRegistroConsultaCyD1erVez').setValue("SI");
                                                            Ext.getCmp('sysRegistroConsultaCyD1erVez').enable();
                                                            Ext.getCmp('fecConsultaCyDPrimeraVez').setValue("1800-01-01");
                                                            Ext.getCmp('fecConsultaCyDPrimeraVez').enable();
                                                            Ext.getCmp('intSuministroSulfatoFerroso1ano').setValue(21);
                                                            Ext.getCmp('intSuministroSulfatoFerroso1ano').enable();
                                                            Ext.getCmp('intSuministroVitaminaA').setValue(21);
                                                            Ext.getCmp('intSuministroVitaminaA').enable();
                                                        }else{
                                                            Ext.getCmp('sysRegistroConsultaCyD1erVez').setValue("NO");
                                                            Ext.getCmp('sysRegistroConsultaCyD1erVez').disable();
                                                            Ext.getCmp('fecConsultaCyDPrimeraVez').setValue("1845-01-01");
                                                            Ext.getCmp('fecConsultaCyDPrimeraVez').disable();
                                                            Ext.getCmp('intSuministroSulfatoFerroso1ano').setValue(0);
                                                            Ext.getCmp('intSuministroSulfatoFerroso1ano').disable();
                                                            Ext.getCmp('intSuministroVitaminaA').setValue(0);
                                                            Ext.getCmp('intSuministroVitaminaA').disable();
                                                        }
                                                        if(MesesCumplidos >= 36){
                                                            Ext.getCmp('intHipotiroidismoCongenito').setValue(0);
                                                            Ext.getCmp('intHipotiroidismoCongenito').disable();
                                                            Ext.getCmp('intNeumococo').setValue(0);
                                                            Ext.getCmp('intNeumococo').disable();
                                                            Ext.getCmp('intInfluenza').setValue(0);
                                                            Ext.getCmp('intInfluenza').disable();
                                                        }else{
                                                            Ext.getCmp('intHipotiroidismoCongenito').setValue(21);
                                                            Ext.getCmp('intHipotiroidismoCongenito').enable();
                                                            Ext.getCmp('intNeumococo').setValue(22);
                                                            Ext.getCmp('intNeumococo').enable();
                                                            Ext.getCmp('intInfluenza').setValue(22);
                                                            Ext.getCmp('intInfluenza').enable();
                                                            
                                                        }
                                                        if(MesesCumplidos <= 216){
                                                            Ext.getCmp('intObesidadDesnutricion').setValue(3);
                                                            Ext.getCmp('intObesidadDesnutricion').disable();
                                                        }else{
                                                            Ext.getCmp('intObesidadDesnutricion').setValue(21);
                                                            Ext.getCmp('intObesidadDesnutricion').enable();
                                                            
                                                        }
                                                        if(MesesCumplidos >= 12){
                                                            Ext.getCmp('intHepatitisB').setValue(0);
                                                            Ext.getCmp('intHepatitisB').disable();
                                                            Ext.getCmp('intFiebreAmarilla').setValue(0);
                                                            Ext.getCmp('intFiebreAmarilla').disable();
                                                        }else{
                                                            Ext.getCmp('intHepatitisB').setValue(22);
                                                            Ext.getCmp('intHepatitisB').enable();
                                                            Ext.getCmp('intFiebreAmarilla').setValue(22);
                                                            Ext.getCmp('intFiebreAmarilla').enable();
                                                            
                                                        }
                                                        if(MesesCumplidos >= 25){
                                                            Ext.getCmp('intPentavalente').setValue(0);
                                                            Ext.getCmp('intPentavalente').disable();
                                                            Ext.getCmp('intHepatitisA').setValue(0);
                                                            Ext.getCmp('intHepatitisA').disable();
                                                            Ext.getCmp('intControlPlacaBacteriana').setValue(22);
                                                            Ext.getCmp('intControlPlacaBacteriana').enable();
                                                        }else{
                                                            Ext.getCmp('intPentavalente').setValue(22);
                                                            Ext.getCmp('intPentavalente').enable();
                                                            Ext.getCmp('intHepatitisA').setValue(22);
                                                            Ext.getCmp('intHepatitisA').enable();
                                                            Ext.getCmp('intControlPlacaBacteriana').setValue(0);
                                                            Ext.getCmp('intControlPlacaBacteriana').disable();
                                                        }
                                                        if(MesesCumplidos >= 8){
                                                            Ext.getCmp('intRotavirus').setValue(0);
                                                            Ext.getCmp('intRotavirus').disable();
                                                        }else{
                                                            Ext.getCmp('intRotavirus').setValue(22);
                                                            Ext.getCmp('intRotavirus').enable();
                                                            
                                                        }
                                                        if(MesesCumplidos >= 2){
                                                            Ext.getCmp('sysRegistroFechaControlRecienNacido').setValue("NO");
                                                            Ext.getCmp('sysRegistroFechaControlRecienNacido').disable();
                                                            Ext.getCmp('fecControlRecienNacido').setValue("1845-01-01");
                                                            Ext.getCmp('fecControlRecienNacido').disable();
                                                            Ext.getCmp('sysRegistroTSHNeonatal').setValue("NO");
                                                            Ext.getCmp('sysRegistroTSHNeonatal').disable();
                                                            Ext.getCmp('fecTSHNeonatal').setValue("1845-01-01");
                                                            Ext.getCmp('fecTSHNeonatal').disable();
                                                            Ext.getCmp('intResultadoTSHNeonatal').setValue(0);
                                                            Ext.getCmp('intResultadoTSHNeonatal').disable();
                                                        }else{
                                                            Ext.getCmp('sysRegistroFechaControlRecienNacido').setValue("SI");
                                                            Ext.getCmp('sysRegistroFechaControlRecienNacido').enable();
                                                            Ext.getCmp('fecControlRecienNacido').setValue("1800-01-01");
                                                            Ext.getCmp('fecControlRecienNacido').enable();
                                                            Ext.getCmp('sysRegistroTSHNeonatal').setValue("SIN DATO");
                                                            Ext.getCmp('sysRegistroTSHNeonatal').enable();
                                                            Ext.getCmp('fecTSHNeonatal').setValue("1800-01-01");
                                                            Ext.getCmp('fecTSHNeonatal').enable();
                                                            Ext.getCmp('intResultadoTSHNeonatal').setValue(22);
                                                            Ext.getCmp('intResultadoTSHNeonatal').enable();
                                                            
                                                        }
                                                        if(MesesCumplidos >= 83){
                                                            Ext.getCmp('intPolio').setValue(0);
                                                            Ext.getCmp('intPolio').disable();
                                                            Ext.getCmp('intDPT').setValue(0);
                                                            Ext.getCmp('intDPT').disable();
                                                            Ext.getCmp('intBCG').setValue(0);
                                                            Ext.getCmp('intBCG').disable();
                                                            Ext.getCmp('intTripleViral').setValue(0);
                                                            Ext.getCmp('intTripleViral').disable();
                                                            Ext.getCmp('sysRegistroEdadGestacionalNacer').setValue("NO APLICA");
                                                            Ext.getCmp('intEdadGestacionalNacer').setValue(0);
                                                            Ext.getCmp('intEdadGestacionalNacer').disable();
                                                        }else{
                                                            Ext.getCmp('intPolio').setValue(22);
                                                            Ext.getCmp('intPolio').enable();
                                                            Ext.getCmp('intDPT').setValue(22);
                                                            Ext.getCmp('intDPT').enable();
                                                            Ext.getCmp('intBCG').setValue(22);
                                                            Ext.getCmp('intBCG').enable();
                                                            Ext.getCmp('intTripleViral').setValue(22);
                                                            Ext.getCmp('intTripleViral').enable();
                                                            Ext.getCmp('sysRegistroEdadGestacionalNacer').setValue("SIN DATO");
                                                            Ext.getCmp('intEdadGestacionalNacer').setValue(999);
                                                            Ext.getCmp('intEdadGestacionalNacer').enable();
                                                            
                                                        }
                                                    } 
                                                }
                                            },
                                            {
                                                html: 'Genero'
                                            },
                                            {
                                                xtype: 'combo',
                                                width: 200,
                                                name: 'Genero',
                                                allowBlank: false,
                                                readOnly: true,
                                                store: 'StoreGenero',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                triggerAction: 'all',
                                                typeAhead: true,
                                                typeAheadDelay: 50,
                                                mode: 'local',
                                                emptyText: 'Seleccione Genero....',
                                                forceSelection: true,
                                                id: 'sysGenero',
                                                listeners:{
                                                    change : function( t, newValue, oldValue){
                                                        if(newValue == "M" || MesesCumplidos <= 120){
                                                            Ext.getCmp('intGestacion').setValue(0);
                                                            Ext.getCmp('intGestacion').disable();
                                                            Ext.getCmp('intSuministroAcidoFolico').setValue(0);
                                                            Ext.getCmp('intSuministroAcidoFolico').disable();
                                                            Ext.getCmp('intSuministroSulfatoFerroso').setValue(0);
                                                            Ext.getCmp('intSuministroSulfatoFerroso').disable();
                                                            Ext.getCmp('intSuministroCarbonatoCalcio').setValue(0);
                                                            Ext.getCmp('intSuministroCarbonatoCalcio').disable();
                                                            Ext.getCmp('sysRegistroFPP').setValue("NO");
                                                            Ext.getCmp('sysRegistroFPP').disable();
                                                            Ext.getCmp('fecProbableParto').setValue("1845-01-01");
                                                            Ext.getCmp('fecProbableParto').disable();
                                                            Ext.getCmp('sysRegistroFechaAtencionParto').setValue("NO");
                                                            Ext.getCmp('sysRegistroFechaAtencionParto').disable();
                                                            Ext.getCmp('fecAtencionParto').setValue("1845-01-01");
                                                            Ext.getCmp('fecAtencionParto').disable();
                                                            Ext.getCmp('sysRegistroSalidaAtencionParto').setValue("NO");
                                                            Ext.getCmp('sysRegistroSalidaAtencionParto').disable();
                                                            Ext.getCmp('fecSalidaAtencionParto').setValue("1845-01-01");
                                                            Ext.getCmp('fecSalidaAtencionParto').disable();
                                                            Ext.getCmp('intHipertencionGestacional').setValue(0);
                                                            Ext.getCmp('intHipertencionGestacional').disable();
                                                            Ext.getCmp('sysRegistroFechaConcejeriaLactancia').setValue("NO");
                                                            Ext.getCmp('sysRegistroFechaConcejeriaLactancia').disable();
                                                            Ext.getCmp('fecConcejeriaLactancia').setValue("1845-01-01");
                                                            Ext.getCmp('fecConcejeriaLactancia').disable();
                                                            Ext.getCmp('sysRegistroControlPrenatalPrimeraVez').setValue("NO");
                                                            Ext.getCmp('sysRegistroControlPrenatalPrimeraVez').disable();
                                                            Ext.getCmp('fecControlPrenatalPrimeraVez').setValue("1845-01-01");
                                                            Ext.getCmp('fecControlPrenatalPrimeraVez').disable();
                                                            Ext.getCmp('sysRegistroControlPrenatal').setValue("NO");
                                                            Ext.getCmp('sysRegistroControlPrenatal').disable();
                                                            Ext.getCmp('intControlPrenatal').setValue(0);
                                                            Ext.getCmp('intControlPrenatal').disable();
                                                            Ext.getCmp('sysRegistroUltimoControlPrenatal').setValue("NO");
                                                            Ext.getCmp('sysRegistroUltimoControlPrenatal').disable();
                                                            Ext.getCmp('fecUltimoControlPrenatal').setValue("1845-01-01");
                                                            Ext.getCmp('fecUltimoControlPrenatal').disable();
                                                            Ext.getCmp('intResultadoAntigenoHepatitisB').disable();
                                                            Ext.getCmp('fecAntigenoHepatitisB').disable();
                                                            Ext.getCmp('sysRegistroFechaAntigenoHepatitisB').disable();
                                                            Ext.getCmp('sysRegistroFechaAntigenoHepatitisB').setValue("NO");
                                                            Ext.getCmp('fecAntigenoHepatitisB').setValue("1845-01-01");
                                                            Ext.getCmp('intResultadoAntigenoHepatitisB').setValue(0);
                                                            Ext.getCmp('intTamizajeCancerCuelloUterino').setValue(0);
                                                            Ext.getCmp('intTamizajeCancerCuelloUterino').disable();
                                                            Ext.getCmp('sysRegistroCitologia').setValue("NO APLICA");
                                                            Ext.getCmp('sysRegistroCitologia').disable();
                                                            Ext.getCmp('fecTomaCitologia').setValue("1845-01-01");
                                                            Ext.getCmp('fecTomaCitologia').disable();
                                                            Ext.getCmp('intResultadoCitologia').setValue(0);
                                                            Ext.getCmp('intResultadoCitologia').disable();
                                                            Ext.getCmp('intCalidadMuestraCitologia').setValue(0);
                                                            Ext.getCmp('intCalidadMuestraCitologia').disable();
                                                            Ext.getCmp('sysRegistroIPSTomaCitologia').setValue("NO APLICA");
                                                            Ext.getCmp('sysRegistroIPSTomaCitologia').disable();
                                                            Ext.getCmp('intCodIPSTomaCitologia').setValue(0);
                                                            Ext.getCmp('intCodIPSTomaCitologia').disable();
                                                            Ext.getCmp('sysRegistroTomaColposcopia').setValue("NO APLICA");
                                                            Ext.getCmp('sysRegistroTomaColposcopia').disable();
                                                            Ext.getCmp('fecTomaColposcopia').setValue("1845-01-01");
                                                            Ext.getCmp('fecTomaColposcopia').disable();
                                                            Ext.getCmp('sysRegistroIPSTomaColposcopia').setValue("NO APLICA");
                                                            Ext.getCmp('sysRegistroIPSTomaColposcopia').disable();
                                                            Ext.getCmp('intCodIPSTomaColposcopia').setValue(0);
                                                            Ext.getCmp('intCodIPSTomaColposcopia').disable();
                                                            Ext.getCmp('sysRegistroBiopsiaCervical').setValue("NO APLICA");
                                                            Ext.getCmp('sysRegistroBiopsiaCervical').disable();
                                                            Ext.getCmp('fecBiopsiaCervical').setValue("1845-01-01");
                                                            Ext.getCmp('fecBiopsiaCervical').disable();
                                                            Ext.getCmp('intResultadoBiopsiaCervical').setValue(0);
                                                            Ext.getCmp('intResultadoBiopsiaCervical').disable();
                                                            Ext.getCmp('sysRegistroIPSTomaBiopsiaCervical').setValue("NO APLICA");
                                                            Ext.getCmp('sysRegistroIPSTomaBiopsiaCervical').disable();
                                                            Ext.getCmp('intCodIPSTomaBiopsiaCervical').setValue(0);
                                                            Ext.getCmp('intCodIPSTomaBiopsiaCervical').disable();
                                                            Ext.getCmp('sysRegistroMamografia').setValue("NO APLICA");
                                                            Ext.getCmp('sysRegistroMamografia').disable();
                                                            Ext.getCmp('fecMamografia').setValue("1845-01-01");
                                                            Ext.getCmp('fecMamografia').disable();
                                                            Ext.getCmp('intResultadoMamografia').setValue(0);
                                                            Ext.getCmp('intResultadoMamografia').disable();
                                                            Ext.getCmp('sysRegistroIPSTomaMamografia').setValue("NO APLICA");
                                                            Ext.getCmp('sysRegistroIPSTomaMamografia').disable();
                                                            Ext.getCmp('intCodIPSTomaMamografia').setValue(0);
                                                            Ext.getCmp('intCodIPSTomaMamografia').disable();
                                                            Ext.getCmp('sysRegistroTomaBiopsiaSenoBACAF').setValue("NO APLICA");
                                                            Ext.getCmp('sysRegistroTomaBiopsiaSenoBACAF').disable();
                                                            Ext.getCmp('fecTomaBiopsiaSenoBACAF').setValue("1845-01-01");
                                                            Ext.getCmp('fecTomaBiopsiaSenoBACAF').disable();
                                                            Ext.getCmp('sysRegistroResultadoBiopsiaSeno').setValue("NO APLICA");
                                                            Ext.getCmp('sysRegistroResultadoBiopsiaSeno').disable();
                                                            Ext.getCmp('fecResultadoBiopsiaSeno').setValue("1845-01-01");
                                                            Ext.getCmp('fecResultadoBiopsiaSeno').disable();
                                                            Ext.getCmp('intResultadoBiopsiaSeno').setValue(0);
                                                            Ext.getCmp('intResultadoBiopsiaSeno').disable();
                                                            Ext.getCmp('sysRegistroIPSTomaBiopsiaSeno').setValue("NO APLICA");
                                                            Ext.getCmp('sysRegistroIPSTomaBiopsiaSeno').disable();
                                                            Ext.getCmp('intCodIPSTomaBiopsiaSeno').setValue(0);
                                                            Ext.getCmp('intCodIPSTomaBiopsiaSeno').disable();
                                                        }else{
                                                            Ext.getCmp('intGestacion').setValue(21);
                                                            Ext.getCmp('intGestacion').enable();
                                                            Ext.getCmp('intSuministroAcidoFolico').setValue(21);
                                                            Ext.getCmp('intSuministroAcidoFolico').enable();
                                                            Ext.getCmp('intSuministroSulfatoFerroso').setValue(21);
                                                            Ext.getCmp('intSuministroSulfatoFerroso').enable();
                                                            Ext.getCmp('intSuministroCarbonatoCalcio').setValue(21);
                                                            Ext.getCmp('intSuministroCarbonatoCalcio').enable();
                                                            Ext.getCmp('sysRegistroFPP').setValue("NO");
                                                            Ext.getCmp('sysRegistroFPP').enable();
                                                            Ext.getCmp('fecProbableParto').setValue("1845-01-01");
                                                            Ext.getCmp('fecProbableParto').enable();
                                                            Ext.getCmp('sysRegistroFechaAtencionParto').setValue("NO");
                                                            Ext.getCmp('sysRegistroFechaAtencionParto').enable();
                                                            Ext.getCmp('fecAtencionParto').setValue("1845-01-01");
                                                            Ext.getCmp('fecAtencionParto').enable();
                                                            Ext.getCmp('sysRegistroSalidaAtencionParto').setValue("NO");
                                                            Ext.getCmp('sysRegistroSalidaAtencionParto').enable();
                                                            Ext.getCmp('fecSalidaAtencionParto').setValue("1845-01-01");
                                                            Ext.getCmp('fecSalidaAtencionParto').enable();
                                                            Ext.getCmp('intHipertencionGestacional').setValue(0);
                                                            Ext.getCmp('intHipertencionGestacional').enable();
                                                            Ext.getCmp('sysRegistroFechaConcejeriaLactancia').setValue("NO");
                                                            Ext.getCmp('sysRegistroFechaConcejeriaLactancia').enable();
                                                            Ext.getCmp('fecConcejeriaLactancia').setValue("1845-01-01");
                                                            Ext.getCmp('fecConcejeriaLactancia').enable();
                                                            Ext.getCmp('sysRegistroControlPrenatalPrimeraVez').setValue("NO");
                                                            Ext.getCmp('sysRegistroControlPrenatalPrimeraVez').enable();
                                                            Ext.getCmp('fecControlPrenatalPrimeraVez').setValue("1845-01-01");
                                                            Ext.getCmp('fecControlPrenatalPrimeraVez').enable();
                                                            Ext.getCmp('sysRegistroControlPrenatal').setValue("NO");
                                                            Ext.getCmp('sysRegistroControlPrenatal').enable();
                                                            Ext.getCmp('intControlPrenatal').setValue(0);
                                                            Ext.getCmp('intControlPrenatal').enable();
                                                            Ext.getCmp('sysRegistroUltimoControlPrenatal').setValue("NO");
                                                            Ext.getCmp('sysRegistroUltimoControlPrenatal').enable();
                                                            Ext.getCmp('fecUltimoControlPrenatal').setValue("1845-01-01");
                                                            Ext.getCmp('fecUltimoControlPrenatal').enable();
                                                            Ext.getCmp('intResultadoAntigenoHepatitisB').enable();
                                                            Ext.getCmp('fecAntigenoHepatitisB').enable();
                                                            Ext.getCmp('sysRegistroFechaAntigenoHepatitisB').enable();
                                                            Ext.getCmp('sysRegistroFechaAntigenoHepatitisB').setValue("NO");
                                                            Ext.getCmp('fecAntigenoHepatitisB').setValue("1845-01-01");
                                                            Ext.getCmp('intResultadoAntigenoHepatitisB').setValue(0);
                                                            Ext.getCmp('intTamizajeCancerCuelloUterino').setValue(22);
                                                            Ext.getCmp('intTamizajeCancerCuelloUterino').enable();
                                                            Ext.getCmp('sysRegistroCitologia').setValue("SIN DATO");
                                                            Ext.getCmp('sysRegistroCitologia').enable();
                                                            Ext.getCmp('fecTomaCitologia').setValue("1800-01-01");
                                                            Ext.getCmp('fecTomaCitologia').enable();
                                                            Ext.getCmp('intResultadoCitologia').setValue(999);
                                                            Ext.getCmp('intResultadoCitologia').enable();
                                                            Ext.getCmp('intCalidadMuestraCitologia').setValue(999);
                                                            Ext.getCmp('intCalidadMuestraCitologia').enable();
                                                            Ext.getCmp('intCodIPSTomaCitologia').setValue(999);
                                                            Ext.getCmp('intCodIPSTomaCitologia').enable();
                                                            Ext.getCmp('sysRegistroIPSTomaCitologia').setValue("SIN DATO");
                                                            Ext.getCmp('sysRegistroIPSTomaCitologia').enable();
                                                            Ext.getCmp('sysRegistroTomaColposcopia').setValue("SIN DATO");
                                                            Ext.getCmp('sysRegistroTomaColposcopia').enable();
                                                            Ext.getCmp('fecTomaColposcopia').setValue("1800-01-01");
                                                            Ext.getCmp('fecTomaColposcopia').enable();
                                                            Ext.getCmp('sysRegistroIPSTomaColposcopia').setValue("SIN DATO");
                                                            Ext.getCmp('sysRegistroIPSTomaColposcopia').enable();
                                                            Ext.getCmp('intCodIPSTomaColposcopia').setValue(999);
                                                            Ext.getCmp('intCodIPSTomaColposcopia').enable();
                                                            Ext.getCmp('sysRegistroBiopsiaCervical').setValue("SIN DATO");
                                                            Ext.getCmp('sysRegistroBiopsiaCervical').enable();
                                                            Ext.getCmp('fecBiopsiaCervical').setValue("1800-01-01");
                                                            Ext.getCmp('fecBiopsiaCervical').enable();
                                                            Ext.getCmp('intResultadoBiopsiaCervical').setValue(999);
                                                            Ext.getCmp('intResultadoBiopsiaCervical').enable();
                                                            Ext.getCmp('sysRegistroIPSTomaBiopsiaCervical').setValue("SIN DATO");
                                                            Ext.getCmp('sysRegistroIPSTomaBiopsiaCervical').enable();
                                                            Ext.getCmp('intCodIPSTomaBiopsiaCervical').setValue(999);
                                                            Ext.getCmp('intCodIPSTomaBiopsiaCervical').enable();
                                                            Ext.getCmp('sysRegistroMamografia').setValue("SIN DATO");
                                                            Ext.getCmp('sysRegistroMamografia').enable();
                                                            Ext.getCmp('fecMamografia').setValue("1800-01-01");
                                                            Ext.getCmp('fecMamografia').enable();
                                                            Ext.getCmp('intResultadoMamografia').setValue(999);
                                                            Ext.getCmp('intResultadoMamografia').enable();
                                                            Ext.getCmp('sysRegistroIPSTomaMamografia').setValue("SIN DATO");
                                                            Ext.getCmp('sysRegistroIPSTomaMamografia').enable();
                                                            Ext.getCmp('intCodIPSTomaMamografia').setValue(999);
                                                            Ext.getCmp('intCodIPSTomaMamografia').enable();
                                                            Ext.getCmp('sysRegistroTomaBiopsiaSenoBACAF').setValue("SIN DATO");
                                                            Ext.getCmp('sysRegistroTomaBiopsiaSenoBACAF').enable();
                                                            Ext.getCmp('fecTomaBiopsiaSenoBACAF').setValue("1800-01-01");
                                                            Ext.getCmp('fecTomaBiopsiaSenoBACAF').enable();
                                                            Ext.getCmp('sysRegistroResultadoBiopsiaSeno').setValue("SIN DATO");
                                                            Ext.getCmp('sysRegistroResultadoBiopsiaSeno').enable();
                                                            Ext.getCmp('fecResultadoBiopsiaSeno').setValue("1800-01-01");
                                                            Ext.getCmp('fecResultadoBiopsiaSeno').enable();
                                                            Ext.getCmp('intResultadoBiopsiaSeno').setValue(999);
                                                            Ext.getCmp('intResultadoBiopsiaSeno').enable();
                                                            Ext.getCmp('sysRegistroIPSTomaBiopsiaSeno').setValue("SIN DATO");
                                                            Ext.getCmp('sysRegistroIPSTomaBiopsiaSeno').enable();
                                                            Ext.getCmp('intCodIPSTomaBiopsiaSeno').setValue(999);
                                                            Ext.getCmp('intCodIPSTomaBiopsiaSeno').enable();
                                                        }
                                                        if(newValue == "M" && MesesCumplidos >= 216){
                                                            Ext.getCmp('intVictimaMaltrato').setValue(0);
                                                            Ext.getCmp('intVictimaMaltrato').disable();
                                                        }else{
                                                            Ext.getCmp('intVictimaMaltrato').setValue(21);
                                                            Ext.getCmp('intVictimaMaltrato').enable();
                                                        }
                                                        if(newValue == "M"){
                                                            Ext.getCmp('intCancerCervix').setValue(0);
                                                            Ext.getCmp('intCancerCervix').disable();
                                                            Ext.getCmp('intVPH').setValue(0);
                                                            Ext.getCmp('intVPH').disable();
                                                            Ext.getCmp('intTD').setValue(0);
                                                            Ext.getCmp('intTD').disable();
                                                        }else{
                                                            Ext.getCmp('intCancerCervix').setValue(21);
                                                            Ext.getCmp('intCancerCervix').enable();
                                                            Ext.getCmp('intVPH').setValue(22);
                                                            Ext.getCmp('intVPH').enable();
                                                            Ext.getCmp('intTD').setValue(22);
                                                            Ext.getCmp('intTD').enable();
                                                            
                                                        }
                                                        if(newValue == "M"){
                                                            Ext.getCmp('intSifilisGestacional').setValue(0);
                                                            Ext.getCmp('intSifilisGestacional').disable();
                                                        }else{
                                                            if(MesesCumplidos <= 16){
                                                                Ext.getCmp('intSifilisGestacional').setValue(0);
                                                                Ext.getCmp('intSifilisGestacional').disable();
                                                            }else{
                                                                Ext.getCmp('intSifilisGestacional').setValue(21);
                                                                Ext.getCmp('intSifilisGestacional').enable();
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 96,
                                                allowBlank: false,
                                                fieldLabel: 'Ocupacion',
                                                value: 9999,
                                                id: 'strOcupacionHC',
                                                listeners:{
                                                    specialkey: function(f,e){
                                                        if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                        {
                                                            if (f.getValue() != "" && f.getValue() != null){
                                                                Ext.Ajax.request({
                                                                    url: '../../controlador/ciuo/controlador_ciuo.php',
                                                                    params:{
                                                                        task: 'BUSCAR',
                                                                        pCodigo: f.getValue().toUpperCase()
                                                                    },
                                                                    success: function(response,options)
                                                                    {
                                                                        var el = Ext.get('response'); // get the LOG
                                                                        var Respuesta = response.responseText;
                                                                        var Contenido = Respuesta.split('^');
                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                            Ext.getCmp('strOcupacionHC').setValue(null);
                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                        } else {
                                                                            Ext.getCmp('strOcupacionHC').setValue(Contenido[0].toUpperCase());
                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(Contenido[1].toUpperCase());
                                                                        }
                                                                    },
                                                                    failure: function(response,options){
                                                                        var el = Ext.get('response');
                                                                        Ext.getCmp('strOcupacionHC').setValue(null);
                                                                        Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                    },
                                                                    scope:this //bind the callbacks
                                                                });
                                                            }else{
                                                                Ext.getCmp('strOcupacionHC').setValue(null);
                                                                Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                            }
                                                        }
                                                    },
                                                    blur: function(t){
                                                        if(Ext.getCmp('sysOcupacionHCNom').getValue()==null || Ext.getCmp('sysOcupacionHCNom').getValue()== "")
                                                        {
                                                            if (Ext.getCmp('strOcupacionHC').getValue() != "" && Ext.getCmp('strOcupacionHC').getValue() != null){
                                                                Ext.Ajax.request({
                                                                    url: '../../controlador/ciuo/controlador_ciuo.php',
                                                                    params:{
                                                                        task: 'BUSCAR',
                                                                        pCodigo: Ext.getCmp('strOcupacionHC').getValue().toUpperCase()
                                                                    },
                                                                    success: function(response,options)
                                                                    {
                                                                        var el = Ext.get('response'); // get the LOG
                                                                        var Respuesta = response.responseText;
                                                                        var Contenido = Respuesta.split('^');
                                                                        if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                            Ext.getCmp('strOcupacionHC').setValue(null);
                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                        } else {
                                                                            Ext.getCmp('strOcupacionHC').setValue(Contenido[0].toUpperCase());
                                                                            Ext.getCmp('sysOcupacionHCNom').setValue(Contenido[1].toUpperCase());
                                                                        }
                                                                    },
                                                                    failure: function(response,options){
                                                                        var el = Ext.get('response');
                                                                        Ext.getCmp('strOcupacionHC').setValue(null);
                                                                        Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                                    },
                                                                    scope:this //bind the callbacks
                                                                });
                                                            }else{
                                                                Ext.getCmp('strOcupacionHC').setValue(null);
                                                                Ext.getCmp('sysOcupacionHCNom').setValue(null);
                                                            }
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'textarea',
                                                readOnly: true,
                                                width: 650,
                                                height: 22,
                                                id: 'sysOcupacionHCNom'
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Ocupacion',
                                                id: 'btnSearchOcupacionHC',
                                                listeners:{
                                                    click : function(){
                                                        buscarciuo('strOcupacionHC','sysOcupacionHCNom');
                                                    }
                                                }
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'combo',
                                                fieldLabel: 'Etnia',
                                                name: 'Etnia',
                                                width: 350,
                                                allowBlank: false,
                                                store: 'StoreEtnia4505',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Etnia....',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 6,
                                                id: 'sysEtniaHC'
                                            },
                                            {
                                                html: 'Escolaridad:'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Escolaridad',
                                                width: 355,
                                                allowBlank: false,
                                                store: 'StoreEscolaridad4505',
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                emptyText: 'Seleccione Escolaridad....',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 1,
                                                id: 'sysEscolaridadHC'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Cliente',
                                        width: 400,
                                        allowBlank: false,
                                        store: 'StoreCliente',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Cliente....',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'sysIdCliente'
                                    },
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '<center>IDENTIFICACION DEL RIESGO</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                autoHeight: true,
                                id: 'pnIdentificacionRiesgo',
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'table',
                                        anchor: '100%',
                                        padding: 0,
                                        layoutConfig: {
                                            columns: 2
                                        },
                                        autoHeight: true,
                                        items: [
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 400,
                                                height: 330,
                                                labelSeparator: '',
                                                labelStyle: 'color:blue;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Gestación',
                                                        fieldLabel: 'Gestación<br>&nbsp;',
                                                        width: 250,
                                                        allowBlank: false,
                                                        store: stGestacion,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 21,
                                                        id: 'intGestacion',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue != 1){
                                                                    Ext.getCmp('sysRegistroFPP').setValue("NO");
                                                                    Ext.getCmp('sysRegistroFPP').disable();
                                                                    Ext.getCmp('fecProbableParto').setValue("1845-01-01");
                                                                    Ext.getCmp('fecProbableParto').disable();
                                                                    Ext.getCmp('sysRegistroFechaAtencionParto').setValue("NO");
                                                                    Ext.getCmp('sysRegistroFechaAtencionParto').disable();
                                                                    Ext.getCmp('fecAtencionParto').setValue("1845-01-01");
                                                                    Ext.getCmp('fecAtencionParto').disable();
                                                                    Ext.getCmp('sysRegistroSalidaAtencionParto').setValue("NO");
                                                                    Ext.getCmp('sysRegistroSalidaAtencionParto').disable();
                                                                    Ext.getCmp('fecSalidaAtencionParto').setValue("1845-01-01");
                                                                    Ext.getCmp('fecSalidaAtencionParto').disable();
                                                                    Ext.getCmp('intHipertencionGestacional').setValue(0);
                                                                    Ext.getCmp('intHipertencionGestacional').disable();
                                                                    Ext.getCmp('sysRegistroFechaConcejeriaLactancia').setValue("NO");
                                                                    Ext.getCmp('sysRegistroFechaConcejeriaLactancia').disable();
                                                                    Ext.getCmp('fecConcejeriaLactancia').setValue("1845-01-01");
                                                                    Ext.getCmp('fecConcejeriaLactancia').disable();
                                                                    Ext.getCmp('sysRegistroControlPrenatalPrimeraVez').setValue("NO");
                                                                    Ext.getCmp('sysRegistroControlPrenatalPrimeraVez').disable();
                                                                    Ext.getCmp('fecControlPrenatalPrimeraVez').setValue("1845-01-01");
                                                                    Ext.getCmp('fecControlPrenatalPrimeraVez').disable();
                                                                    Ext.getCmp('sysRegistroControlPrenatal').setValue("NO");
                                                                    Ext.getCmp('sysRegistroControlPrenatal').disable();
                                                                    Ext.getCmp('intControlPrenatal').setValue(0);
                                                                    Ext.getCmp('intControlPrenatal').disable();
                                                                    Ext.getCmp('sysRegistroUltimoControlPrenatal').setValue("NO");
                                                                    Ext.getCmp('sysRegistroUltimoControlPrenatal').disable();
                                                                    Ext.getCmp('fecUltimoControlPrenatal').setValue("1845-01-01");
                                                                    Ext.getCmp('fecUltimoControlPrenatal').disable();
                                                                    Ext.getCmp('intResultadoAntigenoHepatitisB').disable();
                                                                    Ext.getCmp('fecAntigenoHepatitisB').disable();
                                                                    Ext.getCmp('sysRegistroFechaAntigenoHepatitisB').disable();
                                                                    Ext.getCmp('sysRegistroFechaAntigenoHepatitisB').setValue("NO");
                                                                    Ext.getCmp('fecAntigenoHepatitisB').setValue("1845-01-01");
                                                                    Ext.getCmp('intResultadoAntigenoHepatitisB').setValue(0);
                                                                    Ext.getCmp('intSuministroAcidoFolico').setValue(0);
                                                                    Ext.getCmp('intSuministroAcidoFolico').disable();
                                                                    Ext.getCmp('intSuministroSulfatoFerroso').setValue(0);
                                                                    Ext.getCmp('intSuministroSulfatoFerroso').disable();
                                                                    Ext.getCmp('intSuministroCarbonatoCalcio').setValue(0);
                                                                    Ext.getCmp('intSuministroCarbonatoCalcio').disable();
                                                                }else{
                                                                    Ext.getCmp('intHipertencionGestacional').setValue(21);
                                                                    Ext.getCmp('intHipertencionGestacional').enable();
                                                                    Ext.getCmp('sysRegistroFPP').setValue("SI");
                                                                    Ext.getCmp('sysRegistroFPP').enable();
                                                                    Ext.getCmp('fecProbableParto').setValue("1800-01-01");
                                                                    Ext.getCmp('fecProbableParto').enable();
                                                                    Ext.getCmp('sysRegistroFechaAtencionParto').setValue("SI");
                                                                    Ext.getCmp('sysRegistroFechaAtencionParto').enable();
                                                                    Ext.getCmp('fecAtencionParto').setValue("1800-01-01");
                                                                    Ext.getCmp('fecAtencionParto').enable();
                                                                    Ext.getCmp('sysRegistroSalidaAtencionParto').setValue("SI");
                                                                    Ext.getCmp('sysRegistroSalidaAtencionParto').enable();
                                                                    Ext.getCmp('fecSalidaAtencionParto').setValue("1800-01-01");
                                                                    Ext.getCmp('fecSalidaAtencionParto').enable();
                                                                    Ext.getCmp('sysRegistroFechaConcejeriaLactancia').setValue("SI");
                                                                    Ext.getCmp('sysRegistroFechaConcejeriaLactancia').enable();
                                                                    Ext.getCmp('fecConcejeriaLactancia').setValue("1800-01-01");
                                                                    Ext.getCmp('fecConcejeriaLactancia').enable();
                                                                    Ext.getCmp('sysRegistroControlPrenatalPrimeraVez').setValue("SI");
                                                                    Ext.getCmp('sysRegistroControlPrenatalPrimeraVez').enable();
                                                                    Ext.getCmp('fecControlPrenatalPrimeraVez').setValue("1800-01-01");
                                                                    Ext.getCmp('fecControlPrenatalPrimeraVez').enable();
                                                                    Ext.getCmp('sysRegistroControlPrenatal').setValue("SI");
                                                                    Ext.getCmp('sysRegistroControlPrenatal').enable();
                                                                    Ext.getCmp('intControlPrenatal').setValue(999);
                                                                    Ext.getCmp('intControlPrenatal').enable();
                                                                    Ext.getCmp('sysRegistroUltimoControlPrenatal').setValue("SI");
                                                                    Ext.getCmp('sysRegistroUltimoControlPrenatal').enable();
                                                                    Ext.getCmp('fecUltimoControlPrenatal').setValue("1800-01-01");
                                                                    Ext.getCmp('fecUltimoControlPrenatal').enable();
                                                                    Ext.getCmp('intResultadoAntigenoHepatitisB').enable();
                                                                    Ext.getCmp('fecAntigenoHepatitisB').enable();
                                                                    Ext.getCmp('sysRegistroFechaAntigenoHepatitisB').enable();
                                                                    Ext.getCmp('sysRegistroFechaAntigenoHepatitisB').setValue("SI");
                                                                    Ext.getCmp('fecAntigenoHepatitisB').setValue("1800-01-01");
                                                                    Ext.getCmp('intResultadoAntigenoHepatitisB').setValue(22);
                                                                    Ext.getCmp('intSuministroAcidoFolico').setValue(21);
                                                                    Ext.getCmp('intSuministroAcidoFolico').enable();
                                                                    Ext.getCmp('intSuministroSulfatoFerroso').setValue(21);
                                                                    Ext.getCmp('intSuministroSulfatoFerroso').enable();
                                                                    Ext.getCmp('intSuministroCarbonatoCalcio').setValue(21);
                                                                    Ext.getCmp('intSuministroCarbonatoCalcio').enable();
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Sifilis Gestacional o Congenita',
                                                        fieldLabel: 'Sifilis Gestacional o Congenita',
                                                        width: 250,
                                                        allowBlank: false,
                                                        store: stSifilisGestacional,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 21,
                                                        id: 'intSifilisGestacional',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == 1){
                                                                    Ext.getCmp('intTratamientoSifilisGestacional').setValue(22);
                                                                    Ext.getCmp('intTratamientoSifilisCongenita').setValue(0);
                                                                    Ext.getCmp('intTratamientoSifilisGestacional').enable();
                                                                    Ext.getCmp('intTratamientoSifilisCongenita').disable();
                                                                }else{
                                                                    if(newValue == 2){
                                                                        Ext.getCmp('intTratamientoSifilisGestacional').setValue(0);
                                                                        Ext.getCmp('intTratamientoSifilisCongenita').setValue(22);
                                                                        Ext.getCmp('intTratamientoSifilisGestacional').disable();
                                                                        Ext.getCmp('intTratamientoSifilisCongenita').enable();
                                                                    }else{
                                                                        
                                                                        Ext.getCmp('intTratamientoSifilisGestacional').setValue(0);
                                                                        Ext.getCmp('intTratamientoSifilisCongenita').setValue(0);
                                                                        Ext.getCmp('intTratamientoSifilisGestacional').disable();
                                                                        Ext.getCmp('intTratamientoSifilisCongenita').disable();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Hipertension Gestacional',
                                                        fieldLabel: 'Hipertension Gestacional',
                                                        width: 250,
                                                        allowBlank: false,
                                                        store: stHipertencionGestacional,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 21,
                                                        id: 'intHipertencionGestacional'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Hipotiroidismo Congenito',
                                                        fieldLabel: 'Hipotiroidismo Congenito',
                                                        width: 250,
                                                        allowBlank: false,
                                                        store: stHipotiroidismoCongenito,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 21,
                                                        id: 'intHipotiroidismoCongenito',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == 1){
                                                                    Ext.getCmp('intTratamientoHipotiroidismoCongenito').setValue(22);
                                                                    Ext.getCmp('intTratamientoHipotiroidismoCongenito').enable();
                                                                }else{
                                                                    Ext.getCmp('intTratamientoHipotiroidismoCongenito').setValue(0);
                                                                    Ext.getCmp('intTratamientoHipotiroidismoCongenito').disable();
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Sintomatico Respiratorio',
                                                        fieldLabel: 'Sintomatico Respiratorio',
                                                        width: 250,
                                                        allowBlank: false,
                                                        store: stSintomaticoRespiratorio,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 21,
                                                        id: 'intSintomaticoRespiratorio'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Tuberculosis Multidrogoresistente',
                                                        fieldLabel: 'Tuberculosis Multidrogoresistente',
                                                        width: 250,
                                                        allowBlank: false,
                                                        store: stTuberculosisMultidrogoresistente,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 21,
                                                        id: 'intTuberculosisMultidrogoresistente'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Lepra',
                                                        fieldLabel: 'Lepra<br>&nbsp;',
                                                        width: 250,
                                                        allowBlank: false,
                                                        store: stLepra,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 21,
                                                        id: 'intLepra',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == 2 || newValue == 1){
                                                                    Ext.getCmp('intTratamientoLepra').setValue(22);
                                                                    Ext.getCmp('intTratamientoLepra').enable();
                                                                }else{
                                                                    Ext.getCmp('intTratamientoLepra').setValue(0);
                                                                    Ext.getCmp('intTratamientoLepra').disable();
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Obesidad o Desnutricion',
                                                        fieldLabel: 'Obesidad o Desnutricion',
                                                        width: 250,
                                                        allowBlank: false,
                                                        store: stObesidadDesnutricion,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 21,
                                                        id: 'intObesidadDesnutricion',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue != 2){
                                                                    Ext.getCmp('sysRegistroFechaDxDesnutricion').setValue("NO");
                                                                    Ext.getCmp('fecFechaDxDesnutricion').setValue("1845-01-01");
                                                                    Ext.getCmp('sysRegistroFechaDxDesnutricion').disable();
                                                                    Ext.getCmp('fecFechaDxDesnutricion').disable();
                                                                }else{
                                                                    Ext.getCmp('sysRegistroFechaDxDesnutricion').setValue("SI");
                                                                    Ext.getCmp('fecFechaDxDesnutricion').setValue("1800-01-01");
                                                                    Ext.getCmp('sysRegistroFechaDxDesnutricion').enable();
                                                                    Ext.getCmp('fecFechaDxDesnutricion').enable();
                                                                }
                                                            }
                                                        }
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                width: 400,
                                                height: 330,
                                                labelSeparator: '',
                                                labelStyle: 'color:blue;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Victima Maltrato',
                                                        fieldLabel: 'Victima Maltrato<br>&nbsp;',
                                                        width: 250,
                                                        allowBlank: false,
                                                        store: stVictimaMaltrato,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 21,
                                                        id: 'intVictimaMaltrato',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == 0){
                                                                    Ext.getCmp('sysRegistroMujerVictimaMaltrato').setValue("NO");
                                                                    Ext.getCmp('fecConsultaMujerVictimaMaltrato').setValue("1845-01-01");
                                                                    Ext.getCmp('sysRegistroMujerVictimaMaltrato').disable();
                                                                    Ext.getCmp('fecConsultaMujerVictimaMaltrato').disable();
                                                                }else{
                                                                    if(newValue == 21){
                                                                        Ext.getCmp('sysRegistroMujerVictimaMaltrato').setValue("NO");
                                                                        Ext.getCmp('fecConsultaMujerVictimaMaltrato').setValue("1845-01-01");
                                                                        Ext.getCmp('sysRegistroMujerVictimaMaltrato').disable();
                                                                        Ext.getCmp('fecConsultaMujerVictimaMaltrato').disable();
                                                                    }else{
                                                                        if(newValue == 3){
                                                                            Ext.getCmp('sysRegistroMujerVictimaMaltrato').setValue("NO");
                                                                            Ext.getCmp('fecConsultaMujerVictimaMaltrato').setValue("1845-01-01");
                                                                            Ext.getCmp('sysRegistroMujerVictimaMaltrato').disable();
                                                                            Ext.getCmp('fecConsultaMujerVictimaMaltrato').disable();
                                                                        }else{
                                                                            Ext.getCmp('sysRegistroMujerVictimaMaltrato').setValue("SI");
                                                                            Ext.getCmp('fecConsultaMujerVictimaMaltrato').setValue("1800-01-01");
                                                                            Ext.getCmp('sysRegistroMujerVictimaMaltrato').enable();
                                                                            Ext.getCmp('fecConsultaMujerVictimaMaltrato').enable(); 
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Violencia Sexual',
                                                        fieldLabel: 'Violencia Sexual<br>&nbsp;',
                                                        width: 250,
                                                        allowBlank: false,
                                                        store: stViolenciaSexual,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 21,
                                                        id: 'intViolenciaSexual',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue != 1){
                                                                    Ext.getCmp('sysRegistroViolenciaSexual').setValue("NO");
                                                                    Ext.getCmp('fecConsultaViolenciaSexual').setValue("1845-01-01");
                                                                    Ext.getCmp('sysRegistroViolenciaSexual').disable();
                                                                    Ext.getCmp('fecConsultaViolenciaSexual').disable();
                                                                }else{
                                                                    Ext.getCmp('sysRegistroViolenciaSexual').setValue("SI");
                                                                    Ext.getCmp('fecConsultaViolenciaSexual').setValue("1800-01-01");
                                                                    Ext.getCmp('sysRegistroViolenciaSexual').enable();
                                                                    Ext.getCmp('fecConsultaViolenciaSexual').enable();
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Infecciones Trasmision Sexual',
                                                        fieldLabel: 'Infecciones Trasmision Sexual',
                                                        width: 250,
                                                        allowBlank: false,
                                                        store: stInfeccionesTrasmisionSexual,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 21,
                                                        id: 'intInfeccionesTrasmisionSexual'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Enfermedad Mental',
                                                        fieldLabel: 'Enfermedad Mental',
                                                        width: 250,
                                                        allowBlank: false,
                                                        store: stEnfermedadMental,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 21,
                                                        id: 'intEnfermedadMental'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Cancer Cervix',
                                                        fieldLabel: 'Cancer Cervix<br>&nbsp;',
                                                        width: 250,
                                                        allowBlank: false,
                                                        store: stCancerCervix,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 21,
                                                        id: 'intCancerCervix'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Cancer Seno',
                                                        fieldLabel: 'Cancer Seno<br>&nbsp;',
                                                        width: 250,
                                                        allowBlank: false,
                                                        store: stCancerSeno,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 21,
                                                        id: 'intCancerSeno'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Fluorosis Dental',
                                                        fieldLabel: 'Fluorosis Dental<br>&nbsp;',
                                                        width: 250,
                                                        allowBlank: false,
                                                        store: stFluorosisDental,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 21,
                                                        id: 'intFluorosisDental'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '<center>ACTIVIDADES DE INTERVENCION SEGUN EL RIESGO</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                autoHeight: true,
                                id: 'pnActividadesIntervencion',
                                items: [
                                    {
                                        xtype: 'fieldset',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: false,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Peso Registrado?',
                                                        name: 'Peso Registrado?',
                                                        width: 50,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'sysRegistroPeso',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO"){
                                                                    Ext.getCmp('intPeso').setValue(999);
                                                                    Ext.getCmp('intPeso').disable();
                                                                    Ext.getCmp('fecPeso').setValue("01/01/1800");
                                                                    Ext.getCmp('fecPeso').disable();
                                                                }else{
                                                                    Ext.getCmp('intPeso').enable();
                                                                    Ext.getCmp('fecPeso').enable();
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        html: 'Fecha Peso'
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Peso',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1800',
                                                        style: 'text-align:center;',
                                                        id: 'fecPeso'
                                                    },
                                                    {
                                                        html: 'Peso'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Peso Kg',
                                                        width: 200,
                                                        maxValue: 999,
                                                        value: 999,
                                                        allowBlank: false,
                                                        id: 'intPeso',
                                                        style: 'text-align:center;'
                                                    }
                                                ]
                                            },
                                            {
                                                html: '<br>'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Talla Registrado?',
                                                        name: 'Talla Registrado?',
                                                        width: 50,
                                                        allowBlank: true,
                                                        store: 'StoreSiNo',
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO",
                                                        id: 'sysRegistroTalla',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO"){
                                                                    Ext.getCmp('intTalla').setValue(999);
                                                                    Ext.getCmp('intTalla').disable();
                                                                    Ext.getCmp('fecTalla').setValue("01/01/1800");
                                                                    Ext.getCmp('fecTalla').disable();
                                                                }else{
                                                                    Ext.getCmp('intTalla').enable();
                                                                    Ext.getCmp('fecTalla').enable();
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        html: 'Fecha Talla'
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Talla',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1800',
                                                        style: 'text-align:center;',
                                                        id: 'fecTalla'
                                                    },
                                                    {
                                                        html: 'Talla'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Talla Cm',
                                                        width: 200,
                                                        maxValue: 999,
                                                        decimalPrecision: 0,
                                                        value: 999,
                                                        allowBlank: false,
                                                        style: 'text-align:center;',
                                                        id: 'intTalla'
                                                    }
                                                ]
                                            },
                                            {
                                                html: '<br>'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Edad Gestacional Nacer?',
                                                        name: 'Registro Edad Gestacional Nacer?',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: stRegistroFechas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'SIN DATO',
                                                        id: 'sysRegistroEdadGestacionalNacer',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('intEdadGestacionalNacer').setValue(0);
                                                                    Ext.getCmp('intEdadGestacionalNacer').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('intEdadGestacionalNacer').setValue(999);
                                                                        Ext.getCmp('intEdadGestacionalNacer').disable();
                                                                    }else{
                                                                        Ext.getCmp('intEdadGestacionalNacer').enable();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Edad Gestacional Nacer',
                                                        width: 200,
                                                        maxValue: 999,
                                                        decimalPrecision: 0,
                                                        value: 999,
                                                        allowBlank: false,
                                                        style: 'text-align:center;',
                                                        id: 'intEdadGestacionalNacer'
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'VACUNACION',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'combo',
                                                name: 'BCG',
                                                fieldLabel: 'BCG',
                                                width: 450,
                                                allowBlank: false,
                                                store: stBCG,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 22,
                                                id: 'intBCG'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Hepatitis B',
                                                fieldLabel: 'Hepatitis B',
                                                width: 450,
                                                allowBlank: false,
                                                store: stHepatitisB,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 22,
                                                id: 'intHepatitisB'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Pentavalente',
                                                fieldLabel: 'Pentavalente',
                                                width: 450,
                                                allowBlank: false,
                                                store: stPentavalente,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 22,
                                                id: 'intPentavalente'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Polio',
                                                fieldLabel: 'Polio',
                                                width: 450,
                                                allowBlank: false,
                                                store: stPolio,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 22,
                                                id: 'intPolio'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'DPT',
                                                fieldLabel: 'DPT',
                                                width: 450,
                                                allowBlank: false,
                                                store: stDPT,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 22,
                                                id: 'intDPT'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Rotavirus',
                                                fieldLabel: 'Rotavirus',
                                                width: 450,
                                                allowBlank: false,
                                                store: stRotavirus,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 22,
                                                id: 'intRotavirus'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Neumococo',
                                                fieldLabel: 'Neumococo',
                                                width: 450,
                                                allowBlank: false,
                                                store: stNeumococo,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 22,
                                                id: 'intNeumococo'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Influenza',
                                                fieldLabel: 'Influenza',
                                                width: 450,
                                                allowBlank: false,
                                                store: stInfluenza,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 22,
                                                id: 'intInfluenza'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Fiebre Amarilla',
                                                fieldLabel: 'Fiebre Amarilla',
                                                width: 450,
                                                allowBlank: false,
                                                store: stFiebreAmarilla,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 22,
                                                id: 'intFiebreAmarilla'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Hepatitis A',
                                                fieldLabel: 'Hepatitis A',
                                                width: 450,
                                                allowBlank: false,
                                                store: stHepatitisA,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 22,
                                                id: 'intHepatitisA'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Triple Viral',
                                                fieldLabel: 'Triple Viral',
                                                width: 450,
                                                allowBlank: false,
                                                store: stTripleViral,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 22,
                                                id: 'intTripleViral'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'VPH',
                                                fieldLabel: 'VPH',
                                                width: 450,
                                                allowBlank: false,
                                                store: stVPH,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 22,
                                                id: 'intVPH'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'TD o TT',
                                                fieldLabel: 'TD o TT',
                                                width: 450,
                                                allowBlank: false,
                                                store: stTD,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 22,
                                                id: 'intTD'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'PLANIFICACION FAMILIAR',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Planificacion Familiar 1ra Vez?',
                                                        name: 'Registro Planificacion Familiar 1ra Vez?',
                                                        width: 300,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'SIN DATO',
                                                        id: 'sysRegistroPlanificacionFamiliar1raVez',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').setValue("01/01/1845");
                                                                    Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').setValue("01/01/1800");
                                                                        Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').setValue("01/01/1805");
                                                                            Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').setValue("01/01/1810");
                                                                                Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Planificacion Familiar 1ra Vez',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1800',
                                                        style: 'text-align:center;',
                                                        id: 'fecPlanificacionFamiliarPrimeraVez'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Suministro Metodo Planificacion',
                                                fieldLabel: 'Suministro Metodo Planificacion',
                                                width: 350,
                                                allowBlank: false,
                                                store: stSuministroMetodoPlanificacion,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 21,
                                                id: 'intSuministroMetodoPlanificacion'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Fecha Suministro Metodo?',
                                                        name: 'Registro Fecha Suministro Metodo?',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: stRegistroFechas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'SIN DATO',
                                                        id: 'sysRegistroFechaSuministroMetodo',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecSuministroMetodo').setValue("01/01/1845");
                                                                    Ext.getCmp('fecSuministroMetodo').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecSuministroMetodo').setValue("01/01/1800");
                                                                        Ext.getCmp('fecSuministroMetodo').disable();
                                                                    }else{
                                                                        Ext.getCmp('fecSuministroMetodo').enable();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Suministro Metodo',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1800',
                                                        style: 'text-align:center;',
                                                        id: 'fecSuministroMetodo'
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'ATENCION PRENATAL - POSTPARTO',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Control Prenatal 1ra Vez?',
                                                        name: 'Registro Control Prenatal 1ra Vez?',
                                                        width: 300,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroControlPrenatalPrimeraVez',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecControlPrenatalPrimeraVez').setValue("01/01/1845");
                                                                    Ext.getCmp('fecControlPrenatalPrimeraVez').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecControlPrenatalPrimeraVez').setValue("01/01/1800");
                                                                        Ext.getCmp('fecControlPrenatalPrimeraVez').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecControlPrenatalPrimeraVez').setValue("01/01/1805");
                                                                            Ext.getCmp('fecControlPrenatalPrimeraVez').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecControlPrenatalPrimeraVez').setValue("01/01/1810");
                                                                                Ext.getCmp('fecControlPrenatalPrimeraVez').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecControlPrenatalPrimeraVez').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecControlPrenatalPrimeraVez').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecControlPrenatalPrimeraVez').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecControlPrenatalPrimeraVez').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecControlPrenatalPrimeraVez').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecControlPrenatalPrimeraVez').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecControlPrenatalPrimeraVez').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Control Prenatal 1ra Vez',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecControlPrenatalPrimeraVez'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Control Prenatal No?',
                                                        name: 'Registro Control Prenatal No?',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: stRegistroFechas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "SIN DATO",
                                                        id: 'sysRegistroControlPrenatal',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('intControlPrenatal').setValue(0);
                                                                    Ext.getCmp('intControlPrenatal').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('intControlPrenatal').setValue(999);
                                                                        Ext.getCmp('intControlPrenatal').disable();
                                                                    }else{
                                                                        Ext.getCmp('intControlPrenatal').enable();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Control Prenatal No',
                                                        width: 200,
                                                        maxValue: 999,
                                                        minValue: 0,
                                                        value: 999,
                                                        allowBlank: false,
                                                        style: 'text-align:center;',
                                                        id: 'intControlPrenatal'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Ultimo Control Prenatal?',
                                                        name: 'Registro Ultimo Control Prenatal?',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: stRegistroFechas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroUltimoControlPrenatal',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecUltimoControlPrenatal').setValue("01/01/1845");
                                                                    Ext.getCmp('fecUltimoControlPrenatal').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecUltimoControlPrenatal').setValue("01/01/1800");
                                                                        Ext.getCmp('fecUltimoControlPrenatal').disable();
                                                                    }else{
                                                                        Ext.getCmp('fecUltimoControlPrenatal').enable();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Ultimo Control Prenatal',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecUltimoControlPrenatal'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Suministro Acido Folico',
                                                fieldLabel: 'Suministro Acido Folico',
                                                width: 350,
                                                allowBlank: false,
                                                store: stSuministroAcidoFolico,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 21,
                                                id: 'intSuministroAcidoFolico'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Suministro Sulfato Ferroso',
                                                fieldLabel: 'Suministro Sulfato Ferroso',
                                                width: 350,
                                                allowBlank: false,
                                                store: stSuministroSulfatoFerroso,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 21,
                                                id: 'intSuministroSulfatoFerroso'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Suministro Carbonato Calcio',
                                                fieldLabel: 'Suministro Carbonato Calcio',
                                                width: 350,
                                                allowBlank: false,
                                                store: stSuministroCarbonatoCalcio,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 21,
                                                id: 'intSuministroCarbonatoCalcio'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Fecha Antigeno Hepatitis B?',
                                                        name: 'Registro Fecha Antigeno Hepatitis B?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroFechaAntigenoHepatitisB',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecAntigenoHepatitisB').setValue("01/01/1845");
                                                                    Ext.getCmp('fecAntigenoHepatitisB').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecAntigenoHepatitisB').setValue("01/01/1800");
                                                                        Ext.getCmp('fecAntigenoHepatitisB').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecAntigenoHepatitisB').setValue("01/01/1805");
                                                                            Ext.getCmp('fecAntigenoHepatitisB').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecAntigenoHepatitisB').setValue("01/01/1810");
                                                                                Ext.getCmp('fecAntigenoHepatitisB').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecAntigenoHepatitisB').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecAntigenoHepatitisB').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecAntigenoHepatitisB').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecAntigenoHepatitisB').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecAntigenoHepatitisB').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecAntigenoHepatitisB').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecAntigenoHepatitisB').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 160,
                                                        name: 'Fecha Antigeno Hepatitis B',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecAntigenoHepatitisB'
                                                    },
                                                    {
                                                        html:'Resultado'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Resultado Antigeno Hepatitis B',
                                                        width: 150,
                                                        allowBlank: false,
                                                        store: stResultadoAntigenoHepatitisB,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 0,
                                                        id: 'intResultadoAntigenoHepatitisB'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Fecha Probable Parto?',
                                                        name: 'Registro Fecha Probable Parto?',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: stRegistroFechas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "SIN DATO",
                                                        id: 'sysRegistroFPP',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecProbableParto').setValue("01/01/1845");
                                                                    Ext.getCmp('fecProbableParto').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecProbableParto').setValue("01/01/1800");
                                                                        Ext.getCmp('fecProbableParto').disable();
                                                                    }else{
                                                                        Ext.getCmp('fecProbableParto').enable();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Probable de Parto',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1800',
                                                        style: 'text-align:center;',
                                                        id: 'fecProbableParto'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Fecha Atencion Parto?',
                                                        name: 'Registro Fecha Atencion Parto?',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: stRegistroFechas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroFechaAtencionParto',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecAtencionParto').setValue("01/01/1845");
                                                                    Ext.getCmp('fecAtencionParto').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecAtencionParto').setValue("01/01/1800");
                                                                        Ext.getCmp('fecAtencionParto').disable();
                                                                    }else{
                                                                        Ext.getCmp('fecAtencionParto').enable();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Atencion Parto',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecAtencionParto'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Salida Atencion Parto?',
                                                        name: 'Registro Salida Atencion Parto?',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: stRegistroFechas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroSalidaAtencionParto',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecSalidaAtencionParto').setValue("01/01/1845");
                                                                    Ext.getCmp('fecSalidaAtencionParto').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecSalidaAtencionParto').setValue("01/01/1800");
                                                                        Ext.getCmp('fecSalidaAtencionParto').disable();
                                                                    }else{
                                                                        Ext.getCmp('fecSalidaAtencionParto').enable();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Salida Atencion Parto',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecSalidaAtencionParto'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Fecha Concejeria Lactancia',
                                                        name: 'Registro Fecha Concejeria Lactancia?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroFechaConcejeriaLactancia',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecConcejeriaLactancia').setValue("01/01/1845");
                                                                    Ext.getCmp('fecConcejeriaLactancia').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecConcejeriaLactancia').setValue("01/01/1800");
                                                                        Ext.getCmp('fecConcejeriaLactancia').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecConcejeriaLactancia').setValue("01/01/1805");
                                                                            Ext.getCmp('fecConcejeriaLactancia').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecConcejeriaLactancia').setValue("01/01/1810");
                                                                                Ext.getCmp('fecConcejeriaLactancia').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecConcejeriaLactancia').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecConcejeriaLactancia').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecConcejeriaLactancia').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecConcejeriaLactancia').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecConcejeriaLactancia').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecConcejeriaLactancia').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecConcejeriaLactancia').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Concejeria Lactancia',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecConcejeriaLactancia'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Fecha Control Recien Nacido?',
                                                        name: 'Registro Fecha Control Recien Nacido?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroFechaControlRecienNacido',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecControlRecienNacido').setValue("01/01/1845");
                                                                    Ext.getCmp('fecControlRecienNacido').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecControlRecienNacido').setValue("01/01/1800");
                                                                        Ext.getCmp('fecControlRecienNacido').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecControlRecienNacido').setValue("01/01/1805");
                                                                            Ext.getCmp('fecControlRecienNacido').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecControlRecienNacido').setValue("01/01/1810");
                                                                                Ext.getCmp('fecControlRecienNacido').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecControlRecienNacido').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecControlRecienNacido').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecControlRecienNacido').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecControlRecienNacido').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecControlRecienNacido').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecControlRecienNacido').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecControlRecienNacido').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Control Recien Nacido',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecControlRecienNacido'
                                                    }
                                                ]
                                            },
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'OTROS PROGRAMAS',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'combo',
                                                name: 'Control de Placa Bacteriana',
                                                fieldLabel: 'Control de Placa Bacteriana',
                                                width: 450,
                                                allowBlank: false,
                                                store: stControlPlaca,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 22,
                                                id: 'intControlPlacaBacteriana'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Agudeza Visual?',
                                                        name: 'Registro Agudeza Visual?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroAgudezaVisual',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecValoracionAgudezaVisual').setValue("01/01/1845");
                                                                    Ext.getCmp('fecValoracionAgudezaVisual').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecValoracionAgudezaVisual').setValue("01/01/1800");
                                                                        Ext.getCmp('fecValoracionAgudezaVisual').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecValoracionAgudezaVisual').setValue("01/01/1805");
                                                                            Ext.getCmp('fecValoracionAgudezaVisual').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecValoracionAgudezaVisual').setValue("01/01/1810");
                                                                                Ext.getCmp('fecValoracionAgudezaVisual').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecValoracionAgudezaVisual').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecValoracionAgudezaVisual').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecValoracionAgudezaVisual').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecValoracionAgudezaVisual').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecValoracionAgudezaVisual').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecValoracionAgudezaVisual').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecValoracionAgudezaVisual').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Valoracion Agudeza Visual',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1800',
                                                        style: 'text-align:center;',
                                                        id: 'fecValoracionAgudezaVisual'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Consulta Oftalmologia?',
                                                        name: 'Registro Consulta Oftalmologia?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroConsultaOfitalmologia',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecConsultaOfitalmologia').setValue("01/01/1845");
                                                                    Ext.getCmp('fecConsultaOfitalmologia').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecConsultaOfitalmologia').setValue("01/01/1800");
                                                                        Ext.getCmp('fecConsultaOfitalmologia').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecConsultaOfitalmologia').setValue("01/01/1805");
                                                                            Ext.getCmp('fecConsultaOfitalmologia').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecConsultaOfitalmologia').setValue("01/01/1810");
                                                                                Ext.getCmp('fecConsultaOfitalmologia').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecConsultaOfitalmologia').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecConsultaOfitalmologia').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecConsultaOfitalmologia').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecConsultaOfitalmologia').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecConsultaOfitalmologia').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecConsultaOfitalmologia').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecConsultaOfitalmologia').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Consulta Ofitalmologia',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecConsultaOfitalmologia'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Fecha Dx Desnutricion?',
                                                        name: 'Registro Fecha Dx Desnutricion?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroFechaDxDesnutricion',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecFechaDxDesnutricion').setValue("01/01/1845");
                                                                    Ext.getCmp('fecFechaDxDesnutricion').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecFechaDxDesnutricion').setValue("01/01/1800");
                                                                        Ext.getCmp('fecFechaDxDesnutricion').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecFechaDxDesnutricion').setValue("01/01/1805");
                                                                            Ext.getCmp('fecFechaDxDesnutricion').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecFechaDxDesnutricion').setValue("01/01/1810");
                                                                                Ext.getCmp('fecFechaDxDesnutricion').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecFechaDxDesnutricion').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecFechaDxDesnutricion').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecFechaDxDesnutricion').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecFechaDxDesnutricion').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecFechaDxDesnutricion').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecFechaDxDesnutricion').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecFechaDxDesnutricion').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Dx Desnutricion',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecFechaDxDesnutricion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Consulta Nutricion',
                                                        name: 'Registro Consulta Nutricion',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroConsultaNutricion',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecConsultaNutricion').setValue("01/01/1845");
                                                                    Ext.getCmp('fecConsultaNutricion').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecConsultaNutricion').setValue("01/01/1800");
                                                                        Ext.getCmp('fecConsultaNutricion').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecConsultaNutricion').setValue("01/01/1805");
                                                                            Ext.getCmp('fecConsultaNutricion').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecConsultaNutricion').setValue("01/01/1810");
                                                                                Ext.getCmp('fecConsultaNutricion').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecConsultaNutricion').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecConsultaNutricion').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecConsultaNutricion').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecConsultaNutricion').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecConsultaNutricion').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecConsultaNutricion').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecConsultaNutricion').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Consulta Nutricion',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecConsultaNutricion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Consulta Psicologia',
                                                        name: 'Registro Consulta Psicologia',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroConsultaPsicologia',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecConsultaPsicologia').setValue("01/01/1845");
                                                                    Ext.getCmp('fecConsultaPsicologia').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecConsultaPsicologia').setValue("01/01/1800");
                                                                        Ext.getCmp('fecConsultaPsicologia').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecConsultaPsicologia').setValue("01/01/1805");
                                                                            Ext.getCmp('fecConsultaPsicologia').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecConsultaPsicologia').setValue("01/01/1810");
                                                                                Ext.getCmp('fecConsultaPsicologia').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecConsultaPsicologia').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecConsultaPsicologia').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecConsultaPsicologia').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecConsultaPsicologia').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecConsultaPsicologia').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecConsultaPsicologia').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecConsultaPsicologia').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Consulta Psicologia',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecConsultaPsicologia'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Consulta Joven 1er Vez',
                                                        name: 'Registro Consulta Joven 1er Vez',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroConsultaJoven1erVez',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecConsultaJovenPrimeraVez').setValue("01/01/1845");
                                                                    Ext.getCmp('fecConsultaJovenPrimeraVez').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecConsultaJovenPrimeraVez').setValue("01/01/1800");
                                                                        Ext.getCmp('fecConsultaJovenPrimeraVez').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecConsultaJovenPrimeraVez').setValue("01/01/1805");
                                                                            Ext.getCmp('fecConsultaJovenPrimeraVez').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecConsultaJovenPrimeraVez').setValue("01/01/1810");
                                                                                Ext.getCmp('fecConsultaJovenPrimeraVez').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecConsultaJovenPrimeraVez').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecConsultaJovenPrimeraVez').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecConsultaJovenPrimeraVez').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecConsultaJovenPrimeraVez').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecConsultaJovenPrimeraVez').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecConsultaJovenPrimeraVez').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecConsultaJovenPrimeraVez').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Consulta Joven 1er Vez',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecConsultaJovenPrimeraVez'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Consulta Adulto 1er Vez',
                                                        name: 'Registro Consulta Adulto 1er Vez',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroConsultaAdulto1erVez',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecConsultaAdultoPrimeraVez').setValue("01/01/1845");
                                                                    Ext.getCmp('fecConsultaAdultoPrimeraVez').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecConsultaAdultoPrimeraVez').setValue("01/01/1800");
                                                                        Ext.getCmp('fecConsultaAdultoPrimeraVez').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecConsultaAdultoPrimeraVez').setValue("01/01/1805");
                                                                            Ext.getCmp('fecConsultaAdultoPrimeraVez').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecConsultaAdultoPrimeraVez').setValue("01/01/1810");
                                                                                Ext.getCmp('fecConsultaAdultoPrimeraVez').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecConsultaAdultoPrimeraVez').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecConsultaAdultoPrimeraVez').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecConsultaAdultoPrimeraVez').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecConsultaAdultoPrimeraVez').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecConsultaAdultoPrimeraVez').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecConsultaAdultoPrimeraVez').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecConsultaAdultoPrimeraVez').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Consulta Adulto 1er Vez',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecConsultaAdultoPrimeraVez'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Consulta CyD 1er Vez',
                                                        name: 'Registro Consulta CyD 1er Vez',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroConsultaCyD1erVez',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecConsultaCyDPrimeraVez').setValue("01/01/1845");
                                                                    Ext.getCmp('fecConsultaCyDPrimeraVez').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecConsultaCyDPrimeraVez').setValue("01/01/1800");
                                                                        Ext.getCmp('fecConsultaCyDPrimeraVez').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecConsultaCyDPrimeraVez').setValue("01/01/1805");
                                                                            Ext.getCmp('fecConsultaCyDPrimeraVez').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecConsultaCyDPrimeraVez').setValue("01/01/1810");
                                                                                Ext.getCmp('fecConsultaCyDPrimeraVez').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecConsultaCyDPrimeraVez').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecConsultaCyDPrimeraVez').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecConsultaCyDPrimeraVez').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecConsultaCyDPrimeraVez').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecConsultaCyDPrimeraVez').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecConsultaCyDPrimeraVez').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecConsultaCyDPrimeraVez').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Consulta CyD 1er Vez',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecConsultaCyDPrimeraVez'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Suministro Sulfato Ferroso Menor de 10 años',
                                                fieldLabel: 'Suministro Sulfato Ferroso Menor de 10 años',
                                                width: 350,
                                                allowBlank: false,
                                                store: stSuministroSulfatoFerroso,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 21,
                                                id: 'intSuministroSulfatoFerroso1ano'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Vitamina A Menor de 10 años',
                                                fieldLabel: 'Vitamina A Menor de 10 años',
                                                width: 350,
                                                allowBlank: false,
                                                store: stSuministroVitaminaA,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 21,
                                                id: 'intSuministroVitaminaA'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Preservativos Entregados ITS?',
                                                        name: 'Registro Preservativos Entregados ITS?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'SIN DATO',
                                                        id: 'sysRegistroPreservativosEntregadosITS',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('intPreservativosEntregadosITS').setValue(0);
                                                                    Ext.getCmp('intPreservativosEntregadosITS').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('intPreservativosEntregadosITS').setValue(999);
                                                                        Ext.getCmp('intPreservativosEntregadosITS').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('intPreservativosEntregadosITS').setValue(997);
                                                                            Ext.getCmp('intPreservativosEntregadosITS').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('intPreservativosEntregadosITS').setValue(996);
                                                                                Ext.getCmp('intPreservativosEntregadosITS').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('intPreservativosEntregadosITS').setValue(995);
                                                                                    Ext.getCmp('intPreservativosEntregadosITS').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('intPreservativosEntregadosITS').setValue(994);
                                                                                        Ext.getCmp('intPreservativosEntregadosITS').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('intPreservativosEntregadosITS').setValue(993);
                                                                                            Ext.getCmp('intPreservativosEntregadosITS').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('intPreservativosEntregadosITS').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Preservativos Entregados ITS',
                                                        width: 200,
                                                        maxValue: 999,
                                                        value: 999,
                                                        allowBlank: false,
                                                        id: 'intPreservativosEntregadosITS',
                                                        style: 'text-align:center;'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Asesoria PreTest VIH?',
                                                        name: 'Registro Asesoria PreTest VIH?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroAsesoriaPreTestVIH',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecAsesoriaPreTestVIH').setValue("01/01/1845");
                                                                    Ext.getCmp('fecAsesoriaPreTestVIH').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecAsesoriaPreTestVIH').setValue("01/01/1800");
                                                                        Ext.getCmp('fecAsesoriaPreTestVIH').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecAsesoriaPreTestVIH').setValue("01/01/1805");
                                                                            Ext.getCmp('fecAsesoriaPreTestVIH').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecAsesoriaPreTestVIH').setValue("01/01/1810");
                                                                                Ext.getCmp('fecAsesoriaPreTestVIH').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecAsesoriaPreTestVIH').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecAsesoriaPreTestVIH').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecAsesoriaPreTestVIH').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecAsesoriaPreTestVIH').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecAsesoriaPreTestVIH').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecAsesoriaPreTestVIH').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecAsesoriaPreTestVIH').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Asesoria PreTest VIH',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecAsesoriaPreTestVIH'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Asesoria PosTest VIH?',
                                                        name: 'Registro Asesoria PosTest VIH?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroAsesoriaPosTestVIH',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecAsesoriaPosTestVIH').setValue("01/01/1845");
                                                                    Ext.getCmp('fecAsesoriaPosTestVIH').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecAsesoriaPosTestVIH').setValue("01/01/1800");
                                                                        Ext.getCmp('fecAsesoriaPosTestVIH').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecAsesoriaPosTestVIH').setValue("01/01/1805");
                                                                            Ext.getCmp('fecAsesoriaPosTestVIH').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecAsesoriaPosTestVIH').setValue("01/01/1810");
                                                                                Ext.getCmp('fecAsesoriaPosTestVIH').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecAsesoriaPosTestVIH').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecAsesoriaPosTestVIH').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecAsesoriaPosTestVIH').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecAsesoriaPosTestVIH').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecAsesoriaPosTestVIH').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecAsesoriaPosTestVIH').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecAsesoriaPosTestVIH').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Asesoria PosTest VIH',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecAsesoriaPosTestVIH'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Enf Mental Tratamiento Ult 6 Meses',
                                                fieldLabel: 'Enf Mental Tratamiento Ult 6 Meses',
                                                width: 350,
                                                allowBlank: false,
                                                store: stTratamientoEnfermedadMental,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intEnfMentalTratamientoUlt6Meses'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'VICTIMA DE VIOLENCIA SEXUAL Y MALTRATO',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Mujer o Menor Victima Maltrato?',
                                                        name: 'Registro Mujer Victima Maltrato?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO APLICA",
                                                        id: 'sysRegistroMujerVictimaMaltrato',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecConsultaMujerVictimaMaltrato').setValue("01/01/1845");
                                                                    Ext.getCmp('fecConsultaMujerVictimaMaltrato').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecConsultaMujerVictimaMaltrato').setValue("01/01/1800");
                                                                        Ext.getCmp('fecConsultaMujerVictimaMaltrato').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecConsultaMujerVictimaMaltrato').setValue("01/01/1805");
                                                                            Ext.getCmp('fecConsultaMujerVictimaMaltrato').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecConsultaMujerVictimaMaltrato').setValue("01/01/1810");
                                                                                Ext.getCmp('fecConsultaMujerVictimaMaltrato').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecConsultaMujerVictimaMaltrato').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecConsultaMujerVictimaMaltrato').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecConsultaMujerVictimaMaltrato').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecConsultaMujerVictimaMaltrato').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecConsultaMujerVictimaMaltrato').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecConsultaMujerVictimaMaltrato').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecConsultaMujerVictimaMaltrato').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Consulta Mujer o Menor Victima Maltrato',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecConsultaMujerVictimaMaltrato'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Violencia Sexual?',
                                                        name: 'Registro Violencia Sexual?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: "NO APLICA",
                                                        id: 'sysRegistroViolenciaSexual',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecConsultaViolenciaSexual').setValue("01/01/1845");
                                                                    Ext.getCmp('fecConsultaViolenciaSexual').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecConsultaViolenciaSexual').setValue("01/01/1800");
                                                                        Ext.getCmp('fecConsultaViolenciaSexual').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecConsultaViolenciaSexual').setValue("01/01/1805");
                                                                            Ext.getCmp('fecConsultaViolenciaSexual').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecConsultaViolenciaSexual').setValue("01/01/1810");
                                                                                Ext.getCmp('fecConsultaViolenciaSexual').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecConsultaViolenciaSexual').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecConsultaViolenciaSexual').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecConsultaViolenciaSexual').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecConsultaViolenciaSexual').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecConsultaViolenciaSexual').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecConsultaViolenciaSexual').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecConsultaViolenciaSexual').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Consulta Violencia Sexual',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecConsultaViolenciaSexual'
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'PROGRAMA TAMIZACION CANCER CUELLO UTERINO',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'combo',
                                                name: 'Tamizaje Cancer Cuello Uterino',
                                                fieldLabel: 'Tamizaje Cancer Cuello Uterino',
                                                width: 350,
                                                allowBlank: false,
                                                store: stTamizajeCancerCuelloUterino,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intTamizajeCancerCuelloUterino'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Citologia?',
                                                        name: 'Registro Citologia?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroCitologia',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecTomaCitologia').setValue("01/01/1845");
                                                                    Ext.getCmp('fecTomaCitologia').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecTomaCitologia').setValue("01/01/1800");
                                                                        Ext.getCmp('fecTomaCitologia').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecTomaCitologia').setValue("01/01/1805");
                                                                            Ext.getCmp('fecTomaCitologia').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecTomaCitologia').setValue("01/01/1810");
                                                                                Ext.getCmp('fecTomaCitologia').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecTomaCitologia').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecTomaCitologia').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecTomaCitologia').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecTomaCitologia').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecTomaCitologia').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecTomaCitologia').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecTomaCitologia').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Citologia',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecTomaCitologia'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Resultado Citologia',
                                                fieldLabel: 'Resultado Citologia',
                                                width: 600,
                                                allowBlank: false,
                                                store: stResultadoCitologia,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intResultadoCitologia'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Calidad Muestra de la Citologia',
                                                fieldLabel: 'Calidad Muestra de la Citologia',
                                                width: 350,
                                                allowBlank: false,
                                                store: stCalidadMuestraCitologia,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intCalidadMuestraCitologia'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro IPS Toma Citologia?',
                                                        name: 'Registro IPS Toma Citologia?',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: stRegistroFechas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroIPSTomaCitologia',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('intCodIPSTomaCitologia').setValue(0);
                                                                    Ext.getCmp('intCodIPSTomaCitologia').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('intCodIPSTomaCitologia').setValue(999);
                                                                        Ext.getCmp('intCodIPSTomaCitologia').disable();
                                                                    }else{
                                                                        Ext.getCmp('intCodIPSTomaCitologia').enable();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Cod IPS Toma Citologia',
                                                        store: searchStoreREPSS,
                                                        allowBlank: false,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        typeAhead: false,
                                                        loadingText: 'Buscando...',
                                                        width: 490,
                                                        anchor: '100%',
                                                        hideTrigger: true,
                                                        minChars: 4,
                                                        emptyText:'Escriba el nombre del Prestador -- p.e: HOSPI',
                                                        id: 'intCodIPSTomaCitologia'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Toma Colposcopia?',
                                                        name: 'Registro Toma Colposcopia?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroTomaColposcopia',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecTomaColposcopia').setValue("01/01/1845");
                                                                    Ext.getCmp('fecTomaColposcopia').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecTomaColposcopia').setValue("01/01/1800");
                                                                        Ext.getCmp('fecTomaColposcopia').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecTomaColposcopia').setValue("01/01/1805");
                                                                            Ext.getCmp('fecTomaColposcopia').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecTomaColposcopia').setValue("01/01/1810");
                                                                                Ext.getCmp('fecTomaColposcopia').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecTomaColposcopia').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecTomaColposcopia').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecTomaColposcopia').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecTomaColposcopia').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecTomaColposcopia').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecTomaColposcopia').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecTomaColposcopia').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Toma Colposcopia',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecTomaColposcopia'
                                                    },
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro IPS Toma Colposcopia?',
                                                        name: 'Registro IPS Toma Colposcopia?',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: stRegistroFechas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroIPSTomaColposcopia',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('intCodIPSTomaColposcopia').setValue(0);
                                                                    Ext.getCmp('intCodIPSTomaColposcopia').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('intCodIPSTomaColposcopia').setValue(999);
                                                                        Ext.getCmp('intCodIPSTomaColposcopia').disable();
                                                                    }else{
                                                                        Ext.getCmp('intCodIPSTomaColposcopia').enable();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Cod IPS Toma Colposcopia',
                                                        store: searchStoreREPSS,
                                                        allowBlank: false,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        typeAhead: false,
                                                        loadingText: 'Buscando...',
                                                        width: 490,
                                                        anchor: '100%',
                                                        hideTrigger: true,
                                                        minChars: 4,
                                                        emptyText:'Escriba el nombre del Prestador -- p.e: HOSPI',
                                                        id: 'intCodIPSTomaColposcopia'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Biopsia Cervical?',
                                                        name: 'Registro Biopsia Cervical?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroBiopsiaCervical',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecBiopsiaCervical').setValue("01/01/1845");
                                                                    Ext.getCmp('fecBiopsiaCervical').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecBiopsiaCervical').setValue("01/01/1800");
                                                                        Ext.getCmp('fecBiopsiaCervical').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecBiopsiaCervical').setValue("01/01/1805");
                                                                            Ext.getCmp('fecBiopsiaCervical').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecBiopsiaCervical').setValue("01/01/1810");
                                                                                Ext.getCmp('fecBiopsiaCervical').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecBiopsiaCervical').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecBiopsiaCervical').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecBiopsiaCervical').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecBiopsiaCervical').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecBiopsiaCervical').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecBiopsiaCervical').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecBiopsiaCervical').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Biopsia Cervical',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecBiopsiaCervical'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Resultado Biopsia Cervical',
                                                fieldLabel: 'Resultado Biopsia Cervical',
                                                width: 350,
                                                allowBlank: false,
                                                store: stResultadoBiopsiaCervical,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intResultadoBiopsiaCervical'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro IPS Toma Biopsia Cervical?',
                                                        name: 'Registro IPS Toma Biopsia Cervical?',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: stRegistroFechas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroIPSTomaBiopsiaCervical',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('intCodIPSTomaBiopsiaCervical').setValue(0);
                                                                    Ext.getCmp('intCodIPSTomaBiopsiaCervical').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('intCodIPSTomaBiopsiaCervical').setValue(999);
                                                                        Ext.getCmp('intCodIPSTomaBiopsiaCervical').disable();
                                                                    }else{
                                                                        Ext.getCmp('intCodIPSTomaBiopsiaCervical').enable();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Cod IPS Toma Biopsia Cervical',
                                                        store: searchStoreREPSS,
                                                        allowBlank: false,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        typeAhead: false,
                                                        loadingText: 'Buscando...',
                                                        width: 490,
                                                        anchor: '100%',
                                                        hideTrigger: true,
                                                        minChars: 4,
                                                        emptyText:'Escriba el nombre del Prestador -- p.e: HOSPI',
                                                        id: 'intCodIPSTomaBiopsiaCervical'
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'PROGRAMA CANCER DE MAMA',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Mamografia?',
                                                        name: 'Registro Mamografia?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroMamografia',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecMamografia').setValue("01/01/1845");
                                                                    Ext.getCmp('fecMamografia').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecMamografia').setValue("01/01/1800");
                                                                        Ext.getCmp('fecMamografia').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecMamografia').setValue("01/01/1805");
                                                                            Ext.getCmp('fecMamografia').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecMamografia').setValue("01/01/1810");
                                                                                Ext.getCmp('fecMamografia').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecMamografia').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecMamografia').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecMamografia').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecMamografia').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecMamografia').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecMamografia').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecMamografia').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Mamografia',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecMamografia'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Resultado Mamografia',
                                                fieldLabel: 'Resultado Mamografia',
                                                width: 350,
                                                allowBlank: false,
                                                store: stResultadoMamografia,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intResultadoMamografia'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro IPS Toma Mamografia?',
                                                        name: 'Registro IPS Toma Mamografia?',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: stRegistroFechas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroIPSTomaMamografia',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('intCodIPSTomaMamografia').setValue(0);
                                                                    Ext.getCmp('intCodIPSTomaMamografia').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('intCodIPSTomaMamografia').setValue(999);
                                                                        Ext.getCmp('intCodIPSTomaMamografia').disable();
                                                                    }else{
                                                                        Ext.getCmp('intCodIPSTomaMamografia').enable();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Cod IPS Toma Mamografia',
                                                        store: searchStoreREPSS,
                                                        allowBlank: false,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        typeAhead: false,
                                                        loadingText: 'Buscando...',
                                                        width: 490,
                                                        anchor: '100%',
                                                        hideTrigger: true,
                                                        minChars: 4,
                                                        emptyText:'Escriba el nombre del Prestador -- p.e: HOSPI',
                                                        id: 'intCodIPSTomaMamografia'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Toma Biopsia Seno por BACAF?',
                                                        name: 'Registro Toma Biopsia Seno por BACAF?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroTomaBiopsiaSenoBACAF',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecTomaBiopsiaSenoBACAF').setValue("01/01/1845");
                                                                    Ext.getCmp('fecTomaBiopsiaSenoBACAF').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecTomaBiopsiaSenoBACAF').setValue("01/01/1800");
                                                                        Ext.getCmp('fecTomaBiopsiaSenoBACAF').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecTomaBiopsiaSenoBACAF').setValue("01/01/1805");
                                                                            Ext.getCmp('fecTomaBiopsiaSenoBACAF').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecTomaBiopsiaSenoBACAF').setValue("01/01/1810");
                                                                                Ext.getCmp('fecTomaBiopsiaSenoBACAF').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecTomaBiopsiaSenoBACAF').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecTomaBiopsiaSenoBACAF').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecTomaBiopsiaSenoBACAF').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecTomaBiopsiaSenoBACAF').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecTomaBiopsiaSenoBACAF').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecTomaBiopsiaSenoBACAF').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecTomaBiopsiaSenoBACAF').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Toma Biopsia Seno por BACAF',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecTomaBiopsiaSenoBACAF'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Resultado Biopsia Seno?',
                                                        name: 'Registro Resultado Biopsia Seno?',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: stRegistroFechas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroResultadoBiopsiaSeno',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecResultadoBiopsiaSeno').setValue("01/01/1845");
                                                                    Ext.getCmp('fecResultadoBiopsiaSeno').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecResultadoBiopsiaSeno').setValue("01/01/1800");
                                                                        Ext.getCmp('fecResultadoBiopsiaSeno').disable();
                                                                    }else{
                                                                        Ext.getCmp('fecResultadoBiopsiaSeno').enable();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Resultado Biopsia Seno',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecResultadoBiopsiaSeno'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Resultado Biopsia Seno',
                                                fieldLabel: 'Resultado Biopsia Seno',
                                                width: 350,
                                                allowBlank: false,
                                                store: stResultadoBiopsiaSeno,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intResultadoBiopsiaSeno'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro IPS Toma Biopsia Seno?',
                                                        name: 'Registro IPS Toma Biopsia Seno?',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: stRegistroFechas,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroIPSTomaBiopsiaSeno',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('intCodIPSTomaBiopsiaSeno').setValue(0);
                                                                    Ext.getCmp('intCodIPSTomaBiopsiaSeno').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('intCodIPSTomaBiopsiaSeno').setValue(999);
                                                                        Ext.getCmp('intCodIPSTomaBiopsiaSeno').disable();
                                                                    }else{
                                                                        Ext.getCmp('intCodIPSTomaBiopsiaSeno').enable();
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Cod IPS Toma Biopsia Seno',
                                                        store: searchStoreREPSS,
                                                        allowBlank: false,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        typeAhead: false,
                                                        loadingText: 'Buscando...',
                                                        width: 490,
                                                        anchor: '100%',
                                                        hideTrigger: true,
                                                        minChars: 4,
                                                        emptyText:'Escriba el nombre del Prestador -- p.e: HOSPI',
                                                        id: 'intCodIPSTomaBiopsiaSeno'
                                                    }
                                                ]
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'PARACLINICOS',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Toma Hemoglobina?',
                                                        name: 'Registro Toma Hemoglobina?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroTomaHemoglobina',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecTomaHemoglobina').setValue("01/01/1845");
                                                                    Ext.getCmp('fecTomaHemoglobina').disable();
                                                                    Ext.getCmp('intResultadoHemoglobina').setValue(0);
                                                                    Ext.getCmp('intResultadoHemoglobina').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecTomaHemoglobina').setValue("01/01/1800");
                                                                        Ext.getCmp('fecTomaHemoglobina').disable();
                                                                        Ext.getCmp('intResultadoHemoglobina').setValue(0);
                                                                        Ext.getCmp('intResultadoHemoglobina').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecTomaHemoglobina').setValue("01/01/1805");
                                                                            Ext.getCmp('fecTomaHemoglobina').disable();
                                                                            Ext.getCmp('intResultadoHemoglobina').setValue(0);
                                                                            Ext.getCmp('intResultadoHemoglobina').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecTomaHemoglobina').setValue("01/01/1810");
                                                                                Ext.getCmp('fecTomaHemoglobina').disable();
                                                                                Ext.getCmp('intResultadoHemoglobina').setValue(0);
                                                                                Ext.getCmp('intResultadoHemoglobina').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecTomaHemoglobina').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecTomaHemoglobina').disable();
                                                                                    Ext.getCmp('intResultadoHemoglobina').setValue(0);
                                                                                    Ext.getCmp('intResultadoHemoglobina').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecTomaHemoglobina').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecTomaHemoglobina').disable();
                                                                                        Ext.getCmp('intResultadoHemoglobina').setValue(0);
                                                                                        Ext.getCmp('intResultadoHemoglobina').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecTomaHemoglobina').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecTomaHemoglobina').disable();
                                                                                            Ext.getCmp('intResultadoHemoglobina').setValue(0);
                                                                                            Ext.getCmp('intResultadoHemoglobina').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecTomaHemoglobina').enable();
                                                                                            Ext.getCmp('intResultadoHemoglobina').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Toma Hemoglobina',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecTomaHemoglobina'
                                                    },
                                                    {
                                                        html: 'Resultado'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Resultado Hemoglobina',
                                                        width: 100,
                                                        maxValue: 20,
                                                        minValue: 0,
                                                        value: 0,
                                                        style: 'text-align:center;',
                                                        allowBlank: false,
                                                        id: 'intResultadoHemoglobina'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Toma Creatinina?',
                                                        name: 'Registro Toma Creatinina?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroTomaCreatinina',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecTomaCreatinina').setValue("01/01/1845");
                                                                    Ext.getCmp('fecTomaCreatinina').disable();
                                                                    Ext.getCmp('intResultadoCreatinina').setValue(0);
                                                                    Ext.getCmp('intResultadoCreatinina').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecTomaCreatinina').setValue("01/01/1800");
                                                                        Ext.getCmp('fecTomaCreatinina').disable();
                                                                        Ext.getCmp('intResultadoCreatinina').setValue(999);
                                                                        Ext.getCmp('intResultadoCreatinina').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecTomaCreatinina').setValue("01/01/1805");
                                                                            Ext.getCmp('fecTomaCreatinina').disable();
                                                                            Ext.getCmp('intResultadoCreatinina').setValue(0);
                                                                            Ext.getCmp('intResultadoCreatinina').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecTomaCreatinina').setValue("01/01/1810");
                                                                                Ext.getCmp('fecTomaCreatinina').disable();
                                                                                Ext.getCmp('intResultadoCreatinina').setValue(0);
                                                                                Ext.getCmp('intResultadoCreatinina').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecTomaCreatinina').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecTomaCreatinina').disable();
                                                                                    Ext.getCmp('intResultadoCreatinina').setValue(0);
                                                                                    Ext.getCmp('intResultadoCreatinina').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecTomaCreatinina').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecTomaCreatinina').disable();
                                                                                        Ext.getCmp('intResultadoCreatinina').setValue(0);
                                                                                        Ext.getCmp('intResultadoCreatinina').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecTomaCreatinina').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecTomaCreatinina').disable();
                                                                                            Ext.getCmp('intResultadoCreatinina').setValue(0);
                                                                                            Ext.getCmp('intResultadoCreatinina').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecTomaCreatinina').enable();
                                                                                            Ext.getCmp('intResultadoCreatinina').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Toma Creatinina',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecTomaCreatinina'
                                                    },
                                                    {
                                                        html: 'Resultado'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Resultado Creatinina',
                                                        width: 100,
                                                        maxValue: 999,
                                                        minValue: 0,
                                                        value: 0,
                                                        style: 'text-align:center;',
                                                        allowBlank: false,
                                                        id: 'intResultadoCreatinina'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Toma Hemoglobina Glicosilada?',
                                                        name: 'Registro Toma Hemoglobina Glicosilada?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroTomaHemoglobinaGlicosilada',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecTomaHemoglobinaGlicosilada').setValue("01/01/1845");
                                                                    Ext.getCmp('fecTomaHemoglobinaGlicosilada').disable();
                                                                    Ext.getCmp('intResultadoHemoglobinaGlicosilada').setValue(0);
                                                                    Ext.getCmp('intResultadoHemoglobinaGlicosilada').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecTomaHemoglobinaGlicosilada').setValue("01/01/1800");
                                                                        Ext.getCmp('fecTomaHemoglobinaGlicosilada').disable();
                                                                        Ext.getCmp('intResultadoHemoglobinaGlicosilada').setValue(999);
                                                                        Ext.getCmp('intResultadoHemoglobinaGlicosilada').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecTomaHemoglobinaGlicosilada').setValue("01/01/1805");
                                                                            Ext.getCmp('fecTomaHemoglobinaGlicosilada').disable();
                                                                            Ext.getCmp('intResultadoHemoglobinaGlicosilada').setValue(0);
                                                                            Ext.getCmp('intResultadoHemoglobinaGlicosilada').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecTomaHemoglobinaGlicosilada').setValue("01/01/1810");
                                                                                Ext.getCmp('fecTomaHemoglobinaGlicosilada').disable();
                                                                                Ext.getCmp('intResultadoHemoglobinaGlicosilada').setValue(0);
                                                                                Ext.getCmp('intResultadoHemoglobinaGlicosilada').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecTomaHemoglobinaGlicosilada').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecTomaHemoglobinaGlicosilada').disable();
                                                                                    Ext.getCmp('intResultadoHemoglobinaGlicosilada').setValue(0);
                                                                                    Ext.getCmp('intResultadoHemoglobinaGlicosilada').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecTomaHemoglobinaGlicosilada').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecTomaHemoglobinaGlicosilada').disable();
                                                                                        Ext.getCmp('intResultadoHemoglobinaGlicosilada').setValue(0);
                                                                                        Ext.getCmp('intResultadoHemoglobinaGlicosilada').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecTomaHemoglobinaGlicosilada').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecTomaHemoglobinaGlicosilada').disable();
                                                                                            Ext.getCmp('intResultadoHemoglobinaGlicosilada').setValue(0);
                                                                                            Ext.getCmp('intResultadoHemoglobinaGlicosilada').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecTomaHemoglobinaGlicosilada').enable();
                                                                                            Ext.getCmp('intResultadoHemoglobinaGlicosilada').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Toma Hemoglobina Glicosilada',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecTomaHemoglobinaGlicosilada'
                                                    },
                                                    {
                                                        html: 'Resultado'
                                                    },
                                                    {
                                                        xtype: 'numberfield',
                                                        name: 'Resultado Hemoglobina Glicosilada',
                                                        width: 100,
                                                        maxValue: 999,
                                                        minValue: 0,
                                                        value: 0,
                                                        style: 'text-align:center;',
                                                        allowBlank: false,
                                                        id: 'intResultadoHemoglobinaGlicosilada'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Toma Glicemia?',
                                                        name: 'Registro Toma Glicemia?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroTomaGlicemia',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecTomaGlicemia').setValue("01/01/1845");
                                                                    Ext.getCmp('fecTomaGlicemia').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecTomaGlicemia').setValue("01/01/1800");
                                                                        Ext.getCmp('fecTomaGlicemia').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecTomaGlicemia').setValue("01/01/1805");
                                                                            Ext.getCmp('fecTomaGlicemia').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecTomaGlicemia').setValue("01/01/1810");
                                                                                Ext.getCmp('fecTomaGlicemia').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecTomaGlicemia').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecTomaGlicemia').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecTomaGlicemia').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecTomaGlicemia').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecTomaGlicemia').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecTomaGlicemia').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecTomaGlicemia').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Toma Glicemia',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecTomaGlicemia'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Toma Microalbuminuria?',
                                                        name: 'Registro Toma Microalbuminuria?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroTomaMicroalbuminuria',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecTomaMicroalbuminuria').setValue("01/01/1845");
                                                                    Ext.getCmp('fecTomaMicroalbuminuria').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecTomaMicroalbuminuria').setValue("01/01/1800");
                                                                        Ext.getCmp('fecTomaMicroalbuminuria').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecTomaMicroalbuminuria').setValue("01/01/1805");
                                                                            Ext.getCmp('fecTomaMicroalbuminuria').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecTomaMicroalbuminuria').setValue("01/01/1810");
                                                                                Ext.getCmp('fecTomaMicroalbuminuria').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecTomaMicroalbuminuria').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecTomaMicroalbuminuria').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecTomaMicroalbuminuria').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecTomaMicroalbuminuria').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecTomaMicroalbuminuria').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecTomaMicroalbuminuria').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecTomaMicroalbuminuria').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Toma Microalbuminuria',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecTomaMicroalbuminuria'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Toma HDL?',
                                                        name: 'Registro Toma HDL?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroTomaHDL',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecTomaHDL').setValue("01/01/1845");
                                                                    Ext.getCmp('fecTomaHDL').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecTomaHDL').setValue("01/01/1800");
                                                                        Ext.getCmp('fecTomaHDL').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecTomaHDL').setValue("01/01/1805");
                                                                            Ext.getCmp('fecTomaHDL').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecTomaHDL').setValue("01/01/1810");
                                                                                Ext.getCmp('fecTomaHDL').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecTomaHDL').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecTomaHDL').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecTomaHDL').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecTomaHDL').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecTomaHDL').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecTomaHDL').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecTomaHDL').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Toma HDL',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecTomaHDL'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Toma Baciloscopia?',
                                                        name: 'Registro Toma Baciloscopia?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroTomaBaciloscopia',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecTomaBaciloscopiaDiagnostica').setValue("01/01/1845");
                                                                    Ext.getCmp('fecTomaBaciloscopiaDiagnostica').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecTomaBaciloscopiaDiagnostica').setValue("01/01/1800");
                                                                        Ext.getCmp('fecTomaBaciloscopiaDiagnostica').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecTomaBaciloscopiaDiagnostica').setValue("01/01/1805");
                                                                            Ext.getCmp('fecTomaBaciloscopiaDiagnostica').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecTomaBaciloscopiaDiagnostica').setValue("01/01/1810");
                                                                                Ext.getCmp('fecTomaBaciloscopiaDiagnostica').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecTomaBaciloscopiaDiagnostica').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecTomaBaciloscopiaDiagnostica').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecTomaBaciloscopiaDiagnostica').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecTomaBaciloscopiaDiagnostica').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecTomaBaciloscopiaDiagnostica').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecTomaBaciloscopiaDiagnostica').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecTomaBaciloscopiaDiagnostica').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Toma Baciloscopia Diagnostica',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecTomaBaciloscopiaDiagnostica'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Resultado Baciloscopia Diagnostica',
                                                fieldLabel: 'Resultado Baciloscopia Diagnostica',
                                                width: 350,
                                                allowBlank: false,
                                                store: stResultadoBaciloscopiaDiagnostica,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 4,
                                                id: 'intResultadoBaciloscopiaDiagnostica'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Toma Serologia?',
                                                        name: 'Registro Toma Serologia?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroTomaSerologia',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecSerologia').setValue("01/01/1845");
                                                                    Ext.getCmp('fecSerologia').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecSerologia').setValue("01/01/1800");
                                                                        Ext.getCmp('fecSerologia').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecSerologia').setValue("01/01/1805");
                                                                            Ext.getCmp('fecSerologia').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecSerologia').setValue("01/01/1810");
                                                                                Ext.getCmp('fecSerologia').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecSerologia').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecSerologia').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecSerologia').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecSerologia').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecSerologia').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecSerologia').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecSerologia').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Serologia',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecSerologia'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Resultado Serologia',
                                                fieldLabel: 'Resultado Serologia',
                                                width: 350,
                                                allowBlank: false,
                                                store: stResultadoAntigenoHepatitisB,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intResultadoSerologia'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Toma Elisa VIH?',
                                                        name: 'Registro Toma Elisa VIH?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroTomaElisaVIH',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecTomaElisaVIH').setValue("01/01/1845");
                                                                    Ext.getCmp('fecTomaElisaVIH').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecTomaElisaVIH').setValue("01/01/1800");
                                                                        Ext.getCmp('fecTomaElisaVIH').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecTomaElisaVIH').setValue("01/01/1805");
                                                                            Ext.getCmp('fecTomaElisaVIH').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecTomaElisaVIH').setValue("01/01/1810");
                                                                                Ext.getCmp('fecTomaElisaVIH').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecTomaElisaVIH').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecTomaElisaVIH').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecTomaElisaVIH').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecTomaElisaVIH').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecTomaElisaVIH').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecTomaElisaVIH').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecTomaElisaVIH').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Toma Elisa VIH',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecTomaElisaVIH'
                                                    },
                                                    {
                                                        html:'Resultado'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Resultado Elisa VIH',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: stResultadoAntigenoHepatitisB,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 0,
                                                        id: 'intResultadoElisaVIH'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro TSH Neonatal?',
                                                        name: 'Registro TSH Neonatal?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroTSHNeonatal',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecTSHNeonatal').setValue("01/01/1845");
                                                                    Ext.getCmp('fecTSHNeonatal').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecTSHNeonatal').setValue("01/01/1800");
                                                                        Ext.getCmp('fecTSHNeonatal').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecTSHNeonatal').setValue("01/01/1805");
                                                                            Ext.getCmp('fecTSHNeonatal').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecTSHNeonatal').setValue("01/01/1810");
                                                                                Ext.getCmp('fecTSHNeonatal').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecTSHNeonatal').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecTSHNeonatal').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecTSHNeonatal').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecTSHNeonatal').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecTSHNeonatal').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecTSHNeonatal').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecTSHNeonatal').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha TSH Neonatal',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecTSHNeonatal'
                                                    },
                                                    {
                                                        html:'Resultado'
                                                    },
                                                    {
                                                        xtype: 'combo',
                                                        name: 'Resultado TSH Neonatal',
                                                        width: 100,
                                                        allowBlank: false,
                                                        store: stTSHNeonatal,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 0,
                                                        id: 'intResultadoTSHNeonatal'
                                                    }
                                                ]
                                            },
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'OTROS TRATAMIENTOS',
                                        layout: 'form',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        anchor: '100%',
                                        autoHeight: true,
                                        padding: 7,
                                        items: [
                                            {
                                                xtype: 'combo',
                                                name: 'Tratamiento Hipotiroidismo Congenito',
                                                fieldLabel: 'Tratamiento Hipotiroidismo Congenito',
                                                width: 350,
                                                allowBlank: false,
                                                store: stTratamientoHipotiroidismoCongenito,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intTratamientoHipotiroidismoCongenito'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Tratamiento Sifilis Gestacional',
                                                fieldLabel: 'Tratamiento Sifilis Gestacional',
                                                width: 350,
                                                allowBlank: false,
                                                store: stTratamientoSifilisGestacional,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intTratamientoSifilisGestacional'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Tratamiento Sifilis Congenita',
                                                fieldLabel: 'Tratamiento Sifilis Congenita',
                                                width: 350,
                                                allowBlank: false,
                                                store: stTratamientoSifilisCongenita,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intTratamientoSifilisCongenita'
                                            },
                                            {
                                                xtype: 'combo',
                                                name: 'Tratamiento para Lepra',
                                                fieldLabel: 'Tratamiento para Lepra',
                                                width: 350,
                                                allowBlank: false,
                                                store: stTratamientoLepra,
                                                valueField: 'Codigo',
                                                displayField: 'Descripcion',
                                                mode: 'local',
                                                forceSelection: true,
                                                typeAhead: true,
                                                typeAheadDelay: 10,
                                                triggerAction: 'all',
                                                value: 0,
                                                id: 'intTratamientoLepra'
                                            },
                                            {
                                                xtype: 'compositefield',
                                                style: 'background:transparent;',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Registro Terminacion Tto Leishmaniasis?',
                                                        name: 'Registro Terminacion Tto Leishmaniasis?',
                                                        width: 350,
                                                        allowBlank: false,
                                                        store: stRegistroFechasAdicional,
                                                        valueField: 'Descripcion',
                                                        displayField: 'Descripcion',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        triggerAction: 'all',
                                                        value: 'NO APLICA',
                                                        id: 'sysRegistroTerminacionTtoLeishmaniasis',
                                                        listeners:{
                                                            change : function( t, newValue, oldValue){
                                                                if(newValue == "NO APLICA"){
                                                                    Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').setValue("01/01/1845");
                                                                    Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').disable();
                                                                }else{
                                                                    if(newValue == "SIN DATO"){
                                                                        Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').setValue("01/01/1800");
                                                                        Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').disable();
                                                                    }else{
                                                                        if(newValue == "NO SE REALIZA POR TRADICIONES"){
                                                                            Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').setValue("01/01/1805");
                                                                            Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').disable();
                                                                        }else{
                                                                            if(newValue == "NO SE REALIZA POR CONDICIONES DE SALUD"){
                                                                                Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').setValue("01/01/1810");
                                                                                Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').disable();
                                                                            }else{
                                                                                if(newValue == "NO SE REALIZA POR NEGACION DEL USUARIO"){
                                                                                    Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').setValue("01/01/1825");
                                                                                    Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').disable();
                                                                                }else{
                                                                                    if(newValue == "NO SE REALIZA POR DATOS DEL USUARIO DESACTUALIZADOS"){
                                                                                        Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').setValue("01/01/1830");
                                                                                        Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').disable();
                                                                                    }else{
                                                                                        if(newValue == "NO SE REALIZA POR OTRAS RAZONES"){
                                                                                            Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').setValue("01/01/1835");
                                                                                            Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').disable();
                                                                                        }else{
                                                                                            Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').enable();
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    },
                                                    {
                                                        xtype: 'datefield',
                                                        width: 200,
                                                        name: 'Fecha Terminacion Tratamiento Leishmaniasis',
                                                        allowBlank: false,
                                                        emptyText: '(dia/mes/año) ',
                                                        value: '01/01/1845',
                                                        style: 'text-align:center;',
                                                        id: 'fecTerminacionTratamientoLeishmaniasis'
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar Seguimiento',
                            iconCls: 'btnGuardar',
                            id: 'btnGuardarSeguimiento',
                            listeners:{
                                click : function(){
                                if(Ext.getCmp('sysId4505').getValue() != "" && Ext.getCmp('sysConsecutivoRegistro').getValue() != ""){
                                    modificarDatosRegistro()
                                }else{
                                    guardarDatosRegistro()
                                }
                            }
                        }
                    }
                ]
            }
        }];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    //Predefinir Comportamiento Campos
                    calculoEdadPacienteMeses()
                    //VALIDACIONES INICIALES CARGUE
                    if(Ext.getCmp('sysGenero').getValue() == "M" || MesesCumplidos <= 120){
                        Ext.getCmp('intGestacion').setValue(0);
                        Ext.getCmp('intGestacion').disable();
                        Ext.getCmp('intSuministroAcidoFolico').setValue(0);
                        Ext.getCmp('intSuministroAcidoFolico').disable();
                        Ext.getCmp('intSuministroSulfatoFerroso').setValue(0);
                        Ext.getCmp('intSuministroSulfatoFerroso').disable();
                        Ext.getCmp('intSuministroCarbonatoCalcio').setValue(0);
                        Ext.getCmp('intSuministroCarbonatoCalcio').disable();
                        Ext.getCmp('sysRegistroFPP').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroFPP').disable();
                        Ext.getCmp('fecProbableParto').setValue("1845-01-01");
                        Ext.getCmp('fecProbableParto').disable();
                        Ext.getCmp('sysRegistroFechaAtencionParto').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroFechaAtencionParto').disable();
                        Ext.getCmp('fecAtencionParto').setValue("1845-01-01");
                        Ext.getCmp('fecAtencionParto').disable();
                        Ext.getCmp('sysRegistroSalidaAtencionParto').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroSalidaAtencionParto').disable();
                        Ext.getCmp('fecSalidaAtencionParto').setValue("1845-01-01");
                        Ext.getCmp('fecSalidaAtencionParto').disable();
                        Ext.getCmp('intHipertencionGestacional').setValue(0);
                        Ext.getCmp('intHipertencionGestacional').disable();
                        Ext.getCmp('sysRegistroFechaConcejeriaLactancia').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroFechaConcejeriaLactancia').disable();
                        Ext.getCmp('fecConcejeriaLactancia').setValue("1845-01-01");
                        Ext.getCmp('fecConcejeriaLactancia').disable();
                        Ext.getCmp('sysRegistroControlPrenatalPrimeraVez').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroControlPrenatalPrimeraVez').disable();
                        Ext.getCmp('fecControlPrenatalPrimeraVez').setValue("1845-01-01");
                        Ext.getCmp('fecControlPrenatalPrimeraVez').disable();
                        Ext.getCmp('sysRegistroControlPrenatal').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroControlPrenatal').disable();
                        Ext.getCmp('intControlPrenatal').setValue(0);
                        Ext.getCmp('intControlPrenatal').disable();
                        Ext.getCmp('sysRegistroUltimoControlPrenatal').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroUltimoControlPrenatal').disable();
                        Ext.getCmp('fecUltimoControlPrenatal').setValue("1845-01-01");
                        Ext.getCmp('fecUltimoControlPrenatal').disable();
                        Ext.getCmp('intResultadoAntigenoHepatitisB').disable();
                        Ext.getCmp('fecAntigenoHepatitisB').disable();
                        Ext.getCmp('sysRegistroFechaAntigenoHepatitisB').disable();
                        Ext.getCmp('sysRegistroFechaAntigenoHepatitisB').setValue("NO APLICA");
                        Ext.getCmp('fecAntigenoHepatitisB').setValue("1845-01-01");
                        Ext.getCmp('intResultadoAntigenoHepatitisB').setValue(0);
                        Ext.getCmp('intTamizajeCancerCuelloUterino').setValue(0);
                        Ext.getCmp('intTamizajeCancerCuelloUterino').disable();
                        Ext.getCmp('sysRegistroCitologia').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroCitologia').disable();
                        Ext.getCmp('fecTomaCitologia').setValue("1845-01-01");
                        Ext.getCmp('fecTomaCitologia').disable();
                        Ext.getCmp('intResultadoCitologia').setValue(0);
                        Ext.getCmp('intResultadoCitologia').disable();
                        Ext.getCmp('intCalidadMuestraCitologia').setValue(0);
                        Ext.getCmp('intCalidadMuestraCitologia').disable();
                        Ext.getCmp('sysRegistroIPSTomaCitologia').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroIPSTomaCitologia').disable();
                        Ext.getCmp('intCodIPSTomaCitologia').setValue(0);
                        Ext.getCmp('intCodIPSTomaCitologia').disable();
                        Ext.getCmp('sysRegistroTomaColposcopia').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroTomaColposcopia').disable();
                        Ext.getCmp('fecTomaColposcopia').setValue("1845-01-01");
                        Ext.getCmp('fecTomaColposcopia').disable();
                        Ext.getCmp('sysRegistroIPSTomaColposcopia').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroIPSTomaColposcopia').disable();
                        Ext.getCmp('intCodIPSTomaColposcopia').setValue(0);
                        Ext.getCmp('intCodIPSTomaColposcopia').disable();
                        Ext.getCmp('sysRegistroBiopsiaCervical').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroBiopsiaCervical').disable();
                        Ext.getCmp('fecBiopsiaCervical').setValue("1845-01-01");
                        Ext.getCmp('fecBiopsiaCervical').disable();
                        Ext.getCmp('intResultadoBiopsiaCervical').setValue(0);
                        Ext.getCmp('intResultadoBiopsiaCervical').disable();
                        Ext.getCmp('sysRegistroIPSTomaBiopsiaCervical').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroIPSTomaBiopsiaCervical').disable();
                        Ext.getCmp('intCodIPSTomaBiopsiaCervical').setValue(0);
                        Ext.getCmp('intCodIPSTomaBiopsiaCervical').disable();
                        Ext.getCmp('sysRegistroMamografia').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroMamografia').disable();
                        Ext.getCmp('fecMamografia').setValue("1845-01-01");
                        Ext.getCmp('fecMamografia').disable();
                        Ext.getCmp('intResultadoMamografia').setValue(0);
                        Ext.getCmp('intResultadoMamografia').disable();
                        Ext.getCmp('sysRegistroIPSTomaMamografia').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroIPSTomaMamografia').disable();
                        Ext.getCmp('intCodIPSTomaMamografia').setValue(0);
                        Ext.getCmp('intCodIPSTomaMamografia').disable();
                        Ext.getCmp('sysRegistroTomaBiopsiaSenoBACAF').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroTomaBiopsiaSenoBACAF').disable();
                        Ext.getCmp('fecTomaBiopsiaSenoBACAF').setValue("1845-01-01");
                        Ext.getCmp('fecTomaBiopsiaSenoBACAF').disable();
                        Ext.getCmp('sysRegistroResultadoBiopsiaSeno').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroResultadoBiopsiaSeno').disable();
                        Ext.getCmp('fecResultadoBiopsiaSeno').setValue("1845-01-01");
                        Ext.getCmp('fecResultadoBiopsiaSeno').disable();
                        Ext.getCmp('intResultadoBiopsiaSeno').setValue(0);
                        Ext.getCmp('intResultadoBiopsiaSeno').disable();
                        Ext.getCmp('sysRegistroIPSTomaBiopsiaSeno').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroIPSTomaBiopsiaSeno').disable();
                        Ext.getCmp('intCodIPSTomaBiopsiaSeno').setValue(0);
                        Ext.getCmp('intCodIPSTomaBiopsiaSeno').disable();
                    }
                    if(Ext.getCmp('sysGenero').getValue() == "M" && MesesCumplidos >= 216){
                        Ext.getCmp('intVictimaMaltrato').setValue(0);
                        Ext.getCmp('intVictimaMaltrato').disable();
                    }
                    if(Ext.getCmp('sysGenero').getValue() == "M"){
                        Ext.getCmp('intCancerCervix').setValue(0);
                        Ext.getCmp('intCancerCervix').disable();
                        Ext.getCmp('intVPH').setValue(0);
                        Ext.getCmp('intVPH').disable();
                        Ext.getCmp('intTD').setValue(0);
                        Ext.getCmp('intTD').disable();
                    }
                    if(Ext.getCmp('sysGenero').getValue() == "M"){
                        Ext.getCmp('intSifilisGestacional').setValue(0);
                        Ext.getCmp('intSifilisGestacional').disable();
                    }else{
                        if(MesesCumplidos <= 16){
                            Ext.getCmp('intSifilisGestacional').setValue(0);
                            Ext.getCmp('intSifilisGestacional').disable();
                        }
                    }
                    if(MesesCumplidos >= 120){
                        Ext.getCmp('sysRegistroConsultaCyD1erVez').setValue("NO");
                        Ext.getCmp('sysRegistroConsultaCyD1erVez').disable();
                        Ext.getCmp('fecConsultaCyDPrimeraVez').setValue("1845-01-01");
                        Ext.getCmp('fecConsultaCyDPrimeraVez').disable();
                        Ext.getCmp('intSuministroSulfatoFerroso1ano').setValue(0);
                        Ext.getCmp('intSuministroSulfatoFerroso1ano').disable();
                        Ext.getCmp('intSuministroVitaminaA').setValue(0);
                        Ext.getCmp('intSuministroVitaminaA').disable();
                    }
                    if(MesesCumplidos >= 36){
                        Ext.getCmp('intHipotiroidismoCongenito').setValue(0);
                        Ext.getCmp('intHipotiroidismoCongenito').disable();
                        Ext.getCmp('intNeumococo').setValue(0);
                        Ext.getCmp('intNeumococo').disable();
                        Ext.getCmp('intInfluenza').setValue(0);
                        Ext.getCmp('intInfluenza').disable();
                    }
                    if(MesesCumplidos <= 216){
                        Ext.getCmp('intObesidadDesnutricion').setValue(3);
                        Ext.getCmp('intObesidadDesnutricion').disable();
                    }
                    if(MesesCumplidos >= 12){
                        Ext.getCmp('intHepatitisB').setValue(0);
                        Ext.getCmp('intHepatitisB').disable();
                        Ext.getCmp('intFiebreAmarilla').setValue(0);
                        Ext.getCmp('intFiebreAmarilla').disable();
                    }
                    if(MesesCumplidos >= 25){
                        Ext.getCmp('intPentavalente').setValue(0);
                        Ext.getCmp('intPentavalente').disable();
                        Ext.getCmp('intHepatitisA').setValue(0);
                        Ext.getCmp('intHepatitisA').disable();
                    }
                    if(MesesCumplidos >= 8){
                        Ext.getCmp('intRotavirus').setValue(0);
                        Ext.getCmp('intRotavirus').disable();
                    }
                    if(MesesCumplidos >= 2){
                        Ext.getCmp('sysRegistroFechaControlRecienNacido').setValue("NO APLICA");
                        Ext.getCmp('sysRegistroFechaControlRecienNacido').disable();
                        Ext.getCmp('fecControlRecienNacido').setValue("1845-01-01");
                        Ext.getCmp('fecControlRecienNacido').disable();
                        Ext.getCmp('sysRegistroTSHNeonatal').setValue("NO");
                        Ext.getCmp('sysRegistroTSHNeonatal').disable();
                        Ext.getCmp('fecTSHNeonatal').setValue("1845-01-01");
                        Ext.getCmp('fecTSHNeonatal').disable();
                        Ext.getCmp('intResultadoTSHNeonatal').setValue(0);
                        Ext.getCmp('intResultadoTSHNeonatal').disable();
                    }
                    if(MesesCumplidos >= 83){
                        Ext.getCmp('intPolio').setValue(0);
                        Ext.getCmp('intPolio').disable();
                        Ext.getCmp('intDPT').setValue(0);
                        Ext.getCmp('intDPT').disable();
                        Ext.getCmp('intBCG').setValue(0);
                        Ext.getCmp('intBCG').disable();
                        Ext.getCmp('intTripleViral').setValue(0);
                        Ext.getCmp('intTripleViral').disable();
                        Ext.getCmp('sysRegistroEdadGestacionalNacer').setValue("NO APLICA");
                        Ext.getCmp('intEdadGestacionalNacer').setValue(0);
                        Ext.getCmp('intEdadGestacionalNacer').disable();
                    }
                    if(Ext.getCmp('sysGenero').getValue() == "F" && Ext.getCmp('intGestacion').getValue() != 1){
                        Ext.getCmp('sysRegistroFPP').setValue("NO");
                        Ext.getCmp('sysRegistroFPP').disable();
                        Ext.getCmp('fecProbableParto').setValue("1845-01-01");
                        Ext.getCmp('fecProbableParto').disable();
                        Ext.getCmp('sysRegistroFechaAtencionParto').setValue("NO");
                        Ext.getCmp('sysRegistroFechaAtencionParto').disable();
                        Ext.getCmp('fecAtencionParto').setValue("1845-01-01");
                        Ext.getCmp('fecAtencionParto').disable();
                        Ext.getCmp('sysRegistroSalidaAtencionParto').setValue("NO");
                        Ext.getCmp('sysRegistroSalidaAtencionParto').disable();
                        Ext.getCmp('fecSalidaAtencionParto').setValue("1845-01-01");
                        Ext.getCmp('fecSalidaAtencionParto').disable();
                        Ext.getCmp('intHipertencionGestacional').setValue(0);
                        Ext.getCmp('intHipertencionGestacional').disable();
                        Ext.getCmp('sysRegistroFechaConcejeriaLactancia').setValue("NO");
                        Ext.getCmp('sysRegistroFechaConcejeriaLactancia').disable();
                        Ext.getCmp('fecConcejeriaLactancia').setValue("1845-01-01");
                        Ext.getCmp('fecConcejeriaLactancia').disable();
                        Ext.getCmp('sysRegistroControlPrenatalPrimeraVez').setValue("NO");
                        Ext.getCmp('sysRegistroControlPrenatalPrimeraVez').disable();
                        Ext.getCmp('fecControlPrenatalPrimeraVez').setValue("1845-01-01");
                        Ext.getCmp('fecControlPrenatalPrimeraVez').disable();
                        Ext.getCmp('sysRegistroControlPrenatal').setValue("NO");
                        Ext.getCmp('sysRegistroControlPrenatal').disable();
                        Ext.getCmp('intControlPrenatal').setValue(0);
                        Ext.getCmp('intControlPrenatal').disable();
                        Ext.getCmp('sysRegistroUltimoControlPrenatal').setValue("NO");
                        Ext.getCmp('sysRegistroUltimoControlPrenatal').disable();
                        Ext.getCmp('fecUltimoControlPrenatal').setValue("1845-01-01");
                        Ext.getCmp('fecUltimoControlPrenatal').disable();
                        Ext.getCmp('intResultadoAntigenoHepatitisB').disable();
                        Ext.getCmp('fecAntigenoHepatitisB').disable();
                        Ext.getCmp('sysRegistroFechaAntigenoHepatitisB').disable();
                        Ext.getCmp('sysRegistroFechaAntigenoHepatitisB').setValue("NO");
                        Ext.getCmp('fecAntigenoHepatitisB').setValue("1845-01-01");
                        Ext.getCmp('intResultadoAntigenoHepatitisB').setValue(0);
                        Ext.getCmp('intSuministroAcidoFolico').setValue(0);
                        Ext.getCmp('intSuministroAcidoFolico').disable();
                        Ext.getCmp('intSuministroSulfatoFerroso').setValue(0);
                        Ext.getCmp('intSuministroSulfatoFerroso').disable();
                        Ext.getCmp('intSuministroCarbonatoCalcio').setValue(0);
                        Ext.getCmp('intSuministroCarbonatoCalcio').disable();
                    }
                    if(Ext.getCmp('intSifilisGestacional').getValue() == 1){
                        Ext.getCmp('intTratamientoSifilisGestacional').enable();
                        Ext.getCmp('intTratamientoSifilisCongenita').disable();
                    }else{
                        if(Ext.getCmp('intSifilisGestacional').getValue() == 2){
                            Ext.getCmp('intTratamientoSifilisGestacional').disable();
                            Ext.getCmp('intTratamientoSifilisCongenita').enable();
                        }else{
                            Ext.getCmp('intTratamientoSifilisGestacional').setValue(0);
                            Ext.getCmp('intTratamientoSifilisCongenita').setValue(0);
                            Ext.getCmp('intTratamientoSifilisGestacional').disable();
                            Ext.getCmp('intTratamientoSifilisCongenita').disable();
                        }
                    }
                    if(Ext.getCmp('intHipotiroidismoCongenito').getValue() == 1){
                        Ext.getCmp('intTratamientoHipotiroidismoCongenito').enable();
                    }else{
                        Ext.getCmp('intTratamientoHipotiroidismoCongenito').setValue(0);
                        Ext.getCmp('intTratamientoHipotiroidismoCongenito').disable();
                    }
                    if(Ext.getCmp('intViolenciaSexual').getValue() != 1){
                        Ext.getCmp('sysRegistroViolenciaSexual').setValue("NO APLICA");
                        Ext.getCmp('fecConsultaViolenciaSexual').setValue("1845-01-01");
                        Ext.getCmp('sysRegistroViolenciaSexual').disable();
                        Ext.getCmp('fecConsultaViolenciaSexual').disable();
                    }
                    if(Ext.getCmp('intVictimaMaltrato').getValue() == 0){
                        Ext.getCmp('sysRegistroMujerVictimaMaltrato').disable();
                        Ext.getCmp('fecConsultaMujerVictimaMaltrato').disable();
                    }else{
                        if(Ext.getCmp('intVictimaMaltrato').getValue() == 21){
                            Ext.getCmp('sysRegistroMujerVictimaMaltrato').disable();
                            Ext.getCmp('fecConsultaMujerVictimaMaltrato').disable();
                        }else{
                            if(Ext.getCmp('intVictimaMaltrato').getValue() == 3){
                                Ext.getCmp('sysRegistroMujerVictimaMaltrato').disable();
                                Ext.getCmp('fecConsultaMujerVictimaMaltrato').disable();
                            }
                        }
                    }
                    if(Ext.getCmp('intObesidadDesnutricion').getValue() != 2){
                        Ext.getCmp('sysRegistroFechaDxDesnutricion').setValue("NO");
                        Ext.getCmp('fecFechaDxDesnutricion').setValue("1845-01-01");
                        Ext.getCmp('sysRegistroFechaDxDesnutricion').disable();
                        Ext.getCmp('fecFechaDxDesnutricion').disable();
                    }
                    if(Ext.getCmp('intLepra').getValue() == 2 || Ext.getCmp('intLepra').getValue() == 1){
                        Ext.getCmp('intTratamientoLepra').enable();
                    }else{
                        Ext.getCmp('intTratamientoLepra').setValue(0);
                        Ext.getCmp('intTratamientoLepra').disable();
                    }
                    Ext.getCmp('sysRegistroTerminacionTtoLeishmaniasis').setValue("NO APLICA");
                    Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').setValue("1845-01-01");
                    Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').disable();
                }
            }
        });
        winSeguimientoPacientes4505Ui.superclass.initComponent.call(this);
    }
});

function modificarDatosRegistro(){
        Ext.Msg.show({
        title: 'Modificar Seguimiento....!',
        msg: 'Esta seguro que desea Modificar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn=="yes")
            {
              var frm = Ext.getCmp('frmSeguimeitnoPaciente4505').getForm();
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/pacientes/controlador_pacientes_4505.php',
                        params: {
                            task: 'MODIFICAR_SEGUIMIENTO',
                            pUsuario: Ext.getCmp('sysUsuario').getValue(),
                            pId4505: Ext.getCmp('sysId4505').getValue(),
                            pPaciente: Ext.getCmp('sysIdPaciente').getValue(),
                            pCliente: Ext.getCmp('sysIdCliente').getValue(),
                            pConsecutivoRegistro: Ext.getCmp('sysConsecutivoRegistro').getValue(),
                            pTipoDoc: Ext.getCmp('sysTipoDoc').getValue(),
                            pDocumento: Ext.getCmp('sysDocumento').getValue(),
                            pPrimerApellido: Ext.getCmp('sysPrimerApellido').getValue(),
                            pSegundoApellido: Ext.getCmp('sysSegundoApellido').getValue(),
                            pPrimerNombre: Ext.getCmp('sysPrimerNombre').getValue(),
                            pSegundoNombre: Ext.getCmp('sysSegundoNombre').getValue(),
                            pFechaNac: Ext.getCmp('sysFechaNac').getValue(),
                            pGenero: Ext.getCmp('sysGenero').getValue(),
                            pEtniaHC: Ext.getCmp('sysEtniaHC').getValue(),
                            pOcupacionHC: Ext.getCmp('strOcupacionHC').getValue(),
                            pEscolaridadHC: Ext.getCmp('sysEscolaridadHC').getValue(),
                            pGestacion: Ext.getCmp('intGestacion').getValue(),
                            pSifilisGestacional: Ext.getCmp('intSifilisGestacional').getValue(),
                            pHipertencionGestacional: Ext.getCmp('intHipertencionGestacional').getValue(),
                            pHipotiroidismoCongenito: Ext.getCmp('intHipotiroidismoCongenito').getValue(),
                            pSintomaticoRespiratorio: Ext.getCmp('intSintomaticoRespiratorio').getValue(),
                            pTuberculosisMultidrogoresistente: Ext.getCmp('intTuberculosisMultidrogoresistente').getValue(),
                            pLepra: Ext.getCmp('intLepra').getValue(),
                            pObesidadDesnutricion: Ext.getCmp('intObesidadDesnutricion').getValue(),
                            pVictimaMaltrato: Ext.getCmp('intVictimaMaltrato').getValue(),
                            pViolenciaSexual: Ext.getCmp('intViolenciaSexual').getValue(),
                            pInfeccionesTrasmisionSexual: Ext.getCmp('intInfeccionesTrasmisionSexual').getValue(),
                            pEnfermedadMental: Ext.getCmp('intEnfermedadMental').getValue(),
                            pCancerCervix: Ext.getCmp('intCancerCervix').getValue(),
                            pCancerSeno: Ext.getCmp('intCancerSeno').getValue(),
                            pFluorosisDental: Ext.getCmp('intFluorosisDental').getValue(),
                            pFecPeso: Ext.getCmp('fecPeso').getValue(),
                            pPeso: Ext.getCmp('intPeso').getValue(),
                            pFecTalla: Ext.getCmp('fecTalla').getValue(),
                            pTalla: Ext.getCmp('intTalla').getValue(),
                            pProbableParto: Ext.getCmp('fecProbableParto').getValue(),
                            pEdadGestacionalNacer: Ext.getCmp('intEdadGestacionalNacer').getValue(),
                            pBCG: Ext.getCmp('intBCG').getValue(),
                            pHepatitisB: Ext.getCmp('intHepatitisB').getValue(),
                            pPentavalente: Ext.getCmp('intPentavalente').getValue(),
                            pPolio: Ext.getCmp('intPolio').getValue(),
                            pDPT: Ext.getCmp('intDPT').getValue(),
                            pRotavirus: Ext.getCmp('intRotavirus').getValue(),
                            pNeumococo: Ext.getCmp('intNeumococo').getValue(),
                            pInfluenza: Ext.getCmp('intInfluenza').getValue(),
                            pFiebreAmarilla: Ext.getCmp('intFiebreAmarilla').getValue(),
                            pHepatitisA: Ext.getCmp('intHepatitisA').getValue(),
                            pTripleViral: Ext.getCmp('intTripleViral').getValue(),
                            pVPH: Ext.getCmp('intVPH').getValue(),
                            pTD: Ext.getCmp('intTD').getValue(),
                            pControlPlacaBacteriana: Ext.getCmp('intControlPlacaBacteriana').getValue(),
                            pAtencionParto: Ext.getCmp('fecAtencionParto').getValue(),
                            pSalidaAtencionParto: Ext.getCmp('fecSalidaAtencionParto').getValue(),
                            pConcejeriaLactancia: Ext.getCmp('fecConcejeriaLactancia').getValue(),
                            pControlRecienNacido: Ext.getCmp('fecControlRecienNacido').getValue(),
                            pPlanificacionFamiliarPrimeraVez: Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').getValue(),
                            pSuministroMetodoPlanificacion: Ext.getCmp('intSuministroMetodoPlanificacion').getValue(),
                            pSuministroMetodo: Ext.getCmp('fecSuministroMetodo').getValue(),
                            pControlPrenatalPrimeraVez: Ext.getCmp('fecControlPrenatalPrimeraVez').getValue(),
                            pControlPrenatal: Ext.getCmp('intControlPrenatal').getValue(),
                            pUltimoControlPrenatal: Ext.getCmp('fecUltimoControlPrenatal').getValue(),
                            pSuministroAcidoFolico: Ext.getCmp('intSuministroAcidoFolico').getValue(),
                            pSuministroSulfatoFerroso: Ext.getCmp('intSuministroSulfatoFerroso').getValue(),
                            pSuministroCarbonatoCalcio: Ext.getCmp('intSuministroCarbonatoCalcio').getValue(),
                            pValoracionAgudezaVisual: Ext.getCmp('fecValoracionAgudezaVisual').getValue(),
                            pConsultaOfitalmologia: Ext.getCmp('fecConsultaOfitalmologia').getValue(),
                            pFechaDxDesnutricion: Ext.getCmp('fecFechaDxDesnutricion').getValue(),
                            pConsultaMujerVictimaMaltrato: Ext.getCmp('fecConsultaMujerVictimaMaltrato').getValue(),
                            pConsultaViolenciaSexual: Ext.getCmp('fecConsultaViolenciaSexual').getValue(),
                            pConsultaNutricion: Ext.getCmp('fecConsultaNutricion').getValue(),
                            pConsultaPsicologia: Ext.getCmp('fecConsultaPsicologia').getValue(),
                            pConsultaCyDPrimeraVez: Ext.getCmp('fecConsultaCyDPrimeraVez').getValue(),
                            pSuministroSulfatoFerroso1ano: Ext.getCmp('intSuministroSulfatoFerroso1ano').getValue(),
                            pSuministroVitaminaA: Ext.getCmp('intSuministroVitaminaA').getValue(),
                            pConsultaJovenPrimeraVez: Ext.getCmp('fecConsultaJovenPrimeraVez').getValue(),
                            pConsultaAdultoPrimeraVez: Ext.getCmp('fecConsultaAdultoPrimeraVez').getValue(),
                            pPreservativosEntregadosITS: Ext.getCmp('intPreservativosEntregadosITS').getValue(),
                            pAsesoriaPreTestVIH: Ext.getCmp('fecAsesoriaPreTestVIH').getValue(),
                            pAsesoriaPosTestVIH: Ext.getCmp('fecAsesoriaPosTestVIH').getValue(),
                            pEnfMentalTratamientoUlt6Meses: Ext.getCmp('intEnfMentalTratamientoUlt6Meses').getValue(),
                            pAntigenoHepatitisB: Ext.getCmp('fecAntigenoHepatitisB').getValue(),
                            pResultadoAntigenoHepatitisB: Ext.getCmp('intResultadoAntigenoHepatitisB').getValue(),
                            pSerologia: Ext.getCmp('fecSerologia').getValue(),
                            pResultadoSerologia: Ext.getCmp('intResultadoSerologia').getValue(),
                            pTomaElisaVIH: Ext.getCmp('fecTomaElisaVIH').getValue(),
                            pResultadoElisaVIH: Ext.getCmp('intResultadoElisaVIH').getValue(),
                            pTSHNeonatal: Ext.getCmp('fecTSHNeonatal').getValue(),
                            pResultadoTSHNeonatal: Ext.getCmp('intResultadoTSHNeonatal').getValue(),
                            pTamizajeCancerCuelloUterino: Ext.getCmp('intTamizajeCancerCuelloUterino').getValue(),
                            pTomaCitologia: Ext.getCmp('fecTomaCitologia').getValue(),
                            pResultadoCitologia: Ext.getCmp('intResultadoCitologia').getValue(),
                            pCalidadMuestraCitologia: Ext.getCmp('intCalidadMuestraCitologia').getValue(),
                            pCodIPSTomaCitologia: Ext.getCmp('intCodIPSTomaCitologia').getValue(),
                            pTomaColposcopia: Ext.getCmp('fecTomaColposcopia').getValue(),
                            pCodIPSTomaColposcopia: Ext.getCmp('intCodIPSTomaColposcopia').getValue(),
                            pBiopsiaCervical: Ext.getCmp('fecBiopsiaCervical').getValue(),
                            pResultadoBiopsiaCervical: Ext.getCmp('intResultadoBiopsiaCervical').getValue(),
                            pCodIPSTomaBiopsiaCervical: Ext.getCmp('intCodIPSTomaBiopsiaCervical').getValue(),
                            pMamografia: Ext.getCmp('fecMamografia').getValue(),
                            pResultadoMamografia: Ext.getCmp('intResultadoMamografia').getValue(),
                            pCodIPSTomaMamografia: Ext.getCmp('intCodIPSTomaMamografia').getValue(),
                            pTomaBiopsiaSenoBACAF: Ext.getCmp('fecTomaBiopsiaSenoBACAF').getValue(),
                            pFecResultadoBiopsiaSeno: Ext.getCmp('fecResultadoBiopsiaSeno').getValue(),
                            pResultadoBiopsiaSeno: Ext.getCmp('intResultadoBiopsiaSeno').getValue(),
                            pCodIPSTomaBiopsiaSeno: Ext.getCmp('intCodIPSTomaBiopsiaSeno').getValue(),
                            pTomaHemoglobina: Ext.getCmp('fecTomaHemoglobina').getValue(),
                            pResultadoHemoglobina: Ext.getCmp('intResultadoHemoglobina').getValue(),
                            pTomaGlicemia: Ext.getCmp('fecTomaGlicemia').getValue(),
                            pTomaCreatinina: Ext.getCmp('fecTomaCreatinina').getValue(),
                            pResultadoCreatinina: Ext.getCmp('intResultadoCreatinina').getValue(),
                            pTomaHemoglobinaGlicosilada: Ext.getCmp('fecTomaHemoglobinaGlicosilada').getValue(),
                            pResultadoHemoglobinaGlicosilada: Ext.getCmp('intResultadoHemoglobinaGlicosilada').getValue(),
                            pTomaMicroalbuminuria: Ext.getCmp('fecTomaMicroalbuminuria').getValue(),
                            pTomaHDL: Ext.getCmp('fecTomaHDL').getValue(),
                            pTomaBaciloscopiaDiagnostica: Ext.getCmp('fecTomaBaciloscopiaDiagnostica').getValue(),
                            pResultadoBaciloscopiaDiagnostica: Ext.getCmp('intResultadoBaciloscopiaDiagnostica').getValue(),
                            pTratamientoHipotiroidismoCongenito: Ext.getCmp('intTratamientoHipotiroidismoCongenito').getValue(),
                            pTratamientoSifilisGestacional: Ext.getCmp('intTratamientoSifilisGestacional').getValue(),
                            pTratamientoSifilisCongenita: Ext.getCmp('intTratamientoSifilisCongenita').getValue(),
                            pTratamientoLepra: Ext.getCmp('intTratamientoLepra').getValue(),
                            pTerminacionTratamientoLeishmaniasis: Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').getValue()
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Modificar Seguimiento',
                                        msg: 'Se Modifico Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('winSeguimeitnoPaciente4505').close();
                                    Ext.getCmp('gridSeguimientoPacientes4505').store.load({
                                        params: {
                                            pPaciente: 0
                                        }
                                    });
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Modificar Seguimiento',
                                        msg: 'Ocurrio un error al Modificar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Modificar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'El Usuario es Requerido',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}

function guardarDatosRegistro(){
        Ext.Msg.show({
        title: 'Guardar Seguimiento....!',
        msg: 'Esta seguro que desea Guardar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn=="yes")
            {
              var frm = Ext.getCmp('frmSeguimeitnoPaciente4505').getForm();
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/pacientes/controlador_pacientes_4505.php',
                        params: {
                            task: 'GUARDAR_SEGUIMIENTO',
                            pIPS: Ext.getCmp('sysIPS').getValue(),
                            pId4505: Ext.getCmp('sysId4505').getValue(),
                            pUsuario: Ext.getCmp('sysUsuario').getValue(),
                            pPaciente: Ext.getCmp('sysIdPaciente').getValue(),
                            pCliente: Ext.getCmp('sysIdCliente').getValue(),
                            pTipoDoc: Ext.getCmp('sysTipoDoc').getValue(),
                            pDocumento: Ext.getCmp('sysDocumento').getValue(),
                            pPrimerApellido: Ext.getCmp('sysPrimerApellido').getValue(),
                            pSegundoApellido: Ext.getCmp('sysSegundoApellido').getValue(),
                            pPrimerNombre: Ext.getCmp('sysPrimerNombre').getValue(),
                            pSegundoNombre: Ext.getCmp('sysSegundoNombre').getValue(),
                            pFechaNac: Ext.getCmp('sysFechaNac').getValue(),
                            pGenero: Ext.getCmp('sysGenero').getValue(),
                            pEtniaHC: Ext.getCmp('sysEtniaHC').getValue(),
                            pOcupacionHC: Ext.getCmp('strOcupacionHC').getValue(),
                            pEscolaridadHC: Ext.getCmp('sysEscolaridadHC').getValue(),
                            pGestacion: Ext.getCmp('intGestacion').getValue(),
                            pSifilisGestacional: Ext.getCmp('intSifilisGestacional').getValue(),
                            pHipertencionGestacional: Ext.getCmp('intHipertencionGestacional').getValue(),
                            pHipotiroidismoCongenito: Ext.getCmp('intHipotiroidismoCongenito').getValue(),
                            pSintomaticoRespiratorio: Ext.getCmp('intSintomaticoRespiratorio').getValue(),
                            pTuberculosisMultidrogoresistente: Ext.getCmp('intTuberculosisMultidrogoresistente').getValue(),
                            pLepra: Ext.getCmp('intLepra').getValue(),
                            pObesidadDesnutricion: Ext.getCmp('intObesidadDesnutricion').getValue(),
                            pVictimaMaltrato: Ext.getCmp('intVictimaMaltrato').getValue(),
                            pViolenciaSexual: Ext.getCmp('intViolenciaSexual').getValue(),
                            pInfeccionesTrasmisionSexual: Ext.getCmp('intInfeccionesTrasmisionSexual').getValue(),
                            pEnfermedadMental: Ext.getCmp('intEnfermedadMental').getValue(),
                            pCancerCervix: Ext.getCmp('intCancerCervix').getValue(),
                            pCancerSeno: Ext.getCmp('intCancerSeno').getValue(),
                            pFluorosisDental: Ext.getCmp('intFluorosisDental').getValue(),
                            pFecPeso: Ext.getCmp('fecPeso').getValue(),
                            pPeso: Ext.getCmp('intPeso').getValue(),
                            pFecTalla: Ext.getCmp('fecTalla').getValue(),
                            pTalla: Ext.getCmp('intTalla').getValue(),
                            pProbableParto: Ext.getCmp('fecProbableParto').getValue(),
                            pEdadGestacionalNacer: Ext.getCmp('intEdadGestacionalNacer').getValue(),
                            pBCG: Ext.getCmp('intBCG').getValue(),
                            pHepatitisB: Ext.getCmp('intHepatitisB').getValue(),
                            pPentavalente: Ext.getCmp('intPentavalente').getValue(),
                            pPolio: Ext.getCmp('intPolio').getValue(),
                            pDPT: Ext.getCmp('intDPT').getValue(),
                            pRotavirus: Ext.getCmp('intRotavirus').getValue(),
                            pNeumococo: Ext.getCmp('intNeumococo').getValue(),
                            pInfluenza: Ext.getCmp('intInfluenza').getValue(),
                            pFiebreAmarilla: Ext.getCmp('intFiebreAmarilla').getValue(),
                            pHepatitisA: Ext.getCmp('intHepatitisA').getValue(),
                            pTripleViral: Ext.getCmp('intTripleViral').getValue(),
                            pVPH: Ext.getCmp('intVPH').getValue(),
                            pTD: Ext.getCmp('intTD').getValue(),
                            pControlPlacaBacteriana: Ext.getCmp('intControlPlacaBacteriana').getValue(),
                            pAtencionParto: Ext.getCmp('fecAtencionParto').getValue(),
                            pSalidaAtencionParto: Ext.getCmp('fecSalidaAtencionParto').getValue(),
                            pConcejeriaLactancia: Ext.getCmp('fecConcejeriaLactancia').getValue(),
                            pControlRecienNacido: Ext.getCmp('fecControlRecienNacido').getValue(),
                            pPlanificacionFamiliarPrimeraVez: Ext.getCmp('fecPlanificacionFamiliarPrimeraVez').getValue(),
                            pSuministroMetodoPlanificacion: Ext.getCmp('intSuministroMetodoPlanificacion').getValue(),
                            pSuministroMetodo: Ext.getCmp('fecSuministroMetodo').getValue(),
                            pControlPrenatalPrimeraVez: Ext.getCmp('fecControlPrenatalPrimeraVez').getValue(),
                            pControlPrenatal: Ext.getCmp('intControlPrenatal').getValue(),
                            pUltimoControlPrenatal: Ext.getCmp('fecUltimoControlPrenatal').getValue(),
                            pSuministroAcidoFolico: Ext.getCmp('intSuministroAcidoFolico').getValue(),
                            pSuministroSulfatoFerroso: Ext.getCmp('intSuministroSulfatoFerroso').getValue(),
                            pSuministroCarbonatoCalcio: Ext.getCmp('intSuministroCarbonatoCalcio').getValue(),
                            pValoracionAgudezaVisual: Ext.getCmp('fecValoracionAgudezaVisual').getValue(),
                            pConsultaOfitalmologia: Ext.getCmp('fecConsultaOfitalmologia').getValue(),
                            pFechaDxDesnutricion: Ext.getCmp('fecFechaDxDesnutricion').getValue(),
                            pConsultaMujerVictimaMaltrato: Ext.getCmp('fecConsultaMujerVictimaMaltrato').getValue(),
                            pConsultaViolenciaSexual: Ext.getCmp('fecConsultaViolenciaSexual').getValue(),
                            pConsultaNutricion: Ext.getCmp('fecConsultaNutricion').getValue(),
                            pConsultaPsicologia: Ext.getCmp('fecConsultaPsicologia').getValue(),
                            pConsultaCyDPrimeraVez: Ext.getCmp('fecConsultaCyDPrimeraVez').getValue(),
                            pSuministroSulfatoFerroso1ano: Ext.getCmp('intSuministroSulfatoFerroso1ano').getValue(),
                            pSuministroVitaminaA: Ext.getCmp('intSuministroVitaminaA').getValue(),
                            pConsultaJovenPrimeraVez: Ext.getCmp('fecConsultaJovenPrimeraVez').getValue(),
                            pConsultaAdultoPrimeraVez: Ext.getCmp('fecConsultaAdultoPrimeraVez').getValue(),
                            pPreservativosEntregadosITS: Ext.getCmp('intPreservativosEntregadosITS').getValue(),
                            pAsesoriaPreTestVIH: Ext.getCmp('fecAsesoriaPreTestVIH').getValue(),
                            pAsesoriaPosTestVIH: Ext.getCmp('fecAsesoriaPosTestVIH').getValue(),
                            pEnfMentalTratamientoUlt6Meses: Ext.getCmp('intEnfMentalTratamientoUlt6Meses').getValue(),
                            pAntigenoHepatitisB: Ext.getCmp('fecAntigenoHepatitisB').getValue(),
                            pResultadoAntigenoHepatitisB: Ext.getCmp('intResultadoAntigenoHepatitisB').getValue(),
                            pSerologia: Ext.getCmp('fecSerologia').getValue(),
                            pResultadoSerologia: Ext.getCmp('intResultadoSerologia').getValue(),
                            pTomaElisaVIH: Ext.getCmp('fecTomaElisaVIH').getValue(),
                            pResultadoElisaVIH: Ext.getCmp('intResultadoElisaVIH').getValue(),
                            pTSHNeonatal: Ext.getCmp('fecTSHNeonatal').getValue(),
                            pResultadoTSHNeonatal: Ext.getCmp('intResultadoTSHNeonatal').getValue(),
                            pTamizajeCancerCuelloUterino: Ext.getCmp('intTamizajeCancerCuelloUterino').getValue(),
                            pTomaCitologia: Ext.getCmp('fecTomaCitologia').getValue(),
                            pResultadoCitologia: Ext.getCmp('intResultadoCitologia').getValue(),
                            pCalidadMuestraCitologia: Ext.getCmp('intCalidadMuestraCitologia').getValue(),
                            pCodIPSTomaCitologia: Ext.getCmp('intCodIPSTomaCitologia').getValue(),
                            pTomaColposcopia: Ext.getCmp('fecTomaColposcopia').getValue(),
                            pCodIPSTomaColposcopia: Ext.getCmp('intCodIPSTomaColposcopia').getValue(),
                            pBiopsiaCervical: Ext.getCmp('fecBiopsiaCervical').getValue(),
                            pResultadoBiopsiaCervical: Ext.getCmp('intResultadoBiopsiaCervical').getValue(),
                            pCodIPSTomaBiopsiaCervical: Ext.getCmp('intCodIPSTomaBiopsiaCervical').getValue(),
                            pMamografia: Ext.getCmp('fecMamografia').getValue(),
                            pResultadoMamografia: Ext.getCmp('intResultadoMamografia').getValue(),
                            pCodIPSTomaMamografia: Ext.getCmp('intCodIPSTomaMamografia').getValue(),
                            pTomaBiopsiaSenoBACAF: Ext.getCmp('fecTomaBiopsiaSenoBACAF').getValue(),
                            pFecResultadoBiopsiaSeno: Ext.getCmp('fecResultadoBiopsiaSeno').getValue(),
                            pResultadoBiopsiaSeno: Ext.getCmp('intResultadoBiopsiaSeno').getValue(),
                            pCodIPSTomaBiopsiaSeno: Ext.getCmp('intCodIPSTomaBiopsiaSeno').getValue(),
                            pTomaHemoglobina: Ext.getCmp('fecTomaHemoglobina').getValue(),
                            pResultadoHemoglobina: Ext.getCmp('intResultadoHemoglobina').getValue(),
                            pTomaGlicemia: Ext.getCmp('fecTomaGlicemia').getValue(),
                            pTomaCreatinina: Ext.getCmp('fecTomaCreatinina').getValue(),
                            pResultadoCreatinina: Ext.getCmp('intResultadoCreatinina').getValue(),
                            pTomaHemoglobinaGlicosilada: Ext.getCmp('fecTomaHemoglobinaGlicosilada').getValue(),
                            pResultadoHemoglobinaGlicosilada: Ext.getCmp('intResultadoHemoglobinaGlicosilada').getValue(),
                            pTomaMicroalbuminuria: Ext.getCmp('fecTomaMicroalbuminuria').getValue(),
                            pTomaHDL: Ext.getCmp('fecTomaHDL').getValue(),
                            pTomaBaciloscopiaDiagnostica: Ext.getCmp('fecTomaBaciloscopiaDiagnostica').getValue(),
                            pResultadoBaciloscopiaDiagnostica: Ext.getCmp('intResultadoBaciloscopiaDiagnostica').getValue(),
                            pTratamientoHipotiroidismoCongenito: Ext.getCmp('intTratamientoHipotiroidismoCongenito').getValue(),
                            pTratamientoSifilisGestacional: Ext.getCmp('intTratamientoSifilisGestacional').getValue(),
                            pTratamientoSifilisCongenita: Ext.getCmp('intTratamientoSifilisCongenita').getValue(),
                            pTratamientoLepra: Ext.getCmp('intTratamientoLepra').getValue(),
                            pTerminacionTratamientoLeishmaniasis: Ext.getCmp('fecTerminacionTratamientoLeishmaniasis').getValue()
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar Seguimiento',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('winSeguimeitnoPaciente4505').close();
                                    Ext.getCmp('gridSeguimientoPacientes4505').store.load({
                                        params: {
                                            pPaciente: 0
                                        }
                                    });
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar Seguimiento',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}

function calculoEdadPacienteMeses(){
    var valFecha1 = 0;
    var valFecha2 = 0;
    MesesCumplidos = 0;


    valFecha1 = Ext.getCmp('sysFechaRegistro').getValue();
    valFecha2 =  Ext.getCmp('sysFechaNac').getValue();

    MesesCumplidos = MostrarEdadMeses(valFecha1, valFecha2);
}
