/*
* @category    Formulario Grid Horarios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmNotasProveedorUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Notas Proveedor ::.',
    id: 'winFrmNotasProveedor',
    closable:false,
    width:980,
    height:480,
    plain:true,
    resizable : false,
    y:120,
    layout: 'fit',
    initComponent: function() {
        var mybbar = new utilBbarUi();
        var stGrid = new StoreGridNotasProveedor();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'grid',
                id: 'gridNotasProveedor',
                store: stGrid,
                anchor: "100%",
                border: false,
                frame: true,
                columns: [
                    {
                        xtype: 'gridcolumn',
                        header: 'Id',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'IdNotasProveedor',
                        id: 'IdNotasProveedor'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripcion',
                        sortable: false,
                        width: 450,
                        hidden: false,
                        hideable: false,
                        dataIndex: 'Descripcion',
                        id: 'Descripcion'
                    }
                ],
                selModel: new Ext.grid.RowSelectionModel({singleSelect:true}),
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'button',
                                text: 'Adicionar Nota',
                                iconCls: 'btnAddRow',
                                id: 'btnAddNota'
                            },
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Eliminar Nota',
                                iconCls: 'btnDelRow',
                                id: 'btnDelNota'
                            },
                            {
                                xtype: 'tbfill'
                            },
                            new Ext.app.SearchField({
                                id: 'qryNota',
                                store: stGrid,
                                ValparamP1: ID_EMPRESA,
                                emptyText: 'Escriba el criterio que desea buscar',
                                params: {pEmpresa: Ext.get('idempresa').getValue(), start: 0, limit: 15},
                                width: 120
                            })
                        ]
                    },
                bbar: new Ext.PagingToolbar({
                    pageSize: 15,
                    store: stGrid,
                    displayInfo: true
                })
            }
        ];
        winFrmNotasProveedorUi.superclass.initComponent.call(this);
    }
});
