/*
* @category    Programacion Eventos Formulario Tipo de Horario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmNotasProveedor = Ext.extend(winFrmNotasProveedorUi, {
    initComponent: function() {
        winFrmNotasProveedor.superclass.initComponent.call(this);
        //this.title = Ext.get('ofiversion').getValue() + " .:: Tipos de Horarios ::.";
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        el = Ext.get('idaplicacion');
        var NOM_APLICACION = el.getValue();
        el = Ext.get('idxac');
        var ID_CONSULTORIO = el.getValue();
        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        if(NOM_APLICACION == "OfiClinic"){
            Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        }else{
            Ext.getCmp('fNomEmpresa').setValue("");
            Ext.getCmp('fNomSede').setValue("");
            Ext.getCmp('fNomIPS').setValue("");
            Ext.getCmp('fNomUSR').setValue("");
        }
        Ext.getCmp('gridNotasProveedor').store.load({params: {query: null, pEmpresa: ID_EMPRESA, start: 0, limit: 15}});

        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnAddNota = Ext.getCmp('btnAddNota').on("click",this.AddNota,this);
        var btnDelNota = Ext.getCmp('btnDelNota').on("click",this.DelNota,this);
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    },
    AddNota: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "AddNota";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        //if (!permitir)
        //{
        //    Ext.example.Tiempo = 3;
        //    Ext.example.msg('Tipo Horario - Adicionar:', "Usted no tiene acceso a esta opción del sistema...!");
        //}else
        //{
            var winAddNota = new winNotasProveedorUi();
            winAddNota.title = 'eOfiClinic .::Adicionar Nota::.';
            Ext.getCmp('btn_AdicionarNota').setVisible(true);
            Ext.getCmp('btn_ModificarNota').setVisible(false);
            Ext.getCmp('intPrestador').setValue(ID_EMPRESA);
            Ext.getCmp('intUsuario').setValue(ID_USUARIO);
            var btn_AdicionarHorario = Ext.getCmp('btn_AdicionarNota').on("click",this.GuardarNotaProveedor,this);
            var btn_SalirHorario = Ext.getCmp('btn_SalirNota').on("click",this.CerrarVentana,this);
            winAddNota.show();
        //}
    },
    GuardarNotaProveedor: function(){
        Ext.Msg.show({
            title: 'Guardar Nota',
            msg: 'Esta Seguro que Desea Guardar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("INSERTAR","SI","winNotasProveedorUi","frmNotasProveedor","../../controlador/notasproveedor/controlador_notasproveedor.php","gridNotasProveedor");
                }
            }
        });
    },
    DelNota: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "DelNota";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        //if (!permitir)
        //{
        //    Ext.example.Tiempo = 3;
        //    Ext.example.msg('Tipo Horario - Eliminar:', "Usted no tiene acceso a esta opción del sistema...!");
        //}else
        //{
            if(Ext.getCmp('gridNotasProveedor').selModel.getCount() == 1)
            {
                var selections = Ext.getCmp('gridNotasProveedor').selModel.getSelections();
                Ext.Msg.show({
                    title: 'Nota Proveedor',
                    msg: 'Esta Seguro que Desea Eliminar el Registro ' + selections[0].json.Descripcion + '?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes")
                        {
                            fnEliminarRegistros("../../controlador/notasproveedor/controlador_notasproveedor.php",{task: "ELIMINAR", pIdNota: selections[0].json.IdNotasProveedor}, 'gridNotasProveedor')
                        }
                    }
                });
            }else{
                Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'No podemos eliminar los registros en estos momentos, verifique que solo haya seleccionado un registro',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        //}
    },
    ModificarTipoHorario: function(){
        Ext.Msg.show({
            title: 'Guardar Nota',
            msg: 'Esta Seguro que Desea Modificar la Información?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    fnGuardarRegistros("MODIFICAR","SI","winNotasProveedor","frmNotasProveedor","../../controlador/notasproveedor/controlador_notasproveedor.php","gridNotasProveedor");
                }
            }
        });
    },
    CerrarVentana: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                   Ext.getCmp('winNotasProveedorUi').close();
                }
            }
        });
    },
    PrintTipoHorario: function(){
        var permitir = false;
        var acceso = stOpcionesSistema.queryBy(function(record,id)
        {
            return record.get('codOpcion') == "PrintTipoHorario";
        });
        acceso.each(function(item,index){
            permitir = true
        });
        if (!permitir)
        {
            Ext.example.Tiempo = 3;
            Ext.example.msg('Tipo Horario - Imprimir:', "Usted no tiene acceso a esta opción del sistema...!");
        }else
        {
            location.href='../../controlador/agendas/tipo_horario_print.php?pEmpresa='+ID_EMPRESA+'&query='+Ext.getCmp('qryTipoHorario').getValue();
        }
    }
});


function fnEliminarRegistros(URL,arrParam, pGrid, arrParamStore)
{
    Ext.Ajax.request({
        waitMsg: 'Por favor Espere...',
        url: URL,
        params: arrParam,
        success: function(response){
            var result=eval(response.responseText);
            switch(result){
                case 1:
                    if (typeof pGrid != 'undefined')
                    {
                        Ext.getCmp(pGrid).store.reload(arrParamStore);
                    }
                    break;

                default:
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'No podemos eliminar los registros en estos momentos',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                    break;
            }
        },
        failure: function(response){
            var result = response.responseText;
            Ext.MessageBox.show({
                title: 'Error Base Datos',
                msg: 'No podemos eliminar los registros en estos momentos',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    });
}

function fnGuardarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarDatosBasicosTarjeta').setVisible(false);
                                //Ext.getCmp('btnModificarDatosBasicosTarjeta').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
