/*
* @category    Formulario Grid Municipios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winEditMunicipiosUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Editar Lista de Municipios ::.',
    id: 'winEditMunicipios',
    width: 980,
    height: 480,
    plain: true,
    resizable: false,
    closable: true,
    modal: true,
    y: 120,
    layout: 'fit',
    initComponent: function() {
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        var textField = new Ext.form.TextField({
            style: 'text-transform:uppercase;'
        });

        var st = new StoreDeptoMuni();
        st.load();
        
        this.items = [
           {
                xtype: 'editorgrid',
                id: 'gridMunicipios',
                store: st,
                anchor: "100%",
                border: false,
                frame: true,
                layout: 'fit',
                columns: [
                    new Ext.grid.RowNumberer(),
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: false,
                        width: 1,
                        hidden: true,
                        hideable: false,
                        dataIndex: 'OldDescripcion',
                        id: 'OldDescripcion'
                    },
                    {
                        xtype: 'gridcolumn',
                        header: 'Descripción',
                        sortable: true,
                        editor: textField,
                        width: 930,
                        dataIndex: 'Descripcion',
                        id: 'Descripcion'
                    }
                ],
                tbar:
                    {
                        xtype: 'toolbar',
                        items: [
                            {
                                xtype: 'tbseparator'
                            },
                            {
                                xtype: 'button',
                                text: 'Modificar',
                                iconCls: 'btnEditRow',
                                id: 'btnEditMunicipio',
                                listeners:{
                                    click : function(){
                                        var modified = Ext.getCmp('gridMunicipios').getStore().getModifiedRecords();
                                        if(!Ext.isEmpty(modified)){
                                            var recordsToSend = [];
                                            Ext.each(modified, function(record) {
                                                recordsToSend.push(Ext.apply({OldDescripcion: QuitarAcentosTxt(record.data.OldDescripcion.toUpperCase())},{Descripcion: QuitarAcentosTxt(record.data.Descripcion.toUpperCase())}));
                                            });
                                            Ext.getCmp('gridMunicipios').el.mask('Guardando Información...', 'x-mask-loading');
                                            Ext.getCmp('gridMunicipios').stopEditing();
                                            recordsToSend = Ext.encode(recordsToSend);
                                            Ext.Ajax.request({
                                                url : '../../controlador/municipios/controlador_municipios.php',
                                                params :{
                                                    task: 'Modificar',
                                                    records : recordsToSend
                                                },
                                                scope:this,
                                                success : function(response) {
                                                    Ext.getCmp('gridMunicipios').getStore().commitChanges();
                                                    Ext.getCmp('gridMunicipios').store.reload();
                                                    Ext.getCmp('strMunicipio').store.reload();
                                                    Ext.getCmp('gridMunicipios').el.unmask();
                                                }
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'tbseparator'
                            }
                        ]
                    }
            }
        ];
        winEditMunicipiosUi.superclass.initComponent.call(this);
    }
});
