/*
* @category    Formulario Borrar CAS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winVerInfoCASUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Informacion Orden Servicios - CAS ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winInfoCAS',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmInfoCAS',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'textfield',
                        fieldLabel: 'CAS',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysInfoCAS'
                    },
                    {
                        xtype: 'textfield',
                        fieldLabel: 'Usuario',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysUsuarioInfoCAS'
                    },
                    {
                        xtype: 'textfield',
                        fieldLabel: 'Fecha Actualizacion',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysFechaActInfoCAS'
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                var frm = Ext.getCmp('frmInfoCAS').getForm();
                frm.doAction('load', {
                    url: '../../controlador/radicacionservicios/legalizacioncas.php',
                    waitMsg: 'Cargando Información...',
                    params:{
                        pCAS: Ext.getCmp('sysInfoCAS').getValue(),
                        PROCESO: 'INFO_CAS'
                    },
                    success:function(form, action) {
                        //CargarDataHC(action.result.data.sysEvolucion);
                    }
                });
            }}
        }); 
        winVerInfoCASUi.superclass.initComponent.call(this);
    }
});
