/*
* @category    Formulario Aplicar Abono Cartera Particulares
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAplicarAbonoParticularesUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Aplicar Abono a Particulares ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAplicarAbonoParticulares',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAplicarParticulares',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        html: '<img src="../../../resources/varios/pagoparticular.png" align="left" alt=""/>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        html:'&nbsp;&nbsp;&nbsp;',
                        border: false
                    },
                    {
                        xtype: 'hidden',
                        fieldLabel: 'Legalizacion',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysEmpresaLegalizacion'
                    },
                    {
                        xtype: 'hidden',
                        fieldLabel: 'Legalizacion',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysIPSLegalizacion'
                    },
                    {
                        xtype: 'hidden',
                        fieldLabel: 'Legalizacion',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysLegalizacion'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysLegalizacionUsuario'
                    },
                    {
                        html: ' '
                    },
                    {
                        xtype: 'numericfield',
                        currencySymbol: "$",
                        useThousandSeparator: true,
                        alwaysDisplayDecimals: true,
                        thousandSeparator: ',',
                        decimalPrecision: 2,
                        fieldLabel: 'Saldo Pendiente',
                        width: 150,
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysSaldoPendiente'
                    },
                    {
                        xtype: 'numericfield',
                        currencySymbol: "$",
                        useThousandSeparator: true,
                        alwaysDisplayDecimals: true,
                        thousandSeparator: ',',
                        decimalPrecision: 2,
                        allowBlank: false,
                        fieldLabel: 'Vlr a Pagar',
                        width: 150,
                        minValue: 0,
                        maxValue: 0,
                        id: 'sysPagoCartera'
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'Observaciones',
                        maxLength: 250,
                        allowBlank: true,
                        emptyText: 'Digite el Observaciones...!',
                        id: 'sysLegalizaMotivo'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Aplicar Pago',
                            iconCls: 'btnLiquidar',
                            id: 'btnAplicarPagoParticulares',
                            listeners:{
                                click : function(){
                                    var frm = Ext.getCmp('frmAplicarParticulares').getForm();
                                    if (frm.isValid()){
                                        if(Ext.getCmp('sysPagoCartera').getValue() > 0){
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Esta seguro que desea aplicar el pago?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn === "yes"){
                                                        frm.submit({
                                                            url: '../../controlador/radicacionservicios/legalizacioncas.php',
                                                            params:{
                                                                PROCESO: 'APLICAR_PAGO_PART',
                                                                pLegalizacion: Ext.getCmp('sysLegalizacion').getValue(),
                                                                pEmpresa: Ext.getCmp('sysEmpresaLegalizacion').getValue(),
                                                                pIPS: Ext.getCmp('sysIPSLegalizacion').getValue(),
                                                                pAbono: Ext.getCmp('sysPagoCartera').getValue(),
                                                                pUsuario: Ext.getCmp('sysLegalizacionUsuario').getValue(),
                                                                pMotivo: QuitarAcentosTxt(Ext.getCmp('sysLegalizaMotivo').getValue())
                                                            },
                                                            success: function(res,req)
                                                            {
                                                                switch(req.result.requestedId){
                                                                    case "1":
                                                                        Ext.getCmp('gridFacturacionOrden').store.reload();
                                                                        Ext.getCmp('winAplicarAbonoParticulares').close();
                                                                        Ext.MessageBox.show({
                                                                            title: 'Anulación Documentos',
                                                                            msg: 'Se Aplico el pago con exito del documento seleccionado, imprima el recibo',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.INFO
                                                                        });
                                                                        break;

                                                                    default:
                                                                        Ext.MessageBox.show({
                                                                            title: 'Anulación Documentos',
                                                                            msg: 'Ocurrio un error al aplicar el pago del documento o no se pudo establecer conexión con el servidor.',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                        break;
                                                                }
                                                            },
                                                            failure: function(response,options)
                                                            {
                                                                Ext.MessageBox.show({
                                                                    title: 'Error Base Datos',
                                                                    msg: 'No podemos aplicar el pago del documento en estos momentos',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            }
                                                        });
                                                    }
                                                }
                                            });
                                        }
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'Los Campos del formulario son Requeridos',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAplicarAbonoParticularesUi.superclass.initComponent.call(this);
    }
});
