/*
* @category    Formulario Anular RC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAnularRCUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Anular Documento RC ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: true,
    padding: 10,
    id: 'winAnularRC',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAnularRC',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        html: '<img src="../../../resources/varios/no.png" align="left" alt=""/>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        html:'&nbsp;&nbsp;&nbsp;',
                        border: false
                    },
                    {
                        xtype: 'textfield',
                        fieldLabel: 'Documento Nro.',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysNroRC'
                    },
                    {
                        xtype: 'datefield',
                        width: 120,
                        allowBlank: false,
                        emptyText: '(dia/mes/año)',
                        id: 'sysFechaAnula'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        value: 0,
                        id: 'sysIdLegalizacion'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Empresa',
                        id: 'sysEmpresa'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'IPS',
                        id: 'sysIPS'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        readOnly: true,
                        fieldLabel: 'Usuario',
                        id: 'sysUsuario'
                    },
                    {
                        xtype: 'displayfield',
                        value: ' '
                    },
                    {
                        xtype: 'textarea',
                        anchor: '100%',
                        fieldLabel: 'Motivo',
                        name: 'strMotivo',
                        maxLength: 250,
                        allowBlank: false,
                        emptyText: 'Digite el Motivo de la Anulación...!',
                        id: 'strMotivo'
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Anular RC',
                            iconCls: 'btnBorrar',
                            listeners:{
                                click : function(){
                                    var frm = Ext.getCmp('frmAnularRC').getForm();
                                    if (frm.isValid())
                                    {
                                        frm.submit({
                                            url: '../../controlador/radicacionservicios/legalizacioncas.php',
                                            params:{
                                                PROCESO: 'ANULAR_LEGALIZACION_RC',
                                                pConsecutivoDetalle: Ext.getCmp('sysIdLegalizacion').getValue(),
                                                pEmpresa: Ext.getCmp('sysEmpresa').getValue(),
                                                pIPS: Ext.getCmp('sysIPS').getValue(),
                                                pMotivo: QuitarAcentosTxt(Ext.getCmp('strMotivo').getValue()),
                                                pUsuario: Ext.getCmp('sysUsuario').getValue(),
                                                pFechaAnula: Ext.getCmp('sysFechaAnula').getValue().format("Y-m-d"),
                                                pNroDocumento: Ext.getCmp('sysNroRC').getValue()
                                            },
                                            success: function(res,req)
                                            {
                                                switch(req.result.requestedId){
                                                    case "1":
                                                        Ext.getCmp('gridFacturacionOrden').store.reload();
                                                        Ext.getCmp('winAnularRC').close();
                                                        Ext.MessageBox.show({
                                                            title: 'Anulación Documentos',
                                                            msg: 'Se Anulo con exito el documento seleccionado',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.INFO
                                                        });
                                                        break;

                                                    default:
                                                        Ext.MessageBox.show({
                                                            title: 'Anulación Documentos',
                                                            msg: 'Ocurrio un error al anular el documento o no se pudo establecer conexión con el servidor.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                        break;
                                                }
                                            },
                                            failure: function(response,options)
                                            {
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'No podemos anular el documento en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'El Motivo de la Anulación es Requerido',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAnularRCUi.superclass.initComponent.call(this);
    }
});
