/*
* @category    Formulario Modificacion de Servicios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var xbtnValidarDoc = new btnValidarDoc({
    id: 'btnValidarDoc',
    ref: '../../../../../../btnValidarDoc'
});

winRadicacionServiciosUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: Modificación de Servicios ::.',
    width: 1004,
    height: 646,
    closable: false,
    resizable: false,
    draggable: false,
    frame: true,
    id: 'winRadicacionServicios',
    initComponent: function() {
        
        Ext.util.Format.Currency = function(v)
        {
            return FormatoMoneda(v);
        };
        
        this.items = [
            {
                xtype: 'tabpanel',
                activeTab: 0,
                width: 990,
                height: 565,
                ref: 'fTabPanel',
                id: 'fTabPanel',
                frame: true,
                items: [
                    {
                        xtype: 'panel',
                        title: 'Radicar',
                        height: 441,
                        width: 951,
                        id: 'fichaDatos',
                        frame: true,
                        items: [
                            {
                                xtype: 'form',
                                title: '',
                                padding: 5,
                                border: false,
                                ref: '../../frmRadica',
                                id: 'frmRadica',
                                items: [
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Paciente',
                                        layout: 'table',
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        width: 949,
                                        height: 317,
                                        id: 'fsPaciente',
                                        layoutConfig: {
                                            columns: 4
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnTdoc',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo Doc ID',
                                                        anchor: '100%',
                                                        name: 'cbTdoc',
                                                        allowBlank: false,
                                                        //store: 'StoreTdocPac',
                                                        store: 'StoreTdocPac',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Tipo Documento....',
                                                        mode: 'local',
                                                        triggerAction: 'all',
                                                        forceSelection: true,
                                                        ref: '../../../../../fTdoc',
                                                        disabled: true,
                                                        id: 'fTdoc'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 269,
                                                border: false,
                                                id: 'pnDocID',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                fieldLabel: 'Documento ID',
                                                                name: 'txtDocID',
                                                                allowBlank: false,
                                                                //anchor: '100%',
                                                                width: 200,
                                                                ref: '../../../../../fDocID',
                                                                disabled: true,
                                                                id: 'fDocID'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Paciente',
                                                                id: 'btnBuscarPacienteRadica'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnUsrVerifica',
                                                                tooltip: 'Verificar Paciente en el Listado de Atención',
                                                                ref: '../../../../btnVerificaPacienteListado',
                                                                id: 'btnVerificaPacienteListado'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 215,
                                                border: false,
                                                colspan: 1,
                                                id: 'pnRegimen',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Régimen / Tipo Usuario',
                                                        anchor: '100%',
                                                        name: 'cbRegimen',
                                                        allowBlank: false,
                                                        store: 'StoreTipoRegimen',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Régimen/Tipo Usuario....',
                                                        forceSelection: true,
                                                        value: '1 - Contributivo',
                                                        listWidth: 350,
                                                        disabled: true,
                                                        ref: '../../../../../fRegimen',
                                                        id: 'fRegimen'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 172,
                                                border: false,
                                                colspan: 1,
                                                id: 'pnGenero',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Genero',
                                                        anchor: '100%',
                                                        name: 'cbGenero',
                                                        allowBlank: false,
                                                        store: 'StoreGenero',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Genero....',
                                                        forceSelection: true,
                                                        disabled: true,
                                                        ref: '../../../../../fGenero',
                                                        id: 'fGenero'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnApe1',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '1er Apellido',
                                                        anchor: '100%',
                                                        name: 'txtApe1',
                                                        style: 'text-transform:uppercase;',
                                                        allowBlank: false,
                                                        disabled: true,
                                                        ref: '../../../../../fApe1',
                                                        id: 'fApe1'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnApe2',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '2do Apellido',
                                                        anchor: '100%',
                                                        name: 'txtApe2',
                                                        style: 'text-transform:uppercase;',
                                                        ref: '../../../../../fApe2',
                                                        disabled: true,
                                                        id: 'fApe2'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 215,
                                                border: false,
                                                id: 'pnNom1',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '1er Nombre',
                                                        anchor: '100%',
                                                        name: 'txtNom1',
                                                        allowBlank: false,
                                                        style: 'text-transform:uppercase;',
                                                        disabled: true,
                                                        ref: '../../../../../fNom1',
                                                        id: 'fNom1'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                border: false,
                                                width: 172,
                                                id: 'pnNom2',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: '2do Nombre',
                                                        anchor: '100%',
                                                        name: 'txtNom2',
                                                        disabled: true,
                                                        style: 'text-transform:uppercase;',
                                                        id: 'fNom2'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 146,
                                                border: false,
                                                id: 'pnFecNac',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Fecha Nacimiento',
                                                        anchor: '100%',
                                                        name: 'txtFecNac',
                                                        allowBlank: false,
                                                        disabledDates: '',
                                                        emptyText: '(dia/mes/año) ',
                                                        style: 'text-align:center;',
                                                        ref: '../../../../../fFecNac',
                                                        disabled: true,
                                                        id: 'fFecNac'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnEdad',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Edad Actual',
                                                        anchor: '100%',
                                                        name: 'txtEdad',
                                                        readOnly: true,
                                                        allowBlank: false,
                                                        style: 'color: blue;text-align:center',
                                                        disabled: true,
                                                        ref: '../../../../../fEdad',
                                                        id: 'fEdad'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 386,
                                                border: false,
                                                colspan: 2,
                                                id: 'pnDeptoMuni',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Municipio - Departamento',
                                                        anchor: '100%',
                                                        name: 'cbDeptoMuni',
                                                        allowBlank: false,
                                                        store: 'StoreDeptoMuni',
                                                        valueField: 'IdDeptoMunicipio',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Municipio - Departamento....',
                                                        mode: 'local',
                                                        listWidth: 450,
                                                        forceSelection: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 10,
                                                        ref: '../../../../../fDeptoMuni',
                                                        disabled: true,
                                                        id: 'fDeptoMuni'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 928,
                                                border: false,
                                                colspan: 4,
                                                height: 54,
                                                id: 'pnDatDirTel',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        fieldLabel: 'Dirección - Teléfono - Teléfono (Otro - Cel.) - Zona - Email',
                                                        anchor: '100%',
                                                        id: 'composDatDirTel',
                                                        items: [
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtDireccion',
                                                                allowBlank: false,
                                                                emptyText: 'Dirección....',
                                                                style: 'text-transform:uppercase;',
                                                                width: 250,
                                                                ref: '../../../../../../fDireccion',
                                                                disabled: true,
                                                                id: 'fDireccion'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtTel1',
                                                                allowBlank: false,
                                                                emptyText: 'Teléfono',
                                                                width: 160,
                                                                disabled: true,
                                                                id: 'fTel1'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtTel2',
                                                                emptyText: 'Teléfono (Otro - Cel.)',
                                                                width: 160,
                                                                disabled: true,
                                                                id: 'fTel2'
                                                            },
                                                            {
                                                                xtype: 'combo',
                                                                flex: 1,
                                                                fieldLabel: 'Zona',
                                                                store: 'StoreZonaResidencia',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                mode: 'local',
                                                                name: 'cbZona',
                                                                emptyText: 'Zona....',
                                                                allowBlank: false,
                                                                forceSelection: true,
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                width: 80,
                                                                value: 'Urbana',
                                                                triggerAction: 'all',
                                                                ref: '../../../../../../fZona',
                                                                disabled: true,
                                                                id: 'fZona'
                                                            },
                                                            {
                                                                xtype: 'textfield',
                                                                name: 'txtEmail',
                                                                vtype: 'email',
                                                                emptyText: 'Email....',
                                                                width: 140,
                                                                disabled: true,
                                                                id: 'fEmail'
                                                            },
                                                            /*{
                                                                xtype: 'button',
                                                                tooltip: 'Limpiar Datos del Paciente',
                                                                iconCls: 'btnLimpiar',
                                                                id: 'btnLimpiarPac_citas'
                                                            },*/
                                                            {
                                                                xtype: 'button',
                                                                text: 'Actualiza',
                                                                tooltip: 'Actualizar Datos del Paciente',
                                                                iconCls: 'btnGuardar',
                                                                iconAlign: 'right',
                                                                ref: '../../../../btnActualizaPac',
                                                                id: 'btnActualizaPac'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnTafiliado',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Tipo de Afiliado',
                                                        anchor: '100%',
                                                        name: 'cbTafiliado',
                                                        allowBlank: false,
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreTipoAfiliado',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Tipo de Afiliado....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        tpl: '',
                                                        ref: '../../../../../fTafiliado',
                                                        disabled: true,
                                                        id: 'fTafiliado'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnTafiliacion',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Parentesco',
                                                        anchor: '100%',
                                                        name: 'cbParentesco',
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreParentesco',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        emptyText: 'Seleccione Parentesco....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        disabled: true,
                                                        ref: '../../../../../fParentesco',
                                                        id: 'fParentesco'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 213,
                                                border: false,
                                                id: 'pnRango',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Rango Salarial',
                                                        anchor: '100%',
                                                        name: 'cbRango',
                                                        allowBlank: false,
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreRangoSal',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        emptyText: 'Seleccione Rango Salarial....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        tpl: '<tpl for="."><div class="cbRango"><h3>{Descripcion}</h3><p style="font-size: 12; color: #AA0033">Valor: $ {VlrCuotaModeradora}</p><p style="font-size: 11; color: #0000EE ">Porcentaje: {txtPorcentaje} %</p><p style="font-size: 10; color: #33373d">{Observaciones}</p><hr /></div></tpl>',
                                                        itemSelector: 'div.cbRango',
                                                        listWidth: 450,
                                                        autoHeight: true,
                                                        ref: '../../../../../fRango',
                                                        disabled: true,
                                                        id: 'fRango'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 170,
                                                border: false,
                                                id: 'pnEstado',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Estado - Listado Atención',
                                                        anchor: '100%',
                                                        name: 'cbEstado',
                                                        allowBlank: false,
                                                        listEmptyText: 'Seleccione',
                                                        store: 'StoreEstadoLA',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        mode: 'local',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        emptyText: 'Estado Actual....',
                                                        valueField: 'Codigo',
                                                        displayField: 'Descripcion',
                                                        disabled: true,
                                                        autoSelect: false,
                                                        ref: '../../../../../fEstado',
                                                        id: 'fEstado'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdEmpresa',
                                                id: 'fIdEmpresa',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdSede',
                                                id: 'fIdSede',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdIPS',
                                                id: 'fIdIPS',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtIdPaciente',
                                                id: 'fIdPaciente',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtExcento',
                                                id: 'fExento',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtTutela',
                                                id: 'fTutela',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtClieteLA',
                                                id: 'fClienteLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtPlanLA',
                                                id: 'fPlanLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtSubPlanLA',
                                                id: 'fSubPlanLA',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtPacienteValido',
                                                id: 'fPacienteValido',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtYaLiquidado',
                                                id: 'fYaLiquidado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtYaLegalizado',
                                                id: 'fYaLegalizado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtYaRealizado',
                                                id: 'fYaRealizado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtYaFacturadoEnt',
                                                id: 'fYaFacturadoEnt',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Cliente',
                                        layout: 'table',
                                        width: 949,
                                        height: 82,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        id: 'fsCliente',
                                        layoutConfig: {
                                            columns: 4
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 271,
                                                border: false,
                                                id: 'pnCliete',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Cliente',
                                                        anchor: '100%',
                                                        name: 'cbCliente',
                                                        allowBlank: false,
                                                        store: 'StoreCliente',
                                                        displayField: 'Descripcion',
                                                        valueField: 'IdCliente',
                                                        emptyText: 'Selecione Cliente....',
                                                        mode: 'local',
                                                        forceSelection: true,
                                                        listWidth: 450,
                                                        typeAhead: true,
                                                        autoSelect: false,
                                                        typeAheadDelay: 50,
                                                        submitValue: true,
                                                        enableKeyEvents: true,
                                                        triggerAction: 'all',
                                                        ref: '../../../../../fCliente',
                                                        disabled: true,
                                                        id: 'fCliente'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 274,
                                                border: false,
                                                id: 'pnPlan',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Plan',
                                                        anchor: '100%',
                                                        name: 'cbPlan',
                                                        allowBlank: false,
                                                        mode: 'local',
                                                        store: 'StoreClientesPlan',
                                                        valueField: 'IdPlan',
                                                        displayField: 'Descripcion',
                                                        typeAhead: true,
                                                        triggerAction: 'all',
                                                        disabled: true,
                                                        typeAheadDelay: 50,
                                                        listWidth: 450,
                                                        emptyText: 'Selecione Plan....',
                                                        forceSelection: true,
                                                        ref: '../../../../../fPlan',
                                                        id: 'fPlan'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 215,
                                                border: false,
                                                id: 'pnSubplan',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Sub Plan',
                                                        anchor: '100%',
                                                        name: 'cbSubplan',
                                                        allowBlank: false,
                                                        disabled: true,
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        store: 'StoreClienteSubplan',
                                                        displayField: 'Descripcion',
                                                        valueField: 'IdSubPlan',
                                                        mode: 'local',
                                                        emptyText: 'Selecione Sub Plan....',
                                                        listWidth: 450,
                                                        forceSelection: true,
                                                        ref: '../../../../../fSubPlan',
                                                        id: 'fSubPlan'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                border: false,
                                                width: 172,
                                                id: 'pnContrato',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Contrato',
                                                        anchor: '100%',
                                                        name: 'cbContrato',
                                                        allowBlank: false,
                                                        disabled: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        store: 'StoreClienteContrato',
                                                        valueField: 'IdContrato',
                                                        displayField: 'Contrato',
                                                        mode: 'local',
                                                        listWidth: 450,
                                                        emptyText: 'Selecione Contrato....',
                                                        forceSelection: true,
                                                        ref: '../../../../../fContrato',
                                                        id: 'fContrato'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtUsaListado',
                                                ref: '../../../../fUsaListado',
                                                id: 'fUsaListado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtAtenderFueraListado',
                                                ref: '../../../../fAtenderFueraListado',
                                                id: 'fAtenderFueraListado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtRequiereAutorizacion',
                                                ref: '../../../../fRequiereAutorizacion',
                                                id: 'fRequiereAutorizacion',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtFacturarParticular',
                                                ref: '../../../../fFacturarParticular',
                                                id: 'fFacturarParticular',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtMaxCopago',
                                                ref: '../../../../fMaxCopago',
                                                id: 'fMaxCopago',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fFacturarCopagos',
                                                id: 'fFacturarCopagos',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fCopagoDigitado',
                                                id: 'fCopagoDigitado',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fvlrCuotaModeradoraIndicada',
                                                id: 'fvlrCuotaModeradoraIndicada',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'fPorCopagos',
                                                id: 'fPorCopagos',
                                                value: 0
                                            },
                                            {
                                                xtype: 'hidden',
                                                submitValue: false,
                                                name: 'txtUsaAuditoria',
                                                ref: '../../../../fUsaAuditoria',
                                                id: 'fUsaAuditoria',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Datos del Solicitante',
                                        layout: 'table',
                                        width: 949,
                                        height: 82,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        id: 'fsSolicitud',
                                        layoutConfig: {
                                            columns: 5
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 120,
                                                border: false,
                                                id: 'pnFecSol',
                                                items: [
                                                    {
                                                        xtype: 'datefield',
                                                        fieldLabel: 'Fecha Solicitud',
                                                        anchor: '100%',
                                                        name: 'txtFecSol',
                                                        allowBlank: false,
                                                        style: 'text-align:center;',
                                                        emptyText: '(dia/mes/año) ',
                                                        ref: '../../../../../fFecSol',
                                                        disabled: true,
                                                        id: 'fFecSol'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 274,
                                                border: false,
                                                colspan: 1,
                                                id: 'pnPrograma',
                                                items: [
                                                    {
                                                        xtype: 'combo',
                                                        fieldLabel: 'Programa y/o Tipo de Atención',
                                                        anchor: '100%',
                                                        name: 'cbPrograma',
                                                        allowBlank: false,
                                                        store: 'StorePrograma',
                                                        forceSelection: true,
                                                        triggerAction: 'all',
                                                        typeAhead: true,
                                                        typeAheadDelay: 50,
                                                        mode: 'local',
                                                        valueField: 'IdPrograma',
                                                        displayField: 'Descripcion',
                                                        emptyText: 'Seleccione Programa....',
                                                        submitValue: true,
                                                        ref: '../../../../../fPrograma',
                                                        disabled: true,
                                                        id: 'fPrograma'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 200,
                                                border: false,
                                                colspan: 1,
                                                iconCls: '',
                                                id: 'pnAutorizacion',
                                                items: [
                                                    {
                                                        xtype: 'textfield',
                                                        fieldLabel: 'Autorización',
                                                        anchor: '100%',
                                                        name: 'txtAutorizacion',
                                                        style: 'text-transform:uppercase;',
                                                        allowBlank: false,
                                                        disabled: true,
                                                        ref: '../../../../../fAutorizacion',
                                                        id: 'fAutorizacion'
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                border: false,
                                                width: 340,
                                                colspan: 2,
                                                id: 'pnProfesional',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Profesional / IPS  Solicitante',
                                                                name: 'cbProfeSol',
                                                                allowBlank: false,
                                                                store: 'StoreProfeSol',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                mode: 'local',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                emptyText: 'Seleccione Profesional / IPS Solicitante....',
                                                                valueField: 'idProfeSolicitante',
                                                                displayField: 'Descripcion',
                                                                width: 300,
                                                                listWidth: 450,
                                                                submitValue: true,
                                                                ref: '../../../../../fProfeSol',
                                                                disabled: true,
                                                                id: 'fProfeSol'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnDoctor',
                                                                tooltip: 'Adicionar Profesional / IPS Solicitante',
                                                                ref: '../../../../btnVerificaPacienteListado',
                                                                id: 'btnAddProfeSol'
                                                            }
                                                        ]
                                                    }
                                                 ]
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtFinalidad',
                                                ref: '../../../../fFinalidad',
                                                id: 'fFinalidad',
                                                value: '10'
                                            },
                                            {
                                                xtype: 'hidden',
                                                name: 'txtExento',
                                                ref: '../../../../fExentoPrograma',
                                                id: 'fExentoPrograma',
                                                value: 0
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'hidden',
                                        name: 'txtCas',
                                        id: 'fCas',
                                        value: 0
                                    },
                                    {
                                        xtype: 'hidden',
                                        name: 'txtCas',
                                        id: 'fModificaCAS',
                                        value: 0
                                    }
                                ],
                                tbar: {
                                    xtype: 'toolbar',
                                    id: 'tbarRadica',
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Guardar Datos Básicos del Servicio',
                                            iconCls: 'btnGuardar',
                                            ref: '../../../../btnRadicar',
                                            id: 'btnRadicar'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imprimir Prefactura',
                                            iconCls: 'btnImprimir',
                                            listeners: {
                                                click: function(){
                                                    if(parseInt(Ext.getCmp('fCas').getValue()) !== 0 && (parseInt(Ext.getCmp('fYaFacturadoEnt').getValue()) === 0 || Ext.getCmp('fYaFacturadoEnt').getValue() === "0" || Ext.getCmp('fYaFacturadoEnt').getValue() === null || Ext.getCmp('fYaFacturadoEnt').getValue() === "")){
                                                        window.open('../../../app/controlador/facturacion/infprefacturaxcas.php?pCAS='+Ext.getCmp('fCas').getValue(),"PREFACTURA");
                                                    }else{
                                                        Ext.MessageBox.show({
                                                            title: 'OfiClinic',
                                                            msg: 'Este Servicio no esta disponible para imprimir la prefactura.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                }
                            }
                        ]
                    },
                    //aqui
                    {
                        xtype: 'panel',
                        title: 'Resumen HC',
                        ref: '../fichaResumenHC',
                        id: 'fichaResumenHC',
                        frame: true,
                        items: [
                            {
                                xtype: 'form',
                                title: '',
                                border: false,
                                padding: 5,
                                width: 1046,
                                ref: '../../frmResumenHC',
                                id: 'frmResumenHC',
                                frame: true,
                                items: [
                                    {
                                        xtype: 'fieldset',
                                        title: 'Resumen HC',
                                        layout: 'table',
                                        width: 949,
                                        height: 394,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        padding: 5,
                                        id: 'fsResumenHC',
                                        layoutConfig: {
                                            columns: 1
                                        },
                                        items: [
                                            {
                                                xtype: 'textarea',
                                                name: 'txtResumenHC',
                                                allowBlank: false,
                                                width: 922,
                                                height: 314,
                                                style: 'text-transform:uppercase;',
                                                ref: '../../../../fResumenHC',
                                                id: 'fResumenHC'
                                            }/*,
                                            {
                                                xtype: 'button',
                                                text: 'Gestor de Archivos Adjuntos',
                                                width: 90,
                                                tooltip: 'Cargar y Visualizar archivos adjuntos a la redicación de servicios',
                                                iconCls: 'btnCargarFile',
                                                style: '',
                                                cls: '',
                                                ref: '../../../../btnCargarFile',
                                                id: 'btnCargarFile'
                                            }*/
                                        ]
                                    },
                                    {
                                        xtype: 'fieldset',
                                        title: 'Diagnósticos',
                                        layout: 'table',
                                        width: 949,
                                        height: 82,
                                        collapseFirst: false,
                                        collapsible: true,
                                        animCollapse: true,
                                        titleCollapse: true,
                                        id: 'fsDiagnostico',
                                        layoutConfig: {
                                            columns: 3
                                        },
                                        items: [
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 335,
                                                border: false,
                                                id: 'pnPrincipal',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Diagnostico Principal',
                                                                anchor: '100%',
                                                                name: 'cbDiagPpal',
                                                                allowBlank: false,
                                                                store: 'StoreCIE10',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Diagnostico....',
                                                                submitValue: true,
                                                                ref: '../../../../../fDiagPpal',
                                                                id: 'fDiagPpal'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Principal',
                                                                ref: '../../../../btnSearchDiagPpal',
                                                                id: 'btnSearchDiagPpal'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 335,
                                                border: false,
                                                id: 'pnRel1',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Diagnostico Relacionado1',
                                                                anchor: '100%',
                                                                name: 'cbDiagRel1',
                                                                allowBlank: true,
                                                                store: 'StoreCIE10',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Diagnostico....',
                                                                submitValue: true,
                                                                ref: '../../../../../fDiagRel1',
                                                                id: 'fDiagRel1'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado1',
                                                                ref: '../../../../btnSearchDiagRel1',
                                                                id: 'btnSearchDiagRel1'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            },
                                            {
                                                xtype: 'panel',
                                                title: '',
                                                layout: 'form',
                                                labelAlign: 'top',
                                                padding: 5,
                                                width: 335,
                                                border: false,
                                                id: 'pnRel2',
                                                items: [
                                                    {
                                                        xtype: 'compositefield',
                                                        items: [
                                                            {
                                                                xtype: 'combo',
                                                                fieldLabel: 'Diagnostico Relacionado2',
                                                                anchor: '100%',
                                                                name: 'cbDiagRel2',
                                                                allowBlank: true,
                                                                store: 'StoreCIE10',
                                                                forceSelection: true,
                                                                triggerAction: 'all',
                                                                typeAhead: true,
                                                                typeAheadDelay: 50,
                                                                mode: 'local',
                                                                valueField: 'Codigo',
                                                                displayField: 'Descripcion',
                                                                emptyText: 'Seleccione Diagnostico....',
                                                                submitValue: true,
                                                                ref: '../../../../../fDiagRel2',
                                                                id: 'fDiagRel2'
                                                            },
                                                            {
                                                                xtype: 'button',
                                                                iconCls: 'btnBuscar',
                                                                tooltip: 'Buscar Diagnostico Relacionado2',
                                                                ref: '../../../../btnSearchDiagRel2',
                                                                id: 'btnSearchDiagRel2'
                                                            }
                                                        ]
                                                    }
                                                ]
                                            }
                                        ]
                                    }
                                ]
                            }
                        ],
                        tbar: {
                            xtype: 'toolbar',
                            items: [
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Guardar Resumen HC',
                                    iconCls: 'btnGuardar',
                                    ref: '../../../btnResumenHC',
                                    id: 'btnResumenHC'
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        }
                    },
                    {
                        xtype: 'panel',
                        title: 'Conceptos Solicitados',
                        layout: 'vbox',
                        frame: true,
                        width: 704,
                        height: 403,
                        ref: '../fichaServicios',
                        id: 'fichaServicios',
                        layoutConfig: {
                            align: 'stretch'
                        },
                        items: [
                            {
                                xtype: 'grid',
                                title: '',
                                store: 'StoreSolServicios',
                                height: 175,
                                flex: 1,
                                id: 'gridServicios',
                                tbar: {
                                    xtype: 'toolbar',
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Adicionar',
                                            iconCls: 'btnAddRow',
                                            ref: '../../../../btnAddServicio',
                                            id: 'btnAddServicio'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Modificar',
                                            iconCls: 'btnEditRow',
                                            ref: '../../../../btnEditServicio',
                                            id: 'btnEditServicio'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Eliminar',
                                            iconCls: 'btnDelRow',
                                            ref: '../../../../btnDelServicio',
                                            id: 'btnDelServicio'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        }
                                    ]
                                },
                                columns: [
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Codigo',
                                        sortable: true,
                                        width: 100,
                                        dataIndex: 'Codigo'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Descripción',
                                        sortable: true,
                                        width: 730,
                                        dataIndex: 'Descripcion'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Estado',
                                        sortable: true,
                                        width: 125,
                                        dataIndex: 'Estado'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: 'Información Detallada del Servicio',
                                flex: 1,
                                tpl: [
                                    '<tpl if="TipoRegistroDetalle==\'LaboAnatomopatologia\'">',
                                    '<table border="0" width="870">',
                                    '<tr><td colspan="2" class="ServicioEstado">{DescripcionExamen}&nbsp;&nbsp;-&nbsp;&nbsp;[{PrefijoNroEstudio}-{SubNroEstudioINT}]</td></tr><tr><td colspan="2"></td></tr>',
                                    '<tr><td width="150" class="ServicioID">Codigo:</td><td class="ServicioID">{Codigo}</td></tr><tr><td ',
                                    'class="ServicioID">Descripcion:</td><td class="ServicioID">{Descripcion}</td></tr><tr><td class="ServicioVLR">CANTIDAD: {Cantidad}</td><td class="ServicioVLR">Vlr ',
                                    'Tarifa: ${VlrTarifa}&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;&nbsp;Vlr Cuota Moderadora: ${VlrCuotaModeradora}&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;&nbsp;Vlr ',
                                    'Copago: ${VlrCopago}&nbsp;&nbsp;-&nbsp;&nbspIVA: ${IVA}&nbsp;&nbsp;-&nbsp;&nbspNeto: ${VlrNeto}</td></tr>',
                                    '<tr><td class="ServicioID">Miembro/Parte: </td><td>{DescripcionMiembroParte}</td></tr>',
                                    '<tr><td class="ServicioID">Prioridad: </td><td>{Prioridad}</td></tr>',
                                    '<tr><td class="ServicioID">Nro Muestras: </td><td>Placas:&nbsp;{Recip_NroPlaca}&nbsp;&nbsp;-Frascos:&nbsp;{Recip_NroFrasco}&nbsp;&nbsp;-Bolsas:&nbsp;{Recip_NroBolsa}&nbsp;&nbsp;-Otros:&nbsp;{Recip_NroOtro}</td></tr>',
                                    '<tr><td class="ServicioID">Criterio Calidad: </td><td>{CriteriosCalidad}</td></tr>',
                                    '<tr><td class="ServicioID">Observaciones: </td><td>{Observaciones}</td></tr>',
                                    '</table>',
                                    '</tpl>',
                                    '<tpl if="TipoRegistroDetalle==\'\'">',
                                    '<table border="0" width="870"><tr><td colspan="2" class="ServicioEstado"><img src = "../../../resources/botones/{Estado}.png" style="float: rigth"/>&nbsp;&nbsp;',
                                    '{Estado}</td></tr><tr><td colspan="2"></td></tr><tr><td width="150" class="ServicioID">Codigo:</td><td class="ServicioID">{Codigo}</td></tr><tr><td ',
                                    'class="ServicioID">Descripcion:</td><td class="ServicioID">{Descripcion}</td></tr><tr><td class="ServicioVLR">CANTIDAD: {Cantidad}</td><td class="ServicioVLR">Vlr ',
                                    'Tarifa: ${VlrTarifa}&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;&nbsp;Vlr Cuota Moderadora: ${VlrCuotaModeradora}&nbsp;&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;&nbsp;Vlr ',
                                    'Copago: ${VlrCopago}&nbsp;&nbsp;-&nbsp;&nbspIVA: ${IVA}&nbsp;&nbsp;-&nbsp;&nbspNeto: ${VlrNeto}</td></tr> <tr><td class="ServicioAuditor">Tipo Auditoria:</td><td class="ServicioAuditor">{TipoAuditoria}</td></tr><tr><td ',
                                    'class="ServicioAuditor">Auditor:</td><td class="ServicioAuditor">{Auditor}</td></tr><tr><td class="ServicioAuditor">Fecha Auditoria:</td><td class="ServicioAuditor">{FecAuditoria}',
                                    '</td></tr><tr><td class="ServicioTitObserva">OBSERVACIONES: </td><td class="ServicioObserva">{Observaciones}</td></tr></table><hr><table border="0" width="870">',
                                    '<tr><td class="ServicioProveedor">PROVEEDOR: {nomProveedor}</td></tr>',
                                    '<tr><td class="ServicioTitObserva">Organo: {nomOrganoProveedor}</td></tr>',
                                    '<tr><td class="ServicioTitObserva">Observaciones: {NotasProveedor}</td></tr>',
                                    '<tr><td class="ServicioTitObserva">Fec. Programación: {FecProgramacionProveedor}</td></tr>',
                                    '<tr><td class="ServicioTitObserva">Fec. Realización: {FechaRealizado}</td></tr>',
                                    '</table>',
                                    '</tpl>'
                                ],
                                padding: 10,
                                height: 315,
                                autoScroll: true,
                                ref: '../../pnDetalleServicio',
                                id: 'pnDetalleServicio'
                            }
                        ]
                    },
                    {
                        xtype: 'panel',
                        title: 'Legalizar',
                        ref: '../fichaLegalizar',
                        id: 'fichaLegalizar',
                        width: 704,
                        height: 403,
                        frame: true,
                        items: [
                            {
                                xtype: 'form',
                                title: '',
                                border: false,
                                id: 'frmLegalizar',
                                frame: true,
                                layout: 'table',
                                layoutConfig: {
                                    columns: 3
                                },
                                items: [
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 340,
                                        padding: 40,
                                        items: [
                                            {
                                                xtype: 'numericfield',
                                                currencySymbol: "$",
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: true,
                                                thousandSeparator: ',',
                                                minValue: 0,
                                                fieldLabel: 'Vlr Total',
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                readOnly: true,
                                                value: 0,
                                                id: 'sysVlrTotal_estudios'
                                            },
                                            {
                                                xtype: 'numericfield',
                                                currencySymbol: "$",
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: true,
                                                thousandSeparator: ',',
                                                minValue: 0,
                                                fieldLabel: 'Vlr IVA',
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                readOnly: true,
                                                labelStyle: '',
                                                value: 0,
                                                id: 'sysVlrIVA_estudios'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 300,
                                        padding: 20,
                                        items: [
                                            {
                                                xtype: 'numericfield',
                                                currencySymbol: "$",
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: true,
                                                thousandSeparator: ',',
                                                minValue: 0,
                                                fieldLabel: 'Vlr Cuota Modera.',
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                readOnly: true,
                                                labelStyle: '',
                                                value: 0,
                                                id: 'sysVlrCM_estudios'
                                            },
                                            {
                                                xtype: 'numericfield',
                                                currencySymbol: "$",
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: true,
                                                thousandSeparator: ',',
                                                minValue: 0,
                                                fieldLabel: 'Vlr Copago',
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                readOnly: true,
                                                labelStyle: '',
                                                value: 0,
                                                id: 'sysVlrCopago_estudios'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'panel',
                                        layout: 'form',
                                        width: 300,
                                        padding: 20,
                                        items: [
                                            {
                                                xtype: 'numericfield',
                                                currencySymbol: "$",
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: true,
                                                thousandSeparator: ',',
                                                minValue: 0,
                                                fieldLabel: 'Vlr Descuentos',
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                readOnly: true,
                                                value: 0,
                                                id: 'sysVlrDescuentos_estudios'
                                            },
                                            {
                                                xtype: 'numericfield',
                                                currencySymbol: "$",
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: true,
                                                thousandSeparator: ',',
                                                fieldLabel: 'Vlr Neto',
                                                decimalPrecision: 2,
                                                allowBlank: true,
                                                readOnly: true,
                                                labelStyle: '',
                                                value: 0,
                                                id: 'sysVlrNeto_estudios'
                                            }
                                        ]
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                layout: 'form',
                                title: 'Información de la Legalización',
                                anchor: '100%',
                                border: false,
                                frame: true,
                                padding: 10,
                                items: [
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: 'Tipo Legalización',
                                        allowBlank: true,
                                        readOnly: true,
                                        anchor: '100%',
                                        id: 'sysTipoLegalizacion_estudios'
                                    },
                                    {
                                        xtype: 'textfield',
                                        fieldLabel: 'Responsable',
                                        allowBlank: true,
                                        readOnly: true,
                                        anchor: '100%',
                                        id: 'sysResponsableLegalizacion_estudios'
                                    }
                                ]
                            },
                            {
                                xtype: 'grid',
                                title: '',
                                store: 'StoreLegalizacionesxCAS',
                                height: 235,
                                border: true,
                                id: 'gridFacturacionOrden',
                                tbar: {
                                    xtype: 'toolbar',
                                    items: [
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Anular Documento',
                                            iconCls: 'btnCancelar',
                                            id: 'btnAnularDocumentoFac'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'tbfill'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                        {
                                            xtype: 'button',
                                            text: 'Imprimir Documento',
                                            iconCls: 'btnImprimir',
                                            id: 'btnImprimirDocumentoFac'
                                        },
                                        {
                                            xtype: 'tbseparator'
                                        },
                                    ]
                                },
                                columns: [
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Fecha',
                                        sortable: true,
                                        width: 100,
                                        dataIndex: 'FechaMov'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Prefijo',
                                        sortable: true,
                                        width: 70,
                                        dataIndex: 'Prefijo',
                                        align: 'center'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'NroDocumento',
                                        sortable: true,
                                        width: 125,
                                        dataIndex: 'NroDocumento',
                                        align: 'center'
                                    },
                                    {
                                        //type: 'gridcolumn',
                                        header: 'Debito',
                                        sortable: true,
                                        width: 180,
                                        renderer:  Ext.util.Format.Currency,
                                        dataIndex: 'Debito',
                                        align: 'right'
                                        //summaryType: 'sum'
                                    },
                                    {
                                        xtype: 'gridcolumn',
                                        header: 'Credito',
                                        sortable: true,
                                        width: 180,
                                        renderer:  Ext.util.Format.Currency,
                                        dataIndex: 'Credito',
                                        align: 'right'
                                    }
                                    
                                ]
                            }
                        ],
                        //plugins: new Ext.ux.GridTotals(),
                        tbar: 
                            {
                                xtype: 'toolbar',
                                width: 900,
                                items: [
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    {
                                        xtype: 'button',
                                        text: 'Liquidar Orden de Sevicio',
                                        iconCls: 'btnLiquidar',
                                        id: 'btnLiquidarOrden'
                                    },
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    {
                                        xtype: 'button',
                                        text: 'Legalizar',
                                        iconCls: 'btnLegalizar',
                                        id: 'btnLegalizarOrden'
                                    },
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    {
                                        xtype: 'button',
                                        text: 'Anular Legalización Exenta',
                                        iconCls: 'btnCancelar',
                                        id: 'btnAnularExcenta'
                                    },
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    {
                                        html: '-->'
                                    },
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    {
                                        html: 'Fec.Factura:'
                                    },
                                    {
                                        xtype: 'datefield',
                                        width: 95,
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año)',
                                        id: 'btnFacturaFacturacion'
                                    },
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    {
                                        xtype: 'button',
                                        text: 'Generar Factura por Paciente',
                                        iconCls: 'btnReport',
                                        id: 'btnFacturaxPaciente'
                                    },
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    '->',
                                    {
                                        xtype: 'tbseparator'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnCitasLegalizacion',
                                        text: 'Ver Historial Legalizaciones',
                                        tooltip: 'Ver Historial de Legalizadas por Paciente',
                                        id: 'btnHistorialLegalizaciones_citas1'
                                    }
                                ]
                            }
                    }

                    // termina
                ]
            }
        ];
        this.tbar = {
            xtype: 'toolbar',
            id: 'tbar',
            items: [
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Nuevo',
                    iconCls: 'btnNuevo',
                    ref: '../btnNuevo',
                    id: 'btnNuevo'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Buscar',
                    iconCls: 'btnBuscar',
                    ref: '../btnBuscarRadica',
                    id: 'btnBuscarRadica'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Borar',
                    iconCls: 'btnBorrar',
                    id: 'btnBorrarCAS'
                },
                {
                    xtype: 'tbseparator'
                },
                /*,
                {
                    xtype: 'button',
                    text: 'Anular',
                    iconCls: 'btnAnular',
                    ref: '../btnAnular',
                    id: 'btnAnular'
                },
                {
                    xtype: 'button',
                    text: 'Duplicar',
                    iconCls: 'btnDuplicar',
                    ref: '../btnDuplicar',
                    id: 'btnDuplicar'
                }*/
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'textfield',
                    value: '',
                    width: 110,
                    readOnly: true,
                    name: 'sysTextoEliminado',
                    style: 'background:transparent;color: darkred; font-size: large; font-weight: bold;border:none;',
                    id: 'sysTextoEliminado',
                    listeners:{
                        render: function( p ) {
                            p.getEl().on('dblclick', function (){
                                var winBorrarCAS = new winBorrarCASUi();
                                Ext.getCmp('sysBorraEmpresa').setValue(ID_EMPRESA);
                                Ext.getCmp('sysBorraIPS').setValue(ID_IPS);
                                Ext.getCmp('sysBorraUsuario').setValue(ID_USUARIO);
                                Ext.getCmp('sysBorraCAS').setValue(Ext.getCmp('fCas').getValue());
                                Ext.getCmp('sysProcesoCAS').setValue("BITACORA_CAS");
                                winBorrarCAS.title = "eOfiClinic .:: Bitacora Orden Servicios - CAS ::.";
                                Ext.getCmp('btnProcesoCAS').setVisible(false);
                                Ext.getCmp('strBorraMotivo').readOnly = true;
                                winBorrarCAS.show();
                            });
                        }
                    }
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Reactivar CAS',
                    iconCls: 'btnAceptar',
                    id: 'btnReactivarCAS'
                },        
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sin Registrar',
                    name: 'txtNroCAS',
                    style: 'color: darkblue; font-size: large; font-weight: bold;',
                    ref: '../fNroCAS',
                    id: 'fNroCAS',
                    listeners:{
                        render: function( p ) {
                            p.getEl().on('dblclick', function (){
                                var winVerInfoCAS = new winVerInfoCASUi();
                                winVerInfoCAS.title = "eOfiClinic .:: Informacion Orden Servicios - CAS ::.";
                                Ext.getCmp('sysInfoCAS').setValue(Ext.getCmp('fCas').getValue());
                                winVerInfoCAS.show();
                            });
                        }
                    }
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    name: 'txtFecRadicado',
                    style: 'color: darkblue; font-size: 13px; font-weight: bold;',
                    ref: '../fFecRadicado',
                    id: 'fFecRadicado'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    name: 'txtEstadoCAS',
                    style: 'color: red; font-size: 13px; font-weight: bold;text-decoration: blink;',
                    ref: '../fEstadoCAS',
                    id: 'fEstadoCAS'
                }
            ]
        };
        this.bbar = {
            xtype: 'toolbar',
            id: 'bbar',
            items: [
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnAyuda',
                    tooltip: 'Ver Ayuda en Linea',
                    ref: '../btnAyuda',
                    id: 'btnAyuda'
                },
                {
                    xtype: 'tbfill'
                },
                {
                    xtype: 'displayfield',
                    value: 'Empresa: PASBISALUD IPS',
                    name: 'txtNomEmpresa',
                    ref: '../fNomEmpresa',
                    id: 'fNomEmpresa'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'Sede: MANIZALES',
                    name: 'txtNomSede',
                    ref: '../fNomSede',
                    id: 'fNomSede'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'displayfield',
                    value: 'IPS: BELEN',
                    name: 'txtNomSede',
                    ref: '../fNomIPS',
                    id: 'fNomIPS'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: '',
                    iconCls: 'btnUsr',
                    ref: '../btnUsr',
                    id: 'btnUsr'
                },
                {
                    xtype: 'displayfield',
                    value: 'Usuario: GJUAN ',
                    name: 'txtNomUSR',
                    style: 'color:royalblue',
                    ref: '../fNomUSR',
                    id: 'fNomUSR'
                },
                {
                    xtype: 'tbseparator'
                },
                {
                    xtype: 'button',
                    text: 'Salir',
                    iconCls: 'btnSalir',
                    ref: '../btnSalir',
                    id: 'btnSalir'
                }
            ]
        };
        winRadicacionServiciosUi.superclass.initComponent.call(this);
    }
});
