/*
* @category    Formulario RIPS Recien Nacido
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar Galeano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winRIPSRecienNacido001Ui = Ext.extend(Ext.Window, {
    title: 'eOfiClinic ©  .:: RIPS AN ::.',
    width: 927,
    autoHeight: true, //670,
    autoScroll: true,
    closable: true,
    resizable: false,
    draggable: false,
    modal: true,
    id: 'winRIPSAN',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmRIPSANIngreso',
                padding: 2,
                labelSeparator: '',
                border: false,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'fieldset',
                        title: 'DATOS DEL RECIEN NACIDO',
                        collapseFirst: false,
                        collapsible: true,
                        animCollapse: true,
                        titleCollapse: true,
                        anchor: '100%',
                        autoHeight: true,
                        tbar:{
                            items: [
                                {
                                    xtype: 'tbfill'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    text: 'Guardar',
                                    iconCls: 'btnGuardar',
                                    listeners:{
                                        click : function(){
                                            Ext.Msg.show({
                                                title: 'eOfiClinic',
                                                msg: 'Esta seguro que desea Guardar los datos del Ingreso del RIPS?',
                                                buttons: Ext.Msg.YESNO,
                                                icon: Ext.Msg.QUESTION,
                                                fn: function(btn){
                                                    if(btn === "yes"){
                                                        fnGuardarRegistrosRIPSAN();
                                                    }
                                                }
                                            });
                                        }
                                    }
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        },
                        items: [
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                value: 0,
                                id: 'sysYaGuardoRIPSAN'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                fieldLabel: 'Usuario',
                                id: 'sysUsuarioRIPSAN'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 130,
                                        allowBlank: true,
                                        readOnly: true,
                                        fieldLabel: 'CAS',
                                        id: 'sysCASRIPSAN'
                                    },
                                    {
                                        html: 'Paciente:'
                                    },
                                    {
                                        xtype: 'textfield',
                                        width: 575,
                                        allowBlank: true,
                                        readOnly: true,
                                        //fieldLabel: 'Paciente',
                                        //value: 'CC 792558261  - JORGE GALEANO RUIZ - (Masculino) FechaNac: 1973-01-30, Edad 38 Años',
                                        id: 'sysPacienteRIPSAN'
                                    }
                                ]
                            },
                            {
                                html: '<hr>',
                                style: 'background:transparent;',
                                border: false
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        fieldLabel: 'Fecha Nacimiento',
                                        name: 'Fecha Nacimiento',
                                        allowBlank: false,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecFechaNacimiento'
                                    },
                                    {
                                        html: 'Hora'
                                    },
                                    {
                                        xtype: 'timefield',
                                        width: 95,
                                        allowBlank: false,
                                        forceSelection: false,
                                        emptyText: '(hh:mm)',
                                        format: 'H:i',
                                        altFormats:'H:i',
                                        id: 'strHoraIngresoRIPSAU'
                                    },
                                    {
                                        html: 'Edad Gest:'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 50,
                                        name: 'Edad Gestacional',
                                        minValue: 1,
                                        maxValue: 50,
                                        allowBlank: false,
                                        style: 'text-align:center;',
                                        id: 'intEdadGestacional'
                                    },
                                    {
                                        html: 'Control PN:'
                                    },
                                    {
                                        xtype: 'combo',
                                        name: 'Control Prenatal',
                                        width: 60,
                                        allowBlank: false,
                                        store: 'StoreSiNo',
                                        valueField: 'Descripcion',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'strControlPrenatal'
                                    },
                                    {
                                        html: 'Genero'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 90,
                                        name: 'Genero',
                                        allowBlank: false,
                                        store: 'StoreGenero',
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        triggerAction: 'all',
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        mode: 'local',
                                        emptyText: 'Seleccione Genero....',
                                        forceSelection: true,
                                        id: 'strSexo'
                                    },
                                    {
                                        html: 'Peso (gr)'
                                    },
                                    {
                                        xtype: 'numberfield',
                                        width: 50,
                                        name: 'Peso (gr)',
                                        minValue: 1,
                                        allowBlank: false,
                                        style: 'text-align:center;',
                                        id: 'intPeso'
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: false,
                                        fieldLabel: 'Diagnostico Recien Nacido',
                                        name: 'Diagnostico Recien Nacido',
                                        id: 'strDiagRN',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB){
                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagRN').setValue(null);
                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagRN').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagRN').setValue(null);
                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagRN').setValue(null);
                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                    }
                                                }
                                            },
                                            blur: function(t){
                                                if(Ext.getCmp('sysDiagPpalHCNom').getValue() === null || Ext.getCmp('sysDiagPpalHCNom').getValue() === ""){
                                                    if (Ext.getCmp('strDiagRN').getValue() !== "" && Ext.getCmp('strDiagRN').getValue() !== null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagRN').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagRN').setValue(null);
                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagRN').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagRN').setValue(null);
                                                                Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagRN').setValue(null);
                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 625,
                                        height: 22,
                                        id: 'sysDiagPpalHCNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Principal',
                                        id: 'btnSearchDiagPpalHC',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('strDiagRN','sysDiagPpalHCNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 96,
                                        allowBlank: true,
                                        fieldLabel: 'Diagnostico Causa Muerte',
                                        name: 'Diagnostico Causa Muerte',
                                        id: 'strDiagCM',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB)
                                                {
                                                    if (f.getValue() !== "" && f.getValue() !== null && f.getValue().toUpperCase()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: f.getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagCM').setValue(null);
                                                                    Ext.getCmp('sysDiagCMHCNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagCM').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagCMHCNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagCM').setValue(null);
                                                                Ext.getCmp('sysDiagCMHCNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagCM').setValue(null);
                                                        Ext.getCmp('sysDiagCMHCNom').setValue(null);
                                                    }
                                                }
                                            },
                                            blur: function(t){
                                                if(Ext.getCmp('sysDiagCMHCNom').getValue() === null || Ext.getCmp('sysDiagCMHCNom').getValue() === "")
                                                {
                                                    if (Ext.getCmp('strDiagCM').getValue() !== "" && Ext.getCmp('strDiagCM').getValue() !== null && Ext.getCmp('strDiagCM').getValue().toUpperCase()){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagCM').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                                                                    Ext.getCmp('strDiagCM').setValue(null);
                                                                    Ext.getCmp('sysDiagCMHCNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagCM').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagCMHCNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagCM').setValue(null);
                                                                Ext.getCmp('sysDiagCMHCNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagCM').setValue(null);
                                                        Ext.getCmp('sysDiagCMHCNom').setValue(null);
                                                    }
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 620,
                                        height: 22,
                                        id: 'sysDiagCMHCNom'
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Diagnostico Principal',
                                        id: 'btnSearchDiagPpalHC',
                                        listeners:{
                                            click : function(){
                                                buscarcie10('strDiagCM','sysDiagCMHCNom');
                                            }
                                        }
                                    }
                                ]
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'datefield',
                                        width: 120,
                                        fieldLabel: 'Fecha Muerte',
                                        name: 'Fecha Muerte',
                                        allowBlank: true,
                                        emptyText: '(dia/mes/año) ',
                                        style: 'text-align:center;',
                                        id: 'fecFechaMuerte'
                                    },
                                    {
                                        html: 'Hora'
                                    },
                                    {
                                        xtype: 'timefield',
                                        width: 95,
                                        allowBlank: true,
                                        forceSelection: false,
                                        emptyText: '(hh:mm)',
                                        format: 'H:i',
                                        altFormats:'H:i',
                                        id: 'strHoraMuerte'
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
        this.on({
            afterlayout:{scope:this, single:true, fn:function() {
                Ext.Msg.hide();
                Ext.Ajax.request({
                    url: '../../controlador/asistencial/evolucionhc2013.php',
                    waitMsg: 'Cargando Información...',
                    params:{
                        task: 'RIPSAN_INGRESO_LOAD',
                        pCAS: Ext.getCmp('sysCASRIPSAN').getValue()
                    },
                    success: function(response,options){
                        var el = Ext.get('response'); // get the LOG
                        var Respuesta = response.responseText;
                        var Contenido = Respuesta.split('^');
                        if(Contenido[0] === "" || Contenido[0] === "{success:false}" || Contenido[0] === null){
                            // No Encontro Registros
                        } else {
                            if(Contenido[1] !== "" && Contenido[1] !== null)
                                Ext.getCmp('fecFechaNacimiento').setValue(Contenido[1]);
                            if(Contenido[2] !== "" && Contenido[2] !== null)
                                Ext.getCmp('strHoraIngresoRIPSAU').setValue(Contenido[2]);
                            if(Contenido[3] !== "" && Contenido[3] !== null)
                                Ext.getCmp('intEdadGestacional').setValue(Contenido[3]);
                            if(Contenido[4] !== "" && Contenido[4] !== null){
                                if(parseInt(Contenido[4]) === 1){
                                    Ext.getCmp('strControlPrenatal').setValue("SI");
                                }else{
                                    Ext.getCmp('strControlPrenatal').setValue("NO");
                                }
                            }
                            if(Contenido[5] !== "" && Contenido[5] !== null)
                                Ext.getCmp('strSexo').setValue(Contenido[5]);
                            if(Contenido[6] !== "" && Contenido[6] !== null)
                                Ext.getCmp('intPeso').setValue(Contenido[6]);
                            if(Contenido[7] !== "" && Contenido[7] !== null)
                                Ext.getCmp('strDiagRN').setValue(Contenido[7]);
                            if(Contenido[8] !== "" && Contenido[8] !== null)
                                Ext.getCmp('strDiagCM').setValue(Contenido[8]);
                            if(Contenido[9] !== "" && Contenido[9] !== null)
                                Ext.getCmp('fecFechaMuerte').setValue(Contenido[9]);
                            if(Contenido[10] !== "" && Contenido[10] !== null)
                                Ext.getCmp('strHoraMuerte').setValue(Contenido[10]);
                        }
                    },
                    failure: function(response,options){
                        var el = Ext.get('response');
                    },
                    scope: this 
                });
            }}
        });
        winRIPSRecienNacido001Ui.superclass.initComponent.call(this);
    }
});

function fnGuardarRegistrosRIPSAN(wOpcion){
    var frm = Ext.getCmp('frmRIPSANIngreso').getForm();
    var wTask = 'RIPSAN_INGRESO_GUARDAR';
    if (frm.isValid()){
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            url: '../../controlador/asistencial/evolucionhc2013.php',
            params:{
                task: wTask,
                CAMPOS: listacampos,
                pCAS: Ext.getCmp('sysCASRIPSAN').getValue(),
                pUsuario: Ext.getCmp('sysUsuarioRIPSAN').getValue()
            },
            success: function(res,req){
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}