/*
* @category    Funcion Adicionar / Editar Concepto
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
function AddEditConcepto(pOperacion, pCAS, wUsuario,wConsecutivoDetalle, widConcepto,wCodigo,wDescripcion,wCantidad,wVlrTarifa,wVlrTotal,wVlrCuotaModeradora,wVlrIVA,wVlrNeto, wVlrCopagos, wPorIVA, wPorAplicacion, wVlrDescuentos, wObservaciones, wTipoRegistroDetalle, wIdProveedor,wNotasProveedor,wFechaRealizado,wYaRealizado,wFecProgramacionProveedor,wFecProveedor,wHoraProgramacionProveedor,wYaProgramadoProveedor,wGenerarAutizacionProveedor,wnomProveedor,wYaFacturadoEnt,wNroFactura, wTarifaProveedor, wOrganoProveedor, wTipoRegProced, wDiagPpal, wNomDiagPpal, wDiagRel1, wNomDiagRel1, wDiagRel2, wNomDiagRel2, wDiagRel3, wNomDiagRel3, wTipDagnostico, wCausaExterna, wAmbito, wFinalidadConsulta, wFinalidad, wPersonaAtiende, wFormaActo){
    var AddEditConceptoUi = new Ext.Window({
        title: 'Radicación de Conceptos',
        //width: 1010,
        anchor: '100%',
        height: 510,
        modal: true,
        closable: false,
        resizable: false,
        draggable: false,
        frame: true,
        id: 'AddEditConcepto',
        items: [
        {
            xtype: 'form',
            anchor: '99%',
            height: 485,
            padding: 5,
            frame: true,
            autoScroll: true,
            layout: 'form',
            id: 'frmRadicaConceptos',
            items: [
                {
                    xtype: 'panel',
                    anchor: '98%',
                    autoHeight: true,
                    layout: {
                        columns: 2,
                        type: 'table'
                    },
                    items: [
                        {           
                            xtype: 'panel',
                            layout: 'form',
                            height: 220,
                            width: 670,
                            padding: 5,
                            id: 'pnDatosConcepto',
                            items:[
                                {
                                    xtype: 'compositefield',
                                    fieldLabel: 'Concepto',
                                    width: 540,
                                    id: 'cmpConceptos',
                                    items: [
                                        {
                                            xtype: 'button',
                                            iconCls: 'btnBuscar',
                                            tooltip: 'Buscar Concepto',
                                            id: 'btnSearchConcepto_conceptos',
                                            handler:function(){
                                                var UsaAuditoria = "NO";
                                                if(Ext.getCmp('fUsaAuditoria').getValue() == 1){
                                                    UsaAuditoria = "SI";
                                                }
                                                buscarconcepto('Radicacion', UsaAuditoria,'NO','NO','SI','gridServicios','Radicacion',Ext.getCmp('fCliente').getValue(), Ext.getCmp('fPlan').getValue(), Ext.getCmp('fSubPlan').getValue());
                                            }
                                        },
                                        {
                                            xtype: 'hidden',
                                            flex: 1,
                                            readOnly: true,
                                            width: 96,
                                            value: "add",
                                            id: 'sysOperacion_conceptos'
                                        },
                                        {
                                            xtype: 'hidden',
                                            flex: 1,
                                            readOnly: true,
                                            width: 96,
                                            value: 0,
                                            id: 'sysConsecutivo_conceptos'
                                        },
                                        {
                                            xtype: 'hidden',
                                            flex: 1,
                                            readOnly: true,
                                            width: 96,
                                            value: pCAS,
                                            id: 'intCAS_conceptos'
                                        },
                                        {
                                            xtype: 'hidden',
                                            flex: 1,
                                            readOnly: true,
                                            width: 96,
                                            id: 'intidConcepto_conceptos'
                                        },
                                        {
                                            xtype: 'textfield',
                                            flex: 1,
                                            readOnly: true,
                                            width: 96,
                                            allowBlank: false,
                                            style: 'color: #0000cc; font-weight: bold;',
                                            id: 'strCodConcepto_conceptos'
                                        },
                                        {
                                            xtype: 'textarea',
                                            flex: 1,
                                            readOnly: true,
                                            width: 400,
                                            height: 90,
                                            style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                            id: 'strDesConcepto_conceptos'
                                        }
                                    ]
                                },
                                {
                                    xtype: 'numberfield',
                                    minValue: 1,
                                    fieldLabel: 'Cantidad',
                                    decimalPrecision: 0,
                                    allowBlank: false,
                                    id: 'intCantidad_conceptos',
                                    listeners:
                                    {
                                        scope: this,
                                        specialkey: function(f,e)
                                        {
                                            if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                            {
                                                var vlr = (Ext.getCmp('intVlrUnitario_conceptos').getValue() * Ext.getCmp('intCantidad_conceptos').getValue());  
                                                Ext.getCmp('intVlrTotal_conceptos').setValue(vlr);
                                                var vlrneto = vlr + Ext.getCmp('intVlrIVA_conceptos').getValue() - Ext.getCmp('intVlrCM_conceptos').getValue() - Ext.getCmp('intVlrCopago_conceptos').getValue() - Ext.getCmp('intDescuentos_conceptos').getValue();
                                                Ext.getCmp('intVlrNeto_conceptos').setValue(vlrneto);
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'textarea',
                                    fieldLabel: 'Observaciones',
                                    width: 540,
                                    height: 50,
                                    emptyText: 'Observaciones',
                                    id: 'memObservaciones_conceptos'
                                }
                            ]
                        },
                        {           
                            xtype: 'panel',
                            layout: 'form',
                            height: 225,
                            width: 265,
                            padding: 5,
                            id: 'pnValorProced',
                            items:[
                                {
                                    xtype: 'numberfield',
                                    minValue: 1,
                                    fieldLabel: '% Aplicación',
                                    decimalPrecision: 2,
                                    allowBlank: false,
                                    readOnly: true,
                                    value: 100,
                                    id: 'intPorAplicacion_conceptos'
                                },
                                {
                                    xtype: 'numericfield',
                                    currencySymbol: "$",
                                    useThousandSeparator: true,
                                    alwaysDisplayDecimals: true,
                                    thousandSeparator: ',',
                                    minValue: 0,
                                    fieldLabel: 'Vlr Unitario',
                                    decimalPrecision: 2,
                                    allowBlank: false,
                                    readOnly: false,
                                    id: 'intVlrUnitario_conceptos',
                                    listeners: // arreglo temporal autonoma
                                    {
                                        scope: this,
                                        specialkey: function(f,e)
                                        {
                                            if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                            {
                                                var vlr = (Ext.getCmp('intVlrUnitario_conceptos').getValue() * Ext.getCmp('intCantidad_conceptos').getValue());
                                                Ext.getCmp('intVlrTotal_conceptos').setValue(vlr);
                                                var vlrneto = vlr + Ext.getCmp('intVlrIVA_conceptos').getValue() - Ext.getCmp('intVlrCM_conceptos').getValue() - Ext.getCmp('intVlrCopago_conceptos').getValue() - Ext.getCmp('intDescuentos_conceptos').getValue();
                                                Ext.getCmp('intVlrNeto_conceptos').setValue(vlrneto);
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'numericfield',
                                    currencySymbol: "$",
                                    useThousandSeparator: true,
                                    alwaysDisplayDecimals: true,
                                    thousandSeparator: ',',
                                    minValue: 0,
                                    fieldLabel: 'Vlr Total',
                                    decimalPrecision: 2,
                                    allowBlank: false,
                                    readOnly: true,
                                    id: 'intVlrTotal_conceptos'
                                },
                                {
                                    xtype: 'hidden',
                                    //minValue: 0,
                                    fieldLabel: 'PorIVA',
                                    //decimalPrecision: 2,
                                    allowBlank: true,
                                    readOnly: true,
                                    labelStyle: '',
                                    value: 0,
                                    id: 'intPorIVA_conceptos'
                                },
                                {
                                    xtype: 'numericfield',
                                    currencySymbol: "$",
                                    useThousandSeparator: true,
                                    alwaysDisplayDecimals: true,
                                    thousandSeparator: ',',
                                    minValue: 0,
                                    fieldLabel: 'Vlr IVA',
                                    decimalPrecision: 2,
                                    allowBlank: false,
                                    readOnly: true,
                                    labelStyle: '',
                                    value: 0,
                                    id: 'intVlrIVA_conceptos'
                                },
                                {
                                    xtype: 'numericfield',
                                    currencySymbol: "$",
                                    useThousandSeparator: true,
                                    alwaysDisplayDecimals: true,
                                    thousandSeparator: ',',
                                    minValue: 0,
                                    fieldLabel: 'Vlr Cuota Moderadora',
                                    decimalPrecision: 2,
                                    allowBlank: false,
                                    //readOnly: true,
                                    labelStyle: '',
                                    value: 0,
                                    id: 'intVlrCM_conceptos',
                                    listeners:
                                    {
                                        scope: this,
                                        specialkey: function(f,e)
                                        {
                                            if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                            {
                                                var vlr = f.getValue();  
                                                var vlrneto = Ext.getCmp('intVlrTotal_conceptos').getValue() + Ext.getCmp('intVlrIVA_conceptos').getValue() - vlr - Ext.getCmp('intVlrCopago_conceptos').getValue() - Ext.getCmp('intDescuentos_conceptos').getValue();
                                                Ext.getCmp('intVlrNeto_conceptos').setValue(vlrneto);
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'numericfield',
                                    currencySymbol: "$",
                                    useThousandSeparator: true,
                                    alwaysDisplayDecimals: true,
                                    thousandSeparator: ',',
                                    minValue: 0,
                                    fieldLabel: 'Vlr Copago',
                                    decimalPrecision: 2,
                                    allowBlank: false,
                                    //readOnly: true,
                                    labelStyle: '',
                                    value: 0,
                                    id: 'intVlrCopago_conceptos',
                                    listeners:
                                    {
                                        scope: this,
                                        specialkey: function(f,e)
                                        {
                                            if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                            {
                                                var vlr = f.getValue();  
                                                var vlrneto = Ext.getCmp('intVlrTotal_conceptos').getValue() + Ext.getCmp('intVlrIVA_conceptos').getValue() - vlr - Ext.getCmp('intVlrCM_conceptos').getValue() - Ext.getCmp('intDescuentos_conceptos').getValue();
                                                Ext.getCmp('intVlrNeto_conceptos').setValue(vlrneto);
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'numericfield',
                                    currencySymbol: "$",
                                    useThousandSeparator: true,
                                    alwaysDisplayDecimals: true,
                                    thousandSeparator: ',',
                                    minValue: 0,
                                    fieldLabel: 'Vlr Descuentos',
                                    decimalPrecision: 2,
                                    allowBlank: false,
                                    value: 0,
                                    id: 'intDescuentos_conceptos',
                                    listeners:
                                    {
                                        scope: this,
                                        specialkey: function(f,e)
                                        {
                                            if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                            {
                                                var vlr = f.getValue();  
                                                var vlrneto = Ext.getCmp('intVlrTotal_conceptos').getValue() + Ext.getCmp('intVlrIVA_conceptos').getValue() - vlr - Ext.getCmp('intVlrCM_conceptos').getValue() - Ext.getCmp('intVlrCopago_conceptos').getValue();
                                                Ext.getCmp('intVlrNeto_conceptos').setValue(vlrneto);
                                            }
                                        }
                                    }
                                },
                                {
                                    xtype: 'numericfield',
                                    currencySymbol: "$",
                                    useThousandSeparator: true,
                                    alwaysDisplayDecimals: true,
                                    thousandSeparator: ',',
                                    fieldLabel: 'Vlr Neto',
                                    decimalPrecision: 2,
                                    allowBlank: false,
                                    readOnly: true,
                                    labelStyle: '',
                                    value: 0,
                                    id: 'intVlrNeto_conceptos'
                                }
                            ]
                        }
                    ]
                },
                {
                    xtype: 'panel',
                    anchor: '98%',
                    padding: 5,
                    layout: 'form',
                    autoScroll: true,
                    id: 'pnFother',
                    autoHeight: true,
                    items: [
                        {
                            xtype: 'fieldset',
                            title: 'RIPS CONSULTAS - AC',
                            layout: 'form',
                            anchor: '100%',
                            autoHeight: true,
                            collapseFirst: false,
                            collapsible: true,
                            animCollapse: true,
                            titleCollapse: true,
                            id: 'fsRIPSAC',
                            items: [
                                {
                                    xtype: 'compositefield',
                                    style: 'background:transparent;',
                                    items: [
                                        {
                                            xtype: 'textfield',
                                            width: 96,
                                            allowBlank: true,
                                            fieldLabel: 'Diagnostico Principal',
                                            id: 'strDiagPpalHC',
                                            listeners:{
                                                specialkey: function(f,e){
                                                    if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                    {
                                                        if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel3HC').getValue()){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                params:{
                                                                    task: 'BUSCAR',
                                                                    pCodigo: f.getValue().toUpperCase()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var el = Ext.get('response'); // get the LOG
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                        Ext.getCmp('strDiagPpalHC').setValue(null);
                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                    } else {
                                                                        Ext.getCmp('strDiagPpalHC').setValue(Contenido[0]);
                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1]);
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    var el = Ext.get('response');
                                                                    Ext.getCmp('strDiagPpalHC').setValue(null);
                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }else{
                                                            Ext.getCmp('strDiagPpalHC').setValue(null);
                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                        }
                                                    }
                                                },
                                                blur: function(t){
                                                    //if(Ext.getCmp('sysDiagPpalHCNom').getValue()==null || Ext.getCmp('sysDiagPpalHCNom').getValue()== ""){
                                                        if (Ext.getCmp('sysDiagPpalHC').getValue() != "" && Ext.getCmp('sysDiagPpalHC').getValue() != null && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                params:{
                                                                    task: 'BUSCAR',
                                                                    pCodigo: Ext.getCmp('sysDiagPpalHC').getValue().toUpperCase()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var el = Ext.get('response'); // get the LOG
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                        Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                    } else {
                                                                        Ext.getCmp('sysDiagPpalHC').setValue(Contenido[0].toUpperCase());
                                                                        Ext.getCmp('sysDiagPpalHCNom').setValue(Contenido[1].toUpperCase());
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    var el = Ext.get('response');
                                                                    Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                                    Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }else{
                                                            Ext.getCmp('sysDiagPpalHC').setValue(null);
                                                            Ext.getCmp('sysDiagPpalHCNom').setValue(null);
                                                        }
                                                    //}
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'textarea',
                                            readOnly: true,
                                            width: 600,
                                            height: 22,
                                            id: 'sysDiagPpalHCNom'
                                        },
                                        {
                                            xtype: 'button',
                                            iconCls: 'btnBuscar',
                                            tooltip: 'Buscar Diagnostico Principal',
                                            id: 'btnSearchDiagPpalHC',
                                            listeners:{
                                                click : function(){
                                                    buscarcie10('strDiagPpalHC','sysDiagPpalHCNom');
                                                }
                                            }
                                        }
                                    ]
                                },
                                {
                                    xtype: 'compositefield',
                                    style: 'background:transparent;',
                                    items: [
                                        {
                                            xtype: 'textfield',
                                            width: 96,
                                            allowBlank: true,
                                            fieldLabel: 'Diagnostico Relacionado Nro.1',
                                            id: 'strDiagRel1HC',
                                            listeners:{
                                                specialkey: function(f,e){
                                                    if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                    {
                                                        if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('strDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel3HC').getValue()){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                params:{
                                                                    task: 'BUSCAR',
                                                                    pCodigo: f.getValue().toUpperCase()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var el = Ext.get('response'); // get the LOG
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                        Ext.getCmp('strDiagRel1HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                    } else {
                                                                        Ext.getCmp('strDiagRel1HC').setValue(Contenido[0]);
                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1]);
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    var el = Ext.get('response');
                                                                    Ext.getCmp('strDiagRel1HC').setValue(null);
                                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }else{
                                                            Ext.getCmp('strDiagRel1HC').setValue(null);
                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                        }
                                                    }
                                                },
                                                blur: function(t){
                                                    //if (Ext.getCmp('sysDiagRel1HCNom').getValue == null ||  Ext.getCmp('sysDiagRel1HCNom').getValue() == ""){
                                                        if (Ext.getCmp('sysDiagRel1HC').getValue() != "" && Ext.getCmp('sysDiagRel1HC').getValue() != null && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue() && Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                            Ext.Ajax.request(
                                                            {
                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                params:{
                                                                    task: 'BUSCAR',
                                                                    pCodigo: Ext.getCmp('sysDiagRel1HC').getValue().toUpperCase()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var el = Ext.get('response'); // get the LOG
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                        Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                    } else {
                                                                        Ext.getCmp('sysDiagRel1HC').setValue(Contenido[0].toUpperCase());
                                                                        Ext.getCmp('sysDiagRel1HCNom').setValue(Contenido[1].toUpperCase());
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    var el = Ext.get('response');
                                                                    Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                                    Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }else{
                                                            Ext.getCmp('sysDiagRel1HC').setValue(null);
                                                            Ext.getCmp('sysDiagRel1HCNom').setValue(null);
                                                        }
                                                    //}
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'textarea',
                                            readOnly: true,
                                            width: 600,
                                            height: 22,
                                            id: 'sysDiagRel1HCNom'
                                        },
                                        {
                                            xtype: 'button',
                                            iconCls: 'btnBuscar',
                                            tooltip: 'Buscar Diagnostico Relacionado1',
                                            id: 'btnSearchDiagRel1HC',
                                            listeners:{
                                                click : function(){
                                                    buscarcie10('strDiagRel1HC','sysDiagRel1HCNom');
                                                }
                                            }
                                        }
                                    ]
                                },
                                {
                                    xtype: 'compositefield',
                                    style: 'background:transparent;',
                                    items: [
                                        {
                                            xtype: 'textfield',
                                            width: 96,
                                            allowBlank: true,
                                            fieldLabel: 'Diagnostico Relacionado Nro.2',
                                            id: 'strDiagRel2HC',
                                            listeners:{
                                                specialkey: function(f,e){
                                                    if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                    {
                                                        if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('strDiagPpalHC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel3HC').getValue()){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                params:{
                                                                    task: 'BUSCAR',
                                                                    pCodigo: f.getValue().toUpperCase()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var el = Ext.get('response'); // get the LOG
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                        Ext.getCmp('strDiagRel2HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                    } else {
                                                                        Ext.getCmp('strDiagRel2HC').setValue(Contenido[0]);
                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1]);
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    var el = Ext.get('response');
                                                                    Ext.getCmp('strDiagRel2HC').setValue(null);
                                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }else{
                                                            Ext.getCmp('strDiagRel2HC').setValue(null);
                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                        }
                                                    }
                                                },
                                                blur: function(t){
                                                    //if (Ext.getCmp('sysDiagRel2HCNom').getValue == null || Ext.getCmp('sysDiagRel2HCNom').getValue() == ""){
                                                        if (Ext.getCmp('sysDiagRel2HC').getValue() != "" && Ext.getCmp('sysDiagRel2HC').getValue() != null && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel3HC').getValue()){
                                                            Ext.Ajax.request(
                                                            {
                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                params:{
                                                                    task: 'BUSCAR',
                                                                    pCodigo: Ext.getCmp('sysDiagRel2HC').getValue().toUpperCase()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var el = Ext.get('response'); // get the LOG
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                        Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                    } else {
                                                                        Ext.getCmp('sysDiagRel2HC').setValue(Contenido[0].toUpperCase());
                                                                        Ext.getCmp('sysDiagRel2HCNom').setValue(Contenido[1].toUpperCase());
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    var el = Ext.get('response');
                                                                    Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                                    Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }else{
                                                            Ext.getCmp('sysDiagRel2HC').setValue(null);
                                                            Ext.getCmp('sysDiagRel2HCNom').setValue(null);
                                                        }
                                                    //}
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'textarea',
                                            readOnly: true,
                                            width: 600,
                                            height: 22,
                                            id: 'sysDiagRel2HCNom'
                                        },
                                        {
                                            xtype: 'button',
                                            iconCls: 'btnBuscar',
                                            tooltip: 'Buscar Diagnostico Relacionado2',
                                            id: 'btnSearchDiagRel2HC1',
                                            listeners:{
                                                click : function(){
                                                    buscarcie10('strDiagRel2HC','sysDiagRel2HCNom');
                                                }
                                            }
                                        }
                                    ]
                                },
                                {
                                    xtype: 'compositefield',
                                    style: 'background:transparent;',
                                    items: [
                                        {
                                            xtype: 'textfield',
                                            width: 96,
                                            allowBlank: true,
                                            fieldLabel: 'Diagnostico Relacionado Nro.3',
                                            id: 'strDiagRel3HC',
                                            listeners:{
                                                specialkey: function(f,e){
                                                    if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                    {
                                                        if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel1HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel2HC').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagPpalHC').getValue()){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                params:{
                                                                    task: 'BUSCAR',
                                                                    pCodigo: f.getValue().toUpperCase()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var el = Ext.get('response'); // get the LOG
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                        Ext.getCmp('strDiagRel3HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                    } else {
                                                                        Ext.getCmp('strDiagRel3HC').setValue(Contenido[0]);
                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1]);
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    var el = Ext.get('response');
                                                                    Ext.getCmp('strDiagRel3HC').setValue(null);
                                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }else{
                                                            Ext.getCmp('strDiagRel3HC').setValue(null);
                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                        }
                                                    }
                                                },
                                                blur: function(t){
                                                    //if (Ext.getCmp('sysDiagRel3HCNom').getValue == null || Ext.getCmp('sysDiagRel3HCNom').getValue() == ""){
                                                        if (Ext.getCmp('sysDiagRel3HC').getValue() != "" && Ext.getCmp('sysDiagRel3HC').getValue() != null && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagPpalHC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel1HC').getValue() && Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase() != Ext.getCmp('sysDiagRel2HC').getValue()){
                                                            Ext.Ajax.request(
                                                            {
                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                params:{
                                                                    task: 'BUSCAR',
                                                                    pCodigo: Ext.getCmp('sysDiagRel3HC').getValue().toUpperCase()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var el = Ext.get('response'); // get the LOG
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                        Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                    } else {
                                                                        Ext.getCmp('sysDiagRel3HC').setValue(Contenido[0].toUpperCase());
                                                                        Ext.getCmp('sysDiagRel3HCNom').setValue(Contenido[1].toUpperCase());
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    var el = Ext.get('response');
                                                                    Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                                    Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }else{
                                                            Ext.getCmp('sysDiagRel3HC').setValue(null);
                                                            Ext.getCmp('sysDiagRel3HCNom').setValue(null);
                                                        }
                                                    //}
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'textarea',
                                            readOnly: true,
                                            width: 600,
                                            height: 22,
                                            id: 'sysDiagRel3HCNom'
                                        },
                                        {
                                            xtype: 'button',
                                            iconCls: 'btnBuscar',
                                            tooltip: 'Buscar Diagnostico Relacionado3',
                                            id: 'btnSearchDiagRel3HC',
                                            listeners:{
                                                click : function(){
                                                    buscarcie10('strDiagRel3HC','sysDiagRel3HCNom');
                                                }
                                            }
                                        }
                                    ]
                                },
                                {
                                    xtype: 'combo',
                                    fieldLabel: 'Tipo de Diagnostico',
                                    width:700,
                                    name: 'Tipo de Diagnostico',
                                    allowBlank: true,
                                    store: 'StoreTipoDiagnostico',
                                    forceSelection: true,
                                    triggerAction: 'all',
                                    typeAhead: true,
                                    typeAheadDelay: 50,
                                    mode: 'local',
                                    valueField: 'Codigo',
                                    displayField: 'Descripcion',
                                    emptyText: 'Seleccione....',
                                    submitValue: true,
                                    id: 'strTipoDiagosticoHC'
                                },
                                {
                                    xtype: 'combo',
                                    fieldLabel: 'Finalidad Consulta',
                                    width:700,
                                    name: 'Finalidad Consulta',
                                    allowBlank: true,
                                    store: 'StoreFinalidadConsulta',
                                    forceSelection: true,
                                    triggerAction: 'all',
                                    typeAhead: true,
                                    typeAheadDelay: 50,
                                    mode: 'local',
                                    valueField: 'Codigo',
                                    displayField: 'Descripcion',
                                    emptyText: 'Seleccione....',
                                    submitValue: true,
                                    //value: 10,
                                    id: 'strFinalidadConsultaHC'
                                },
                                {
                                    xtype: 'combo',
                                    fieldLabel: 'Causa Externa',
                                    width:700,
                                    name: 'Causa Externa',
                                    allowBlank: true,
                                    store: 'StoreCausaExterna',
                                    forceSelection: true,
                                    triggerAction: 'all',
                                    typeAhead: true,
                                    typeAheadDelay: 50,
                                    mode: 'local',
                                    valueField: 'Codigo',
                                    displayField: 'Descripcion',
                                    emptyText: 'Seleccione....',
                                    submitValue: true,
                                    //value: 13,
                                    id: 'strCausaExternaHC'
                                }
                            ]
                        },
                        {
                            xtype: 'fieldset',
                            title: 'RIPS PROCEDIMIENTOS - AP',
                            layout: 'form',
                            anchor: '100%',
                            autoHeight: true,
                            collapseFirst: false,
                            collapsible: true,
                            animCollapse: true,
                            titleCollapse: true,
                            id: 'fsRIPSAP',
                            items: [
                                {
                                    xtype: 'compositefield',
                                    style: 'background:transparent;',
                                    items: [
                                        {
                                            xtype: 'textfield',
                                            width: 96,
                                            allowBlank: true,
                                            fieldLabel: 'Diagnostico Principal',
                                            id: 'strDiagPpalProc',
                                            listeners:{
                                                specialkey: function(f,e){
                                                    if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                    {
                                                        if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel1Proc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel1Proc').getValue()){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                params:{
                                                                    task: 'BUSCAR',
                                                                    pCodigo: f.getValue().toUpperCase()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var el = Ext.get('response'); // get the LOG
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                        Ext.getCmp('strDiagPpalProc').setValue(null);
                                                                        Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                                    } else {
                                                                        Ext.getCmp('strDiagPpalProc').setValue(Contenido[0]);
                                                                        Ext.getCmp('sysDiagPpalProcNom').setValue(Contenido[1]);
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    var el = Ext.get('response');
                                                                    Ext.getCmp('strDiagPpalProc').setValue(null);
                                                                    Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }else{
                                                            Ext.getCmp('strDiagPpalProc').setValue(null);
                                                            Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                        }
                                                    }
                                                },
                                                blur: function(t){
                                                    if (Ext.getCmp('strDiagPpalProc').getValue() != "" && Ext.getCmp('strDiagPpalProc').getValue() != null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagPpalProc').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                    Ext.getCmp('strDiagPpalProc').setValue(null);
                                                                    Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagPpalProc').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagPpalProcNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagPpalProc').setValue(null);
                                                                Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagPpalProc').setValue(null);
                                                        Ext.getCmp('sysDiagPpalProcNom').setValue(null);
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'textarea',
                                            readOnly: true,
                                            width: 600,
                                            height: 22,
                                            id: 'sysDiagPpalProcNom'
                                        },
                                        {
                                            xtype: 'button',
                                            iconCls: 'btnBuscar',
                                            tooltip: 'Buscar Diagnostico Principal',
                                            id: 'btnSearchDiagPpalProc',
                                            listeners:{
                                                click : function(){
                                                    buscarcie10('strDiagPpalProc','sysDiagPpalProcNom');
                                                }
                                            }
                                        }
                                    ]
                                },
                                {
                                    xtype: 'compositefield',
                                    style: 'background:transparent;',
                                    items: [
                                        {
                                            xtype: 'textfield',
                                            width: 96,
                                            allowBlank: true,
                                            fieldLabel: 'Diagnostico Relacionado',
                                            id: 'strDiagRel1Proc',
                                            listeners:{
                                                specialkey: function(f,e){
                                                    if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                    {
                                                        if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('strDiagPpalProc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel2Proc').getValue()){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                params:{
                                                                    task: 'BUSCAR',
                                                                    pCodigo: f.getValue().toUpperCase()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var el = Ext.get('response'); // get the LOG
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                        Ext.getCmp('strDiagRel1Proc').setValue(null);
                                                                        Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                    } else {
                                                                        Ext.getCmp('strDiagRel1Proc').setValue(Contenido[0]);
                                                                        Ext.getCmp('sysDiagRel1ProcNom').setValue(Contenido[1]);
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    var el = Ext.get('response');
                                                                    Ext.getCmp('strDiagRel1Proc').setValue(null);
                                                                    Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }else{
                                                            Ext.getCmp('strDiagRel1Proc').setValue(null);
                                                            Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                        }
                                                    }
                                                },
                                                blur: function(t){
                                                    if (Ext.getCmp('strDiagRel1Proc').getValue() != "" && Ext.getCmp('strDiagRel1Proc').getValue() != null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagRel1Proc').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                    Ext.getCmp('strDiagRel1Proc').setValue(null);
                                                                    Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagRel1Proc').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagRel1ProcNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagRel1Proc').setValue(null);
                                                                Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagRel1Proc').setValue(null);
                                                        Ext.getCmp('sysDiagRel1ProcNom').setValue(null);
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'textarea',
                                            readOnly: true,
                                            width: 600,
                                            height: 22,
                                            id: 'sysDiagRel1ProcNom'
                                        },
                                        {
                                            xtype: 'button',
                                            iconCls: 'btnBuscar',
                                            tooltip: 'Buscar Diagnostico Relacionado',
                                            id: 'btnSearchDiagRel1Proc',
                                            listeners:{
                                                click : function(){
                                                    buscarcie10('strDiagRel1Proc','sysDiagRel1ProcNom');
                                                }
                                            }
                                        }
                                    ]
                                },
                                {
                                    xtype: 'compositefield',
                                    style: 'background:transparent;',
                                    items: [
                                        {
                                            xtype: 'textfield',
                                            width: 96,
                                            allowBlank: true,
                                            fieldLabel: 'Diagnostico Complicación',
                                            id: 'strDiagRel2Proc',
                                            listeners:{
                                                specialkey: function(f,e){
                                                    if (e.getKey() == e.ENTER || e.getKey() == e.TAB)
                                                    {
                                                        if (f.getValue() != "" && f.getValue() != null && f.getValue().toUpperCase() != Ext.getCmp('strDiagPpalProc').getValue() && f.getValue().toUpperCase() != Ext.getCmp('strDiagRel1Proc').getValue()){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/cie10/controlador_cie10.php',
                                                                params:{
                                                                    task: 'BUSCAR',
                                                                    pCodigo: f.getValue().toUpperCase()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var el = Ext.get('response'); // get the LOG
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                        Ext.getCmp('strDiagRel2Proc').setValue(null);
                                                                        Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                    } else {
                                                                        Ext.getCmp('strDiagRel2Proc').setValue(Contenido[0]);
                                                                        Ext.getCmp('sysDiagRel2ProcNom').setValue(Contenido[1]);
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    var el = Ext.get('response');
                                                                    Ext.getCmp('strDiagRel2Proc').setValue(null);
                                                                    Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                },
                                                                scope:this //bind the callbacks
                                                            });
                                                        }else{
                                                            Ext.getCmp('strDiagRel2Proc').setValue(null);
                                                            Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                        }
                                                    }
                                                },
                                                blur: function(t){
                                                    if (Ext.getCmp('strDiagRel2Proc').getValue() != "" && Ext.getCmp('strDiagRel2Proc').getValue() != null){
                                                        Ext.Ajax.request({
                                                            url: '../../controlador/cie10/controlador_cie10.php',
                                                            params:{
                                                                task: 'BUSCAR',
                                                                pCodigo: Ext.getCmp('strDiagRel2Proc').getValue().toUpperCase()
                                                            },
                                                            success: function(response,options)
                                                            {
                                                                var el = Ext.get('response'); // get the LOG
                                                                var Respuesta = response.responseText;
                                                                var Contenido = Respuesta.split('^');
                                                                if(Contenido[0]=="" || Contenido[0]== "{success:false}" || Contenido[0]== null){
                                                                    Ext.getCmp('strDiagRel2Proc').setValue(null);
                                                                    Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                                } else {
                                                                    Ext.getCmp('strDiagRel2Proc').setValue(Contenido[0].toUpperCase());
                                                                    Ext.getCmp('sysDiagRel2ProcNom').setValue(Contenido[1].toUpperCase());
                                                                }
                                                            },
                                                            failure: function(response,options){
                                                                var el = Ext.get('response');
                                                                Ext.getCmp('strDiagRel2Proc').setValue(null);
                                                                Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                            },
                                                            scope:this //bind the callbacks
                                                        });
                                                    }else{
                                                        Ext.getCmp('strDiagRel2Proc').setValue(null);
                                                        Ext.getCmp('sysDiagRel2ProcNom').setValue(null);
                                                    }
                                                }
                                            }
                                        },
                                        {
                                            xtype: 'textarea',
                                            readOnly: true,
                                            width: 600,
                                            height: 22,
                                            id: 'sysDiagRel2ProcNom'
                                        },
                                        {
                                            xtype: 'button',
                                            iconCls: 'btnBuscar',
                                            tooltip: 'Buscar Diagnostico Complicación',
                                            id: 'btnSearchDiagRel1Proc',
                                            listeners:{
                                                click : function(){
                                                    buscarcie10('strDiagRel2Proc','sysDiagRel2ProcNom');
                                                }
                                            }
                                        }
                                    ]
                                },
                                {
                                    xtype: 'combo',
                                    fieldLabel: 'Ambito',
                                    width:700,
                                    name: 'Ambito',
                                    allowBlank: true,
                                    store: 'StoreAmbitoProcedimiento',
                                    forceSelection: true,
                                    triggerAction: 'all',
                                    typeAhead: true,
                                    typeAheadDelay: 50,
                                    mode: 'local',
                                    valueField: 'Codigo',
                                    displayField: 'Descripcion',
                                    emptyText: 'Seleccione....',
                                    submitValue: true,
                                    //value: 1,
                                    id: 'strAmbitoProc'
                                },
                                {
                                    xtype: 'combo',
                                    fieldLabel: 'Finalidad Procedimiento',
                                    width:700,
                                    name: 'Finalidad Procedimiento',
                                    allowBlank: true,
                                    store: 'StoreFinalidadProcedimiento',
                                    forceSelection: true,
                                    triggerAction: 'all',
                                    typeAhead: true,
                                    typeAheadDelay: 50,
                                    mode: 'local',
                                    valueField: 'Codigo',
                                    displayField: 'Descripcion',
                                    emptyText: 'Seleccione....',
                                    submitValue: true,
                                    id: 'strFinalidadProcedimientoProc'
                                },
                                {
                                    xtype: 'combo',
                                    fieldLabel: 'Personal Atiende',
                                    width:700,
                                    name: 'Personal Atiende',
                                    allowBlank: true,
                                    store: 'StorePersonalAtiendeProcedimiento',
                                    forceSelection: true,
                                    triggerAction: 'all',
                                    typeAhead: true,
                                    typeAheadDelay: 50,
                                    mode: 'local',
                                    valueField: 'Codigo',
                                    displayField: 'Descripcion',
                                    emptyText: 'Seleccione....',
                                    submitValue: true,
                                    id: 'strPersonalAtiendeProcedimientoProc'
                                },
                                {
                                    xtype: 'combo',
                                    fieldLabel: 'Forma Realización Acto Quirúrgico',
                                    width:700,
                                    name: 'Forma Realización Acto Quirúrgico',
                                    allowBlank: true,
                                    store: 'StoreFormaRealizacionProcedimiento',
                                    forceSelection: true,
                                    triggerAction: 'all',
                                    typeAhead: true,
                                    typeAheadDelay: 50,
                                    mode: 'local',
                                    valueField: 'Codigo',
                                    displayField: 'Descripcion',
                                    emptyText: 'Seleccione....',
                                    submitValue: true,
                                    //value: 1,
                                    id: 'strFormaRealizaProcedimientoProc'
                                }
                            ]
                        },
                        {
                            xtype: 'combo',
                            fieldLabel: 'Generar Autorización a Proveedor?',
                            name: 'Generar Autorización a Proveedor?',
                            store: 'StoreSiNo',
                            width: 100,
                            valueField: 'Descripcion',
                            displayField: 'Descripcion',
                            forceSelection: false,
                            triggerAction: 'all',
                            typeAhead: true,
                            allowBlank: false,
                            value: "SI",
                            mode: 'local',
                            readOnly: true,
                            id: 'strProveedor_GenerarAuto',
                            listeners:{
                                select : function(cmb, rec, idx){
                                    if (cmb.getValue() == "SI"){
                                        Ext.getCmp('fsAutorizaProveedores').setVisible(true);
                                        Ext.getCmp('fecProveedor_conceptosFechaAtencion').setVisible(false);
                                        Ext.getCmp('fecProveedor_conceptosFechaRealiza').setVisible(false);
                                        Ext.getCmp('bolProveedor_conceptosYaRealiza').setVisible(false);
                                    }else{
                                        Ext.getCmp('fsAutorizaProveedores').setVisible(false);
                                        Ext.getCmp('intProveedor_conceptos').setValue(null);
                                        Ext.getCmp('intProveedor_conceptosOrgano').setValue(null);
                                        Ext.getCmp('memProveedor_conceptosNotas').setValue(null);
                                        Ext.getCmp('fecProveedor_conceptosFechaAtencion').setValue(null);
                                        Ext.getCmp('fecProveedor_conceptosFechaRealiza').setValue(null);
                                        Ext.getCmp('bolProveedor_conceptosYaRealiza').setValue(null);
                                        Ext.getCmp('fecProveedor_conceptosFechaAtencion').setVisible(false);
                                        Ext.getCmp('fecProveedor_conceptosFechaRealiza').setVisible(false);
                                        Ext.getCmp('bolProveedor_conceptosYaRealiza').setVisible(false);
                                        Ext.getCmp('intProveedor_conceptosTarifa').setValue(null);
                                    }
                                }
                            }
                        },
                        {
                            xtype: 'fieldset',
                            title: 'Autorización Servicios a Proveedores',
                            autoScroll: true,
                            collapsible: true,
                            anchor: '98%',
                            animCollapse: true,
                            autoHeight: true,
                            id: 'fsAutorizaProveedores',
                            items: [
                                {
                                    xtype: 'combo',
                                    fieldLabel: 'Proveedor',
                                    name: 'Proveedor',
                                    store: 'StoreProveedor',
                                    anchor: '100%',
                                    valueField: 'Codigo',
                                    displayField: 'Descripcion',
                                    listWidth: 850,
                                    validationDelay: 50,
                                    typeAhead: true,
                                    allowBlank: false,
                                    emptyText: 'Seleccione un Proveedor...',
                                    mode: 'local',
                                    id: 'intProveedor_conceptos'
                                },
                                {
                                    xtype: 'combo',
                                    width: 542,
                                    store: 'StoreMiembroParte',
                                    anchor: '100%',
                                    validationDelay: 50,
                                    triggerAction: 'all',
                                    mode: 'local',
                                    typeAhead: true,
                                    forceSelection: true,
                                    fieldLabel: 'Organo',
                                    valueField: 'Codigo',
                                    displayField: 'Descripcion',
                                    id: 'intProveedor_conceptosOrgano'
                                },
                                {
                                    xtype: 'textarea',
                                    fieldLabel: 'Notas',
                                    anchor: '100%',
                                    height: 50,
                                    emptyText: 'Notas a Proveedor',
                                    id: 'memProveedor_conceptosNotas'
                                },
                                {
                                    xtype: 'datefield',
                                    fieldLabel: 'Fecha Atención',
                                    name: 'Fecha Atención',
                                    width: 120,
                                    allowBlank: true,
                                    disabledDates: '',
                                    emptyText: '(dia/mes/año) ',
                                    style: 'text-align:center;',
                                    id: 'fecProveedor_conceptosFechaAtencion'
                                },
                                {
                                    xtype: 'checkbox',
                                    fieldLabel: 'Ya Realizado',
                                    name: 'Ya Realizado',
                                    anchor: '100%',
                                    value: 'false',
                                    id: 'bolProveedor_conceptosYaRealiza'
                                },
                                {
                                    xtype: 'datefield',
                                    fieldLabel: 'Fecha Realización',
                                    name: 'Fecha Realización',
                                    width: 120,
                                    allowBlank: true,
                                    disabledDates: '',
                                    emptyText: '(dia/mes/año) ',
                                    style: 'text-align:center;',
                                    id: 'fecProveedor_conceptosFechaRealiza'
                                },
                                {
                                    xtype: 'hidden',
                                    fieldLabel: 'Tarifa',
                                    width: 120,
                                    allowBlank: true,
                                    value: 0,
                                    id: 'intProveedor_conceptosTarifa'
                                }
                            ]
                        }
                    ]
                },
                {
                    xtype: 'hidden',
                    flex: 1,
                    allowBlank: true,
                    id: 'strTipoRegistroDetalle'
                }
            ],
            bbar: {
                xtype: 'toolbar',
                buttonAlign: 'right',
                height: 31,
                width: 982,
                items: [
                    {
                        xtype: 'button',
                        text: 'Guardar',
                        iconCls: 'btnGuardar',
                        id: 'btnGuardarConcepto_conceptos',
                        handler:function(){
                            fnGuardarConcepto(pCAS, wUsuario);
                        }
                    },
                    {
                        xtype: 'tbseparator'
                    },
                    {
                        xtype: 'button',
                        text: 'Salir',
                        iconCls: 'btnSalir',
                        id: 'btnSalir_conceptos',
                        handler:function(){
                            AddEditConceptoUi.close();
                        }
                    }
                ]
            }
        }]
    });
    el = Ext.get('idusaproveedor');
    ID_USAPROVEEDOR = el.getValue();
    Ext.getCmp('fsAutorizaProveedores').setVisible(false);
    /*if (ID_USAPROVEEDOR == "SI"){
        Ext.getCmp('fsAutorizaProveedores').setVisible(true);
    }else{
        Ext.getCmp('fsAutorizaProveedores').setVisible(false);
    }*/
    Ext.getCmp('fsRIPSAC').setVisible(false);
    Ext.getCmp('fsRIPSAP').setVisible(false);
    if (pOperacion == "edit")
   {
        Ext.getCmp('sysConsecutivo_conceptos').setValue(wConsecutivoDetalle);
        Ext.getCmp('intCAS_conceptos').setValue(pCAS);
        Ext.getCmp('intidConcepto_conceptos').setValue(widConcepto);
        Ext.getCmp('strCodConcepto_conceptos').setValue(wCodigo);
        Ext.getCmp('strDesConcepto_conceptos').setValue(wDescripcion);
        Ext.getCmp('intCantidad_conceptos').setValue(wCantidad);
        Ext.getCmp('memObservaciones_conceptos').setValue(wObservaciones);
        //Ext.getCmp('intPorAplicacion_conceptos').setValue(wPorAplicacion);
        Ext.getCmp('intPorAplicacion_conceptos').setValue(100);
        Ext.getCmp('intVlrUnitario_conceptos').setValue(wVlrTarifa);
        Ext.getCmp('intVlrTotal_conceptos').setValue(wVlrTotal);
        Ext.getCmp('intPorIVA_conceptos').setValue(wPorIVA);
        Ext.getCmp('intVlrIVA_conceptos').setValue(wVlrIVA);
        Ext.getCmp('intVlrCM_conceptos').setValue(wVlrCuotaModeradora);
        Ext.getCmp('intVlrCopago_conceptos').setValue(wVlrCopagos);
        Ext.getCmp('intDescuentos_conceptos').setValue(wVlrDescuentos);
        Ext.getCmp('intVlrNeto_conceptos').setValue(wVlrNeto);
        
        Ext.getCmp('strTipoRegistroDetalle').setValue(wTipoRegistroDetalle);
        Ext.getCmp('intProveedor_conceptos').setValue(wIdProveedor);
        Ext.getCmp('memProveedor_conceptosNotas').setValue(wNotasProveedor);
        Ext.getCmp('intProveedor_conceptosOrgano').setValue(wOrganoProveedor);
        Ext.getCmp('fecProveedor_conceptosFechaAtencion').setValue(wFecProveedor);
        Ext.getCmp('fecProveedor_conceptosFechaRealiza').setValue(wFechaRealizado);
        if(wYaRealizado=="1"){
            Ext.getCmp('bolProveedor_conceptosYaRealiza').setValue(true);
        }else{
            Ext.getCmp('bolProveedor_conceptosYaRealiza').setValue(false);
        }
        Ext.getCmp('fecProveedor_conceptosFechaRealiza').setValue(wFechaRealizado);

        Ext.getCmp('strProveedor_GenerarAuto').setValue(wGenerarAutizacionProveedor);
        Ext.getCmp('intProveedor_conceptosTarifa').setValue(wTarifaProveedor);
        if(wGenerarAutizacionProveedor=="SI"){
            Ext.getCmp('fsAutorizaProveedores').setVisible(true);
        }else{
            Ext.getCmp('fsAutorizaProveedores').setVisible(false);
        }
        Ext.getCmp('sysOperacion_conceptos').setValue("edit");
        
        if(wTipoRegProced==1){
            Ext.getCmp('strDiagPpalHC').setValue(wDiagPpal);
            Ext.getCmp('sysDiagPpalHCNom').setValue(wNomDiagPpal);
            Ext.getCmp('strDiagRel1HC').setValue(wDiagRel1);
            Ext.getCmp('sysDiagRel1HCNom').setValue(wNomDiagRel1);
            Ext.getCmp('strDiagRel2HC').setValue(wDiagRel2);
            Ext.getCmp('sysDiagRel2HCNom').setValue(wNomDiagRel2);
            Ext.getCmp('strDiagRel3HC').setValue(wDiagRel3);
            Ext.getCmp('sysDiagRel3HCNom').setValue(wNomDiagRel3);
            Ext.getCmp('strTipoDiagosticoHC').setValue(wTipDagnostico);
            Ext.getCmp('strFinalidadConsultaHC').setValue(wFinalidadConsulta);
            Ext.getCmp('strCausaExternaHC').setValue(wCausaExterna);
            Ext.getCmp('fsRIPSAP').setVisible(false);
            Ext.getCmp('fsRIPSAC').setVisible(true);
            Ext.getCmp('strDiagPpalProc').allowBlank = true;
            Ext.getCmp('sysDiagPpalProcNom').allowBlank = true;
            Ext.getCmp('strDiagRel1Proc').allowBlank = true;
            Ext.getCmp('sysDiagRel1ProcNom').allowBlank = true;
            Ext.getCmp('strDiagRel2Proc').allowBlank = true;
            Ext.getCmp('sysDiagRel2ProcNom').allowBlank = true;
            Ext.getCmp('strAmbitoProc').allowBlank = true;
            Ext.getCmp('strFinalidadProcedimientoProc').allowBlank = true;
            Ext.getCmp('strPersonalAtiendeProcedimientoProc').allowBlank = true;
            Ext.getCmp('strFormaRealizaProcedimientoProc').allowBlank = true;
        }else{
            if(wTipoRegProced==2){
                Ext.getCmp('strDiagPpalProc').setValue(wDiagPpal);
                Ext.getCmp('sysDiagPpalProcNom').setValue(wNomDiagPpal);
                Ext.getCmp('strDiagRel1Proc').setValue(wDiagRel1);
                Ext.getCmp('sysDiagRel1ProcNom').setValue(wNomDiagRel1);
                Ext.getCmp('strDiagRel2Proc').setValue(wDiagRel2);
                Ext.getCmp('sysDiagRel2ProcNom').setValue(wNomDiagRel2);
                Ext.getCmp('strAmbitoProc').setValue(wAmbito);
                Ext.getCmp('strFinalidadProcedimientoProc').setValue(wFinalidad);
                Ext.getCmp('strPersonalAtiendeProcedimientoProc').setValue(wPersonaAtiende);
                Ext.getCmp('strFormaRealizaProcedimientoProc').setValue(wFormaActo);
                Ext.getCmp('fsRIPSAP').setVisible(true);
                Ext.getCmp('fsRIPSAC').setVisible(false);
                Ext.getCmp('strDiagPpalHC').allowBlank = true;
                Ext.getCmp('sysDiagPpalHCNom').allowBlank = true;
                Ext.getCmp('strDiagRel1HC').allowBlank = true;
                Ext.getCmp('sysDiagRel1HCNom').allowBlank = true;
                Ext.getCmp('strDiagRel2HC').allowBlank = true;
                Ext.getCmp('sysDiagRel2HCNom').allowBlank = true;
                Ext.getCmp('strDiagRel3HC').allowBlank = true;
                Ext.getCmp('sysDiagRel3HCNom').allowBlank = true;
                Ext.getCmp('strTipoDiagosticoHC').allowBlank = true;
                Ext.getCmp('strFinalidadConsultaHC').allowBlank = true;
                Ext.getCmp('strCausaExternaHC').allowBlank = true;
            }
        }
   }
   AddEditConceptoUi.show();
}

function fnGuardarConcepto(wCas,wUsuario){
    var frm = Ext.getCmp('frmRadicaConceptos').getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        if (Ext.getCmp('sysOperacion_conceptos').getValue() == "edit")
        {
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea guardar el concepto',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        frm.submit({
                            waitMsg: 'Por favor Espere...',
                            url: '../../controlador/radicacionservicios/guardar_datosbasicos.php',
                            params:{
                                PROCESO: 'ModificarConceptoCVM',
                                CAMPOS: listacampos,
                                pUsuario: wUsuario,
                                pConsecutivoDetalle: Ext.getCmp('sysConsecutivo_conceptos').getValue()
                            },
                            success: function(res,req)
                            {
                                switch(req.result.requestedId){
                                    case "1":
                                        Ext.MessageBox.hide();
                                        Ext.MessageBox.show({
                                            title: 'Guardar',
                                            msg: 'Se Guardo la Información con Exito.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.INFO
                                        });
                                        Ext.getCmp('gridServicios').store.load({
                                            params:{
                                                pCAS: wCas
                                            }
                                        });
                                        Ext.getCmp('fYaLiquidado').setValue(0);
                                        Ext.getCmp('AddEditConcepto').close();
                                        break;

                                    default:
                                        Ext.MessageBox.hide();
                                        Ext.MessageBox.show({
                                            title: 'Guardar',
                                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                        break;
                                }
                            },
                            failure: function(response,options)
                            {
                                Ext.MessageBox.hide();
                                Ext.MessageBox.show({
                                    title: 'Guardar',
                                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }
                        });
                    }
                }
            });
        }else{
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea guardar el concepto',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        frm.submit({
                            waitMsg: 'Por favor Espere...',
                            url: '../../controlador/radicacionservicios/guardar_datosbasicos.php',
                            params:{
                                PROCESO: 'AdicionarConceptoCVM',
                                CAMPOS: listacampos,
                                pUsuario: wUsuario
                            },
                            success: function(res,req)
                            {
                                switch(req.result.requestedId){
                                    case "1":
                                        Ext.MessageBox.hide();
                                        Ext.MessageBox.show({
                                            title: 'Guardar',
                                            msg: 'Se Guardo la Información con Exito.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.INFO
                                        });
                                        Ext.getCmp('fYaLiquidado').setValue(0);
                                        Ext.getCmp('gridServicios').store.load({
                                            params:{
                                                pCAS: wCas
                                            }
                                        });
                                        Ext.getCmp('AddEditConcepto').close();
                                        break;

                                    default:
                                        Ext.MessageBox.hide();
                                        Ext.MessageBox.show({
                                            title: 'Guardar',
                                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                        break;
                                }
                            },
                            failure: function(response,options)
                            {
                                Ext.MessageBox.hide();
                                Ext.MessageBox.show({
                                    title: 'Guardar',
                                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }
                        });
                    }
                }
            });
        }
    }else{
        Ext.MessageBox.hide();
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
