/*
* @category    Formulario Manual Tarifario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winManualTarifaUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Manual Tarifario ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winManualTarifaUi',
    initComponent: function() {
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmManual',
                padding: 10,
                items: [
                    {
                        html:'<img src="../../../resources/varios/manualtarifa.png" align="left" alt=""/>',border: false
                    },
                    {
                        html:'</br>',border: false
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intUsuario',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIdManualTarifario',
                                value: 0
                            },
                            {
                                xtype: 'textfield',
                                anchor: '100%',
                                fieldLabel: 'Descripción',
                                allowBlank: false,
                                emptyText: 'Descripción',
                                id: 'strDescripcion'
                            },
                            {
                                xtype: 'compositefield',
                                frame: true,
                                fieldLabel: 'Activo',
                                items: [
                                    {
                                        xtype: 'checkbox',
                                        anchor: '100%',
                                        value: 'true',
                                        id: 'bolActivo'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        html:'</br>',border: false
                    },
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            ref: '../btn_AdicionarHorario',
                            id: 'btn_AdicionarHorario'
                        },
                        {
                            xtype: 'button',
                            text: 'Modificar',
                            iconCls: 'btnGuardar',
                            ref: '../btn_ModificarHorario',
                            id: 'btn_ModificarHorario'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            ref: '../btn_SalirHorario',
                            id: 'btn_SalirHorario'
                        }
                    ]
                }
            }
        ];
        winManualTarifaUi.superclass.initComponent.call(this);
    }
});
