/*
* @category    Formulario Asociar Conceptos a Manual Tarifario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAsocConceptoManualUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Asociar Conceptos a Manual Tarifario ::.',
    width: 900,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winAsocConceptoManualUi',
    initComponent: function() {
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmAsocConcepto',
                padding: 10,
                items: [
                    {
                        html:'<img src="../../../resources/varios/conceptomed.png" align="left" alt=""/>',border: false
                    },
                    {
                        html:'</br>',border: false
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'intUsuario',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIdManualTarifario',
                                value: 0
                            },
                            {
                                xtype: 'hidden',
                                id: 'intIdProcedimiento',
                                value: 0
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                fieldLabel: 'Concepto',
                                items: [
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Concepto',
                                        id: 'btnSearchConcepto_conceptos',
                                        handler:function(){
                                            buscarconceptoBasico('Search');
                                        }
                                    },
                                    {
                                        xtype: 'textfield',
                                        readOnly: true,
                                        width: 96,
                                        allowBlank: false,
                                        style: 'color: #0000cc; font-weight: bold;',
                                        id: 'sysCodConcepto'
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 435,
                                        height: 50,
                                        fieldLabel: 'Descripción',
                                        style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                        id: 'sysDesConcepto'
                                    }
                                ]
                            },
                            {
                                xtype: 'numericfield',
                                currencySymbol: "$",
                                useThousandSeparator: true,
                                alwaysDisplayDecimals: true,
                                thousandSeparator: ',',
                                minValue: 0,
                                fieldLabel: 'Vlr Tarifa',
                                decimalPrecision: 2,
                                allowBlank: false,
                                id: 'intVlrTarifa'
                            }
                        ]
                    },
                    {
                        html:'</br>',border: false
                    },
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Asociar Concepto',
                            iconCls: 'btnGuardar',
                            id: 'btn_AsociarIPS'
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirAsociarIPS'
                        }
                    ]
                }
            }
        ];
        winAsocConceptoManualUi.superclass.initComponent.call(this);
    }
});
