/*
* @category    Modelo LogOn Sistema
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/
Ext.ns('com.oficlinic');
Ext.BLANK_IMAGE_URL = "../../lib/extjs/resources/images/default/s.gif";
Ext.SSL_SECURE_URL = "../../lib/extjs/resources/images/default/s.gif";
com.oficlinic.frmPrincipal = {
    init:function(){
         var dsEmpresa = new Ext.data.JsonStore({
            proxy: new Ext.data.HttpProxy ({
                url: '../app/controlador/combobox/cbempresa.php',
                method: 'POST'
            }),
            id: 'dsEmpresaJsonStore',
            idProperty: 'Codigo',
            root: 'rows',
            fields:[
                {name: 'Codigo'},
                {name: 'Descripcion'},
                {name: 'TipoDocumento'},
                {name: 'Documento'},
                {name: 'Especialidad'},
                {name: 'ciudad'},
                {name: 'Direccion'},
                {name: 'Telefono'},
                {name: 'Regimen'},
                {name: 'Contribuyentes'},
                {name: 'RetenedoresICA'},
                {name: 'RetenedoresIVA'},
                {name: 'EsLabClinico'},
                {name: 'EsLabAnatomopatologia'},
                {name: 'codMultiprestador'},
                {name: 'ImprimeMCTirilla'},
                {name: 'ImprimeRCTirilla'},
                {name: 'ImprimeFVPARTTirilla'},
                {name: 'ImprimeOrdenamientosTirilla'},
                {name: 'ImprimeFacPacienteMediaCarta'}
            ]
        });
        dsEmpresa.load();
        
        var form = new Ext.form.FormPanel({
            url: 'Home/SubmitForm',
            frame: true,
            padding: 10,
            id: 'frmLogon',
            autoHeight: true,
            items:[
                {
                    fieldLabel: 'Usuario ',
                    name: 'user',
                    id: 'user',
                    xtype : 'textfield',
                    allowBlank: false, 
                    emptyText: 'ID Usuario...!',
                    anchor: '100%'
                },{
                    fieldLabel: 'Contraseña ',
                    name: 'code',
                    id: 'code',
                    xtype : 'textfield',
                    inputType: 'password',
                    allowBlank: false,
                    emptyText: 'Contraseña',
                    anchor: '100%'
                },{
                    xtype : 'hidden',
                    name: 'vEmpresa',
                    id: 'fEmpresa',
                    value: 1
                },{
                    xtype : 'hidden',
                    name: 'vSede',
                    id: 'fSede',
                    value: 1
                },{
                    xtype : 'hidden',
                    name: 'vIps',
                    id: 'fIps',
                    value: 1
                },{
                    xtype : 'hidden',
                    name: 'pEmpresaTdoc',
                    id: 'pEmpresaTdoc'
                },{
                    xtype : 'hidden',
                    name: 'pEmpresaDoc',
                    id: 'pEmpresaDoc'
                },{
                    xtype : 'hidden',
                    name: 'pEmpresaDir',
                    id: 'pEmpresaDir'
                },{
                    xtype : 'hidden',
                    name: 'pEmpresaTel',
                    id: 'pEmpresaTel'
                },{
                    xtype : 'hidden',
                    name: 'pEmpresaCiu',
                    id: 'pEmpresaCiu'
                },{
                    xtype : 'hidden',
                    name: 'pEmpresaEsp',
                    id: 'pEmpresaEsp'
                },{
                    xtype : 'hidden',
                    name: 'pEmpresaRegimen',
                    id: 'pEmpresaRegimen'
                },{
                    xtype : 'hidden',
                    name: 'pEmpresaContribuyente',
                    id: 'pEmpresaContribuyente'
                },{
                    xtype : 'hidden',
                    name: 'pEmpresaReteICA',
                    id: 'pEmpresaReteICA'
                },{
                    xtype : 'hidden',
                    name: 'pEmpresaReteIVA',
                    id: 'pEmpresaReteIVA'
                },{
                        xtype : 'hidden',
                        name: 'pEsLabAnatomopatologia',
                        id: 'pEsLabAnatomopatologia'
                },{
                        xtype : 'hidden',
                        name: 'pEsLabClinico',
                        id: 'pEsLabClinico'
                },{
                        xtype : 'hidden',
                        name: 'pcodMultiprestador',
                        id: 'pcodMultiprestador'
                },{
                        xtype : 'hidden',
                        name: 'pImprimeMCTirilla',
                        id: 'pImprimeMCTirilla'
                },{
                        xtype : 'hidden',
                        name: 'pImprimeRCTirilla',
                        id: 'pImprimeRCTirilla'
                },{
                        xtype : 'hidden',
                        name: 'pImprimeFVPARTTirilla',
                        id: 'pImprimeFVPARTTirilla'
                },{
                        xtype : 'hidden',
                        name: 'pImprimeOrdenamientosTirilla',
                        id: 'pImprimeOrdenamientosTirilla'
                },{
                        xtype : 'hidden',
                        name: 'pImprimeFacPacienteMediaCarta',
                        id: 'pImprimeFacPacienteMediaCarta'
                }
            ],
            buttons : [
                {
                    text : 'Aceptar',
                    iconCls: 'btnAceptar',
                    listeners:{
                        click: function(){
                            var frm = Ext.getCmp('frmLogon').getForm();
                            if (frm.isValid()){
                                Ext.getCmp('pEmpresaTdoc').setValue(dsEmpresa.getAt(0).get('TipoDocumento'));
                                Ext.getCmp('pEmpresaDoc').setValue(dsEmpresa.getAt(0).get('Documento'));
                                Ext.getCmp('pEmpresaDir').setValue(dsEmpresa.getAt(0).get('Direccion'));
                                Ext.getCmp('pEmpresaTel').setValue(dsEmpresa.getAt(0).get('Telefono'));
                                Ext.getCmp('pEmpresaCiu').setValue(dsEmpresa.getAt(0).get('ciudad'));
                                Ext.getCmp('pEmpresaEsp').setValue(dsEmpresa.getAt(0).get('Especialidad'));
                                Ext.getCmp('pEmpresaRegimen').setValue(dsEmpresa.getAt(0).get('Regimen'));
                                Ext.getCmp('pEmpresaContribuyente').setValue(dsEmpresa.getAt(0).get('Contribuyentes'));
                                Ext.getCmp('pEmpresaReteICA').setValue(dsEmpresa.getAt(0).get('RetenedoresICA'));
                                Ext.getCmp('pEmpresaReteIVA').setValue(dsEmpresa.getAt(0).get('RetenedoresIVA'));
                                Ext.getCmp('pEsLabClinico').setValue(dsEmpresa.getAt(0).get('EsLabClinico'));
                                Ext.getCmp('pEsLabAnatomopatologia').setValue(dsEmpresa.getAt(0).get('EsLabAnatomopatologia'));
                                Ext.getCmp('pcodMultiprestador').setValue(dsEmpresa.getAt(0).get('codMultiprestador'));
                                Ext.getCmp('pImprimeMCTirilla').setValue(dsEmpresa.getAt(0).get('ImprimeMCTirilla'));
                                Ext.getCmp('pImprimeRCTirilla').setValue(dsEmpresa.getAt(0).get('ImprimeRCTirilla'));
                                Ext.getCmp('pImprimeFVPARTTirilla').setValue(dsEmpresa.getAt(0).get('ImprimeFVPARTTirilla'));
                                Ext.getCmp('pImprimeOrdenamientosTirilla').setValue(dsEmpresa.getAt(0).get('ImprimeOrdenamientosTirilla'));
                                Ext.getCmp('pImprimeFacPacienteMediaCarta').setValue(dsEmpresa.getAt(0).get('ImprimeFacPacienteMediaCarta'));
                                frm.submit({
                                    url: "../app/func/validarusuario.php",
                                    success: function(f,a)
                                    {
                                         if(a && a.result && a.result.success){
                                            Ext.Ajax.request(
                                            {
                                                url: '../app/controlador/agendas/controlador_asignarcitas.php',
                                                params:{
                                                    task: "AGENDAS_DESBLOQUEAR",
                                                    pUsuario: a.result.pUsuario,
                                                    pIPS: a.result.pIPS
                                                },
                                                scope:this
                                            });
                                            this.close();
                                            location.href='../app/frm/frmofimedical.php';
                                        }
                                    },
                                    failure: function(f,a)
                                    {
                                        Ext.Msg.show(
                                        {  
                                            title: 'Verificacion del Usuario..!',
                                            msg: a.result.errors.msg, 
                                            buttons: Ext.Msg.OK, 
                                            icon: Ext.Msg.ERROR 
                                        });  
                                    }
                                });
                            }else{
                                Ext.MessageBox.show({
                                    title: 'OfiClnic',
                                    msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }
                        }
                    }
                }
            ]
        });
        var main = new Ext.Panel({
            title: 'Ingresar al Sistema',
            width:290,
            height:155,
            autoScroll: true,
            frame: true,
            bodyStyle:'padding:0px 0px 0px 0px; background-color:#DFE9F7;',
            items: [form]
        });
        main.render('xformulario');
    }
};

Ext.onReady(com.oficlinic.frmPrincipal.init,com.oficlinic.frmPrincipal);
