/*
* @category    Modelo Maestro IPS
* @package     OfiClinic Web
* @author      Jorge Ancizar GAleano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.desarrollo@ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

var DGDataStore;
var DGColumnModel;
var DGListingEditorGrid;
var DGListingWindow;
var DGCreateForm;
var DGCreateWindow;
var DGModifyForm;
var DGModifyWindow;
var DGViewForm;
var DGViewWindow;
var IdRecordField;
var DescripcionField;
var MunicipioField;
var DireccionField;
var TelefonoField;
var GerenteField;
var Gerente_EmailField;
var CordinadorField;
var Cordinador_EmailField;
var EnfermeraField;
var Enfermera_EmailField;

var IdRecordField1;
var DescripcionField1;
var MunicipioField1;
var DireccionField1;
var TelefonoField1;
var GerenteField1;
var Gerente_EmailField1;
var CordinadorField1;
var Cordinador_EmailField1;
var EnfermeraField1;
var Enfermera_EmailField1;

var IdRecordField2;
var DescripcionField2;
var MunicipioField2;
var DireccionField2;
var TelefonoField2;
var GerenteField2;
var Gerente_EmailField2;
var CordinadorField2;
var Cordinador_EmailField2;
var EnfermeraField2;
var Enfermera_EmailField2;

var IPSListingSelectedRow;
var IPSListingContextMenu;
var anchoPantalla;
var MargenIzquierdo;

Ext.onReady(function(){
    Ext.QuickTips.init();
    var el = Ext.get('idusuario');
    var ID_USUARIO = el.getValue();
    el = Ext.get('nomusuario');
    var NOM_USUARIO = el.getValue();
    el = Ext.get('codusuario');
    var COD_USUARIO = el.getValue();
    el = Ext.get('idempresa');
    var ID_EMPRESA = el.getValue();
    el = Ext.get('nomempresa');
    var NOM_EMPRESA = el.getValue();
    el = Ext.get('idcliente');
    var ID_CLIENTE = el.getValue();
    el = Ext.get('nomcliente');
    var NOM_CLIENTE = el.getValue();
    el = Ext.get('idsede');
    var ID_SEDE = el.getValue();
    el = Ext.get('nomsede');
    var NOM_SEDE = el.getValue();
    el = Ext.get('idperfil');
    var ID_PERFIL = el.getValue();
    anchoPantalla = screen.width;
    switch(anchoPantalla)
    {
        case 1024:
            MargenIzquierdo = 15;
            break;
        case 1280:
            MargenIzquierdo = 150;
            break;
    }

    var dsMunicipios = new Ext.data.JsonStore({
        proxy: new Ext.data.HttpProxy ({
            url: '../data/municipios.php',
            method: 'POST'
        }),
        id: 'dsMunicipiosJsonStore',
        idProperty: 'Codigo',
        root: 'rows',
        fields:[
           {name: 'Codigo'},
           {name: 'Descripcion'}
        ]
    });
    dsMunicipios.load();

    var btnSalir = new Ext.Button({
        id: 'btnSalir',
        text: 'Salir',
        icon: '../../../resources/botones/salir.png',
        iconCls: 'x-btn-text-icon',
        minWidth: 80,
        handler:function(){
            window.close();
        }
    });

    function modifyRecord(oGrid_event){
        Ext.Msg.show({
            title: 'eOfiClinic',
            buttons: Ext.MessageBox.YESNO,
            msg: "Esta Seguro que Desea Modificar la información, Si Hace Esto no Podra Deshacer los Cambios'",
            icon: Ext.MessageBox.QUESTION,
            fn: function(btn)
            {
                if (btn == 'yes')
                {
                    Ext.Ajax.request({
                        waitMsg: 'Por favor Espere...',
                        url: '../data/controlador_ips.php',
                        params: {
                            task: "UPDATE",
                            USUARIO: ID_USUARIO,
                            IDRecord: IdRecordField2.getValue(),
                            IPS: DescripcionField2.getValue(),
                            Gerente: GerenteField2.getValue(),
                            Cordinador: CordinadorField2.getValue(),
                            Enfermera: EnfermeraField2.getValue(),
                            Direccion: DireccionField2.getValue(),
                            Telefono: TelefonoField2.getValue(),
                            GerenteEmail: Gerente_EmailField2.getValue(),
                            CordinadorEmail: Cordinador_EmailField2.getValue(),
                            EnfermeraEmail: Enfermera_EmailField2.getValue(),
                            IdMunicipio: MunicipioField2.getValue()
                        },
                        success: function(response){
                            var result=eval(response.responseText);
                            switch(result){
                                case 1:
                                    DGDataStore.commitChanges();
                                    DGDataStore.reload();
                                    DGModifyWindow.hide();
                                    break;
                                default:
                                    Ext.MessageBox.alert('Error...','No podemos guardar la información en estos momentos...');
                                    break;
                            }
                        },
                        failure: function(response){
                            var result=response.responseText;
                            Ext.MessageBox.alert('Error Base Datos...','No podemos guardar la información en estos momentos...');
                        }
                    });
                } else {
                    DGDataStore.rejectChanges();
                }
            }
        });
    }

    function createRecord(){
        if(isDGFormValid()){
            Ext.Ajax.request({
                waitMsg: 'Por favor Espere...',
                url: '../data/controlador_ips.php',
                params: {
                    task: "CREATE",
                    SEDE: ID_SEDE,
                    CLIENTE: ID_CLIENTE,
                    USUARIO: ID_USUARIO,
                    IPS: DescripcionField.getValue(),
                    Gerente: GerenteField.getValue(),
                    Cordinador: CordinadorField.getValue(),
                    Enfermera: EnfermeraField.getValue(),
                    Direccion: DireccionField.getValue(),
                    Telefono: TelefonoField.getValue(),
                    GerenteEmail: Gerente_EmailField.getValue(),
                    CordinadorEmail: Cordinador_EmailField.getValue(),
                    EnfermeraEmail: Enfermera_EmailField.getValue(),
                    IdMunicipio: MunicipioField.getValue()
                },
                success: function(response){
                    var result=eval(response.responseText);
                    switch(result){
                        case 1:
                            Ext.MessageBox.alert('eOfiClinic','La IPS se creo satisfactoriamente.');
                            DGDataStore.reload();
                            DGCreateWindow.hide();
                            break;
                        default:
                            Ext.MessageBox.alert('Error...','No podemos guardar la IPS en estos momentos, verifique nuevamente la información');
                        break;
                    }
                },
                failure: function(response){
                    var result=response.responseText;
                    Ext.MessageBox.alert('Error Base Datos...','No podemos guardar la información en estos momentos...');
                }
            });
        } else {
            Ext.MessageBox.alert('Atención', 'La información ingresada no es valida!');
        }
    }

    function resetForm(){
        if(DescripcionField.getValue() != null)
        {
            DescripcionField.setValue('');
            GerenteField.setValue('');
            CordinadorField.setValue('');
            EnfermeraField.setValue('');
            DireccionField.setValue('');
            TelefonoField.setValue('');
            MunicipioField.setValue('');
            Gerente_EmailField.setValue('');
            Cordinador_EmailField.setValue('');
            Enfermera_EmailField.setValue('');
        }
    }

    function isDGFormValid(){
        return(DescripcionField.isValid() && GerenteField.isValid() && CordinadorField.isValid() && EnfermeraField.isValid() && DireccionField.isValid() && TelefonoField.isValid() && MunicipioField.isValid());
    }

    function displayFormWindow(){
        if(!DGCreateWindow.isVisible()){
            resetForm();
            DGCreateWindow.show();
        } else {
            DGCreateWindow.toFront();
        }
    }

    function ViewFormWindowView(){
        if(!DGViewWindow.isVisible()){
            //resetForm();
            var selections = DGListingEditorGrid.selModel.getSelections();
            IdRecordField1.setValue(selections[0].json.idrecord);
            DescripcionField1.setValue(selections[0].json.ips);
            GerenteField1.setValue(selections[0].json.gerente);
            CordinadorField1.setValue(selections[0].json.cordinador);
            EnfermeraField1.setValue(selections[0].json.enfermera);
            DireccionField1.setValue(selections[0].json.direccion);
            TelefonoField1.setValue(selections[0].json.telefono);
            MunicipioField1.setValue(selections[0].json.idmunicipio);
            Gerente_EmailField1.setValue(selections[0].json.gerenteemail);
            Cordinador_EmailField1.setValue(selections[0].json.cordinadoremail);
            Enfermera_EmailField1.setValue(selections[0].json.enfermeraemail);
            DGViewWindow.show();
        } else {
            DGViewWindow.toFront();
        }
    }

    function ViewFormWindowEdit(){
        if(!DGModifyWindow.isVisible()){
            //resetForm();
            var selections = DGListingEditorGrid.selModel.getSelections();
            IdRecordField2.setValue(selections[0].json.idrecord);
            DescripcionField2.setValue(selections[0].json.ips);
            GerenteField2.setValue(selections[0].json.gerente);
            CordinadorField2.setValue(selections[0].json.cordinador);
            EnfermeraField2.setValue(selections[0].json.enfermera);
            DireccionField2.setValue(selections[0].json.direccion);
            TelefonoField2.setValue(selections[0].json.telefono);
            MunicipioField2.setValue(selections[0].json.idmunicipio);
            Gerente_EmailField2.setValue(selections[0].json.gerenteemail);
            Cordinador_EmailField2.setValue(selections[0].json.cordinadoremail);
            Enfermera_EmailField2.setValue(selections[0].json.enfermeraemail);
            DGModifyWindow.show();
        } else {
            DGModifyWindow.toFront();
        }
    }

    function confirmDelete(){
        if(DGListingEditorGrid.selModel.getCount() == 1) // only one president is selected here
        {
            Ext.MessageBox.confirm('Confirmación','Es Seguro que Desea Eliminar el Registro?', deleteRecord);
        } else if(DGListingEditorGrid.selModel.getCount() > 1){
            Ext.MessageBox.confirm('Confirmación','Es Seguro que Desea Eliminar los Registros Seleccionados?', deleteRecord);
        } else {
            Ext.MessageBox.alert('Error...','No podemos eliminar los registros en estos momentos');
        }
    }
   
    function deleteRecord(btn){
        if(btn=='yes'){
            var selections = DGListingEditorGrid.selModel.getSelections();
            var prez = [];
            for(i = 0; i< DGListingEditorGrid.selModel.getCount(); i++){
                prez.push(selections[i].json.idrecord);
            }
            var encoded_array = Ext.encode(prez);
            Ext.Ajax.request({
                waitMsg: 'Por favor Espere...',
                url: '../data/controlador_ips.php',
                params: {
                    task: "DELETE",
                    ids:  encoded_array
                },
                success: function(response){
                    var result=eval(response.responseText);
                    switch(result){
                        case 1:  // Success : simply reload
                            DGDataStore.reload();
                            break;
                        default:
                            Ext.MessageBox.alert('Error...','No podemos eliminar los registros en estos momentos');
                            break;
                    }
                },
                failure: function(response){
                    var result=response.responseText;
                    Ext.MessageBox.alert('Error Base Datos...','No podemos eliminar la información en estos momentos...');
                }
            });
        }
    }

    function startAdvancedSearch(){
        var SearchForm;
        var SearchWindow;
        var SearchDescripcion;
        var SearchGerente;
        var SearchCordinador;
        var SearchEnfermera;
        var SearchMunicipio;

        function listSearch(){
         // render according to a SQL date format.
         /*var startDate = "";
         var endDate = "";
         if(SearchEnteringItem.getValue() !== "") {
            startDate = SearchEnteringItem.getValue().format('Y-m-d');
         }
         if(SearchLeavingItem.getValue() !== "") {
            endDate = SearchLeavingItem.getValue().format('Y-m-d');
         }*/

            DGDataStore.baseParams = {
                task: 'SEARCH',
                SEDE: ID_SEDE,
                CLIENTE: ID_CLIENTE,
                IPS: SearchDescripcion.getValue(),
                Gerente: SearchGerente.getValue(),
                Cordinador: SearchCordinador.getValue(),
                Enfermera: SearchEnfermera.getValue(),
                Municipio: SearchMunicipio.getValue()
            };
            DGDataStore.reload({params: {start: 0, limit: 15}});
        }

        function resetSearch(){
            DGDataStore.baseParams = {
                task: 'LISTING',
                SEDE: ID_SEDE,
                CLIENTE: ID_CLIENTE,
                IPS: null,
                Gerente: null,
                Cordinador: null,
                Enfermera: null,
                Municipio: null
            };

            DGDataStore.reload({params: {start: 0, limit: 15}});
            SearchWindow.close();
        }

        SearchDescripcion = new Ext.form.TextField({
            fieldLabel: 'Nombre IPS',
            emptyText: 'Todos',
            maxLength: 200,
            anchor : '95%',
            maskRe: /([a-zA-Z0-9\s]+)$/
        });

        SearchGerente = new Ext.form.TextField({
            fieldLabel: 'Gerente',
            emptyText: 'Todos',
            maxLength: 100,
            anchor : '95%',
            maskRe: /([a-zA-Z0-9\s]+)$/
        });

        SearchCordinador = new Ext.form.TextField({
            fieldLabel: 'Coordinador',
            emptyText: 'Todos',
            maxLength: 100,
            anchor : '95%',
            maskRe: /([a-zA-Z0-9\s]+)$/
        });

        SearchEnfermera = new Ext.form.TextField({
            fieldLabel: 'Enfermera',
            emptyText: 'Todos',
            maxLength: 100,
            anchor : '95%',
            maskRe: /([a-zA-Z0-9\s]+)$/
        });

        SearchMunicipio = new Ext.form.ComboBox({
            fieldLabel: 'Municipio',
            store: dsMunicipios,
            mode: 'local',
            loadingText: 'Cargando Municipios...!',
            valueField: 'Codigo',
            displayField: 'Descripcion',
            emptyText: 'Todos',
            anchor:'95%',
            triggerAction: 'all'
        });

        SearchForm = new Ext.FormPanel({
            bodyStyle: 'padding: 5px',
            width: 700,
            items: [{
                layout: 'form',
                border: false,
                items: [ SearchDescripcion,SearchGerente,SearchCordinador,SearchEnfermera,SearchMunicipio ],
                buttons: [{
                    text: 'Buscar',
                    handler: listSearch
                },{
                    text: 'Cerrar y Limpair Busqueda',
                    handler: resetSearch
                }]
            }]
        });

        SearchWindow = new Ext.Window({
            title: 'Busqueda',
            closable:true,
            width: 750,
            height: 210,
            plain:true,
            layout: 'fit',
            items: SearchForm
        });

        SearchWindow.show();
    }

    function printListing(){
        var searchquery = "";
        var searchfirstname = "";
        var searchlastname = "";
        var searchparty = "";
        var searchenteringoffice = "";
        var searchleavingoffice = "";
        var win;               // our popup window
        // check if we do have some search data...
        if(DGDataStore.baseParams.query!==null){searchquery = DGDataStore.baseParams.query;}
        if(DGDataStore.baseParams.firstname!==null){searchfirstname = DGDataStore.baseParams.firstname;}
        if(DGDataStore.baseParams.lastname!==null){searchlastname = DGDataStore.baseParams.lastname;}
        if(DGDataStore.baseParams.party!==null){searchparty = PresidenDGDataStoretsDataStore.baseParams.party;}
        if(DGDataStore.baseParams.enteringoffice!==null){searchenteringoffice = DGDataStore.baseParams.enteringoffice;}
        if(DGDataStore.baseParams.leavingoffice!==null){searchleavingoffice = DGDataStore.baseParams.leavingoffice;}

        Ext.Ajax.request({
            waitMsg: 'Por favor Espere...',
            url: '../data/controlador_ips.php',
            params: {
                task: "PRINT",
                query: searchquery,                                 // if we are doing a quicksearch, use this
                firstname : searchfirstname,                        // if we are doing advanced search, use this
                lastname : searchlastname,
                party : searchparty,
                enteringoffice : searchenteringoffice,
                leavingoffice : searchleavingoffice,
                currentlisting: DGDataStore.baseParams.task // this tells us if we are searching or not
            },
            success: function(response){
                var result=eval(response.responseText);
                switch(result){
                    case 1:
                        win = window.open('./presidentslist.html','presidentslist','height=400,width=600,resizable=1,scrollbars=1, menubar=1');
                        win.print();
                        break;
                    default:
                        Ext.MessageBox.alert('Error','No puedo imprimir la información!');
                        break;
                }
            },
            failure: function(response){
                var result=response.responseText;
                Ext.MessageBox.alert('Error Base Datos','No puedo imprimir la información!');
            }
        });
    }

    function onListingEditorGridContextMenu(grid, rowIndex, e) {
        e.stopEvent();
        var coords = e.getXY();
        DGListingContextMenu.rowRecord = grid.store.getAt(rowIndex);
        grid.selModel.selectRow(rowIndex);
        DGListingSelectedRow=rowIndex;
        DGListingContextMenu.showAt([coords[0], coords[1]]);
    }

    function modifyContextMenu(){
        DGListingEditorGrid.startEditing(DGListingSelectedRow,1);
    }

    function deleteContextMenu(){
        confirmDelete();
    }

    function printListingContextMenu(){
        printListing();
    }

    DGDataStore = new Ext.data.Store({
        id: 'DGDataStore',
        proxy: new Ext.data.HttpProxy({
            url: '../data/controlador_ips.php',
            method: 'POST'
        }),
        baseParams:{task: "LISTING", CLIENTE: ID_CLIENTE, SEDE: ID_SEDE},
        reader: new Ext.data.JsonReader({
        root: 'results',
        totalProperty: 'total',
        id: 'id'
      },[
        {name: 'IDRecord', type: 'int', mapping: 'idrecord'},
        {name: 'IPS', type: 'string', mapping: 'ips',sortable: true},
        {name: 'Gerente', type: 'string', mapping: 'gerente',sortable: true},
        {name: 'EmailGerente', type: 'string', mapping: 'gerenteemail'},
        {name: 'Coordinador', type: 'string', mapping: 'cordinador',sortable: true},
        {name: 'EmailCordinador', type: 'string', mapping: 'cordinadoremail'},
        {name: 'Enfermera', type: 'string', mapping: 'enfermera',sortable: true},
        {name: 'EmailEnfermera', type: 'string', mapping: 'enfermeraemail'},
        {name: 'IdMunicipio', type: 'int', mapping: 'idmunicipio'},
        {name: 'Municipio', type: 'string', mapping: 'municipio',sortable: true},
        {name: 'Direccion', type: 'string', mapping: 'direccion'},
        {name: 'Telefono', type: 'string', mapping: 'telefono'}
      ]),
      sortInfo:{field: 'IDRecord', direction: "ASC"}
    });

    DGColumnModel = new Ext.grid.ColumnModel(
        [{
            header: '#',
            readOnly: true,
            sortable: true,
            dataIndex: 'IDRecord',
            width: 40,
            renderer: function(value, cell){
                cell.css = "readonlycell";
                return value;
            },
            hidden: false
        },{
            header: 'IPS',
            dataIndex: 'IPS',
            sortable: true,
            width: 260,
            editor: new Ext.form.TextField({
                allowBlank: false,
                maxLength: 250,
                maskRe: /([a-zA-Z0-9\s]+)$/
        }),
        renderer: function(value, cell){
            cell.css = "coolcell";
            return value;
        }
        },{
            header: 'Gerente',
            dataIndex: 'Gerente',
            sortable: true,
            width: 150,
            editor: new Ext.form.TextField({
                allowBlank: false,
                maxLength: 100,
                maskRe: /([a-zA-Z0-9\s]+)$/
            }),
            renderer: function(value, cell){
                cell.css = "coolcell";
                return value;
            }
        },{
            header: 'Email-Gerente',
            dataIndex: 'EmailGerente',
            width: 150,
            readOnly: true
        },{
            header: 'Coordinador',
            dataIndex: 'Coordinador',
            width: 150,
            editor: new Ext.form.TextField({
                allowBlank: false,
                maxLength: 100,
                maskRe: /([a-zA-Z0-9\s]+)$/
            }),
            renderer: function(value, cell){
                cell.css = "coolcell";
                return value;
            }
        },{
            header: 'Email-Coordinador',
            dataIndex: 'EmailCordinador',
            width: 150,
            readOnly: true
        },{
            header: 'Enfermera',
            dataIndex: 'Enfermera',
            width: 150,
            editor: new Ext.form.TextField({
                allowBlank: false,
                maxLength: 20,
                maskRe: /([a-zA-Z0-9\s]+)$/
            }),
            renderer: function(value, cell){
                cell.css = "coolcell";
                return value;
            }
        },{
            header: 'Email-Enfermera',
            dataIndex: 'EmailEnfermera',
            width: 150,
            readOnly: true
        },{
            header: 'IdMunicipio',
            readOnly: true,
            dataIndex: 'IdMunicipio',
            width: 0,
            renderer: function(value, cell){
                cell.css = "readonlycell";
                return value;
            },
            hidden: true
        },{
            header: 'Municipio',
            dataIndex: 'Municipio',
            width: 150,
            editor: new Ext.form.ComboBox({
                typeAhead: true,
                triggerAction: 'all',
                store: dsMunicipios,
                mode: 'local',
                loadingText: 'Cargando Municipios...!',
                valueField: 'Codigo',
                displayField: 'Descripcion',
                emptyText: 'Seleccione un Municipio',
                lazyRender:true,
                listClass: 'x-combo-list-small'
            })
        },{
            header: 'Dirección',
            dataIndex: 'Direccion',
            width: 150,
            editor: new Ext.form.TextField({
                allowBlank: false,
                maxLength: 100,
                maskRe: /([a-zA-Z0-9\s]+)$/
            }),
            renderer: function(value, cell){
                cell.css = "coolcell";
                return value;
            }
        },{
            header: 'Teléfono',
            dataIndex: 'Telefono',
            width: 150,
            editor: new Ext.form.TextField({
                allowBlank: false,
                maxLength: 100,
                maskRe: /([a-zA-Z0-9\s]+)$/
            }),
            renderer: function(value, cell){
                cell.css = "coolcell";
                return value;
            }
        }]
    );
    DGColumnModel.defaultSortable= true;

    DGListingEditorGrid =  new Ext.grid.GridPanel({
        id: 'DGListingEditorGrid',
        store: DGDataStore,
        cm: DGColumnModel,
        //enableColLock:false,
        //clicksToEdit:2,
        selModel: new Ext.grid.RowSelectionModel({singleSelect:false}),
        bbar: new Ext.PagingToolbar({
            pageSize: 15,
            store: DGDataStore,
            displayInfo: true
        }),
        tbar: [{
            text: 'Adicionar',
            tooltip: 'Adicionar Registro...',
            iconCls:'add',                      // reference to our css
            handler: displayFormWindow
        },'-',{
            text: 'Modificar',
            tooltip: 'Modificar Registro...',
            iconCls:'edit',                      // reference to our css
            handler: ViewFormWindowEdit
        },'-',{
            text: 'Consultar',
            tooltip: 'Consultar Registro...',
            iconCls:'view',                      // reference to our css
            handler: ViewFormWindowView
        }, '-',{
            text: 'Eliminar',
            tooltip: 'Eliminar Registro(s)...',
            handler: confirmDelete,   // Confirm before deleting
            iconCls:'remove'
        }, '-', { // Added in Tutorial 8
            text: 'Buscar',
            tooltip: 'Buscar Registros...',
            handler: startAdvancedSearch,
            iconCls:'search'
        }, '-', new Ext.app.SearchField({
                store: DGDataStore,
                params: {start: 0, limit: 15},
                width: 120
        })]
    });
    /*,'-', {
            text: 'Imprimir',
            tooltip: 'Imprimir Tabla...',
            handler: printListing,
            iconCls:'print'
        }*/
    DGListingEditorGrid.addListener('rowcontextmenu', onListingEditorGridContextMenu);

    DGListingContextMenu = new Ext.menu.Menu({
        id: 'DGListingEditorGridContextMenu',
        items: [
            {text: 'Eliminar este Registro', handler: deleteContextMenu}
        ]
    });

    DGListingWindow = new Ext.Window({
        id: 'DGListingWindow',
        title: ' ',
        closable:false,
        width:980,
        height:480,
        plain:true,
        resizable : false,
        x: MargenIzquierdo,
        y:120,
        layout: 'fit',
        items: DGListingEditorGrid,
        tbar:['->',btnSalir],
        bbar:[{
            text  : 'Empresa: ' + NOM_EMPRESA,
            xtype : 'tbtext'
        },'->',{
            text  : 'Sistemas Ofisalud - desarrollo@ofisalud.com - Tel: 3016398114',
            xtype : 'tbtext'
        }]
    });

    DGDataStore.load({params: {start: 0, limit: 15}});
    DGListingWindow.show();

    /*EnteringOfficeField = new Ext.form.DateField({
    id:'EnteringOfficeField',
    fieldLabel: 'Entering Office',
    format : 'm/d/Y',
    allowBlank: false,
    anchor:'95%'
    });*/

    DescripcionField = new Ext.form.TextField({
        id: 'DescripcionField',
        fieldLabel: 'IPS',
        maxLength: 200,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    IdRecordField = new Ext.form.TextField({
        id: 'IdRecordField',
        fieldLabel: 'IDRecord',
        maxLength: 200,
        anchor : '95%',
        hidden: true
    });

    GerenteField = new Ext.form.TextField({
        id: 'GerenteField',
        fieldLabel: 'Gerente',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    CordinadorField = new Ext.form.TextField({
        id: 'CordinadorField',
        fieldLabel: 'Coordinador',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    EnfermeraField = new Ext.form.TextField({
        id: 'EnfermeraField',
        fieldLabel: 'Enfermera',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    MunicipioField = new Ext.form.ComboBox({
        id:'MunicipioField',
        fieldLabel: 'Municipio',
        store: dsMunicipios,
        mode: 'local',
        loadingText: 'Cargando Municipios...!',
        valueField: 'Codigo',
        displayField: 'Descripcion',
        emptyText: 'Seleccione un Municipio',
        allowBlank: false,
        anchor:'95%',
        triggerAction: 'all'
    });

    DireccionField = new Ext.form.TextField({
        id: 'DireccionField',
        fieldLabel: 'Dirección',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    TelefonoField = new Ext.form.TextField({
        id: 'TelefonoField',
        fieldLabel: 'Teléfono',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    Gerente_EmailField = new Ext.form.TextField({
        id: 'Gerente_EmailField',
        fieldLabel: 'Email-Gerente',
        maxLength: 200,
        allowBlank: true,
        anchor : '95%',
        vtype: 'email'
    });

    Cordinador_EmailField = new Ext.form.TextField({
        id: 'Cordinador_EmailField',
        fieldLabel: 'Email-Coordinador',
        maxLength: 200,
        allowBlank: true,
        anchor : '95%',
        vtype: 'email'
    });

    Enfermera_EmailField = new Ext.form.TextField({
        id: 'Enfermera_EmailField',
        fieldLabel: 'Email-Enfermera',
        maxLength: 200,
        allowBlank: true,
        anchor : '95%',
        vtype: 'email'
    });

    //Set 1
    DescripcionField1 = new Ext.form.TextField({
        id: 'DescripcionField1',
        fieldLabel: 'IPS',
        maxLength: 200,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    IdRecordField1 = new Ext.form.TextField({
        id: 'IdRecordField1',
        fieldLabel: 'IDRecord',
        maxLength: 200,
        anchor : '95%',
        hidden: true
    });

    GerenteField1 = new Ext.form.TextField({
        id: 'GerenteField1',
        fieldLabel: 'Gerente',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    CordinadorField1 = new Ext.form.TextField({
        id: 'CordinadorField1',
        fieldLabel: 'Coordinador',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    EnfermeraField1 = new Ext.form.TextField({
        id: 'EnfermeraField1',
        fieldLabel: 'Enfermera',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    MunicipioField1 = new Ext.form.ComboBox({
        id:'MunicipioField1',
        fieldLabel: 'Municipio',
        store: dsMunicipios,
        mode: 'local',
        loadingText: 'Cargando Municipios...!',
        valueField: 'Codigo',
        displayField: 'Descripcion',
        emptyText: 'Seleccione un Municipio',
        allowBlank: false,
        anchor:'95%',
        triggerAction: 'all'
    });

    DireccionField1 = new Ext.form.TextField({
        id: 'DireccionField1',
        fieldLabel: 'Dirección',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    TelefonoField1 = new Ext.form.TextField({
        id: 'TelefonoField1',
        fieldLabel: 'Teléfono',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    Gerente_EmailField1 = new Ext.form.TextField({
        id: 'Gerente_EmailField1',
        fieldLabel: 'Email-Gerente',
        maxLength: 200,
        allowBlank: true,
        anchor : '95%',
        vtype: 'email'
    });

    Cordinador_EmailField1 = new Ext.form.TextField({
        id: 'Cordinador_EmailField1',
        fieldLabel: 'Email-Coordinador',
        maxLength: 200,
        allowBlank: true,
        anchor : '95%',
        vtype: 'email'
    });

    Enfermera_EmailField1 = new Ext.form.TextField({
        id: 'Enfermera_EmailField1',
        fieldLabel: 'Email-Enfermera',
        maxLength: 200,
        allowBlank: true,
        anchor : '95%',
        vtype: 'email'
    });

    // Set 2
    DescripcionField2 = new Ext.form.TextField({
        id: 'DescripcionField2',
        fieldLabel: 'IPS',
        maxLength: 200,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    IdRecordField2 = new Ext.form.TextField({
        id: 'IdRecordField2',
        fieldLabel: 'IDRecord',
        maxLength: 200,
        anchor : '95%',
        hidden: true
    });

    GerenteField2 = new Ext.form.TextField({
        id: 'GerenteField2',
        fieldLabel: 'Gerente',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    CordinadorField2 = new Ext.form.TextField({
        id: 'CordinadorField2',
        fieldLabel: 'Coordinador',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    EnfermeraField2 = new Ext.form.TextField({
        id: 'EnfermeraField2',
        fieldLabel: 'Enfermera',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    MunicipioField2 = new Ext.form.ComboBox({
        id:'MunicipioField2',
        fieldLabel: 'Municipio',
        store: dsMunicipios,
        mode: 'local',
        loadingText: 'Cargando Municipios...!',
        valueField: 'Codigo',
        displayField: 'Descripcion',
        emptyText: 'Seleccione un Municipio',
        allowBlank: false,
        anchor:'95%',
        triggerAction: 'all'
    });

    DireccionField2 = new Ext.form.TextField({
        id: 'DireccionField2',
        fieldLabel: 'Dirección',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    TelefonoField2 = new Ext.form.TextField({
        id: 'TelefonoField2',
        fieldLabel: 'Teléfono',
        maxLength: 100,
        allowBlank: false,
        anchor : '95%',
        maskRe: /([a-zA-Z0-9\s]+)$/
    });

    Gerente_EmailField2 = new Ext.form.TextField({
        id: 'Gerente_EmailField2',
        fieldLabel: 'Email-Gerente',
        maxLength: 200,
        allowBlank: true,
        anchor : '95%',
        vtype: 'email'
    });

    Cordinador_EmailField2 = new Ext.form.TextField({
        id: 'Cordinador_EmailField2',
        fieldLabel: 'Email-Coordinador',
        maxLength: 200,
        allowBlank: true,
        anchor : '95%',
        vtype: 'email'
    });

    Enfermera_EmailField2 = new Ext.form.TextField({
        id: 'Enfermera_EmailField2',
        fieldLabel: 'Email-Enfermera',
        maxLength: 200,
        allowBlank: true,
        anchor : '95%',
        vtype: 'email'
    });

    DGCreateForm = new Ext.FormPanel({
        labelAlign: 'top',
        bodyStyle:'padding:5px',
        width: 620,
        items: [{
            layout:'column',
            border:false,
            items:[{
                columnWidth:0.5,
                layout: 'form',
                border:false,
                items: [DescripcionField, MunicipioField, DireccionField, TelefonoField]
            },{
                columnWidth:0.5,
                layout: 'form',
                border:false,
                items: [GerenteField, Gerente_EmailField, CordinadorField, Cordinador_EmailField, EnfermeraField, Enfermera_EmailField]
            }]
        }],
        buttons: [{
            text: 'Guardar y Cerrar',
            handler: createRecord
        },{
            text: 'Cancelar',
            handler: function(){
                DGCreateWindow.hide();
        }
      }]
    });

    DGModifyForm = new Ext.FormPanel({
        labelAlign: 'top',
        bodyStyle:'padding:5px',
        width: 620,
        items: [{
            layout:'column',
            border:false,
            items:[{
                columnWidth:0.5,
                layout: 'form',
                border:false,
                items: [DescripcionField2, MunicipioField2, DireccionField2, TelefonoField2,IdRecordField2]
            },{
                columnWidth:0.5,
                layout: 'form',
                border:false,
                items: [GerenteField2, Gerente_EmailField2, CordinadorField2, Cordinador_EmailField2, EnfermeraField2, Enfermera_EmailField2]
            }]
        }],
        buttons: [{
            text: 'Modificar y Cerrar',
            handler: modifyRecord
        },{
            text: 'Cancelar',
            handler: function(){
                DGModifyWindow.hide();
            }
        }]
    });

    DGViewForm = new Ext.FormPanel({
        labelAlign: 'top',
        bodyStyle:'padding:5px',
        width: 620,
        readOnly: true,
        items: [{
            layout:'column',
            border:false,
            items:[{
                columnWidth:0.5,
                layout: 'form',
                border:false,
                items: [DescripcionField1, MunicipioField1, DireccionField1, TelefonoField1, IdRecordField1]
            },{
                columnWidth:0.5,
                layout: 'form',
                border:false,
                items: [GerenteField1, Gerente_EmailField1, CordinadorField1, Cordinador_EmailField1, EnfermeraField1, Enfermera_EmailField1]
            }]
        }],
        buttons: [{
            text: 'Cerrar',
            handler: function(){
                DGViewWindow.hide();
            }
        }]
    });

    DGCreateWindow= new Ext.Window({
        id: 'DGCreateWindow',
        title: 'Crear IPS',
        closable: false,
        width: 610,
        height: 380,
        plain:true,
        layout: 'fit',
        items: DGCreateForm
    });

    DGModifyWindow= new Ext.Window({
        id: 'DGModifyWindow',
        title: 'Modificar IPS',
        closable: false,
        width: 610,
        height: 380,
        plain:true,
        layout: 'fit',
        items: DGModifyForm
    });

    DGViewWindow= new Ext.Window({
        id: 'DGViewWindow',
        title: 'Consultar IPS',
        closable: false,
        width: 610,
        height: 380,
        plain:true,
        layout: 'fit',
        items: DGViewForm
    });
});