/*
* @category    Formulario Cerrar Inventario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winCerrarInventarioUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Cerrar Inventario ::.',
    width: 600,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winCerrarInventarioUi',
    initComponent: function() {
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmCerrarInventario',
                padding: 10,
                items: [
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        id: 'intIdInventarioCloseInv'
                    },
                    {
                        xtype: 'hidden',
                        anchor: '100%',
                        allowBlank: true,
                        id: 'strTaskCloseInv'
                    },
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Bodega',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysBodegasCloseInv'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Zona',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysZonasCloseInv'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Tipo Inventario',
                                anchor: '100%',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysTipoInventarioCloseInv'
                            },
                            {
                                xtype: 'textfield',
                                fieldLabel: 'Hora Apertura',
                                width: 90,
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysHoraAperturaAddInv'
                            },        
                            {
                                xtype: 'textarea',
                                anchor: '100%',
                                fieldLabel: 'Acta Apertura',
                                allowBlank: true,
                                readOnly: true,
                                id: 'sysActaAperturaCloseInv'
                            },
                            {
                                xtype: 'timefield',
                                fieldLabel: 'Hora Cierre',
                                width: 90,
                                allowBlank: false,
                                forceSelection: false,
                                minValue: '06:00 AM',
                                maxValue: '09:00 PM',
                                emptyText: 'p.e. 07:00',
                                id: 'strHoraCierreCloseInv'
                            },        
                            {
                                xtype: 'textarea',
                                anchor: '100%',
                                fieldLabel: 'Acta Cierre',
                                allowBlank: false,
                                id: 'strActaCierreCloseInv'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Cerrar Inventario',
                            iconCls: 'btnGuardar',
                            listeners:{
                                click : function(){
                                    var frm = Ext.getCmp('frmCerrarInventario').getForm();
                                    if (frm.isValid()){
                                        Ext.Msg.show({
                                            title: 'Inventarios',
                                            msg: 'Esta Seguro que Desea Crear el Inventario?',
                                            buttons: Ext.Msg.YESNO,
                                            icon: Ext.Msg.QUESTION,
                                            fn: function(btn){
                                                if(btn === "yes"){
                                                    frm.submit({
                                                        url: '../../controlador/inventario/controlador_inventario.php',
                                                        params: {
                                                            task: Ext.getCmp('strTaskCloseInv').getValue(),
                                                            pEmpresa: ID_EMPRESA,
                                                            pIPS: ID_IPS,
                                                            pUsuario: ID_USUARIO,
                                                            pInventario: Ext.getCmp('intIdInventarioCloseInv').getValue(),
                                                            pHoraCierre: Ext.getCmp('strHoraCierreCloseInv').getValue(),
                                                            pActaCierre: Ext.getCmp('strActaCierreCloseInv').getValue()
                                                        },
                                                        success: function(res,req)
                                                        {
                                                            switch(req.result.requestedId){
                                                                case "1":
                                                                    LimpiarCamposINV();
                                                                    Ext.getCmp('treeHistiricoInventarios').root.reload();
                                                                    Ext.getCmp('winCerrarInventarioUi').close();
                                                                    Ext.MessageBox.show({
                                                                        title: 'Inventario',
                                                                        msg: 'Se Cerro el Inventario con exito, por favor busquelo en el historico de inventarios para continuar con el proceso.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.INFO
                                                                    });
                                                                    break;

                                                                default:
                                                                    Ext.MessageBox.show({
                                                                        title: 'Inventario',
                                                                        msg: 'Ocurrio un error al Cerrar el inventario o no se pudo establecer conexión con el servidor.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                    break;
                                                            }
                                                        },
                                                        failure: function(response,options)
                                                        {
                                                            Ext.MessageBox.show({
                                                                title: 'Error Base Datos',
                                                                msg: 'No podemos Cerrar el inventario en estos momentos',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        }
                                                    });
                                                }
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'Los campos son Requeridos',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirAddInv',
                            listeners: {
                                click: function(){
                                    Ext.getCmp('winCerrarInventarioUi').close();
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winCerrarInventarioUi.superclass.initComponent.call(this);
    }
});
