/*
* @category    Formulario Adicionar - Editar Item Conteo Inventario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddEditItemConteoUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Item Conteo ::.',
    width: 940,
    autoHeight: true,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winAddEditItemConteoUi',
    initComponent: function() {
        
        var stLotesxConceptoInv = new StoreLotesxConcepto();
        
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmItemConteo',
                padding: 10,
                items: [
                    {
                        xtype: 'panel',
                        layout: 'form',
                        border: false,
                        labelWidth: 170,
                        items: [
                            {
                                xtype: 'hidden',
                                flex: 1,
                                readOnly: true,
                                width: 96,
                                value: 0,
                                id: 'intidConsecutivoItemConteo'
                            },
                            {
                                xtype: 'hidden',
                                flex: 1,
                                readOnly: true,
                                width: 96,
                                id: 'intidInventarioItemConteo'
                            },
                            {
                                xtype: 'hidden',
                                flex: 1,
                                readOnly: true,
                                width: 96,
                                id: 'intidConteoItemConteo'
                            },
                            {
                                xtype: 'hidden',
                                flex: 1,
                                readOnly: true,
                                width: 96,
                                id: 'intidConceptoItemConteo'
                            },
                            {
                                xtype: 'hidden',
                                flex: 1,
                                readOnly: true,
                                width: 96,
                                id: 'intUsaLoteItemConteo'
                            },
                            {
                                xtype: 'compositefield',
                                frame: true,
                                fieldLabel: 'Codigo Barras',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'textfield',
                                        width: 130,
                                        allowBlank: true,
                                        id: 'sysFilterCodBarrasItemConteo',
                                        listeners:{
                                            specialkey: function(f,e){
                                                if (e.getKey() === e.ENTER || e.getKey() === e.TAB && Ext.getCmp('sysFilterCodBarrasItemConteo').getValue() !== "" && Ext.getCmp('sysFilterCodBarrasItemConteo').getValue() !== null){
                                                    Ext.Ajax.request({
                                                        url: '../../controlador/conceptos/controlador_conceptos.php',
                                                        params:{
                                                            task: 'SEARCH_CONCEPTO_BARRAS',
                                                            pBarras: Ext.getCmp('sysFilterCodBarrasItemConteo').getValue()
                                                        },
                                                        success: function(response,options)
                                                        {
                                                            var Respuesta = response.responseText;
                                                            var Contenido = Respuesta.split('^');
                                                            if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                Ext.MessageBox.show({
                                                                    title: 'eOfiClinic',
                                                                    msg: 'El Codigo de Barras no esta asociado a ningun concepto.',
                                                                    buttons: Ext.MessageBox.OK,
                                                                    icon: Ext.MessageBox.ERROR
                                                                });
                                                            } else {
                                                                Ext.getCmp('intLoteConceptoItemConteo').store.removeAll();
                                                                Ext.getCmp('intUsaLoteItemConteo').setValue(Contenido[3]);
                                                                Ext.getCmp('intidConceptoItemConteo').setValue(Contenido[0]);
                                                                Ext.getCmp('strCodConceptoItemConteo').setValue(Contenido[1]);
                                                                Ext.getCmp('strDesConceptoItemConteo').setValue(Contenido[2]);
                                                                if(parseInt(Ext.getCmp('intUsaLoteItemConteo').getValue()) === 1){
                                                                    Ext.getCmp('intLoteConceptoItemConteo').store.load({
                                                                        params:{
                                                                            pConcepto: Ext.getCmp('intidConceptoItemConteo').getValue()
                                                                        }
                                                                    });
                                                                    Ext.getCmp('intLoteConceptoItemConteo').allowBlank = false;
                                                                    Ext.getCmp('intLoteConceptoItemConteo').setVisible(true);
                                                                }else{
                                                                    Ext.getCmp('intLoteConceptoItemConteo').setValue(null);
                                                                    Ext.getCmp('intLoteConceptoItemConteo').clearInvalid();
                                                                    Ext.getCmp('intLoteConceptoItemConteo').allowBlank = true;
                                                                    Ext.getCmp('intLoteConceptoItemConteo').setVisible(false);
                                                                }
                                                            }
                                                        },
                                                        failure: function(response,options){
                                                            Ext.MessageBox.show({
                                                                title: 'Error Conexión',
                                                                msg: 'El Codigo de Barras no esta asociado a ningun concepto.',
                                                                buttons: Ext.MessageBox.OK,
                                                                icon: Ext.MessageBox.ERROR
                                                            });
                                                        },
                                                        scope:this 
                                                    });
                                                }
                                            }
                                        }
                                    },
                                    {
                                        xtype: 'button',
                                        iconCls: 'btnBuscar',
                                        tooltip: 'Buscar Concepto',
                                        id: 'btnSearchConceptoItemConteo',
                                        handler:function(){
                                            buscarconceptoBasico('ItemConteo');
                                        }
                                    },
                                    {
                                        xtype: 'textfield',
                                        readOnly: true,
                                        width: 96,
                                        allowBlank: false,
                                        style: 'color: #0000cc; font-weight: bold;',
                                        id: 'strCodConceptoItemConteo'
                                    },
                                    {
                                        xtype: 'textarea',
                                        readOnly: true,
                                        width: 435,
                                        height: 90,
                                        style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                        id: 'strDesConceptoItemConteo'
                                    }
                                ]
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Lote',
                                anchor: '100%',
                                allowBlank: false,
                                store: stLotesxConceptoInv,
                                valueField: 'IdLoteVencimiento',
                                displayField: 'NroLote',
                                mode: 'local',
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 10,
                                triggerAction: 'all',
                                itemSelector: 'div.cbLote',
                                tpl: '<tpl for="."><div class="cbLote"><h3>{NroLote}</h3>Vencimiento: {FecVencimiento}<hr /></div></tpl>',
                                id: 'intLoteConceptoItemConteo'
                            },
                            {
                                xtype: 'numericfield',
                                fieldLabel: 'Cantidad',
                                width: 100,
                                allowBlank: false,
                                currencySymbol: '',
                                useThousandSeparator: true,
                                alwaysDisplayDecimals: false,
                                thousandSeparator: ',',
                                minValue: 0,
                                decimalPrecision: 0,
                                id: 'intCantidadItemConteo'
                            }
                        ]
                    }
                ],
                tbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Guardar',
                            iconCls: 'btnGuardar',
                            id: 'btn_AdicionarItemConteo',
                            listeners:{
                                click : function(){
                                    var frm = Ext.getCmp('frmItemConteo').getForm();
                                    if (frm.isValid()){
                                        frm.submit({
                                            url: '../../controlador/inventario/controlador_inventario.php',
                                            params: {
                                                task: 'ADD_ITEM_CONTEO',
                                                pEmpresa: ID_EMPRESA,
                                                pIPS: ID_IPS,
                                                pUsuario: ID_USUARIO,
                                                pConsecutivoItemConteo: Ext.getCmp('intidConsecutivoItemConteo').getValue(),
                                                pInventario: Ext.getCmp('intidInventarioItemConteo').getValue(),
                                                pConteo: Ext.getCmp('intidConteoItemConteo').getValue(),
                                                pConcepto: Ext.getCmp('intidConceptoItemConteo').getValue(),
                                                pLote: Ext.getCmp('intLoteConceptoItemConteo').getValue(),
                                                pCantidad: Ext.getCmp('intCantidadItemConteo').getValue()
                                            },
                                            success: function(res,req)
                                            {
                                                switch(req.result.requestedId){
                                                    case "1":
                                                        var wConteos = "N";
                                                        if(parseInt(Ext.getCmp('intidConteoItemConteo').getValue()) > 1){
                                                            wConteos = "S";
                                                        }
                                                        CargarStoreDetalleInv(Ext.getCmp('intidInventarioItemConteo').getValue(),"","","N");
                                                        Ext.getCmp('winAddEditItemConteoUi').close();
                                                        break;

                                                    default:
                                                        Ext.MessageBox.show({
                                                            title: 'Inventario',
                                                            msg: 'Ocurrio un error al crear el item o no se pudo establecer conexión con el servidor.',
                                                            buttons: Ext.MessageBox.OK,
                                                            icon: Ext.MessageBox.ERROR
                                                        });
                                                        break;
                                                }
                                            },
                                            failure: function(response,options)
                                            {
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'No podemos crear el item en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'Los campos son Requeridos',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                }
                            }
                        }
                    ]
                },
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'button',
                            text: 'Salir',
                            iconCls: 'btnSalir',
                            id: 'btn_SalirItemConteo',
                            listeners: {
                                click: function(){
                                    Ext.getCmp('winAddEditItemConteoUi').close();
                                }
                            }
                        }
                    ]
                }
            }
        ];
        winAddEditItemConteoUi.superclass.initComponent.call(this);
    }
});
