/*
* @category    Programacion Eventos Formulario Profesionales
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmMovimientos = Ext.extend(winFrmMovimientosUi, {
    initComponent: function() {
        winFrmMovimientos.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";

        
        stOpcionesSistema = new StoreOpcionesSistema();
        stOpcionesSistema.load({
            params: { 'pPerfil': ID_PERFIL }
        });
        
        var btnCrearRegistro = Ext.getCmp('btnCrearRegistro').on("click",this.NuevoItem,this);
        var btnActualizar = Ext.getCmp('btnActualizar').on("click",this.ListarMovimientos,this);
        var btnAplicarMov = Ext.getCmp('btnAplicarMov').on("click",this.AplicarMovimiento,this);
        var btnSalir = Ext.getCmp('btnSalir').on("click",this.SalirOpcion,this);
        var btnNuevo = Ext.getCmp('btnNuevo').on("click",this.NuevoMovimiento,this);
    },
    
    NuevoMovimiento: function(){
        Ext.getCmp('strEstado').setValue("A");
        Ext.getCmp('intTipoMovimiento').clearValue();
        Ext.getCmp('fecFechaMovimiento').setValue("");
        Ext.getCmp('intIdMovimiento').clearValue();
        Ext.getCmp('strFacturaCompra').setValue("");
        Ext.getCmp('strProveedorCompra').setValue("");
        Ext.getCmp('fecFechaCompra').setValue("");
        Ext.getCmp('memMotivoBaja').setValue("");
        Ext.getCmp('strTipoAjuste').setValue("");
        Ext.getCmp('memObservaciones').setValue("");
        Ext.getCmp('intBodegasAddInv').store.removeAll(true);
        Ext.getCmp('intBodegasDestino').store.removeAll(true);
        Ext.getCmp('intZonasAddInv').store.removeAll(true);
        Ext.getCmp('intZonasDestino').store.removeAll(true);
        Ext.getCmp('gridMovimientos').store.removeAll(true);
        Ext.getCmp('fNroMovimientos').setValue("Sin Registrar");
        Ext.getCmp('fsAjusteInventario').setVisible(false);
        Ext.getCmp('fsBajaInventario').setVisible(false);
        Ext.getCmp('fsBodegaDestino').setVisible(false);
        Ext.getCmp('fsCompras').setVisible(false);
    },
    
    NuevoItem: function(){
        if(Ext.getCmp('intIdMovimiento').getValue() === ""  || Ext.getCmp('intIdMovimiento').getValue() === null || Ext.getCmp('intIdMovimiento').getValue() === 0){
            Ext.MessageBox.show({
                title: 'Nuevo Item',
                msg: 'Debe guardar el Movimiento para agregar un item.',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }else{
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea Agregar un Nuevo Item?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn)
                {
                    if(btn=="yes")
                    {
                        if(Ext.getCmp('intIdMovimiento').getValue() == 0 || Ext.getCmp('intIdMovimiento').getValue() == null || Ext.getCmp('intIdMovimiento').getValue() == ""){
                            Ext.MessageBox.show({
                                title: 'Error',
                                msg: 'Cree un Movimiento antes de Agregar un Item',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }else{
                            var winAddItem = new winAddItemUi();
                            Ext.getCmp('sysTipoMovimiento').setValue(Ext.getCmp('intTipoMovimiento').getValue());
                            Ext.getCmp('sysConsecutivoMovimiento').setValue(Ext.getCmp('intIdMovimiento').getValue());
                            winAddItem.show();
                        }
                    }
                }
            });
        }
    },
    
    EliminarItem: function(){
        if(Ext.getCmp('gridMovimientos').selModel.getCount() == 1){
            var selections = Ext.getCmp('gridMovimientos').selModel.getSelections();
            if(Ext.getCmp('strEstado').getValue == "C"){
                Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Item seleccionado no se puede Eliminar.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
            }else{
                Ext.Msg.show({
                    title: 'eOfiClinic',
                    msg: 'Esta seguro que desea Eliminar el Item Seleccionado?',
                    buttons: Ext.Msg.YESNO,
                    icon: Ext.Msg.QUESTION,
                    fn: function(btn)
                    {
                        if(btn=="yes"){
                            var selections = Ext.getCmp('gridMovimientos').selModel.getSelections();
                            var frm = Ext.getCmp('frmMovimientos').getForm();
                            if (frm.isValid())
                            {
                                frm.submit({
                                    url: '../../controlador/inventario/controlador_inventario.php',
                                    params: {
                                        task: 'DEL_MOVIMIENTO_DETALLE',
                                        pConsecutivo: selections[0].json.ConsecutivoDetalleMovimiento
                                    },
                                    success: function(res,req)
                                    {
                                        switch(req.result.requestedId){
                                            case "1":
                                                Ext.MessageBox.show({
                                                    title: 'Eliminar Item',
                                                    msg: 'Se Elimino la Informacion con Exito.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.INFO
                                                });
                                                Ext.getCmp('gridAlertasPacientes').store.load();
                                                break;

                                            default:
                                                Ext.MessageBox.show({
                                                    title: 'Eliminar Item',
                                                    msg: 'Ocurrio un error al Eliminar la Informacion o no se pudo establecer conexión con el servidor.',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                                break;
                                        }
                                    },
                                    failure: function(response,options)
                                    {
                                        Ext.MessageBox.show({
                                            title: 'Error Base Datos',
                                            msg: 'No podemos Eliminar la Informacion en estos momentos',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                });
                            }else{
                                Ext.MessageBox.show({
                                    title: 'Error',
                                    msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }
                        }
                    }
                })
            }
        }
    },
    
    AplicarMovimiento: function(){
        if(Ext.getCmp('strEstado').getValue() === "C"){
            Ext.MessageBox.show({
                    title: 'Error',
                    msg: 'El Movimiento Seleccionado ya se Encuentra Aplicado.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
        }else{
            Ext.Msg.show({
                title: 'eOfiClinic',
                msg: 'Esta seguro que desea Aplicar el Movimiento Seleccionado?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn){
                    if(btn==="yes"){
                        Ext.Ajax.request({
                            waitMsg: 'Por favor Espere...',
                            url: '../../controlador/inventario/controlador_inventario.php',
                            params: {
                                task: 'APLICAR_MOVIMIENTO',
                                pMovimiento: Ext.getCmp('intIdMovimiento').getValue(),
                                pUsuario: ID_USUARIO
                            },
                            success: function(response)
                            {
                                var result = response.responseText;
                                if (result !== "0" && result !== "{failure:true}"){
                                    Ext.MessageBox.show({
                                        title: 'Aplicar Movimiento',
                                        msg: 'Se Aplico la Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('strEstado').setValue("C");
                                }else{
                                    Ext.MessageBox.show({
                                        title: 'Aplicar Movimiento',
                                        msg: 'Ocurrio un error al Aplicar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }
                            },
                            failure: function(response){
                                Ext.MessageBox.show({
                                    title: 'Error Base Datos',
                                    msg: 'No podemos Aplicar la Informacion en estos momentos',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }
                        });
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }   
                }
            });
        }
    },
    ListarMovimientos: function(){
        if(Ext.getCmp('intIdMovimiento').getValue() == null || Ext.getCmp('intIdMovimiento').getValue() == "" || Ext.getCmp('intIdMovimiento').getValue() == 0){
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'Seleccione un Movimiento',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }else{
            Ext.getCmp('gridMovimientos').store.baseParams = {
                task: 'LISTAR_MOVIMIENTOS_DETALLE',
                pMovimiento: Ext.getCmp('intIdMovimiento').getValue()
            };
            Ext.getCmp('gridMovimientos').store.load();
        }
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
});





function fnEliminarAlerta(){
        Ext.Msg.show({
        title: 'Eliminar Alerta....!',
        msg: 'Esta seguro que desea Eliminar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn=="yes")
            {
                var selections = Ext.getCmp('gridAlertasPacientes').selModel.getSelections();
                var frm = Ext.getCmp('frmKardexPacientes').getForm();
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/pacientes/controlador_pacientes_kardex.php',
                        params: {
                            task: 'ELIMINAR_ALERTA',
                            pIdAlerta: selections[0].json.IdAlerta
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Eliminar Alerta',
                                        msg: 'Se Elimino la Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('gridAlertasPacientes').store.load();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Eliminar Alerta',
                                        msg: 'Ocurrio un error al Eliminar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Eliminar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}


function fnGuardarRegistros(pAccion,pCerrar,pWin,pForm,URL,pGrid,arrParam,pCampoLlave,pCampoTextoLlave, pLimpiarForm, pCambiarBotones){
    var frm = Ext.getCmp(pForm).getForm();
    if (frm.isValid())
    {
        var listacampos = ExtraerCamposFrm(frm);
        frm.submit({
            waitMsg: 'Por favor Espere...',
            url: URL,
            params:{
                task: pAccion,
                CAMPOS: listacampos
            },
            success: function(res,req)
            {
                Ext.Msg.hide();
                switch(req.result.requestedId){
                    case "1":
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Se Guardo la Información con Exito.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.INFO
                        });
                        if (typeof pLimpiarForm != 'undefined')
                        {
                            if (pLimpiarForm == "SI")
                                frm.reset();
                        }else{
                            frm.reset();
                        }
                        if (typeof pGrid != 'undefined')
                        {
                            if (pGrid != 'NA')
                            {
                                Ext.getCmp(pGrid).store.reload(arrParam);
                            }
                        }
                        if (typeof pCampoLlave != 'undefined')
                        {
                            if (pCampoLlave != 'NA')
                            {
                                Ext.getCmp(pCampoLlave).setValue(req.result.Data);
                                if (typeof pCampoTextoLlave != 'undefined')
                                    Ext.getCmp(pCampoTextoLlave).setValue("Tarjeta Nro: " + req.result.Data);
                            }
                        }
                        if (typeof pCambiarBotones != 'undefined')
                        {
                            if (pCambiarBotones == 'SI')
                            {
                                Ext.getCmp('btnGuardarPac_citas').setVisible(false);
                                Ext.getCmp('btnModificarPac_citas').setVisible(true);
                            }
                        }
                        if(pCerrar == "SI")
                        {
                            Ext.getCmp(pWin).close();
                        }
                        break;

                    default:
                        Ext.MessageBox.show({
                            title: 'Guardar',
                            msg: 'Ocurrio un error al guardar, la llave principal no es valida o no se pudo establecer conexión con el servidor.',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                        break;
                }
            },
            failure: function(response,options)
            {
                Ext.Msg.hide();
                Ext.MessageBox.show({
                    title: 'Guardar',
                    msg: 'Ocurrio un error al guardar o no se pudo establecer conexión con el servidor.',
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.ERROR
                });
            }
        });
    }else{
        Ext.MessageBox.show({
            title: 'Guardar',
            msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
            buttons: Ext.MessageBox.OK,
            icon: Ext.MessageBox.ERROR
        });
    }
}
