/*
* @category    Formulario Pre-Inscripcion Pacientes
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winAddItemUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Pre-Inscripcion Pacientes ::.',
    width: 1000,
    autoHeight: true,
    closable: true,
    resizable: false,
    draggable: false,
    modal: true,
    autoScroll: true,
    padding: 10,
    id: 'winAddItem',
    initComponent: function() {
        
        var stBodegasAddInv = new StoreBodegas();
        var stBodegasZonasAddInv = new StoreBodegasZonas();
        
        //Store Local
        
        var dataTipoMovimiento = [
            [4,'COMPRAS'],
            [5,'RECEPCION TRASLADO'],
            [6,'TRASLADO'],
            [8,'BAJA DE INVENTARIO'],
            [9,'AJUSTE POR INVENTARIO']
        ];
        var stTipoMovimiento = new Ext.data.ArrayStore({
            fields: [
                {name: 'Codigo'},
                {name: 'Descripcion'}
            ]
        });
        stTipoMovimiento.loadData(dataTipoMovimiento);

        
        
        this.items = [
            {
                xtype: 'panel',
                frame: true,
                anchor: '85%',
                id: 'panelHC',
                border: false,
                autoHeight: true,
                autoScroll: true,
                layout: 'form',
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'form',
                        frame: true,
                        anchor: '100%',
                        id: 'frmAddItem',
                        padding: 10,
                        border: false,
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'Usuario',
                                id: 'sysUsuario'
                            },
                            {
                                xtype: 'hidden',
                                anchor: '100%',
                                allowBlank: false,
                                readOnly: true,
                                fieldLabel: 'ConsecutivoMovimiento',
                                id: 'sysConsecutivoMovimiento'
                            },
                            {
                                xtype: 'panel',
                                title: '<center>DATOS MOVIMIENTO</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                autoHeight: true,
                                id: 'pnDatosBasicos',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Tipo Movimiento',
                                        anchor: '100%',
                                        allowBlank: false,
                                        store: stTipoMovimiento,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        mode: 'local',
                                        forceSelection: true,
                                        typeAhead: true,
                                        typeAheadDelay: 10,
                                        triggerAction: 'all',
                                        id: 'sysTipoMovimiento'
                                    }
                                ]
                            },
                            {
                                xtype: 'panel',
                                title: '<center>ITEM</center>',
                                layout: 'form',
                                anchor: '100%',
                                labelSeparator: '',
                                autoHeight: true,
                                id: 'pnPreInscripcionPrograma',
                                items: [
                                    {
                                        xtype: 'hidden',
                                        flex: 1,
                                        readOnly: true,
                                        width: 96,
                                        id: 'intLoteConceptoItemConteo'
                                    },
                                    {
                                        xtype: 'hidden',
                                        flex: 1,
                                        readOnly: true,
                                        width: 96,
                                        id: 'intidInventarioItemConteo'
                                    },
                                    {
                                        xtype: 'hidden',
                                        flex: 1,
                                        readOnly: true,
                                        width: 96,
                                        id: 'intidConteoItemConteo'
                                    },
                                    {
                                        xtype: 'hidden',
                                        flex: 1,
                                        readOnly: true,
                                        width: 96,
                                        id: 'intidConceptoItemConteo'
                                    },
                                    {
                                        xtype: 'hidden',
                                        flex: 1,
                                        readOnly: true,
                                        width: 96,
                                        id: 'intUsaLoteItemConteo'
                                    },
                                    {
                                        xtype: 'compositefield',
                                        frame: true,
                                        fieldLabel: 'Codigo Barras',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'textfield',
                                                width: 130,
                                                allowBlank: true,
                                                id: 'sysFilterCodBarrasItemConteo',
                                                listeners:{
                                                    specialkey: function(f,e){
                                                        if (e.getKey() === e.ENTER || e.getKey() === e.TAB && Ext.getCmp('sysFilterCodBarrasItemConteo').getValue() !== "" && Ext.getCmp('sysFilterCodBarrasItemConteo').getValue() !== null){
                                                            Ext.Ajax.request({
                                                                url: '../../controlador/conceptos/controlador_conceptos.php',
                                                                params:{
                                                                    task: 'SEARCH_CONCEPTO_BARRAS',
                                                                    pBarras: Ext.getCmp('sysFilterCodBarrasItemConteo').getValue()
                                                                },
                                                                success: function(response,options)
                                                                {
                                                                    var Respuesta = response.responseText;
                                                                    var Contenido = Respuesta.split('^');
                                                                    if(Contenido[0] === "{success:false}" || Contenido[0] === "{failure:true}"){
                                                                        Ext.MessageBox.show({
                                                                            title: 'eOfiClinic',
                                                                            msg: 'El Codigo de Barras no esta asociado a ningun concepto.',
                                                                            buttons: Ext.MessageBox.OK,
                                                                            icon: Ext.MessageBox.ERROR
                                                                        });
                                                                    } else {
                                                                        Ext.getCmp('intLoteConceptoItemConteo').store.removeAll();
                                                                        Ext.getCmp('intUsaLoteItemConteo').setValue(Contenido[3]);
                                                                        Ext.getCmp('intidConceptoItemConteo').setValue(Contenido[0]);
                                                                        Ext.getCmp('strCodConceptoItemConteo').setValue(Contenido[1]);
                                                                        Ext.getCmp('strDesConceptoItemConteo').setValue(Contenido[2]);
                                                                        if(parseInt(Ext.getCmp('intUsaLoteItemConteo').getValue()) === 1){
                                                                            Ext.getCmp('intLoteConceptoItemConteo').store.load({
                                                                                params:{
                                                                                    pConcepto: Ext.getCmp('intidConceptoItemConteo').getValue()
                                                                                }
                                                                            });
                                                                            Ext.getCmp('intLoteConceptoItemConteo').allowBlank = false;
                                                                            Ext.getCmp('intLoteConceptoItemConteo').setVisible(true);
                                                                        }else{
                                                                            Ext.getCmp('intLoteConceptoItemConteo').setValue(null);
                                                                            Ext.getCmp('intLoteConceptoItemConteo').clearInvalid();
                                                                            Ext.getCmp('intLoteConceptoItemConteo').allowBlank = true;
                                                                            Ext.getCmp('intLoteConceptoItemConteo').setVisible(false);
                                                                        }
                                                                    }
                                                                },
                                                                failure: function(response,options){
                                                                    Ext.MessageBox.show({
                                                                        title: 'Error Conexión',
                                                                        msg: 'El Codigo de Barras no esta asociado a ningun concepto.',
                                                                        buttons: Ext.MessageBox.OK,
                                                                        icon: Ext.MessageBox.ERROR
                                                                    });
                                                                },
                                                                scope:this 
                                                            });
                                                        }
                                                    }
                                                }
                                            },
                                            {
                                                xtype: 'button',
                                                iconCls: 'btnBuscar',
                                                tooltip: 'Buscar Concepto',
                                                id: 'btnSearchConceptoItemConteo',
                                                handler:function(){
                                                    buscarconceptoBasico('ItemConteo');
                                                }
                                            },
                                            {
                                                xtype: 'textfield',
                                                readOnly: true,
                                                width: 96,
                                                allowBlank: false,
                                                style: 'color: #0000cc; font-weight: bold;',
                                                id: 'strCodConceptoItemConteo'
                                            },
                                            {
                                                xtype: 'textarea',
                                                readOnly: true,
                                                width: 435,
                                                height: 90,
                                                style: 'font-family: Arial,Helvetica,sans-serif;font-size: 10px; color: #0000cc; font-weight: bold;',
                                                id: 'strDesConceptoItemConteo'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'compositefield',
                                        style: 'background:transparent;',
                                        items: [
                                            {
                                                xtype: 'numericfield',
                                                fieldLabel: 'Entrada',
                                                width: 100,
                                                allowBlank: false,
                                                currencySymbol: '',
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: false,
                                                thousandSeparator: ',',
                                                minValue: 0,
                                                decimalPrecision: 0,
                                                id: 'intEntrada'
                                            },
                                            {
                                                html: '&nbsp;&nbsp;&nbsp;Salida'
                                            },
                                            {
                                                xtype: 'numericfield',
                                                name: 'Salida',
                                                width: 100,
                                                allowBlank: false,
                                                currencySymbol: '',
                                                useThousandSeparator: true,
                                                alwaysDisplayDecimals: false,
                                                thousandSeparator: ',',
                                                minValue: 0,
                                                decimalPrecision: 0,
                                                id: 'intSalida'
                                            }
                                        ]
                                    },
                                    {
                                        xtype: 'numberfield',
                                        name: 'VlrCompra',
                                        fieldLabel: 'VlrCompra',
                                        width: 100,
                                        allowBlank: true,
                                        id: 'intVlrCompra'
                                    }
                                ]
                            }
                        ]
                    }
                ],
                bbar:{
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            text: 'Crear Registro',
                            iconCls: 'btnAsignarCita',
                            id: 'btnCrearAlerta',
                            listeners:{
                                click : function(){
                                    guardarItem()
                            }
                        }
                    }
                ]
            }
        }];
        this.on({
            afterlayout:{
                scope:this, 
                single:true, 
                fn:function() {
                    Ext.Msg.hide();
                    if(Ext.getCmp('sysTipoMovimiento').getValue() == 4){
                        Ext.getCmp('intSalida').allowBlank = true
                        Ext.getCmp('intEntrada').allowBlank = false
                        Ext.getCmp('intSalida').disable()
                        Ext.getCmp('intEntrada').enable()
                    }else{
                        if(Ext.getCmp('sysTipoMovimiento').getValue() == 6){
                            Ext.getCmp('intSalida').allowBlank = false
                            Ext.getCmp('intEntrada').allowBlank = true
                            Ext.getCmp('intSalida').enable()
                            Ext.getCmp('intEntrada').disable()
                        }else{
                            if(Ext.getCmp('sysTipoMovimiento').getValue() == 8){
                                Ext.getCmp('intSalida').allowBlank = false
                                Ext.getCmp('intEntrada').allowBlank = true
                                Ext.getCmp('intSalida').enable()
                                Ext.getCmp('intEntrada').disable()
                            }else{
                                if(Ext.getCmp('sysTipoMovimiento').getValue() == 9){
                                    Ext.getCmp('intSalida').allowBlank = false
                                    Ext.getCmp('intEntrada').allowBlank = true
                                    Ext.getCmp('intSalida').enable()
                                    Ext.getCmp('intEntrada').disable()
                                }else{
                                    Ext.getCmp('intSalida').allowBlank = true
                                    Ext.getCmp('intEntrada').allowBlank = true
                                    Ext.getCmp('intSalida').disable()
                                    Ext.getCmp('intEntrada').disable()
                                }
                            }
                        }
                    }
                }
            }
        });
        winAddItemUi.superclass.initComponent.call(this);
    }
});

function guardarItem(){
        Ext.Msg.show({
        title: 'Guardar Alerta....!',
        msg: 'Esta seguro que desea Guardar la Informacion?',
        buttons: Ext.Msg.YESNO,
        icon: Ext.Msg.QUESTION,
        fn: function(btn)
        {
            if(btn=="yes")
            {
              var frm = Ext.getCmp('frmAddItem').getForm();
                if (frm.isValid())
                {
                    frm.submit({
                        url: '../../controlador/inventario/controlador_inventario.php',
                        params: {
                            task: 'ADD_MOVIMIENTO_DETALLE',
                            pItem: Ext.getCmp('intidConceptoItemConteo').getValue(),
                            pEntrada: Ext.getCmp('intEntrada').getValue(),
                            pSalida: Ext.getCmp('intSalida').getValue(),
                            pVlrCompra: Ext.getCmp('intVlrCompra').getValue(),
                            pMovimiento: Ext.getCmp('sysConsecutivoMovimiento').getValue()
                        },
                        success: function(res,req)
                        {
                            switch(req.result.requestedId){
                                case "1":
                                    Ext.MessageBox.show({
                                        title: 'Guardar Alerta',
                                        msg: 'Se Guardo Informacion con Exito.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                    Ext.getCmp('winAddItem').close();
                                    Ext.getCmp("gridMovimientos").reload();
                                    break;

                                default:
                                    Ext.MessageBox.show({
                                        title: 'Guardar Alerta',
                                        msg: 'Ocurrio un error al Guardar la Informacion o no se pudo establecer conexión con el servidor.',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                    break;
                            }
                        },
                        failure: function(response,options)
                        {
                            Ext.MessageBox.show({
                                title: 'Error Base Datos',
                                msg: 'No podemos Guardar la Informacion en estos momentos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    });
                }else{
                    Ext.MessageBox.show({
                        title: 'Error',
                        msg: 'Por favor verifique que todos los campos obligatorios estén diligenciados.',
                        buttons: Ext.MessageBox.OK,
                        icon: Ext.MessageBox.ERROR
                    });
                }
            }
        }
    });
}
