/*
* @category    Formulario Ver Ordenamientos HC
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winViewOrdenamientosUi = Ext.extend(Ext.Window, {
    title: 'eOfiClinic .:: Ver Historial Ordenamientos ::.',
    width: 970,
    height: 570,
    border: false,
    modal: true,
    closable: false,
    padding: 10,
    id: 'winViewOrdenamientos',
    initComponent: function() {
        el = Ext.get('idaplicacion');
        //NOMAPLICACION = el.getValue();
        NOMAPLICACION = "OfiClinic";
        
        function VerInfoServicio(value, metaData, record, rowIndex, colIndex, store){  
            metaData.attr = 'style="white-space:normal"';  
            return '<h3><b>' + value + '</b></h3>' + '</br><h4>' + record.get('Actividad') + '</br><span style="color: darkblue;">Profesional: ' + record.get('NomProfe') + '</span></br></br><span style="color: #B40404;">Programa: ' + record.get('Programa') + '</span></h4>';  
        }
        
        var viewResumenOrdenamientos = new Ext.Panel({
            id:'viewResumenOrdenamientos',
            width: 620,
            height: 475,
            autoScroll:true,
            closable:false
        });
        
        this.bbar = [
            {
                xtype: 'tbseparator'
            },
            /*{
                xtype: 'button',
                text: 'Importar Ordenamiento',
                iconCls: 'btnAceptar',
                id: 'btnAddOrdenamientosHC',
                listeners: {
                    click : function() {
                        if(parseInt(Ext.getCmp('gridHistorialOrdenamientos').selModel.getCount()) === 1){
                            var selections = Ext.getCmp('gridHistorialOrdenamientos').selModel.getSelections();
                            Ext.Msg.show({
                                title: 'eOfiClinic',
                                msg: 'Esta seguro que desea cargar los ordenamientos de la atencion seleccionada?',
                                buttons: Ext.Msg.YESNO,
                                icon: Ext.Msg.QUESTION,
                                fn: function(btn){
                                    if(btn=="yes"){
                                        Ext.Ajax.request({
                                            waitMsg: 'Por favor Espere...',
                                            url: "../../controlador/solexa/controlador_solexa.php",
                                            params: {
                                                task: "CARGAR_EXA_ORDENSELECCIONADA",
                                                pEmpresa: ID_EMPRESA,
                                                pSEDE: ID_SEDE, 
                                                pIPS: ID_IPS, 
                                                pCASOrigen:  selections[0].json.CAS,
                                                pCASDestino: Ext.getCmp('CASImportarOrdenamientos').getValue(),
                                                pCargarReporteParaclinicos: Ext.getCmp('CargarReporteParaclinicos').getValue()
                                            },
                                            success: function(response)
                                            {
                                                var result = response.responseText.split("^");
                                                Ext.getCmp('gridExamenesHC').store.reload();
                                                try {
                                                    var campo = Ext.getCmp('gridReporteParaclinicos');
                                                    if ( campo != null ) {
                                                        Ext.getCmp("gridReporteParaclinicos").store.reload();
                                                    }
                                                }catch(ex) {
                                                }
                                                Ext.getCmp('winViewOrdenamientos').close();;
                                            },
                                            failure: function(response){
                                                var result = response.responseText;
                                                Ext.MessageBox.show({
                                                    title: 'Error Base Datos',
                                                    msg: 'Error de conexión - No podemos adicionar los ordenamientos en estos momentos',
                                                    buttons: Ext.MessageBox.OK,
                                                    icon: Ext.MessageBox.ERROR
                                                });
                                            }
                                        });
                                    }
                                }
                            });
                        }else{
                            Ext.MessageBox.show({
                                title: NOMAPLICACION,
                                msg: 'Debe Seleccionar una Evolución.',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            },*/
            {
                xtype: 'tbfill'
            },
            {
                xtype: 'button',
                text: 'Salir',
                iconCls: 'btnSalir',
                listeners: {
                    click : function() {
                        Ext.getCmp('winViewOrdenamientos').close();
                    }
                }
            }
        ];
        
        this.items = [
            {
                xtype: 'hidden',
                id: 'CASImportarOrdenamientos'
            },
            {
                xtype: 'hidden',
                id: 'CargarReporteParaclinicos'
            },
            {
                xtype: 'panel',
                title: 'Historial de Ordenamientos',
                layout: 'hbox',
                //width: 900,
                anchor: '100%',
                height: 500,
                items: [
                    {
                        xtype: 'grid',
                        store: 'StoreGridHistorialOrdenamientosHC',
                        title: 'Atenciones',
                        width: 320,
                        height: 485,
                        flex: 1,
                        id: 'gridHistorialOrdenamientos',
                        columns: [
                            {
                                xtype: 'gridcolumn',
                                header: 'Fecha',
                                sortable: true,
                                width: 120,
                                dataIndex: 'FechaAtencion',
                                renderer: VerInfoServicio,
                                hideable: false
                            }
                        ],
                        viewConfig: {
                            forceFit:true
                        },
                        selModel: new Ext.grid.RowSelectionModel({singleSelect:true})
                    },
                    viewResumenOrdenamientos
                ]
            }
        ];
        winViewOrdenamientosUi.superclass.initComponent.call(this);
    }
});
