/*
* @category    Formulario RIPS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmRIPSUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: RIPS - Salud P&P ::.',
    id: 'winFrmRIPS',
    closable:false,
    width:1004,
    autoHeight: true,
    resizable : false,
    border: false,
    frame: true,
    //autoScroll: true,
    y:120,
    initComponent: function() {
        var mybbar = new utilBbarUi();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        this.bbar = mybbar;
        stProfesionalesxIPS = new StoreProfesionales();
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmFacturacion',
                border: false,
                autoHeight: true,
                padding: 3,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'compositefield',
                        style: 'background:transparent;',
                        anchor: '100%',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Cliente',
                                width: 300,
                                allowBlank: false,
                                store: 'StoreCliente',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Cliente....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intClienteFacturacion',
                                listeners: {
                                    select: function(cmb, rec, idx) {
                                        if(cmb.getValue() === null || cmb.getValue() === ""){
                                            Ext.getCmp('intPlanFacturacion').store.removeAll(true);
                                            Ext.getCmp('intSubPlanFacturacion').store.removeAll(true);
                                            Ext.getCmp('intContratoFacturacion').store.removeAll(true);
                                            Ext.getCmp('intPlanFacturacion').setValue(null);
                                            Ext.getCmp('intSubPlanFacturacion').setValue(null);
                                            Ext.getCmp('intPlanFacturacion').disable();
                                            Ext.getCmp('intSubPlanFacturacion').disable();
                                            Ext.getCmp('intContratoFacturacion').disable();
                                            
                                        }else{
                                            Ext.getCmp('intPlanFacturacion').store.removeAll(true);
                                            Ext.getCmp('intSubPlanFacturacion').store.removeAll(true);
                                            Ext.getCmp('intContratoFacturacion').store.removeAll(true);
                                            Ext.getCmp('intPlanFacturacion').setValue(null);
                                            Ext.getCmp('intSubPlanFacturacion').setValue(null);
                                            Ext.getCmp('intSubPlanFacturacion').disable();
                                            Ext.getCmp('intPlanFacturacion').store.load({
                                                params:{
                                                    pCliente: cmb.getValue()
                                                },
                                                callback: function(){
                                                    Ext.getCmp('intPlanFacturacion').enable();
                                                }
                                            });
                                            Ext.getCmp('intContratoFacturacion').store.load({
                                                params:{
                                                    pCliente: cmb.getValue()
                                                },
                                                callback: function(){
                                                    Ext.getCmp('intContratoFacturacion').enable();
                                                }
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Plan:'
                            },
                            {
                                xtype: 'combo',
                                width: 135,
                                listWidth: 250,
                                allowBlank: true,
                                disabled: true,
                                store: 'StoreClientesPlan',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdPlan',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Plan....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intPlanFacturacion',
                                listeners: {
                                    select: function(cmb, rec, idx) {
                                        if(cmb.getValue() === null || cmb.getValue() === ""){
                                            Ext.getCmp('intSubPlanFacturacion').store.removeAll(true);
                                            Ext.getCmp('intSubPlanFacturacion').setValue(null);
                                            Ext.getCmp('intSubPlanFacturacion').disable();
                                        }else{
                                            Ext.getCmp('intSubPlanFacturacion').store.removeAll(true);
                                            Ext.getCmp('intSubPlanFacturacion').store.load({
                                                params:{
                                                    pPlan: cmb.getValue()
                                                },
                                                callback: function(){
                                                    Ext.getCmp('intSubPlanFacturacion').enable();
                                                }
                                            });
                                        }
                                    }
                                }
                            },
                            {
                                xtype: 'displayfield',
                                value: 'SubPlan:'
                            },
                            {
                                xtype: 'combo',
                                width: 135,
                                listWidth: 250,
                                allowBlank: true,
                                disabled: true,
                                store: 'StoreClienteSubplan',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdSubPlan',
                                displayField: 'Descripcion',
                                emptyText: 'Seleccione Plan....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intSubPlanFacturacion'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Contrato:'
                            },
                            {
                                xtype: 'combo',
                                width: 133,
                                listWidth: 250,
                                allowBlank: true,
                                disabled: true,
                                store: 'StoreClienteContrato',
                                typeAhead: true,
                                typeAheadDelay: 50,
                                valueField: 'IdContrato',
                                displayField: 'Contrato',
                                emptyText: 'Seleccione Contrato....',
                                mode: 'local',
                                triggerAction: 'all',
                                forceSelection: true,
                                id: 'intContratoFacturacion'
                            }
                        ]
                    },
                    {
                        xtype: 'combo',
                        anchor: '100%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        fieldLabel: 'Profesional',
                        listWidth: 670,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: stProfesionalesxIPS,
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: true,
                        id: 'intProfesional'
                    },
                    //{
                    //    xtype: 'displayfield',
                    //    value: 'Nro Factura:'
                    //},
                    {
                        //xtype: 'combo',
                        xtype: 'hidden',
                        width: 120,
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StoreFacturasIns',
                        triggerAction: 'all',
                        mode: 'local',
                        allowBlank: true,
                        id: 'sysNroFactura'
                    },
                    //{
                    //    xtype: 'displayfield',
                    //    value: 'Particular:'
                    //},
                    {
                        xtype: 'hidden',
                        width: 50,
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StoreSiNo',
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: false,
                        value: 'NO',
                        id: 'strParticulares'
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                fieldLabel: 'Desde',
                                width: 100,
                                allowBlank: false,
                                id: 'fecDesdeFacturacion'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Hasta:'
                            },
                            {
                                xtype: 'datefield',
                                width: 100,
                                allowBlank: false,
                                id: 'fecHastaFacturacion'
                            },
                            {
                                xtype: 'displayfield',
                                value: '# Env.:'
                            },
                            {
                                xtype: 'numberfield',
                                minValue: 1,
                                decimalPrecision: 0,
                                allowBlank: false,
                                width: 60,
                                value: (new Date().getMonth() + 1),
                                id: 'intEnvio'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Capita:'
                            },
                            {
                                xtype: 'combo',
                                width: 50,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                title: '',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                store: 'StoreSiNo',
                                triggerAction: 'all',
                                mode: 'local',
                                emptyText: 'Seleccione...!',
                                allowBlank: false,
                                value: 'SI',
                                id: 'strCapitacion'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Por CAS:'
                            },
                            {
                                xtype: 'combo',
                                width: 50,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                title: '',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                store: 'StoreSiNo',
                                triggerAction: 'all',
                                mode: 'local',
                                emptyText: 'Seleccione...!',
                                allowBlank: false,
                                value: 'SI',
                                id: 'strXCAS'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        fbar: {
                            xtype: 'toolbar',
                            width: 760,
                            buttonAlign: 'center',
                            items: [
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnAceptar',
                                    text: 'RIPS Generales',
                                    id: 'btnGenerarRIPSRadica'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnAceptar',
                                    text: 'RIPS por Profesional',
                                    id: 'btnGenerarRIPS'
                                },
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnGuardar',
                                    text: 'Descargar Archivos',
                                    id: 'btnDescargarRIPS'
                                },
                                {
                                    xtype: 'tbseparator'
                                }
                            ]
                        }
                    }
                ],
                tbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnLimpiar',
                            text: 'Limpiar Formulario',
                            id: 'btnLimpiar'
                        }
                    ]
                }
            },
            
        ];
        winFrmRIPSUi.superclass.initComponent.call(this);
    }
});
