/*
* @category    Programacion Eventos Formulario RIPS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmRIPS = Ext.extend(winFrmRIPSUi, {
    initComponent: function() {
        winFrmRIPS.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnLimpiar = Ext.getCmp('btnLimpiar').on("click",this.LimpiarFormulario,this);
        var btnGenerarRIPS = Ext.getCmp('btnGenerarRIPS').on("click",this.GenerarRIPS,this);
        var btnDescargarRIPS = Ext.getCmp('btnDescargarRIPS').on("click",this.DescargarRIPS,this);
        
        var intClienteFacturacion = Ext.getCmp('intClienteFacturacion').on("select",this.CargaFacturas,this);
        
    },
    DescargarRIPS: function(){
        location.href = "../../controlador/facturacion/descargarips.php?pConsecutivo=" + Ext.getCmp('intEnvio').getValue();
    },
    GenerarRIPS: function(){
        Ext.Msg.show({
            title: 'Facturación',
            msg: 'Esta seguro que desea los RIPS?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn){
                if(btn=="yes"){
                    var frm = Ext.getCmp('frmFacturacion').getForm();
                    if (frm.isValid()){
                        Ext.Msg.wait('Generando RIPS... por favor espere!');
                        Ext.Ajax.request({
                            url: "../../controlador/facturacion/facturacion.php",
                            params: {
                                task: "GENERAR_RIPS",
                                pEmpresa: ID_EMPRESA,
                                pCliente: Ext.getCmp('intClienteFacturacion').getValue(),
                                pParticulares: Ext.getCmp('strParticulares').getValue(),
                                pFactura: Ext.getCmp('sysNroFactura').getValue(),
                                pDesde: Ext.getCmp('fecDesdeFacturacion').getValue().format("Y-m-d"),
                                pHasta: Ext.getCmp('fecHastaFacturacion').getValue().format("Y-m-d"),
                                pConsecutivo: Ext.getCmp('intEnvio').getValue()
                            },
                            success: function(response)
                            {
                                var result = response.responseText;
                                if (result > 0)
                                {
                                    Ext.Msg.hide();
                                    Ext.getCmp('sysNroFactura').store.load({
                                       params: {
                                           pEmpresa: ID_EMPRESA,
                                           pCliente: Ext.getCmp('intClienteFacturacion').getValue()
                                       } 
                                    });
                                    Ext.getCmp('sysNroFactura').setValue(null);
                                    var html = '<table><tr><td width="50"><img src="../../../resources/varios/rips.png" alt=""/></td><td width="10">&nbsp</td><td style="padding 10px;"><h1 style="color: #2E2EFE; font-size: 14px;">Facturación:</h1><br/><p style="color: #003333;font-weight: bold;">Se Generaron los RIPS, por favor descarguelos</p>';
                                    html += '</td><td width="70">&nbsp</td></tr></table>';
                                    Sexy.info(html);
                                }else{
                                    Ext.MessageBox.show({
                                        title: 'Error',
                                        msg: 'No podemos generar los RIPS en estos momentos',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }
                            },
                            failure: function(response){
                                var result = response.responseText;
                                Ext.MessageBox.show({
                                    title: 'Error Base Datos',
                                    msg: 'No podemos generar los RIPS en estos momentos',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }
                        });
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Verifique los campos requeridos',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
            }
        });
    },
    CargaFacturas: function(cmb, rec, idx) {
        Ext.getCmp('sysNroFactura').setValue(null);
        Ext.getCmp('sysNroFactura').store.load({
           params: {
               pEmpresa: ID_EMPRESA,
               pCliente: cmb.getValue(),
               pIPS: ID_IPS
           } 
        });
    },
    LimpiarFormulario: function(){
        var frm = Ext.getCmp('frmFacturacion').getForm();
        frm.reset();
        frm.clearInvalid();
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
    
});

