/*
* @category    Formulario RIPS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmHEONUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Archivos Cuenta HEON ::.',
    id: 'winFrmRIPS',
    closable:false,
    width:980,
    autoHeight: true,
    resizable : false,
    border: false,
    frame: true,
    //autoScroll: true,
    y:120,
    initComponent: function() {
        var mybbar = new utilBbarUi();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmFacturacion',
                border: false,
                autoHeight: true,
                padding: 3,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'combo',
                        anchor: '96%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StoreCliente',
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: false,
                        fieldLabel: 'Cliente',
                        id: 'intClienteFacturacion'
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '96%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'displayfield',
                                fieldLabel: '',
                                value: 'Desde:'
                            },
                            {
                                xtype: 'datefield',
                                width: 100,
                                allowBlank: false,
                                id: 'fecDesdeFacturacion'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Hasta:'
                            },
                            {
                                xtype: 'datefield',
                                width: 100,
                                allowBlank: false,
                                id: 'fecHastaFacturacion'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Nro Factura:'
                            },
                            {
                                xtype: 'combo',
                                fieldLabel: 'Factura',
                                width: 120,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                title: '',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                store: 'StoreFacturasIns',
                                triggerAction: 'all',
                                mode: 'local',
                                allowBlank: true,
                                id: 'sysNroFactura'
                            },
                            {
                                xtype: 'hidden',
                                minValue: 1,
                                decimalPrecision: 0,
                                allowBlank: true,
                                width: 60,
                                value: (new Date().getMonth() + 1),
                                id: 'intEnvio'
                            },
                            {
                                xtype: 'hidden',
                                /*width: 90,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                title: '',
                                valueField: 'Codigo',
                                displayField: 'Descripcion',
                                store: 'StoreSiNo',
                                triggerAction: 'all',
                                mode: 'local',
                                emptyText: 'Seleccione...!',*/
                                allowBlank: true,
                                id: 'strParticulares'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        fbar: {
                            xtype: 'toolbar',
                            width: 760,
                            buttonAlign: 'center',
                            items: [
                                {
                                    xtype: 'button',
                                    iconCls: 'btnAceptar',
                                    text: 'Generar Archivos',
                                    id: 'btnGenerarRIPS'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnGuardar',
                                    text: 'Descargar Archivos',
                                    id: 'btnDescargarRIPS'
                                }
                            ]
                        }
                    }
                ],
                tbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnLimpiar',
                            text: 'Limpiar Formulario',
                            id: 'btnLimpiar'
                        }
                    ]
                }
            }
        ];
        winFrmHEONUi.superclass.initComponent.call(this);
    }
});
