/*
* @category    Programacion Eventos Formulario Notas Factura
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmNotasFac = Ext.extend(winFrmNotasFacUi, {
    initComponent: function() {
        winFrmNotasFac.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        
        var FechaFactura = new Date();
        var ValorTotal = 0;
        var ValorCM = 0;
        var ValorCOP = 0;
        var ValorDesc = 0;
        var ValorFactura = 0;
        
        var btnLimpiar = Ext.getCmp('btnLimpiar').on("click",this.LimpiarFormulario,this);
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnImprimirAnulada = Ext.getCmp('btnImprimirAnulada').on("click",this.ImprimirFacturaAnulada,this);
        var btnAnularFactura = Ext.getCmp('btnAnularFactura').on("click",this.NotaFactura,this);
        var sysClienteFacturacion = Ext.getCmp('sysClienteFacturacion').on("select",this.CargaFacturas,this);
        var sysNroFactura = Ext.getCmp('sysNroFactura').on("select",this.CargaInfoFactura,this);
        var sysNroNota = Ext.getCmp('sysNroNota').on("select",this.CargaInfoNota,this);
    },
    LimpiarFormulario: function(){
        var frm = Ext.getCmp('frmNotas').getForm();
        frm.reset();
        frm.clearInvalid();
    },
    NotaFactura: function(){
        if(Ext.getCmp('sysPuedeAnular').getValue() == 1){
            Ext.Msg.show({
                title: 'Facturación',
                msg: 'Esta seguro que desea Realizar la Nota a la Factura?',
                buttons: Ext.Msg.YESNO,
                icon: Ext.Msg.QUESTION,
                fn: function(btn){
                    if(btn=="yes"){
                        var frm = Ext.getCmp('frmNotas').getForm();
                        if (frm.isValid()){
                            Ext.Msg.wait('Aplicando Nota Factura... por favor espere!');
                            Ext.Ajax.request({
                                url: "../../controlador/facturacion/facturacion.php",
                                params: {
                                    task: "NOTA_FACTURA",
                                    pEmpresa: ID_EMPRESA,
                                    pCliente: Ext.getCmp('sysClienteFacturacion').getValue(),
                                    pFactura: Ext.getCmp('sysNroFactura').getValue(),
                                    pFecha: Ext.getCmp('sysAnulaFactura').getValue().format("Y-m-d"),
                                    pTipo: Ext.getCmp('sysTipoNotaFacturacion').getValue(),
                                    pValorTotal: Ext.getCmp('intVlrNotaValorTotal').getValue(),
                                    pValorCM: Ext.getCmp('intVlrNotaValorCM').getValue(),
                                    pValorCOP: Ext.getCmp('intVlrNotaValorCOP').getValue(),
                                    pValorDesc: Ext.getCmp('intVlrNotaValorDescuentos').getValue(),
                                    pValorNeto: Ext.getCmp('intVlrNotaValorNeto').getValue(),
                                    pMotivo: Ext.getCmp('sysMotivoAnulacion').getValue(),
                                    pUsuario: ID_USUARIO
                                },
                                success: function(response)
                                {
                                    var result = response.responseText;
                                    if (result > 0)
                                    {
                                        Ext.Msg.hide();
                                        Ext.MessageBox.show({
                                            title: 'eOfiClinic',
                                            msg: 'La nota se aplico con exito.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.INFO
                                        });
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Error',
                                            msg: 'No podemos aplicar la nota en estos momentos',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                    }
                                },
                                failure: function(response){
                                    var result = response.responseText;
                                    Ext.MessageBox.show({
                                        title: 'Error Base Datos',
                                        msg: 'No podemos aplicar la nota en estos momentos',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }
                            });
                        }else{
                            Ext.MessageBox.show({
                                title: 'Error',
                                msg: 'Verifique los campos requeridos',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }
                }
            });
        }else{
            Ext.MessageBox.show({
                title: 'Error',
                msg: 'La Factura no esta disponible para aplicar la nota',
                buttons: Ext.MessageBox.OK,
                icon: Ext.MessageBox.ERROR
            });
        }
    },
    CargaFacturas: function(cmb, rec, idx) {
        Ext.getCmp('sysNroFactura').setValue(null);
        Ext.getCmp('sysNroFactura').store.load({
           params: {
               pEmpresa: ID_EMPRESA,
               pCliente: cmb.getValue(),
               pIPS: ID_IPS
           } 
        });
    },
    CargaInfoFactura: function(cmb, rec, idx) {
        Ext.getCmp('sysPuedeAnular').setValue(1);
        if(rec.data.Anulada == 1 || rec.data.Anulada == '1'){
            Ext.getCmp('sysPuedeAnular').setValue(0);
        }
        Ext.getCmp('sysNroNota').setValue(null);
        Ext.getCmp('sysNroNota').store.removeAll();
        Ext.getCmp('sysNroNota').store.load({
           params: {
               pFactura: Ext.getCmp('sysNroFactura').getValue()
           } 
        });
        FechaFactura = rec.data.FechaDocumento;
        ValorTotal = rec.data.VlrTotal;
        ValorCM = rec.data.VlrCuotaModeradora;
        ValorCOP = rec.data.VlrCopagos;
        ValorDesc = rec.data.VlrDescuentos;
        ValorFactura = rec.data.VlrNeto;
        Ext.getCmp('sysAnulaFactura').setValue(null);
        Ext.getCmp('sysTipoNotaFacturacion').setValue(null);
        Ext.getCmp('sysMotivoAnulacion').setValue(null);
        Ext.getCmp('sysAnulaFactura').setReadOnly(false);
        Ext.getCmp('sysTipoNotaFacturacion').setReadOnly(false);
        Ext.getCmp('sysMotivoAnulacion').setReadOnly(false);
        Ext.getCmp('intVlrNotaValorTotal').setReadOnly(false);
        Ext.getCmp('intVlrNotaValorCM').setReadOnly(false);
        Ext.getCmp('intVlrNotaValorCOP').setReadOnly(false);
        Ext.getCmp('intVlrNotaValorDescuentos').setReadOnly(false);
        Ext.getCmp('intVlrNotaValorNeto').setReadOnly(false);
        Ext.getCmp('btnAnularFactura').setDisabled(false);
        Ext.getCmp('btnAnularFactura').setDisabled(false);
        Ext.getCmp('intVlrNotaValorTotal').setValue(null);
        Ext.getCmp('intVlrNotaValorTotal').setValue(rec.data.VlrTotal);
        Ext.getCmp('intVlrNotaValorCM').setValue(null);
        Ext.getCmp('intVlrNotaValorCM').setValue(rec.data.VlrCuotaModeradora);
        Ext.getCmp('intVlrNotaValorCOP').setValue(null);
        Ext.getCmp('intVlrNotaValorCOP').setValue(rec.data.VlrCopagos);
        Ext.getCmp('intVlrNotaValorDescuentos').setValue(null);
        Ext.getCmp('intVlrNotaValorDescuentos').setValue(rec.data.VlrDescuentos);
        Ext.getCmp('intVlrNotaValorNeto').setValue(null);
        Ext.getCmp('intVlrNotaValorNeto').setValue(rec.data.VlrNeto);
    },
    CargaInfoNota: function(cmb, rec, idx) {
        if(cmb.getValue() !== null && cmb.getValue() !== ""){
            Ext.getCmp('sysAnulaFactura').setValue(rec.data.FechaDocumento);
            Ext.getCmp('sysTipoNotaFacturacion').setValue(rec.data.Naturaleza);
            Ext.getCmp('sysMotivoAnulacion').setValue(rec.data.Concepto);
            Ext.getCmp('intVlrNotaValorTotal').setValue(null);
            Ext.getCmp('intVlrNotaValorTotal').setValue(rec.data.VlrTotal);
            Ext.getCmp('intVlrNotaValorCM').setValue(null);
            Ext.getCmp('intVlrNotaValorCM').setValue(rec.data.VlrCuotaModeradora);
            Ext.getCmp('intVlrNotaValorCOP').setValue(null);
            Ext.getCmp('intVlrNotaValorCOP').setValue(rec.data.VlrCopagos);
            Ext.getCmp('intVlrNotaValorDescuentos').setValue(null);
            Ext.getCmp('intVlrNotaValorDescuentos').setValue(rec.data.VlrDescuentos);
            Ext.getCmp('intVlrNotaValorNeto').setValue(null);
            Ext.getCmp('intVlrNotaValorNeto').setValue(rec.data.VlrNeto);
            Ext.getCmp('sysAnulaFactura').setReadOnly(true);
            Ext.getCmp('sysTipoNotaFacturacion').setReadOnly(true);
            Ext.getCmp('sysMotivoAnulacion').setReadOnly(true);
            Ext.getCmp('intVlrNotaValorTotal').setReadOnly(true);
            Ext.getCmp('intVlrNotaValorCM').setReadOnly(true);
            Ext.getCmp('intVlrNotaValorCOP').setReadOnly(true);
            Ext.getCmp('intVlrNotaValorDescuentos').setReadOnly(true);
            Ext.getCmp('intVlrNotaValorNeto').setReadOnly(true);
            Ext.getCmp('btnAnularFactura').setDisabled(true);
        }
    },
    ImprimirFacturaAnulada: function(){
        if(Ext.getCmp('sysNroFactura').getValue() !== "" && Ext.getCmp('sysNroFactura').getValue() !== null && Ext.getCmp('sysNroNota').getValue() !== "" && Ext.getCmp('sysNroNota').getValue() !== null){
            window.open ("../../controlador/facturacion/inffactura_notadc.php?pDocumento="+Ext.getCmp('sysNroNota').getValue()+"&pDocumentoFac="+Ext.getCmp('sysNroFactura').getValue(),"Nota Factura");
        }
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn){
                if(btn === "yes"){
                    window.close();
                }
            }
        });
    }
    
});

