/*
* @category    Programacion Eventos Formulario Tipo de Horario
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmUnificarPaciente = Ext.extend(winFrmUnificarPacienteUi, {
    initComponent: function() {
        winFrmUnificarPaciente.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        FACTURA_PACIENTE = false;
        BD_MULTIPRESTADOR = "NA";
        el = Ext.get('impFACTURAPAC_MC');
        FACTURAPAC_MC = el.getValue();
                
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        Ext.getCmp('infoCapitaFacturacion').setVisible(false);
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnLimpiar = Ext.getCmp('btnLimpiar').on("click",this.LimpiarFormulario,this);
        var btnGenerarPrefa = Ext.getCmp('btnGenerarPrefa').on("click",this.GenerarPrefactura,this);
        var btnImprimirDetaPrefa = Ext.getCmp('btnImprimirDetaPrefa').on("click",this.ImprimirPrefacturaDetalle,this);
        var btnDetallePrefa = Ext.getCmp('btnDetallePrefa').on("click",this.ExportarPrefacturaDetalle,this);
        var btnGenerarFactura = Ext.getCmp('btnGenerarFactura').on("click",this.GenerarFactura,this);
        var btnImprimirFactura = Ext.getCmp('btnImprimirFactura').on("click",this.ImprmirFacturaxDetalle,this);
        var btnImprimirFacturaxPlan = Ext.getCmp('btnImprimirFacturaxPlan').on("click",this.ImprmirFacturaxPlan,this);
        var btnImprimirDetaFactura = Ext.getCmp('btnImprimirDetaFactura').on("click",this.ImprmirSoporteFacturaxDetalle,this);
        var btnDetalleFacturaExcel = Ext.getCmp('btnDetalleFacturaExcel').on("click",this.ExportarSoporteFacturaxDetalle,this);
        var btnImprimirBloqueFactura = Ext.getCmp('btnImprimirBloqueFactura').on("click",this.ImprimirBloqueFacturas,this);
        
        var btnBuscarPacienteFacturacion = Ext.getCmp('btnBuscarPacienteFacturacion').on("click",this.BuscarPaciente,this);
        var btnBuscarCoceptoFacturacion = Ext.getCmp('btnBuscarCoceptoFacturacion').on("click",this.BuscarConcepto,this);
        var strCapitacionFacturacion = Ext.getCmp('strCapitacionFacturacion').on("select",this.ValidarEsCapitacion,this);
        var intClienteFacturacion = Ext.getCmp('intClienteFacturacion').on("select",this.CargaCbPlan,this);
        var intPlanFacturacion = Ext.getCmp('intPlanFacturacion').on("select",this.CargaCbSubPlan,this);
        var sysNroFactura = Ext.getCmp('sysNroFactura').on("select",this.CargaFactura,this);
        
    },
    CargaFactura: function(cmb, rec, idx) {
        FACTURA_PACIENTE = false;
        if(rec.data.TipoDocumento == "FIPAC"){
            FACTURA_PACIENTE = true;
        }
    },
    ExportarSoporteFacturaxDetalle: function(){
        Ext.Msg.show({
            title: 'Facturación',
            msg: 'Esta seguro que desea exportar el detalle de la factura?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    if (Ext.getCmp('sysNroFactura').getValue() != "")
                    {
                        //location.href = "../../controlador/facturacion/inffactura_detexcel.php?pDocumento="+Ext.getCmp('sysNroFactura').getValue()+"&pCampo1="+Ext.getCmp('strCampo1').getValue()+"&pCampo2="+Ext.getCmp('strCampo2').getValue()+"&pCampo3="+Ext.getCmp('strCampo3').getValue();
                        window.open ("../../controlador/facturacion/inffactura_detexcel.php?pDocumento="+Ext.getCmp('sysNroFactura').getValue()+"&pCampo1="+Ext.getCmp('strCampo1').getValue()+"&pCampo2="+Ext.getCmp('strCampo2').getValue()+"&pCampo3="+Ext.getCmp('strCampo3').getValue(),"Facturacion");
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Verifique los campos requeridos',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
            }
        });
    },
    ImprmirSoporteFacturaxDetalle: function(){
        Ext.Msg.show({
            title: 'Facturación',
            msg: 'Esta seguro que desea imprimir el detalle de la factura?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    if (Ext.getCmp('sysNroFactura').getValue() != "")
                    {
                        //location.href = "../../controlador/facturacion/inffactura_det.php?pDocumento="+Ext.getCmp('sysNroFactura').getValue()+"&pCampo1="+Ext.getCmp('strCampo1').getValue()+"&pCampo2="+Ext.getCmp('strCampo2').getValue()+"&pCampo3="+Ext.getCmp('strCampo3').getValue();
                        window.open ("../../controlador/facturacion/inffactura_det.php?pDocumento="+Ext.getCmp('sysNroFactura').getValue()+"&pCampo1="+Ext.getCmp('strCampo1').getValue()+"&pCampo2="+Ext.getCmp('strCampo2').getValue()+"&pCampo3="+Ext.getCmp('strCampo3').getValue(),"Facturacion");
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Verifique los campos requeridos',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
            }
        });
    },
    ImprimirBloqueFacturas: function(){
        Ext.Msg.show({
            title: 'Facturación',
            msg: 'Esta seguro que desea imprimir las facturas?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    if (Ext.getCmp('intClienteFacturacion').getValue() != "" && Ext.getCmp('strFacturaDesde').getValue() != "" && Ext.getCmp('strFacturaHasta').getValue() != "")
                    {
                        if(FACTURAPAC_MC === 1 || FACTURAPAC_MC === "1"){
                            window.open ("../../controlador/facturacion/inffactura_paciente_bloquemc.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pCliente=" + Ext.getCmp('intClienteFacturacion').getValue() + "&pFacturaDesde=" + Ext.getCmp('strFacturaDesde').getValue() + "&pFacturaHasta=" + Ext.getCmp('strFacturaHasta').getValue(),"Facturacion");
                        }else{
                            window.open ("../../controlador/facturacion/inffactura_paciente_bloque.php?pEmpresa=" + ID_EMPRESA + "&pIPS=" + ID_IPS + "&pCliente=" + Ext.getCmp('intClienteFacturacion').getValue() + "&pFacturaDesde=" + Ext.getCmp('strFacturaDesde').getValue() + "&pFacturaHasta=" + Ext.getCmp('strFacturaHasta').getValue(),"Facturacion");
                        }
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Verifique los campos requeridos',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
            }
        });
    },
    ImprmirFacturaxPlan: function(){
        Ext.Msg.show({
            title: 'Facturación',
            msg: 'Esta seguro que desea imprimir la factura por plan?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn){
                if(btn==="yes"){
                    if (Ext.getCmp('sysNroFactura').getValue() !== ""){
                        window.open ("../../controlador/facturacion/inffacturaxplan.php?pDocumento="+Ext.getCmp('sysNroFactura').getValue(),"Facturacion");
                    }
                }
            }
        });
    },
    ImprmirFacturaxDetalle: function(){
        Ext.Msg.show({
            title: 'Facturación',
            msg: 'Esta seguro que desea imprimir la factura?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn==="yes")
                {
                    if (Ext.getCmp('sysNroFactura').getValue() !== "")
                    {
                        if (FACTURA_PACIENTE){
                            if(FACTURAPAC_MC === 1 || FACTURAPAC_MC === "1"){
                                window.open ("../../controlador/facturacion/inffactura_pacientemc.php?pFactura="+Ext.getCmp('sysNroFactura').getValue(),"Facturacion");
                            }else{
                                window.open ("../../controlador/facturacion/inffactura_paciente.php?pFactura="+Ext.getCmp('sysNroFactura').getValue(),"Facturacion");
                            }
                        }else{
                            //location.href = "../../controlador/facturacion/inffacturaxdetalle.php?pDocumento="+Ext.getCmp('sysNroFactura').getValue();
                            window.open ("../../controlador/facturacion/inffacturaxdetalle.php?pDocumento="+Ext.getCmp('sysNroFactura').getValue(),"Facturacion");
                        }
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Verifique los campos requeridos',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
            }
        });
    },
    GenerarFactura: function(){
        Ext.Msg.show({
            title: 'Facturación',
            msg: 'Esta seguro que desea generar la factura?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn){
                if(btn=="yes"){
                    var frm = Ext.getCmp('frmFacturacion').getForm();
                    if (frm.isValid()){
                        if(Ext.getCmp('fecFacturaFacturacion').isValid() && Ext.getCmp('fecFacturaFacturacion').getValue() != ""){
                            Ext.Msg.wait('Generando Factura de Venta... por favor espere!');
                            Ext.Ajax.request({
                                waitMsg: 'Por favor Espere...',
                                url: "../../controlador/facturacion/facturacion.php",
                                params: {
                                    task: "GENERAR_FACTURA",
                                    pEmpresa: ID_EMPRESA,
                                    pIPS: ID_IPS,
                                    pUsuario: ID_USUARIO,
                                    pPaciente: Ext.getCmp('intPacienteFacturacion').getValue(),
                                    pProcedimiento: Ext.getCmp('intConceptoFacturacion').getValue(),
                                    pCliente: Ext.getCmp('intClienteFacturacion').getValue(),
                                    pPlan: Ext.getCmp('intPlanFacturacion').getValue(),
                                    pSubplan: Ext.getCmp('intSubPlanFacturacion').getValue(),
                                    pContrato: Ext.getCmp('intContratoFacturacion').getValue(),
                                    pTipoEstudio: Ext.getCmp('intTipoEstudioFacturacion').getValue(),
                                    pCampo1: Ext.getCmp('strCampo1').getValue(),
                                    pCampo2: Ext.getCmp('strCampo2').getValue(),
                                    pCampo3: Ext.getCmp('strCampo3').getValue(),
                                    pDesde: Ext.getCmp('fecDesdeFacturacion').getValue().format("Y-m-d"),
                                    pHasta: Ext.getCmp('fecHastaFacturacion').getValue().format("Y-m-d"),
                                    pNroPacientes: Ext.getCmp('intCantidadPacientesFacturacion').getValue(),
                                    pPorFechaEstudio: Ext.getCmp('strPorFechaEstudioFacturacion').getValue(),
                                    pCapitacion: Ext.getCmp('strCapitacionFacturacion').getValue(),
                                    pVlrUPC: Ext.getCmp('intValorUPCCapitaFacturacion').getValue(),
                                    pAfiliados: Ext.getCmp('intAfiliadosCapitaFacturacion').getValue(),
                                    pProcentajeUPS: Ext.getCmp('intPorcentajeUPCCapitaFacturacion').getValue(),
                                    pVlrTotalCapita: Ext.getCmp('intValorTotalCapitaFacturacion').getValue(),
                                    pCMCapita: Ext.getCmp('intCMCapitaFacturacion').getValue(),
                                    pCopagosCapita: Ext.getCmp('intCopagosCapitaFacturacion').getValue(),
                                    pNetoCapita: Ext.getCmp('intNetoCapitaFacturacion').getValue(),
                                    pConceptoFactura: Ext.getCmp('memConceptoFacturacion').getValue(),
                                    pFechaFac: Ext.getCmp('fecFacturaFacturacion').getValue().format("Y-m-d"),
                                    pPorPaciente: Ext.getCmp('strPorPaciente').getValue()
                                },
                                success: function(response)
                                {
                                    var result = response.responseText;
                                    if (result != "0")
                                    {
                                        Ext.Msg.hide();
                                        Ext.getCmp('sysNroFactura').store.load({
                                           params: {
                                               pEmpresa: ID_EMPRESA,
                                               pCliente: Ext.getCmp('intClienteFacturacion').getValue()
                                           } 
                                        });
                                        Ext.getCmp('sysNroFactura').setValue(null);
                                        var html = '<table><tr><td width="50"><img src="../../../resources/varios/money.png" alt=""/></td><td width="10">&nbsp</td><td style="padding 10px;"><h1 style="color: #2E2EFE; font-size: 14px;">Facturación:</h1><br/><p style="color: #003333;font-weight: bold;">Se Genero la Factura de Venta Institucional Nro. ' + result  + '</p></br>';
                                        html += '</td><td width="70">&nbsp</td></tr></table>';
                                        Sexy.info(html);
                                    }else{
                                        Ext.MessageBox.show({
                                            title: 'Facturación',
                                            msg: 'Se Generaron las facturas por favor limpie el formulario, seleccione el cliente y verifique el ultimo numero de factura',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.INFO
                                        });
                                    }
                                },
                                failure: function(response){
                                    var result = response.responseText;
                                    Ext.MessageBox.show({
                                        title: 'Facturación',
                                        msg: 'Se Generaron las facturas por favor limpie el formulario, seleccione el cliente y verifique el ultimo numero de factura',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                }
                            });
                        }else{
                            Ext.MessageBox.show({
                                title: 'Error',
                                msg: 'La Fecha de Facturación es Requerida',
                                buttons: Ext.MessageBox.OK,
                                icon: Ext.MessageBox.ERROR
                            });
                        }
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Verifique los campos requeridos',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
            }
        });
    },
    ExportarPrefacturaDetalle: function(){
        Ext.Msg.show({
            title: 'Facturación',
            msg: 'Esta seguro que desea generar la prefactura?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    var frm = Ext.getCmp('frmFacturacion').getForm();
                    if (frm.isValid())
                    {
                        //location.href = "../../controlador/facturacion/infprefactura_detexcel.php?pEmpresa"+ID_EMPRESA+"&pIPS="+ID_IPS+"&pUsuario="+ID_USUARIO+"&pPaciente="+Ext.getCmp('intPacienteFacturacion').getValue()+"&pProcedimiento="+Ext.getCmp('intConceptoFacturacion').getValue()+"&pCliente="+Ext.getCmp('intClienteFacturacion').getValue()+"&pPlan="+Ext.getCmp('intPlanFacturacion').getValue()+"&pSubplan="+Ext.getCmp('intSubPlanFacturacion').getValue()+"&pContrato="+Ext.getCmp('intContratoFacturacion').getValue()+"&pTipoEstudio="+Ext.getCmp('intTipoEstudioFacturacion').getValue()+"&pCampo1="+Ext.getCmp('strCampo1').getValue()+"&pCampo2="+Ext.getCmp('strCampo2').getValue()+"&pCampo3="+Ext.getCmp('strCampo3').getValue()+"&pDesde="+Ext.getCmp('fecDesdeFacturacion').getValue().format("Y-m-d")+"&pHasta="+Ext.getCmp('fecHastaFacturacion').getValue().format("Y-m-d")+"&pNroPacientes="+Ext.getCmp('intCantidadPacientesFacturacion').getValue()+"&pPorFechaEstudio="+Ext.getCmp('strPorFechaEstudioFacturacion').getValue()+"&pCapitacion="+Ext.getCmp('strCapitacionFacturacion').getValue()+"&pVlrUPC="+Ext.getCmp('intValorUPCCapitaFacturacion').getValue()+"&pAfiliados="+Ext.getCmp('intAfiliadosCapitaFacturacion').getValue()+"&pProcentajeUPS="+Ext.getCmp('intPorcentajeUPCCapitaFacturacion').getValue()+"&pVlrTotalCapita="+Ext.getCmp('intValorTotalCapitaFacturacion').getValue()+"&pCopagosCapita="+Ext.getCmp('intCopagosCapitaFacturacion').getValue()+"&pNetoCapita="+Ext.getCmp('intNetoCapitaFacturacion').getValue()+"&pConceptoFactura="+Ext.getCmp('memConceptoFacturacion').getValue();
                        window.open ("../../controlador/facturacion/infprefactura_detexcel.php?pEmpresa="+ID_EMPRESA+"&pIPS="+ID_IPS+"&pUsuario="+ID_USUARIO+"&pPaciente="+Ext.getCmp('intPacienteFacturacion').getValue()+"&pProcedimiento="+Ext.getCmp('intConceptoFacturacion').getValue()+"&pCliente="+Ext.getCmp('intClienteFacturacion').getValue()+"&pPlan="+Ext.getCmp('intPlanFacturacion').getValue()+"&pSubplan="+Ext.getCmp('intSubPlanFacturacion').getValue()+"&pContrato="+Ext.getCmp('intContratoFacturacion').getValue()+"&pTipoEstudio="+Ext.getCmp('intTipoEstudioFacturacion').getValue()+"&pCampo1="+Ext.getCmp('strCampo1').getValue()+"&pCampo2="+Ext.getCmp('strCampo2').getValue()+"&pCampo3="+Ext.getCmp('strCampo3').getValue()+"&pDesde="+Ext.getCmp('fecDesdeFacturacion').getValue().format("Y-m-d")+"&pHasta="+Ext.getCmp('fecHastaFacturacion').getValue().format("Y-m-d")+"&pNroPacientes="+Ext.getCmp('intCantidadPacientesFacturacion').getValue()+"&pPorFechaEstudio="+Ext.getCmp('strPorFechaEstudioFacturacion').getValue()+"&pCapitacion="+Ext.getCmp('strCapitacionFacturacion').getValue()+"&pVlrUPC="+Ext.getCmp('intValorUPCCapitaFacturacion').getValue()+"&pAfiliados="+Ext.getCmp('intAfiliadosCapitaFacturacion').getValue()+"&pProcentajeUPS="+Ext.getCmp('intPorcentajeUPCCapitaFacturacion').getValue()+"&pVlrTotalCapita="+Ext.getCmp('intValorTotalCapitaFacturacion').getValue()+"&pCopagosCapita="+Ext.getCmp('intCopagosCapitaFacturacion').getValue()+"&pNetoCapita="+Ext.getCmp('intNetoCapitaFacturacion').getValue()+"&pConceptoFactura="+Ext.getCmp('memConceptoFacturacion').getValue(),"Facturacion");
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Verifique los campos requeridos',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
            }
        });
    },
    
    ImprimirPrefacturaDetalle: function(){
        Ext.Msg.show({
            title: 'Facturación',
            msg: 'Esta seguro que desea generar la prefactura?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    var frm = Ext.getCmp('frmFacturacion').getForm();
                    if (frm.isValid())
                    {
                        //location.href = "../../controlador/facturacion/infprefactura_det.php?pEmpresa"+ID_EMPRESA+"&pIPS="+ID_IPS+"&pUsuario="+ID_USUARIO+"&pPaciente="+Ext.getCmp('intPacienteFacturacion').getValue()+"&pProcedimiento="+Ext.getCmp('intConceptoFacturacion').getValue()+"&pCliente="+Ext.getCmp('intClienteFacturacion').getValue()+"&pPlan="+Ext.getCmp('intPlanFacturacion').getValue()+"&pSubplan="+Ext.getCmp('intSubPlanFacturacion').getValue()+"&pContrato="+Ext.getCmp('intContratoFacturacion').getValue()+"&pTipoEstudio="+Ext.getCmp('intTipoEstudioFacturacion').getValue()+"&pCampo1="+Ext.getCmp('strCampo1').getValue()+"&pCampo2="+Ext.getCmp('strCampo2').getValue()+"&pCampo3="+Ext.getCmp('strCampo3').getValue()+"&pDesde="+Ext.getCmp('fecDesdeFacturacion').getValue().format("Y-m-d")+"&pHasta="+Ext.getCmp('fecHastaFacturacion').getValue().format("Y-m-d")+"&pNroPacientes="+Ext.getCmp('intCantidadPacientesFacturacion').getValue()+"&pPorFechaEstudio="+Ext.getCmp('strPorFechaEstudioFacturacion').getValue()+"&pCapitacion="+Ext.getCmp('strCapitacionFacturacion').getValue()+"&pVlrUPC="+Ext.getCmp('intValorUPCCapitaFacturacion').getValue()+"&pAfiliados="+Ext.getCmp('intAfiliadosCapitaFacturacion').getValue()+"&pProcentajeUPS="+Ext.getCmp('intPorcentajeUPCCapitaFacturacion').getValue()+"&pVlrTotalCapita="+Ext.getCmp('intValorTotalCapitaFacturacion').getValue()+"&pCopagosCapita="+Ext.getCmp('intCopagosCapitaFacturacion').getValue()+"&pNetoCapita="+Ext.getCmp('intNetoCapitaFacturacion').getValue()+"&pConceptoFactura="+Ext.getCmp('memConceptoFacturacion').getValue();
                        window.open ("../../controlador/facturacion/infprefactura_det.php?pEmpresa="+ID_EMPRESA+"&pIPS="+ID_IPS+"&pUsuario="+ID_USUARIO+"&pPaciente="+Ext.getCmp('intPacienteFacturacion').getValue()+"&pProcedimiento="+Ext.getCmp('intConceptoFacturacion').getValue()+"&pCliente="+Ext.getCmp('intClienteFacturacion').getValue()+"&pPlan="+Ext.getCmp('intPlanFacturacion').getValue()+"&pSubplan="+Ext.getCmp('intSubPlanFacturacion').getValue()+"&pContrato="+Ext.getCmp('intContratoFacturacion').getValue()+"&pTipoEstudio="+Ext.getCmp('intTipoEstudioFacturacion').getValue()+"&pCampo1="+Ext.getCmp('strCampo1').getValue()+"&pCampo2="+Ext.getCmp('strCampo2').getValue()+"&pCampo3="+Ext.getCmp('strCampo3').getValue()+"&pDesde="+Ext.getCmp('fecDesdeFacturacion').getValue().format("Y-m-d")+"&pHasta="+Ext.getCmp('fecHastaFacturacion').getValue().format("Y-m-d")+"&pNroPacientes="+Ext.getCmp('intCantidadPacientesFacturacion').getValue()+"&pPorFechaEstudio="+Ext.getCmp('strPorFechaEstudioFacturacion').getValue()+"&pCapitacion="+Ext.getCmp('strCapitacionFacturacion').getValue()+"&pVlrUPC="+Ext.getCmp('intValorUPCCapitaFacturacion').getValue()+"&pAfiliados="+Ext.getCmp('intAfiliadosCapitaFacturacion').getValue()+"&pProcentajeUPS="+Ext.getCmp('intPorcentajeUPCCapitaFacturacion').getValue()+"&pVlrTotalCapita="+Ext.getCmp('intValorTotalCapitaFacturacion').getValue()+"&pCopagosCapita="+Ext.getCmp('intCopagosCapitaFacturacion').getValue()+"&pNetoCapita="+Ext.getCmp('intNetoCapitaFacturacion').getValue()+"&pConceptoFactura="+Ext.getCmp('memConceptoFacturacion').getValue(),"Facturacion");
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Verifique los campos requeridos',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
            }
        });
    },
    GenerarPrefactura: function(){
        Ext.Msg.show({
            title: 'Facturación',
            msg: 'Esta seguro que desea generar la prefactura?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    var frm = Ext.getCmp('frmFacturacion').getForm();
                    if (frm.isValid())
                    {
                        //location.href = "../../controlador/facturacion/infprefactura.php?pEmpresa"+ID_EMPRESA+"&pIPS="+ID_IPS+"&pUsuario="+ID_USUARIO+"&pPaciente="+Ext.getCmp('intPacienteFacturacion').getValue()+"&pProcedimiento="+Ext.getCmp('intConceptoFacturacion').getValue()+"&pCliente="+Ext.getCmp('intClienteFacturacion').getValue()+"&pPlan="+Ext.getCmp('intPlanFacturacion').getValue()+"&pSubplan="+Ext.getCmp('intSubPlanFacturacion').getValue()+"&pContrato="+Ext.getCmp('intContratoFacturacion').getValue()+"&pTipoEstudio="+Ext.getCmp('intTipoEstudioFacturacion').getValue()+"&pCampo1="+Ext.getCmp('strCampo1').getValue()+"&pCampo2="+Ext.getCmp('strCampo2').getValue()+"&pCampo3="+Ext.getCmp('strCampo3').getValue()+"&pDesde="+Ext.getCmp('fecDesdeFacturacion').getValue().format("Y-m-d")+"&pHasta="+Ext.getCmp('fecHastaFacturacion').getValue().format("Y-m-d")+"&pNroPacientes="+Ext.getCmp('intCantidadPacientesFacturacion').getValue()+"&pPorFechaEstudio="+Ext.getCmp('strPorFechaEstudioFacturacion').getValue()+"&pCapitacion="+Ext.getCmp('strCapitacionFacturacion').getValue()+"&pVlrUPC="+Ext.getCmp('intValorUPCCapitaFacturacion').getValue()+"&pAfiliados="+Ext.getCmp('intAfiliadosCapitaFacturacion').getValue()+"&pProcentajeUPS="+Ext.getCmp('intPorcentajeUPCCapitaFacturacion').getValue()+"&pVlrTotalCapita="+Ext.getCmp('intValorTotalCapitaFacturacion').getValue()+"&pCopagosCapita="+Ext.getCmp('intCopagosCapitaFacturacion').getValue()+"&pNetoCapita="+Ext.getCmp('intNetoCapitaFacturacion').getValue()+"&pConceptoFactura="+Ext.getCmp('memConceptoFacturacion').getValue();
                        window.open ("../../controlador/facturacion/infprefactura.php?pEmpresa="+ID_EMPRESA+"&pIPS="+ID_IPS+"&pUsuario="+ID_USUARIO+"&pPaciente="+Ext.getCmp('intPacienteFacturacion').getValue()+"&pProcedimiento="+Ext.getCmp('intConceptoFacturacion').getValue()+"&pCliente="+Ext.getCmp('intClienteFacturacion').getValue()+"&pPlan="+Ext.getCmp('intPlanFacturacion').getValue()+"&pSubplan="+Ext.getCmp('intSubPlanFacturacion').getValue()+"&pContrato="+Ext.getCmp('intContratoFacturacion').getValue()+"&pTipoEstudio="+Ext.getCmp('intTipoEstudioFacturacion').getValue()+"&pCampo1="+Ext.getCmp('strCampo1').getValue()+"&pCampo2="+Ext.getCmp('strCampo2').getValue()+"&pCampo3="+Ext.getCmp('strCampo3').getValue()+"&pDesde="+Ext.getCmp('fecDesdeFacturacion').getValue().format("Y-m-d")+"&pHasta="+Ext.getCmp('fecHastaFacturacion').getValue().format("Y-m-d")+"&pNroPacientes="+Ext.getCmp('intCantidadPacientesFacturacion').getValue()+"&pPorFechaEstudio="+Ext.getCmp('strPorFechaEstudioFacturacion').getValue()+"&pCapitacion="+Ext.getCmp('strCapitacionFacturacion').getValue()+"&pVlrUPC="+Ext.getCmp('intValorUPCCapitaFacturacion').getValue()+"&pAfiliados="+Ext.getCmp('intAfiliadosCapitaFacturacion').getValue()+"&pProcentajeUPS="+Ext.getCmp('intPorcentajeUPCCapitaFacturacion').getValue()+"&pVlrTotalCapita="+Ext.getCmp('intValorTotalCapitaFacturacion').getValue()+"&pCopagosCapita="+Ext.getCmp('intCopagosCapitaFacturacion').getValue()+"&pNetoCapita="+Ext.getCmp('intNetoCapitaFacturacion').getValue()+"&pConceptoFactura="+Ext.getCmp('memConceptoFacturacion').getValue(),"Facturacion");
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Verifique los campos requeridos',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
            }
        });
    },
    BuscarConcepto: function(){
        buscarconcepto('Radicacion', 'NO','NO','NO','NO','NA','Facturacion');
    },
    CargaCbSubPlan: function(cmb, rec, idx) {
        Ext.getCmp('intSubPlanFacturacion').clearValue();
        Ext.getCmp('intSubPlanFacturacion').store.load({
            params: { 'pPlan': cmb.getValue() }
        });
        Ext.getCmp('intSubPlanFacturacion').enable();
    },
    CargaCbPlan: function(cmb, rec, idx) {
        Ext.Ajax.request({
            url: '../../controlador/conceptos/matrizconceptosxcliente.php',
            params:{
                pIdTabla: "USR_" + ID_USUARIO,
                pCliente: cmb.getValue(),
                pIPS: ID_IPS,
                pEsParticular: 0,
                pUsaAuditoria: 0
            },
            success: function(response,options){
            },
            failure: function(response,options){
            },
            scope:this
        });
        Ext.getCmp('intPlanFacturacion').clearValue();
        Ext.getCmp('intSubPlanFacturacion').clearValue();
        Ext.getCmp('intContratoFacturacion').clearValue();
        Ext.getCmp('intPlanFacturacion').store.load({
            params: { 'pCliente': cmb.getValue() }
        });
        Ext.getCmp('intPlanFacturacion').enable();
        Ext.getCmp('intSubPlanFacturacion').disable();
        Ext.getCmp('intContratoFacturacion').store.load({
            params: { 'pCliente': cmb.getValue() }
        });
        Ext.getCmp('intContratoFacturacion').enable();
        Ext.getCmp('sysNroFactura').setValue(null);
        Ext.getCmp('sysNroFactura').store.load({
           params: {
               pEmpresa: ID_EMPRESA,
               pIPS: ID_IPS,
               pCliente: cmb.getValue()
           } 
        });
    },
    ValidarEsCapitacion: function(cmb, rec, idx) {
        if(cmb.getValue() == 'SI')
            Ext.getCmp('infoCapitaFacturacion').setVisible(true);
        else
            Ext.getCmp('infoCapitaFacturacion').setVisible(false);
    },
    BuscarPaciente: function(){
        buscarpaciente("Facturacion");
    },
    LimpiarFormulario: function(){
        var frm = Ext.getCmp('frmFacturacion').getForm();
        frm.reset();
        frm.clearInvalid();
        Ext.getCmp('infoCapitaFacturacion').setVisible(false);
    },
    Unificar: function(){
        Ext.Msg.show({
            title: 'Pacientes....!',
            msg: 'Esta seguro que desea unificar la información de los pacientes, si hace esto después de la unificación el paciente malo será eliminado?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    var frm = Ext.getCmp('frmUnificarPaciente').getForm();
                    if (frm.isValid())
                    {
                        frm.submit({
                            url: '../../controlador/pacientes/controlador_pacientes.php',
                            params: {
                                task: 'UNIFICAR',
                                pEmpresa: ID_EMPRESA,
                                pIPS: ID_IPS ,
                                pUsuario: ID_USUARIO,
                                pPacienteMalo: Ext.getCmp('sysPacienteMalo').getValue(),
                                pPacienteBueno: Ext.getCmp('sysPacienteBueno').getValue(),
                                pMotivo: "Paciente Malo: " + Ext.getCmp('fPacienteMalo').getValue() + " - Paciente Bueno: " + Ext.getCmp('fPacienteBueno').getValue()
                            },
                            success: function(res,req)
                            {
                                switch(req.result.requestedId){
                                    case "1":
                                        Ext.MessageBox.show({
                                            title: 'Pacientes',
                                            msg: 'Se Unifico con Exito la información de los pacientes seleccionados.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.INFO
                                        });
                                        window.close();
                                        break;

                                    default:
                                        Ext.MessageBox.show({
                                            title: 'Pacientes',
                                            msg: 'Ocurrio un error al unificar los pacientes o no se pudo establecer conexión con el servidor.',
                                            buttons: Ext.MessageBox.OK,
                                            icon: Ext.MessageBox.ERROR
                                        });
                                        break;
                                }
                            },
                            failure: function(response,options)
                            {
                                Ext.MessageBox.show({
                                    title: 'Error Base Datos',
                                    msg: 'No podemos unificar los pacientes en estos momentos',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }
                        });
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Debe Seleccionar los Pacientes',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
            }
        });
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
    
});

