/*
* @category    Formulario Anular Factura
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmAnularFacUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Anular Factura ::.',
    id: 'winFrmRIPS',
    closable:false,
    width:980,
    autoHeight: true,
    resizable : false,
    border: false,
    frame: true,
    //autoScroll: true,
    y:120,
    initComponent: function() {
        var mybbar = new utilBbarUi();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmFacturacion',
                border: false,
                autoHeight: true,
                padding: 3,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'hidden',
                        id: 'sysPuedeAnular',
                        value: 0
                    },
                    {
                        xtype: 'combo',
                        anchor: '96%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StoreCliente',
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: false,
                        fieldLabel: 'Cliente',
                        id: 'sysClienteFacturacion'
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '96%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'combo',
                                fieldLabel: 'Factura',
                                name: 'cbFactura',
                                width: 220,
                                listWidth: 450,
                                forceSelection: true,
                                typeAhead: true,
                                typeAheadDelay: 50,
                                listEmptyText: '',
                                title: '',
                                valueField: 'idLegalizacion',
                                displayField: 'NroFactura',
                                store: 'StoreRelacionFacturas',
                                triggerAction: 'all',
                                mode: 'local',
                                allowBlank: false,
                                tpl: '<tpl for="."><div class="cbFactura"><h3>{NroFactura}</h3><p style="font-size: 12;">Fecha Factura: {FechaDocumento}</p><tpl if="Anulada==\'1\'"><p style="font-size:11; color:red;">Fecha Anulacion: {FechaAnula}</p><p style="font-size: 10; color:red;">{MotivoAnula}</p></tpl><hr /></div></tpl>',
                                itemSelector: 'div.cbFactura',
                                id: 'sysNroFactura'
                            },
                            {
                                xtype: 'displayfield',
                                fieldLabel: '',
                                value: 'Fecha Anulacion:'
                            },
                            {
                                xtype: 'datefield',
                                width: 100,
                                allowBlank: false,
                                id: 'sysAnulaFactura'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        xtype: 'textarea',
                        fieldLabel: 'Motivo',
                        name: 'Motivo',
                        width: 800,
                        allowBlank: false,
                        id: 'sysMotivoAnulacion'
                    },
                    {
                        fbar: {
                            xtype: 'toolbar',
                            width: 760,
                            buttonAlign: 'center',
                            items: [
                                {
                                    xtype: 'button',
                                    iconCls: 'btnAnularFactura',
                                    text: 'Anular Factura',
                                    id: 'btnAnularFactura'
                                }
                            ]
                        }
                    }
                ],
                tbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnImprimir',
                            text: 'Imprimir Factura Anulada',
                            id: 'btnImprimirAnulada'
                        },
                        {
                            xtype: 'tbseparator'
                        }
                    ]
                }
            },
            
        ];
        winFrmAnularFacUi.superclass.initComponent.call(this);
    }
});
