/*
* @category    Formulario RIPS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmCargarActividadODOUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Cargar Actividades Odontologia ::.',
    id: 'winFrmCargarActividadODO',
    closable:false,
    width:1004,
    autoHeight: true,
    resizable : false,
    border: false,
    frame: true,
    //autoScroll: true,
    y:120,
    initComponent: function() {
        var mybbar = new utilBbarUi();
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmCargarActividadOdo',
                border: false,
                autoHeight: true,
                padding: 3,
                autoScroll: true,
                style: 'background:transparent;',
                items: [
                    {
                        xtype: 'combo',
                        fieldLabel: 'Cliente',
                        anchor: '100%',
                        allowBlank: false,
                        store: 'StoreCliente',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        emptyText: 'Seleccione Cliente....',
                        mode: 'local',
                        triggerAction: 'all',
                        forceSelection: true,
                        id: 'intClienteActividadesOdo',
                        listeners: {
                            select: function(cmb, rec, idx) {
                                if(cmb.getValue() === null || cmb.getValue() === ""){
                                    Ext.getCmp('intPlanActividadesOdo').store.removeAll(true);
                                    Ext.getCmp('intSubPlanActividadesOdo').store.removeAll(true);
                                    Ext.getCmp('intContratoActividadesOdo').store.removeAll(true);
                                    Ext.getCmp('intPlanActividadesOdo').setValue(null);
                                    Ext.getCmp('intSubPlanActividadesOdo').setValue(null);
                                    Ext.getCmp('intPlanActividadesOdo').disable();
                                    Ext.getCmp('intSubPlanActividadesOdo').disable();
                                    Ext.getCmp('intContratoActividadesOdo').disable();

                                }else{
                                    Ext.getCmp('intPlanActividadesOdo').store.removeAll(true);
                                    Ext.getCmp('intSubPlanActividadesOdo').store.removeAll(true);
                                    Ext.getCmp('intContratoActividadesOdo').store.removeAll(true);
                                    Ext.getCmp('intPlanActividadesOdo').setValue(null);
                                    Ext.getCmp('intSubPlanActividadesOdo').setValue(null);
                                    Ext.getCmp('intSubPlanActividadesOdo').disable();
                                    Ext.getCmp('intPlanActividadesOdo').store.load({
                                        params:{
                                            pCliente: cmb.getValue()
                                        },
                                        callback: function(){
                                            Ext.getCmp('intPlanActividadesOdo').enable();
                                        }
                                    });
                                    Ext.getCmp('intContratoActividadesOdo').store.load({
                                        params:{
                                            pCliente: cmb.getValue()
                                        },
                                        callback: function(){
                                            Ext.getCmp('intContratoActividadesOdo').enable();
                                        }
                                    });
                                }
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Plan',
                        anchor: '100%',
                        allowBlank: true,
                        disabled: true,
                        store: 'StoreClientesPlan',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        valueField: 'IdPlan',
                        displayField: 'Descripcion',
                        emptyText: 'Seleccione Plan....',
                        mode: 'local',
                        triggerAction: 'all',
                        forceSelection: true,
                        id: 'intPlanActividadesOdo',
                        listeners: {
                            select: function(cmb, rec, idx) {
                                if(cmb.getValue() === null || cmb.getValue() === ""){
                                    Ext.getCmp('intSubPlanActividadesOdo').store.removeAll(true);
                                    Ext.getCmp('intSubPlanActividadesOdo').setValue(null);
                                    Ext.getCmp('intSubPlanActividadesOdo').disable();
                                }else{
                                    Ext.getCmp('intSubPlanActividadesOdo').store.removeAll(true);
                                    Ext.getCmp('intSubPlanActividadesOdo').store.load({
                                        params:{
                                            pPlan: cmb.getValue()
                                        },
                                        callback: function(){
                                            Ext.getCmp('intSubPlanActividadesOdo').enable();
                                        }
                                    });
                                }
                            }
                        }
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'SubPlan',
                        anchor: '100%',
                        allowBlank: true,
                        disabled: true,
                        store: 'StoreClienteSubplan',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        valueField: 'IdSubPlan',
                        displayField: 'Descripcion',
                        emptyText: 'Seleccione Plan....',
                        mode: 'local',
                        triggerAction: 'all',
                        forceSelection: true,
                        id: 'intSubPlanActividadesOdo'
                    },
                    {
                        xtype: 'combo',
                        fieldLabel: 'Contrato',
                        anchor: '100%',
                        allowBlank: false,
                        disabled: true,
                        store: 'StoreClienteContrato',
                        typeAhead: true,
                        typeAheadDelay: 50,
                        valueField: 'IdContrato',
                        displayField: 'Contrato',
                        emptyText: 'Seleccione Contrato....',
                        mode: 'local',
                        triggerAction: 'all',
                        forceSelection: true,
                        id: 'intContratoActividadesOdo'
                    },
                    {
                        xtype: 'compositefield',
                        anchor: '100%',
                        style: 'background:transparent;',
                        items: [
                            {
                                xtype: 'datefield',
                                fieldLabel: 'Desde',
                                width: 100,
                                allowBlank: false,
                                id: 'fecDesdeActividadesOdo'
                            },
                            {
                                xtype: 'displayfield',
                                value: 'Hasta:'
                            },
                            {
                                xtype: 'datefield',
                                width: 100,
                                allowBlank: false,
                                id: 'fecHastaActividadesOdo'
                            }
                        ]
                    },
                    {
                        html: '<hr>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        fbar: {
                            xtype: 'toolbar',
                            width: 760,
                            buttonAlign: 'center',
                            items: [
                                {
                                    xtype: 'tbseparator'
                                },
                                {
                                    xtype: 'button',
                                    iconCls: 'btnAceptar',
                                    text: 'Cargar Actividades',
                                    id: 'btnCargarActividadesOdo'
                                }
                            ]
                        }
                    }
                ]
            }
        ];
        winFrmCargarActividadODOUi.superclass.initComponent.call(this);
    }
});
