/*
* @category    Programacion Eventos Formulario RIPS
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/


winFrmCargarActividadODO = Ext.extend(winFrmCargarActividadODOUi, {
    initComponent: function() {
        winFrmCargarActividadODO.superclass.initComponent.call(this);
        el = Ext.get('idempresa');
        ID_EMPRESA = el.getValue();
        el = Ext.get('idsede');
        ID_SEDE = el.getValue();
        el = Ext.get('idips');
        ID_IPS = el.getValue();
        el = Ext.get('idusuario');
        ID_USUARIO = el.getValue();
        el = Ext.get('idperfil');
        ID_PERFIL = el.getValue();
        BD_MULTIPRESTADOR = "NA";
        
        Ext.getCmp('fNomEmpresa').setValue("EMPRESA: " + Ext.get('nomempresa').getValue());
        Ext.getCmp('fNomSede').setValue("");
        Ext.getCmp('fNomIPS').setValue("");
        Ext.getCmp('fNomUSR').setValue("Usr: [" + Ext.get('codusuario').getValue() + "]-" + Ext.get('nomusuario').getValue());
        
        var btnSalirOpcion = Ext.getCmp('btnSalirOpcion').on("click",this.SalirOpcion,this);
        var btnCargarActividadesOdo = Ext.getCmp('btnCargarActividadesOdo').on("click",this.CargarActividades,this);
        
    },
    CargarActividades: function(){
        Ext.Msg.show({
            title: 'Actividaes Odontologia',
            msg: 'Esta seguro que desea los Adicionar las Actividades Realizadas al CAS de cada servicio?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn){
                if(btn=="yes"){
                    var wTask = "CARGAR_ACTIVIDADES_ODONTOLOGIA";
                    var frm = Ext.getCmp('frmCargarActividadOdo').getForm();
                    if (frm.isValid()){
                        Ext.Msg.wait('Cargando Actividades... por favor espere!');
                        Ext.Ajax.request({
                            url: "../../controlador/facturacion/facturacion.php",
                            params: {
                                task: wTask,
                                pEmpresa: ID_EMPRESA,
                                pIPS: ID_IPS,
                                pCliente: Ext.getCmp('intClienteActividadesOdo').getValue(),
                                pPlan: Ext.getCmp('intPlanActividadesOdo').getValue(),
                                pSubPlan: Ext.getCmp('intSubPlanActividadesOdo').getValue(),
                                pContrato: Ext.getCmp('intContratoActividadesOdo').getValue(),
                                pDesde: Ext.getCmp('fecDesdeActividadesOdo').getValue().format("Y-m-d"),
                                pHasta: Ext.getCmp('fecHastaActividadesOdo').getValue().format("Y-m-d")
                            },
                            success: function(response)
                            {
                                var result = response.responseText;
                                if (result > 0)
                                {
                                    Ext.Msg.hide();
                                    Ext.MessageBox.show({
                                        title: 'OfiClinic',
                                        msg: 'Se cargaron con exito las actividades de odontologia',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.INFO
                                    });
                                }else{
                                    Ext.MessageBox.show({
                                        title: 'Error',
                                        msg: 'No podemos cargar las actividades en estos momentos',
                                        buttons: Ext.MessageBox.OK,
                                        icon: Ext.MessageBox.ERROR
                                    });
                                }
                            },
                            failure: function(response){
                                var result = response.responseText;
                                Ext.MessageBox.show({
                                    title: 'Error Base Datos',
                                    msg: 'No podemos cargar las actividades en estos momentos',
                                    buttons: Ext.MessageBox.OK,
                                    icon: Ext.MessageBox.ERROR
                                });
                            }
                        });
                    }else{
                        Ext.MessageBox.show({
                            title: 'Error',
                            msg: 'Verifique los campos requeridos',
                            buttons: Ext.MessageBox.OK,
                            icon: Ext.MessageBox.ERROR
                        });
                    }
                }
            }
        });
    },
    SalirOpcion: function(){
        Ext.Msg.show({
            title: 'eOfiClinic',
            msg: 'Esta seguro que desea cerrar la ventana?',
            buttons: Ext.Msg.YESNO,
            icon: Ext.Msg.QUESTION,
            fn: function(btn)
            {
                if(btn=="yes")
                {
                    window.close();
                }
            }
        });
    }
    
});

