/*
* @category    Formulario Grid Horarios
* @package     OfiClinic Web
* @author      Jorge Ancizar Galeano Ruiz<desarrollo@ofisalud.com>
* @copyright   2010 Jorge Ancizar GAleano Ruiz
* @version     OfiClinic Web 1.0
* @license     COMERCIAL
* @link        http://www.ofisalud.com
* @country     Colombia
* @telephone   3016398114
*/

winFrmDesbloqueoAgendaUi = Ext.extend(Ext.Window, {
    title: 'OfiClinic© Web..! .:: Desbloquear Agendas ::.',
    id: 'winFrmDesbloqueoAgenda',
    closable:false,
    width:980,
    //height:280,
    autoHeight: true,
    resizable : false,
    border: false,
    frame: true,
    y:120,
    initComponent: function() {
        el = Ext.get('idempresa');
        var ID_EMPRESA = el.getValue();
        var stMultiprestadorDesbloqueo = new StoreMultiprestador();
        var stMultiprestadorSedeDesbloqueo = new Ext.data.JsonStore({
                url: '../../controlador/combobox/cbsedexempresa.php',
                root: 'rows',
                fields: ['Codigo', 'Descripcion']
        });
        var stMultiprestadorIPSDesbloqueo = new Ext.data.JsonStore({
                url: '../../controlador/combobox/cbipsxsedexempresa.php',
                root: 'rows',
                fields: ['Codigo', 'Descripcion']
        });
        var mybbar = new utilBbarUi();
        this.bbar = mybbar;
        this.items = [
            {
                xtype: 'form',
                frame: true,
                anchor: '100%',
                id: 'frmDesbloquearAgenda',
                padding: 10,
                border: false,
                style: 'background:transparent;',
                items: [
                    {
                        html: '<img src="../../../resources/varios/agendablock.png" align="left" alt=""/>',
                        style: 'background:transparent;',
                        border: false
                    },
                    {
                        html:'&nbsp;&nbsp;&nbsp;',
                        border: false
                    },
                    {
                        xtype: 'fieldset',
                        title: 'Datos del Prestador',
                        layout: 'form',
                        collapseFirst: false,
                        collapsible: false,
                        width: 949,
                        labelWidth: 60,
                        autoHeight: true,
                        id: 'fsPrestador',
                        items: [
                            {
                                xtype: 'hidden',
                                id: 'sysMultiprestaBDdesblo'
                            },
                            {
                                xtype: 'compositefield',
                                style: 'background:transparent;',
                                items: [
                                    {
                                        xtype: 'combo',
                                        fieldLabel: 'Prestador',
                                        width: 380,
                                        name: 'Prestador',
                                        allowBlank: false,
                                        store: stMultiprestadorDesbloqueo,
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Prestador...',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        id: 'sysMultiprestaCoddesblo'
                                    },
                                    {
                                        html: 'Sede:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 200,
                                        name: 'Sede',
                                        allowBlank: false,
                                        store: stMultiprestadorSedeDesbloqueo,
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione Sede...',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        disabled: true,
                                        id: 'sysMultiprestaSededesblo'
                                    },
                                    {
                                        html: 'IPS:'
                                    },
                                    {
                                        xtype: 'combo',
                                        width: 207,
                                        name: 'IPS',
                                        allowBlank: false,
                                        store: stMultiprestadorIPSDesbloqueo,
                                        typeAhead: true,
                                        typeAheadDelay: 50,
                                        valueField: 'Codigo',
                                        displayField: 'Descripcion',
                                        emptyText: 'Seleccione IPS...',
                                        mode: 'local',
                                        triggerAction: 'all',
                                        forceSelection: true,
                                        disabled: true,
                                        id: 'sysMultiprestaIPSdesblo'
                                    }
                                ]
                            }
                        ]
                    },
                    {
                        xtype: 'combo',
                        anchor: '100%',
                        forceSelection: true,
                        typeAhead: true,
                        typeAheadDelay: 50,
                        listEmptyText: '',
                        title: '',
                        fieldLabel: 'Usuario',
                        valueField: 'Codigo',
                        displayField: 'Descripcion',
                        store: 'StoreUsuarioBloqueoAgenda',
                        triggerAction: 'all',
                        mode: 'local',
                        emptyText: 'Seleccione...!',
                        allowBlank: false,
                        disabled: true,
                        id: 'intUsuarioBloqueo'
                    },
                    {
                        html:'&nbsp;&nbsp;&nbsp;',
                        border: false
                    }
                ],
                tbar: {
                    xtype: 'toolbar',
                    items: [
                        {
                            xtype: 'tbfill'
                        },
                        {
                            xtype: 'tbseparator'
                        },
                        {
                            xtype: 'button',
                            iconCls: 'btnCitasCanceladas',
                            text: 'Desbloquear',
                            id: 'btnDesbloquear'
                        }
                    ]
                }
            }
        ];
        winFrmDesbloqueoAgendaUi.superclass.initComponent.call(this);
    }
});
